/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.condition;

import com.landawn.abacus.condition.Between;
import com.landawn.abacus.condition.Condition;
import com.landawn.abacus.condition.ConditionFactory;
import com.landawn.abacus.condition.Equal;
import com.landawn.abacus.condition.GreaterEqual;
import com.landawn.abacus.condition.GreaterThan;
import com.landawn.abacus.condition.In;
import com.landawn.abacus.condition.IsNotNull;
import com.landawn.abacus.condition.IsNull;
import com.landawn.abacus.condition.LessEqual;
import com.landawn.abacus.condition.LessThan;
import com.landawn.abacus.condition.Like;
import com.landawn.abacus.condition.Not;
import com.landawn.abacus.condition.NotEqual;
import com.landawn.abacus.condition.Or;
import com.landawn.abacus.util.N;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class NamedProperty {
    private static final Map<String, NamedProperty> instancePool = new ConcurrentHashMap<String, NamedProperty>();
    final String propName;

    NamedProperty() {
        this.propName = null;
    }

    public NamedProperty(String propName) {
        this.propName = propName;
    }

    public static final NamedProperty of(String propName) {
        if (N.isNullOrEmpty(propName)) {
            throw new IllegalArgumentException("the property name can't be null or empty string.");
        }
        NamedProperty instance = instancePool.get(propName);
        if (instance == null) {
            instance = new NamedProperty(propName);
            instancePool.put(propName, instance);
        }
        return instance;
    }

    public Equal eq(Object values) {
        return ConditionFactory.CF.eq(this.propName, values);
    }

    @SafeVarargs
    public final Or eqOr(Object ... values) {
        Or or = ConditionFactory.CF.or(new Condition[0]);
        for (Object propValue : values) {
            or.add(ConditionFactory.CF.eq(this.propName, propValue));
        }
        return or;
    }

    public Or eqOr(Collection<?> values) {
        Or or = ConditionFactory.CF.or(new Condition[0]);
        for (Object propValue : values) {
            or.add(ConditionFactory.CF.eq(this.propName, propValue));
        }
        return or;
    }

    public NotEqual ne(Object values) {
        return ConditionFactory.CF.ne(this.propName, values);
    }

    public GreaterThan gt(Object value) {
        return ConditionFactory.CF.gt(this.propName, value);
    }

    public GreaterEqual ge(Object value) {
        return ConditionFactory.CF.ge(this.propName, value);
    }

    public LessThan lt(Object value) {
        return ConditionFactory.CF.lt(this.propName, value);
    }

    public LessEqual le(Object value) {
        return ConditionFactory.CF.le(this.propName, value);
    }

    public IsNull isNull() {
        return ConditionFactory.CF.isNull(this.propName);
    }

    public IsNotNull isNotNull() {
        return ConditionFactory.CF.isNotNull(this.propName);
    }

    public Between bt(Object minValue, Object maxValue) {
        return ConditionFactory.CF.between(this.propName, minValue, maxValue);
    }

    public Like like(Object value) {
        return ConditionFactory.CF.like(this.propName, value);
    }

    public Not notLike(Object value) {
        return ConditionFactory.CF.notLike(this.propName, value);
    }

    public Like startsWith(Object value) {
        return ConditionFactory.CF.startsWith(this.propName, value);
    }

    public Like endsWith(Object value) {
        return ConditionFactory.CF.endsWith(this.propName, value);
    }

    public Like contains(Object value) {
        return ConditionFactory.CF.contains(this.propName, value);
    }

    @SafeVarargs
    public final In in(Object ... values) {
        return ConditionFactory.CF.in(this.propName, values);
    }

    public In in(Collection<?> values) {
        return ConditionFactory.CF.in(this.propName, values);
    }

    public int hashCode() {
        return this.propName.hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof NamedProperty && N.equals(((NamedProperty)obj).propName, this.propName);
    }

    public String toString() {
        return this.propName;
    }
}

