/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.condition;

import com.landawn.abacus.condition.AbstractCondition;
import com.landawn.abacus.condition.Condition;
import com.landawn.abacus.condition.Operator;
import com.landawn.abacus.util.Joiner;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.NamingPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class NotIn
extends AbstractCondition {
    private static final long serialVersionUID = 6819362182648251435L;
    final String propName;
    private List<?> values;

    NotIn() {
        this.propName = null;
    }

    public NotIn(String propName, Collection<?> values) {
        super(Operator.NOT_IN);
        N.checkArgNotNullOrEmpty(values, "'values' can't be null or empty");
        this.propName = propName;
        this.values = new ArrayList(values);
    }

    public String getPropName() {
        return this.propName;
    }

    public List<?> getValues() {
        return this.values;
    }

    public void setValues(List<?> values) {
        this.values = values;
    }

    @Override
    public List<Object> getParameters() {
        return this.values == null ? N.emptyList() : this.values;
    }

    @Override
    public void clearParameters() {
        if (N.notNullOrEmpty(this.values)) {
            N.fill(this.values, null);
        }
    }

    @Override
    public <T extends Condition> T copy() {
        NotIn copy = (NotIn)super.copy();
        copy.values = new ArrayList(this.values);
        return (T)copy;
    }

    @Override
    public String toString(NamingPolicy namingPolicy) {
        if (namingPolicy == NamingPolicy.NO_CHANGE) {
            return this.propName + ' ' + this.getOperator().toString() + Joiner.with(", ", " (", ")").reuseCachedBuffer().appendAll((Collection<?>)this.values).toString();
        }
        return namingPolicy.convert(this.propName) + ' ' + this.getOperator().toString() + Joiner.with(", ", " (", ")").reuseCachedBuffer().appendAll((Collection<?>)this.values).toString();
    }

    public int hashCode() {
        int h = 17;
        h = h * 31 + this.propName.hashCode();
        h = h * 31 + this.operator.hashCode();
        h = h * 31 + (this.values == null ? 0 : this.values.hashCode());
        return h;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof NotIn) {
            NotIn other = (NotIn)obj;
            return N.equals(this.propName, other.propName) && N.equals((Object)this.operator, (Object)other.operator) && N.equals(this.values, other.values);
        }
        return false;
    }
}

