/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.condition;

import com.landawn.abacus.condition.AbstractCondition;
import com.landawn.abacus.condition.Condition;
import com.landawn.abacus.condition.Operator;
import com.landawn.abacus.condition.SubQuery;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.NamingPolicy;
import com.landawn.abacus.util.StringUtil;
import com.landawn.abacus.util.Throwables;
import java.util.Collection;
import java.util.List;

public class NotInSubQuery
extends AbstractCondition {
    private static final long serialVersionUID = 3151853530575587557L;
    final String propName;
    final Collection<String> propNames;
    private SubQuery subQuery;

    NotInSubQuery() {
        this.propName = null;
        this.propNames = null;
    }

    public NotInSubQuery(String propName, SubQuery subQuery) {
        super(Operator.NOT_IN);
        N.checkArgNotNull(subQuery, "'subQuery' can't be null or empty");
        this.propName = propName;
        this.subQuery = subQuery;
        this.propNames = null;
    }

    public NotInSubQuery(Collection<String> propNames, SubQuery subQuery) {
        super(Operator.NOT_IN);
        N.checkArgNotNullOrEmpty(propNames, "propNames");
        N.checkArgNotNull(subQuery, "'subQuery' can't be null or empty");
        this.propNames = propNames;
        this.subQuery = subQuery;
        this.propName = null;
    }

    public String getPropName() {
        return this.propName;
    }

    public Collection<String> getPropNames() {
        return this.propNames;
    }

    public SubQuery getSubQuery() {
        return this.subQuery;
    }

    public void setSubQuery(SubQuery subQuery) {
        this.subQuery = subQuery;
    }

    @Override
    public List<Object> getParameters() {
        return this.subQuery.getParameters();
    }

    @Override
    public void clearParameters() {
        this.subQuery.clearParameters();
    }

    @Override
    public <T extends Condition> T copy() {
        NotInSubQuery copy = (NotInSubQuery)super.copy();
        copy.subQuery = (SubQuery)this.subQuery.copy();
        return (T)copy;
    }

    public int hashCode() {
        int h = 17;
        h = h * 31 + (N.notNullOrEmpty(this.propName) ? N.hashCode(this.propName) : N.hashCode(this.propNames));
        h = h * 31 + this.operator.hashCode();
        h = h * 31 + (this.subQuery == null ? 0 : this.subQuery.hashCode());
        return h;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof NotInSubQuery) {
            NotInSubQuery other = (NotInSubQuery)obj;
            return N.equals(this.propName, other.propName) && N.equals(this.propNames, other.propNames) && N.equals((Object)this.operator, (Object)other.operator) && N.equals(this.subQuery, other.subQuery);
        }
        return false;
    }

    @Override
    public String toString(final NamingPolicy namingPolicy) {
        if (N.notNullOrEmpty(this.propName)) {
            if (namingPolicy == NamingPolicy.NO_CHANGE) {
                return this.propName + ' ' + this.getOperator().toString() + " (" + this.subQuery.toString(namingPolicy) + ")";
            }
            return namingPolicy.convert(this.propName) + ' ' + this.getOperator().toString() + " (" + this.subQuery.toString(namingPolicy) + ")";
        }
        if (namingPolicy == NamingPolicy.NO_CHANGE) {
            return "(" + StringUtil.join(this.propNames, ", ") + ") " + this.getOperator().toString() + " (" + this.subQuery.toString(namingPolicy) + ")";
        }
        Throwables.Function<String, String, RuntimeException> func = new Throwables.Function<String, String, RuntimeException>(){

            @Override
            public String apply(String t) throws RuntimeException {
                return namingPolicy.convert(t);
            }
        };
        return "(" + StringUtil.join(N.map(this.propNames, func), ", ") + ") " + this.getOperator().toString() + " (" + this.subQuery.toString(namingPolicy) + ")";
    }
}

