/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.condition;

import com.landawn.abacus.util.N;
import java.util.HashMap;
import java.util.Map;

public enum Operator {
    EQUAL("="),
    NOT_EQUAL("<>"),
    NOT_EQUAL2("!="),
    NOT("NOT"),
    NOT_OP("!"),
    XOR("XOR"),
    LIKE("LIKE"),
    AND("AND"),
    AND_OP("&&"),
    OR("OR"),
    OR_OP("||"),
    GREATER_THAN(">"),
    GREATER_EQUAL(">="),
    LESS_THAN("<"),
    LESS_EQUAL("<="),
    BETWEEN("BETWEEN"),
    IS("IS"),
    IS_NOT("IS NOT"),
    EXISTS("EXISTS"),
    IN("IN"),
    NOT_IN("NOT IN"),
    ANY("ANY"),
    SOME("SOME"),
    ALL("ALL"),
    ON("ON"),
    USING("USING"),
    JOIN("JOIN"),
    LEFT_JOIN("LEFT JOIN"),
    RIGHT_JOIN("RIGHT JOIN"),
    FULL_JOIN("FULL JOIN"),
    CROSS_JOIN("CROSS JOIN"),
    INNER_JOIN("INNER JOIN"),
    NATURAL_JOIN("NATURAL JOIN"),
    WHERE("WHERE"),
    HAVING("HAVING"),
    GROUP_BY("GROUP BY"),
    ORDER_BY("ORDER BY"),
    LIMIT("LIMIT"),
    OFFSET("OFFSET"),
    FOR_UPDATE("FOR UPDATE"),
    UNION("UNION"),
    UNION_ALL("UNION ALL"),
    INTERSECT("INTERSECT"),
    EXCEPT("EXCEPT"),
    MINUS("MINUS"),
    EMPTY(N.EMPTY_STRING);

    private String name;
    private static final Map<String, Operator> operatorMap;

    private Operator(String name) {
        this.name = name;
    }

    public static synchronized Operator getOperator(String name) {
        Operator operator;
        if (operatorMap.size() == 0) {
            Operator[] values = Operator.values();
            for (int i = 0; i < values.length; ++i) {
                operatorMap.put(values[i].name, values[i]);
            }
        }
        if ((operator = operatorMap.get(name)) == null && (operator = operatorMap.get(name.toUpperCase())) != null) {
            operatorMap.put(name, operator);
        }
        return operator;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    static {
        operatorMap = new HashMap<String, Operator>();
    }
}

