/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.core;

import com.landawn.abacus.DirtyMarker;
import com.landawn.abacus.annotation.Internal;
import com.landawn.abacus.core.AbstractDirtyMarker;
import com.landawn.abacus.util.ObjectPool;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

@Internal
public final class DirtyMarkerUtil {
    static final int POOL_SIZE;
    private static final Map<Class<?>, Boolean> dirtyMarkerClassPool;

    private DirtyMarkerUtil() {
    }

    public static boolean isDirtyMarker(Class<?> cls) {
        Boolean b = dirtyMarkerClassPool.get(cls);
        if (b == null) {
            b = DirtyMarker.class.isAssignableFrom(cls);
            dirtyMarkerClassPool.put(cls, b);
        }
        return b;
    }

    public static boolean isDirty(DirtyMarker entity) {
        return entity.isDirty();
    }

    public static boolean isDirty(DirtyMarker entity, String propName) {
        return entity.isDirty(propName);
    }

    public static void markDirty(DirtyMarker entity, boolean isDirty) {
        entity.markDirty(isDirty);
    }

    public static void markDirty(DirtyMarker entity, String propName, boolean isDirty) {
        entity.markDirty(propName, isDirty);
    }

    public static void markDirty(DirtyMarker entity, Collection<String> propNames, boolean isDirty) {
        entity.markDirty(propNames, isDirty);
    }

    public static Set<String> signedPropNames(DirtyMarker entity) {
        return entity.signedPropNames();
    }

    public static Set<String> dirtyPropNames(DirtyMarker entity) {
        return entity.dirtyPropNames();
    }

    public static void setDirtyMarker(Object source, Object target) {
        if (source instanceof DirtyMarker && target instanceof DirtyMarker) {
            DirtyMarker dirtyMarkerSource = (DirtyMarker)source;
            DirtyMarker dirtyMarkerTarget = (DirtyMarker)target;
            dirtyMarkerTarget.signedPropNames().clear();
            dirtyMarkerTarget.signedPropNames().addAll(dirtyMarkerSource.signedPropNames());
            dirtyMarkerTarget.dirtyPropNames().clear();
            dirtyMarkerTarget.dirtyPropNames().addAll(dirtyMarkerSource.dirtyPropNames());
            DirtyMarkerUtil.setVersion(dirtyMarkerTarget, dirtyMarkerSource.version());
        }
    }

    public static void setVersion(DirtyMarker targetEntity, long version) {
        AbstractDirtyMarker dirtyMarker = null;
        dirtyMarker = targetEntity instanceof AbstractDirtyMarker ? (AbstractDirtyMarker)targetEntity : AbstractDirtyMarker.getDirtyMarkerImpl(targetEntity);
        if (dirtyMarker != null) {
            dirtyMarker.version = version;
        }
    }

    static {
        int multi = (int)(Runtime.getRuntime().maxMemory() / 0x10000000L);
        POOL_SIZE = Math.max(1000, Math.min(1000 * multi, 8192));
        dirtyMarkerClassPool = new ObjectPool(POOL_SIZE);
    }
}

