/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.core;

import com.landawn.abacus.annotation.Internal;
import com.landawn.abacus.core.AbstractDirtyMarker;
import com.landawn.abacus.core.NameUtil;
import com.landawn.abacus.util.N;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

@Internal
public final class MapEntity
extends AbstractDirtyMarker
implements Serializable {
    private static final long serialVersionUID = -6595007303962724540L;
    private final Map<String, Object> values = new HashMap<String, Object>();

    MapEntity() {
        this(N.EMPTY_STRING);
    }

    public MapEntity(String entityName) {
        super(entityName);
    }

    public MapEntity(String entityName, Map<String, Object> props) {
        this(entityName);
        this.set(props);
    }

    public static MapEntity valueOf(String entityName) {
        return new MapEntity(entityName);
    }

    public static MapEntity valueOf(String entityName, Map<String, Object> props) {
        return new MapEntity(entityName, props);
    }

    public <T> T get(String propName) {
        if (NameUtil.isCanonicalName(this.entityName, propName)) {
            return (T)this.values.get(NameUtil.getSimpleName(propName));
        }
        return (T)this.values.get(propName);
    }

    public <T> T get(Class<T> clazz, String propName) {
        T propValue = this.get(propName);
        if (propValue == null) {
            propValue = N.defaultValueOf(clazz);
        }
        return N.convert(propValue, clazz);
    }

    public MapEntity set(String propName, Object propValue) {
        this.checkForzen();
        if (NameUtil.isCanonicalName(this.entityName, propName)) {
            propName = NameUtil.getSimpleName(propName);
        }
        this.values.put(propName, propValue);
        this.setUpdatedPropName(propName);
        return this;
    }

    public void set(Map<String, Object> nameValues) {
        this.checkForzen();
        for (Map.Entry<String, Object> entry : nameValues.entrySet()) {
            this.set(entry.getKey(), entry.getValue());
        }
    }

    public Object remove(String propName) {
        this.checkForzen();
        if (this.values.size() == 0) {
            return null;
        }
        if (NameUtil.isCanonicalName(this.entityName, propName)) {
            propName = NameUtil.getSimpleName(propName);
        }
        this.dirtyPropNames.remove(propName);
        return this.values.remove(propName);
    }

    public void removeAll(Collection<String> propNames) {
        this.checkForzen();
        for (String propName : propNames) {
            this.remove(propName);
        }
    }

    public boolean containsKey(String propName) {
        if (this.values.size() == 0) {
            return false;
        }
        if (NameUtil.isCanonicalName(this.entityName, propName)) {
            return this.values.containsKey(NameUtil.getSimpleName(propName));
        }
        return this.values.containsKey(propName);
    }

    public Set<String> keySet() {
        return this.values.keySet();
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        return this.values.entrySet();
    }

    public Map<String, Object> props() {
        return this.values;
    }

    public int size() {
        return this.values.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public void clear() {
        this.checkForzen();
        this.dirtyPropNames().clear();
        this.values.clear();
    }

    public MapEntity copy() {
        MapEntity copy = new MapEntity(this.entityName, this.values);
        copy.version = this.version;
        copy.dirtyPropNames.clear();
        copy.dirtyPropNames.addAll(this.dirtyPropNames);
        return copy;
    }

    public int hashCode() {
        int h = 17;
        h = h * 31 + this.entityName.hashCode();
        h = h * 31 + this.values.hashCode();
        return h;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MapEntity) {
            MapEntity other = (MapEntity)obj;
            return N.equals(this.entityName, other.entityName) && N.equals(this.values, other.values);
        }
        return false;
    }

    public String toString() {
        return this.values.toString();
    }

    @Override
    public Set<String> signedPropNames() {
        return this.values.keySet();
    }

    @Override
    protected void setUpdatedPropName(String propName) {
        this.dirtyPropNames.add(propName);
    }

    @Override
    protected void setUpdatedPropNames(Collection<String> propNames) {
        this.dirtyPropNames.addAll(propNames);
    }

    @Override
    protected void init() {
        this.dirtyPropNames = N.newHashSet();
    }
}

