/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.core;

import com.landawn.abacus.DataSet;
import com.landawn.abacus.DirtyMarker;
import com.landawn.abacus.PaginatedDataSet;
import com.landawn.abacus.core.DirtyMarkerUtil;
import com.landawn.abacus.core.NameUtil;
import com.landawn.abacus.exception.UncheckedIOException;
import com.landawn.abacus.parser.JSONParser;
import com.landawn.abacus.parser.JSONSerializationConfig;
import com.landawn.abacus.parser.KryoParser;
import com.landawn.abacus.parser.ParserFactory;
import com.landawn.abacus.parser.ParserUtil;
import com.landawn.abacus.parser.XMLParser;
import com.landawn.abacus.parser.XMLSerializationConfig;
import com.landawn.abacus.type.Type;
import com.landawn.abacus.util.Array;
import com.landawn.abacus.util.ArrayHashMap;
import com.landawn.abacus.util.ArrayHashSet;
import com.landawn.abacus.util.BiIterator;
import com.landawn.abacus.util.BufferedJSONWriter;
import com.landawn.abacus.util.BufferedXMLWriter;
import com.landawn.abacus.util.ClassUtil;
import com.landawn.abacus.util.Comparators;
import com.landawn.abacus.util.DateTimeFormat;
import com.landawn.abacus.util.Fn;
import com.landawn.abacus.util.IOUtil;
import com.landawn.abacus.util.ImmutableList;
import com.landawn.abacus.util.Indexed;
import com.landawn.abacus.util.ListMultimap;
import com.landawn.abacus.util.Multimap;
import com.landawn.abacus.util.Multiset;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.NoCachingNoUpdating;
import com.landawn.abacus.util.Objectory;
import com.landawn.abacus.util.Pair;
import com.landawn.abacus.util.Properties;
import com.landawn.abacus.util.StringUtil;
import com.landawn.abacus.util.Throwables;
import com.landawn.abacus.util.Triple;
import com.landawn.abacus.util.Tuple;
import com.landawn.abacus.util.Wrapper;
import com.landawn.abacus.util.function.BiConsumer;
import com.landawn.abacus.util.function.Function;
import com.landawn.abacus.util.function.IndexedConsumer;
import com.landawn.abacus.util.function.IntFunction;
import com.landawn.abacus.util.function.Supplier;
import com.landawn.abacus.util.stream.Collector;
import com.landawn.abacus.util.u;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Set;

public class RowDataSet
implements DataSet,
Cloneable {
    static final char PROP_NAME_SEPARATOR = '.';
    static final String NULL_STRING = "null".intern();
    static final char[] NULL_CHAR_ARRAY = NULL_STRING.toCharArray();
    static final String TRUE = Boolean.TRUE.toString().intern();
    static final char[] TRUE_CHAR_ARRAY = TRUE.toCharArray();
    static final String FALSE = Boolean.FALSE.toString().intern();
    static final char[] FALSE_CHAR_ARRAY = FALSE.toCharArray();
    static final Set<Class<?>> SUPPORTED_COUNT_COLUMN_TYPES = N.asSet(Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class);
    private static final String ROW = "row";
    private static final JSONParser jsonParser = ParserFactory.createJSONParser();
    private static final XMLParser xmlParser = ParserFactory.isXMLAvailable() ? ParserFactory.createXMLParser() : null;
    private static final KryoParser kryoParser = ParserFactory.isKryoAvailable() ? ParserFactory.createKryoParser() : null;
    private static final JSONSerializationConfig jsc = (JSONSerializationConfig)JSONSerializationConfig.JSC.create().setDateTimeFormat(DateTimeFormat.ISO_8601_TIMESTAMP);
    private static final XMLSerializationConfig xsc = (XMLSerializationConfig)XMLSerializationConfig.XSC.create().setDateTimeFormat(DateTimeFormat.ISO_8601_TIMESTAMP);
    private static final Type<Object> strType = N.typeOf(String.class);
    private static final Comparator<Object[]> MULTI_COLUMN_COMPARATOR = new Comparator<Object[]>(){
        private final Comparator<Comparable> naturalOrder = Comparators.naturalOrder();

        @Override
        public int compare(Object[] o1, Object[] o2) {
            int rt = 0;
            int len = o1.length;
            for (int i = 0; i < len; ++i) {
                rt = this.naturalOrder.compare((Comparable)o1[i], (Comparable)o2[i]);
                if (rt == 0) continue;
                return rt;
            }
            return rt;
        }
    };
    List<String> _columnNameList;
    List<List<Object>> _columnList;
    Map<String, Integer> _columnIndexMap;
    int[] _columnIndexes;
    int _currentRowNum = 0;
    boolean _isFrozen = false;
    Properties<String, Object> _properties;
    transient int modCount = 0;
    private static final Function<NoCachingNoUpdating.DisposableObjArray, Object[]> CLONE = new Function<NoCachingNoUpdating.DisposableObjArray, Object[]>(){

        @Override
        public Object[] apply(NoCachingNoUpdating.DisposableObjArray t) {
            return t.clone();
        }
    };

    protected RowDataSet() {
    }

    public RowDataSet(List<String> columnNameList, List<List<Object>> columnList) {
        this(columnNameList, columnList, null);
    }

    public RowDataSet(List<String> columnNameList, List<List<Object>> columnList, Properties<String, Object> properties) {
        N.checkArgNotNull(columnNameList);
        N.checkArgNotNull(columnList);
        N.checkArgument(!N.hasDuplicates(columnNameList), "Dupliated column names: {}", columnNameList);
        N.checkArgument(columnNameList.size() == columnList.size(), "the size of column name list: {} is different from the size of column list: {}", columnNameList.size(), columnList.size());
        int size = columnList.size() == 0 ? 0 : columnList.get(0).size();
        for (List<Object> column : columnList) {
            N.checkArgument(column.size() == size, "All columns in the specified 'columnList' must have same size.");
        }
        this._columnNameList = columnNameList;
        this._columnList = columnList;
        this._properties = properties;
    }

    @Override
    public ImmutableList<String> columnNameList() {
        return ImmutableList.of(this._columnNameList);
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this._columnNameList.get(columnIndex);
    }

    @Override
    public int getColumnIndex(String columnName) {
        Integer columnIndex;
        if (this._columnIndexMap == null) {
            this._columnIndexMap = new HashMap<String, Integer>();
            int i = 0;
            for (String e : this._columnNameList) {
                this._columnIndexMap.put(e, i++);
            }
        }
        if ((columnIndex = this._columnIndexMap.get(columnName)) == null) {
            columnIndex = this._columnIndexMap.get(NameUtil.getSimpleName(columnName));
        }
        return columnIndex == null ? -1 : columnIndex;
    }

    @Override
    public int[] getColumnIndexes(Collection<String> columnNames) {
        int[] columnIndexes = new int[columnNames.size()];
        int i = 0;
        for (String columnName : columnNames) {
            columnIndexes[i++] = this.getColumnIndex(columnName);
        }
        return columnIndexes;
    }

    @Override
    public boolean containsColumn(String columnName) {
        return this.getColumnIndex(columnName) >= 0;
    }

    @Override
    public boolean containsAllColumns(Collection<String> columnNames) {
        for (String columnName : columnNames) {
            if (this.containsColumn(columnName)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void renameColumn(String columnName, String newColumnName) {
        this.checkFrozen();
        int idx = this.checkColumnName(columnName);
        if (!columnName.equals(newColumnName)) {
            if (this._columnNameList.contains(newColumnName)) {
                throw new IllegalArgumentException("The new property name is already included: " + this._columnNameList + ". ");
            }
            if (this._columnIndexMap != null) {
                this._columnIndexMap.put(newColumnName, this._columnIndexMap.remove(this._columnNameList.get(idx)));
            }
            this._columnNameList.set(idx, newColumnName);
        }
        ++this.modCount;
    }

    @Override
    public void renameColumns(Map<String, String> oldNewNames) {
        this.checkFrozen();
        if (N.hasDuplicates(oldNewNames.values())) {
            throw new IllegalArgumentException("Duplicated new column names: " + oldNewNames.values());
        }
        for (Map.Entry<String, String> entry : oldNewNames.entrySet()) {
            this.checkColumnName(entry.getKey());
            if (!this._columnNameList.contains(entry.getValue()) || entry.getKey().equals(entry.getValue())) continue;
            throw new IllegalArgumentException("The new property name is already included: " + this._columnNameList + ". ");
        }
        for (Map.Entry<String, String> entry : oldNewNames.entrySet()) {
            this.renameColumn(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public <E extends Exception> void renameColumn(String columnName, Throwables.Function<String, String, E> func) throws E {
        this.renameColumn(columnName, func.apply(columnName));
    }

    @Override
    public <E extends Exception> void renameColumns(Collection<String> columnNames, Throwables.Function<String, String, E> func) throws E {
        this.checkColumnName(columnNames);
        Map<String, String> map = N.newHashMap(columnNames.size());
        for (String columnName : columnNames) {
            map.put(columnName, func.apply(columnName));
        }
        this.renameColumns(map);
    }

    @Override
    public <E extends Exception> void renameColumns(Throwables.Function<String, String, E> func) throws E {
        this.renameColumns(this._columnNameList, func);
    }

    @Override
    public void moveColumn(String columnName, int newPosition) {
        this.checkFrozen();
        int idx = this.checkColumnName(columnName);
        if (newPosition < 0 || newPosition >= this._columnNameList.size()) {
            throw new IllegalArgumentException("The new column index must be >= 0 and < " + this._columnNameList.size());
        }
        if (idx != newPosition) {
            this._columnNameList.add(newPosition, this._columnNameList.remove(idx));
            this._columnList.add(newPosition, this._columnList.remove(idx));
            this._columnIndexMap = null;
            this._columnIndexes = null;
        }
        ++this.modCount;
    }

    @Override
    public void moveColumns(Map<String, Integer> columnNameNewPositionMap) {
        this.checkFrozen();
        ArrayList<Map.Entry<String, Integer>> entries = new ArrayList<Map.Entry<String, Integer>>(columnNameNewPositionMap.size());
        for (Map.Entry<String, Integer> entry : columnNameNewPositionMap.entrySet()) {
            this.checkColumnName(entry.getKey());
            if (entry.getValue() < 0 || entry.getValue() >= this._columnNameList.size()) {
                throw new IllegalArgumentException("The new column index must be >= 0 and < " + this._columnNameList.size());
            }
            entries.add(entry);
        }
        N.sort(entries, new Comparator<Map.Entry<String, Integer>>(){

            @Override
            public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                return Integer.compare(o1.getValue(), o2.getValue());
            }
        });
        for (Map.Entry<String, Integer> entry : entries) {
            int currentColumnIndex = this.checkColumnName(entry.getKey());
            if (currentColumnIndex == entry.getValue()) continue;
            this._columnNameList.add(entry.getValue(), this._columnNameList.remove(currentColumnIndex));
            this._columnList.add(entry.getValue(), this._columnList.remove(currentColumnIndex));
            this._columnIndexMap = null;
        }
        ++this.modCount;
    }

    @Override
    public void swapColumns(String columnNameA, String columnNameB) {
        this.checkFrozen();
        int columnIndexA = this.checkColumnName(columnNameA);
        int columnIndexB = this.checkColumnName(columnNameB);
        if (columnNameA.equals(columnNameB)) {
            return;
        }
        String tmpColumnNameA = this._columnNameList.get(columnIndexA);
        this._columnNameList.set(columnIndexA, this._columnNameList.get(columnIndexB));
        this._columnNameList.set(columnIndexB, tmpColumnNameA);
        List<Object> tmpColumnA = this._columnList.get(columnIndexA);
        this._columnList.set(columnIndexA, this._columnList.get(columnIndexB));
        this._columnList.set(columnIndexB, tmpColumnA);
        if (N.notNullOrEmpty(this._columnIndexMap)) {
            this._columnIndexMap.put(columnNameA, columnIndexB);
            this._columnIndexMap.put(columnNameB, columnIndexA);
        }
        ++this.modCount;
    }

    @Override
    public void moveRow(int rowIndex, int newRowIndex) {
        this.checkFrozen();
        this.checkRowNum(rowIndex);
        this.checkRowNum(newRowIndex);
        if (rowIndex == newRowIndex) {
            return;
        }
        for (List<Object> column : this._columnList) {
            column.add(newRowIndex, column.remove(rowIndex));
        }
        ++this.modCount;
    }

    @Override
    public void swapRows(int rowIndexA, int rowIndexB) {
        this.checkFrozen();
        this.checkRowNum(rowIndexA);
        this.checkRowNum(rowIndexB);
        if (rowIndexA == rowIndexB) {
            return;
        }
        Object tmp = null;
        for (List<Object> column : this._columnList) {
            tmp = column.get(rowIndexA);
            column.set(rowIndexA, column.get(rowIndexB));
            column.set(rowIndexB, tmp);
        }
        ++this.modCount;
    }

    @Override
    public <T> T get(int rowIndex, int columnIndex) {
        return (T)this._columnList.get(columnIndex).get(rowIndex);
    }

    @Override
    public <T> T get(Class<T> targetType, int rowIndex, int columnIndex) {
        Object rt = this._columnList.get(columnIndex).get(rowIndex);
        return (T)(rt == null ? N.defaultValueOf(targetType) : rt);
    }

    @Override
    public void set(int rowIndex, int columnIndex, Object element) {
        this.checkFrozen();
        this._columnList.get(columnIndex).set(rowIndex, element);
        ++this.modCount;
    }

    @Override
    public boolean isNull(int rowIndex, int columnIndex) {
        return this.get(rowIndex, columnIndex) == null;
    }

    @Override
    public <T> T get(int columnIndex) {
        return (T)this._columnList.get(columnIndex).get(this._currentRowNum);
    }

    @Override
    public <T> T get(Class<T> targetType, int columnIndex) {
        T rt = this.get(columnIndex);
        return rt == null ? N.defaultValueOf(targetType) : rt;
    }

    @Override
    public <T> T get(String columnName) {
        return this.get(this.checkColumnName(columnName));
    }

    @Override
    public <T> T get(Class<T> targetType, String columnName) {
        return this.get(targetType, this.checkColumnName(columnName));
    }

    @Override
    public <T> T getOrDefault(int columnIndex, T defaultValue) {
        return columnIndex < 0 ? defaultValue : this.get(columnIndex);
    }

    @Override
    public <T> T getOrDefault(String columnName, T defaultValue) {
        return this.getOrDefault(this.getColumnIndex(columnName), defaultValue);
    }

    @Override
    public boolean getBoolean(int columnIndex) {
        Boolean rt = this.get(Boolean.TYPE, columnIndex);
        return rt == null ? false : rt;
    }

    @Override
    public boolean getBoolean(String columnName) {
        return this.getBoolean(this.checkColumnName(columnName));
    }

    @Override
    public char getChar(int columnIndex) {
        Character rt = (Character)this.get(columnIndex);
        return rt == null ? (char)'\u0000' : rt.charValue();
    }

    @Override
    public char getChar(String columnName) {
        return this.getChar(this.checkColumnName(columnName));
    }

    @Override
    public byte getByte(int columnIndex) {
        Number rt = (Number)this.get(columnIndex);
        return rt == null ? (byte)0 : rt.byteValue();
    }

    @Override
    public byte getByte(String columnName) {
        return this.getByte(this.checkColumnName(columnName));
    }

    @Override
    public short getShort(int columnIndex) {
        Number rt = (Number)this.get(columnIndex);
        return rt == null ? (short)0 : rt.shortValue();
    }

    @Override
    public short getShort(String columnName) {
        return this.getShort(this.checkColumnName(columnName));
    }

    @Override
    public int getInt(int columnIndex) {
        Number rt = (Number)this.get(columnIndex);
        return rt == null ? 0 : rt.intValue();
    }

    @Override
    public int getInt(String columnName) {
        return this.getInt(this.checkColumnName(columnName));
    }

    @Override
    public long getLong(int columnIndex) {
        Number rt = (Number)this.get(columnIndex);
        return rt == null ? 0L : rt.longValue();
    }

    @Override
    public long getLong(String columnName) {
        return this.getLong(this.checkColumnName(columnName));
    }

    @Override
    public float getFloat(int columnIndex) {
        Number rt = (Number)this.get(columnIndex);
        return rt == null ? 0.0f : rt.floatValue();
    }

    @Override
    public float getFloat(String columnName) {
        return this.getFloat(this.checkColumnName(columnName));
    }

    @Override
    public double getDouble(int columnIndex) {
        Number rt = (Number)this.get(columnIndex);
        return rt == null ? 0.0 : rt.doubleValue();
    }

    @Override
    public double getDouble(String columnName) {
        return this.getDouble(this.checkColumnName(columnName));
    }

    @Override
    public boolean isNull(int columnIndex) {
        return this.get(columnIndex) == null;
    }

    @Override
    public boolean isNull(String columnName) {
        return this.get(columnName) == null;
    }

    @Override
    public void set(int columnIndex, Object value) {
        this.checkFrozen();
        this._columnList.get(columnIndex).set(this._currentRowNum, value);
        ++this.modCount;
    }

    @Override
    public void set(String columnName, Object value) {
        this.set(this.checkColumnName(columnName), value);
    }

    @Override
    public <T> ImmutableList<T> getColumn(int columnIndex) {
        return ImmutableList.of(this._columnList.get(columnIndex));
    }

    @Override
    public <T> ImmutableList<T> getColumn(String columnName) {
        return this.getColumn(this.checkColumnName(columnName));
    }

    @Override
    public void addColumn(String columnName, List<?> column) {
        this.addColumn(this._columnList.size(), columnName, column);
    }

    @Override
    public void addColumn(int columnIndex, String columnName, List<?> column) {
        this.checkFrozen();
        if (columnIndex < 0 || columnIndex > this._columnNameList.size()) {
            throw new IllegalArgumentException("Invalid column index: " + columnIndex + ". It must be >= 0 and <= " + this._columnNameList.size());
        }
        if (this.containsColumn(columnName)) {
            throw new IllegalArgumentException("Column(" + columnName + ") is already included in this DataSet.");
        }
        if (N.notNullOrEmpty(column) && column.size() != this.size()) {
            throw new IllegalArgumentException("The specified column size[" + column.size() + "] must be same as the this DataSet size[" + this.size() + "]. ");
        }
        this._columnNameList.add(columnIndex, columnName);
        if (N.isNullOrEmpty(column)) {
            this._columnList.add(columnIndex, N.repeat(null, this.size()));
        } else {
            this._columnList.add(columnIndex, new ArrayList(column));
        }
        this.updateColumnIndex(columnIndex, columnName);
        ++this.modCount;
    }

    @Override
    public <T, E extends Exception> void addColumn(String newColumnName, String fromColumnName, Throwables.Function<T, ?, E> func) throws E {
        this.addColumn(this._columnList.size(), newColumnName, fromColumnName, func);
    }

    @Override
    public <T, E extends Exception> void addColumn(int columnIndex, String newColumnName, String fromColumnName, Throwables.Function<T, ?, E> func) throws E {
        this.checkFrozen();
        if (columnIndex < 0 || columnIndex > this._columnNameList.size()) {
            throw new IllegalArgumentException("Invalid column index: " + columnIndex + ". It must be >= 0 and <= " + this._columnNameList.size());
        }
        if (this.containsColumn(newColumnName)) {
            throw new IllegalArgumentException("Column(" + newColumnName + ") is already included in this DataSet.");
        }
        ArrayList newColumn = new ArrayList(this.size());
        Throwables.Function<Object, ?, E> mapper2 = func;
        List<Object> column = this._columnList.get(this.checkColumnName(fromColumnName));
        for (Object val : column) {
            newColumn.add(mapper2.apply(val));
        }
        this._columnNameList.add(columnIndex, newColumnName);
        this._columnList.add(columnIndex, newColumn);
        this.updateColumnIndex(columnIndex, newColumnName);
        ++this.modCount;
    }

    @Override
    public <E extends Exception> void addColumn(String newColumnName, Collection<String> fromColumnNames, Throwables.Function<? super NoCachingNoUpdating.DisposableObjArray, ?, E> func) throws E {
        this.addColumn(this._columnList.size(), newColumnName, fromColumnNames, func);
    }

    @Override
    public <E extends Exception> void addColumn(int columnIndex, String newColumnName, Collection<String> fromColumnNames, Throwables.Function<? super NoCachingNoUpdating.DisposableObjArray, ?, E> func) throws E {
        this.checkFrozen();
        if (this.containsColumn(newColumnName)) {
            throw new IllegalArgumentException("Column(" + newColumnName + ") is already included in this DataSet.");
        }
        int size = this.size();
        int[] fromColumnIndexes = this.checkColumnName(fromColumnNames);
        Throwables.Function<NoCachingNoUpdating.DisposableObjArray, ?, E> mapper2 = func;
        ArrayList newColumn = new ArrayList(size);
        Object[] row = new Object[fromColumnIndexes.length];
        NoCachingNoUpdating.DisposableObjArray disposableArray = NoCachingNoUpdating.DisposableObjArray.wrap(row);
        for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
            int len = fromColumnIndexes.length;
            for (int i = 0; i < len; ++i) {
                row[i] = this._columnList.get(fromColumnIndexes[i]).get(rowIndex);
            }
            newColumn.add(mapper2.apply(disposableArray));
        }
        this._columnNameList.add(columnIndex, newColumnName);
        this._columnList.add(columnIndex, newColumn);
        this.updateColumnIndex(columnIndex, newColumnName);
        ++this.modCount;
    }

    private void updateColumnIndex(int columnIndex, String newColumnName) {
        if (this._columnIndexMap != null && columnIndex == this._columnIndexMap.size()) {
            this._columnIndexMap.put(newColumnName, columnIndex);
        } else {
            this._columnIndexMap = null;
        }
        if (this._columnIndexes != null && columnIndex == this._columnIndexes.length) {
            this._columnIndexes = N.copyOf(this._columnIndexes, this._columnIndexes.length + 1);
            this._columnIndexes[columnIndex] = columnIndex;
        } else {
            this._columnIndexes = null;
        }
    }

    @Override
    public <E extends Exception> void addColumn(String newColumnName, Tuple.Tuple2<String, String> fromColumnNames, Throwables.BiFunction<?, ?, ?, E> func) throws E {
        this.addColumn(this._columnList.size(), newColumnName, fromColumnNames, func);
    }

    @Override
    public <E extends Exception> void addColumn(int columnIndex, String newColumnName, Tuple.Tuple2<String, String> fromColumnNames, Throwables.BiFunction<?, ?, ?, E> func) throws E {
        this.checkFrozen();
        if (this.containsColumn(newColumnName)) {
            throw new IllegalArgumentException("Column(" + newColumnName + ") is already included in this DataSet.");
        }
        int size = this.size();
        List<Object> column1 = this._columnList.get(this.checkColumnName((String)fromColumnNames._1));
        List<Object> column2 = this._columnList.get(this.checkColumnName((String)fromColumnNames._2));
        Throwables.BiFunction<?, ?, ?, E> mapper2 = func;
        ArrayList newColumn = new ArrayList(this.size());
        for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
            newColumn.add(mapper2.apply(column1.get(rowIndex), column2.get(rowIndex)));
        }
        this._columnNameList.add(columnIndex, newColumnName);
        this._columnList.add(columnIndex, newColumn);
        this.updateColumnIndex(columnIndex, newColumnName);
        ++this.modCount;
    }

    @Override
    public <E extends Exception> void addColumn(String newColumnName, Tuple.Tuple3<String, String, String> fromColumnNames, Throwables.TriFunction<?, ?, ?, ?, E> func) throws E {
        this.addColumn(this._columnList.size(), newColumnName, fromColumnNames, func);
    }

    @Override
    public <E extends Exception> void addColumn(int columnIndex, String newColumnName, Tuple.Tuple3<String, String, String> fromColumnNames, Throwables.TriFunction<?, ?, ?, ?, E> func) throws E {
        this.checkFrozen();
        if (this.containsColumn(newColumnName)) {
            throw new IllegalArgumentException("Column(" + newColumnName + ") is already included in this DataSet.");
        }
        int size = this.size();
        List<Object> column1 = this._columnList.get(this.checkColumnName((String)fromColumnNames._1));
        List<Object> column2 = this._columnList.get(this.checkColumnName((String)fromColumnNames._2));
        List<Object> column3 = this._columnList.get(this.checkColumnName((String)fromColumnNames._3));
        Throwables.TriFunction<?, ?, ?, ?, E> mapper2 = func;
        ArrayList newColumn = new ArrayList(this.size());
        for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
            newColumn.add(mapper2.apply(column1.get(rowIndex), column2.get(rowIndex), column3.get(rowIndex)));
        }
        this._columnNameList.add(columnIndex, newColumnName);
        this._columnList.add(columnIndex, newColumn);
        this.updateColumnIndex(columnIndex, newColumnName);
        ++this.modCount;
    }

    @Override
    public <T> List<T> removeColumn(String columnName) {
        this.checkFrozen();
        int columnIndex = this.checkColumnName(columnName);
        this._columnIndexMap = null;
        this._columnIndexes = null;
        this._columnNameList.remove(columnIndex);
        List<Object> removedColumn = this._columnList.remove(columnIndex);
        ++this.modCount;
        return removedColumn;
    }

    @Override
    public void removeColumns(Collection<String> columnNames) {
        this.checkFrozen();
        int[] columnIndexes = this.checkColumnName(columnNames);
        N.sort(columnIndexes);
        int len = columnIndexes.length;
        for (int i = 0; i < len; ++i) {
            this._columnNameList.remove(columnIndexes[i] - i);
            this._columnList.remove(columnIndexes[i] - i);
        }
        this._columnIndexMap = null;
        this._columnIndexes = null;
        ++this.modCount;
    }

    @Override
    public <E extends Exception> void removeColumns(Throwables.Predicate<String, E> filter) throws E {
        this.removeColumns(N.filter(this._columnNameList, filter));
    }

    @Override
    @Deprecated
    public <E extends Exception> void removeColumnsIf(Throwables.Predicate<String, E> filter) throws E {
        this.removeColumns(filter);
    }

    @Override
    public void convertColumn(String columnName, Class<?> targetType) {
        this.checkFrozen();
        this.convertColumnType(this.checkColumnName(columnName), targetType);
    }

    @Override
    public void convertColumns(Map<String, Class<?>> columnTargetTypes) {
        this.checkFrozen();
        this.checkColumnName(columnTargetTypes.keySet());
        for (Map.Entry<String, Class<?>> entry : columnTargetTypes.entrySet()) {
            this.convertColumnType(this.checkColumnName(entry.getKey()), entry.getValue());
        }
    }

    @Override
    public <E extends Exception> void updateColumn(String columnName, Throwables.Function<?, ?, E> func) throws E {
        this.checkFrozen();
        Throwables.Function<?, ?, E> func2 = func;
        List<Object> column = this._columnList.get(this.checkColumnName(columnName));
        int len = this.size();
        for (int i = 0; i < len; ++i) {
            column.set(i, func2.apply(column.get(i)));
        }
        ++this.modCount;
    }

    @Override
    public <E extends Exception> void updateColumns(Collection<String> columnNames, Throwables.Function<?, ?, E> func) throws E {
        this.checkColumnName(columnNames);
        Throwables.Function<?, ?, E> func2 = func;
        for (String columnName : columnNames) {
            List<Object> column = this._columnList.get(this.checkColumnName(columnName));
            int len = this.size();
            for (int i = 0; i < len; ++i) {
                column.set(i, func2.apply(column.get(i)));
            }
        }
        ++this.modCount;
    }

    private void convertColumnType(int columnIndex, Class<?> targetType) {
        List<Object> column = this._columnList.get(columnIndex);
        Object newValue = null;
        int len = this.size();
        for (int i = 0; i < len; ++i) {
            newValue = N.convert(column.get(i), targetType);
            column.set(i, newValue);
        }
        ++this.modCount;
    }

    @Override
    public void combineColumns(Collection<String> columnNames, String newColumnName, Class<?> newColumnClass) {
        this.checkFrozen();
        List<?> newColumn = this.toList(newColumnClass, columnNames, 0, this.size());
        this.removeColumns(columnNames);
        this.addColumn(newColumnName, newColumn);
    }

    @Override
    public <E extends Exception> void combineColumns(Collection<String> columnNames, String newColumnName, Throwables.Function<? super NoCachingNoUpdating.DisposableObjArray, ?, E> combineFunc) throws E {
        this.addColumn(newColumnName, columnNames, combineFunc);
        this.removeColumns(columnNames);
    }

    @Override
    public <E extends Exception> void combineColumns(Throwables.Predicate<String, E> columnNameFilter, String newColumnName, Class<?> newColumnClass) throws E {
        this.combineColumns(N.filter(this._columnNameList, columnNameFilter), newColumnName, newColumnClass);
    }

    @Override
    public <E extends Exception, E2 extends Exception> void combineColumns(Throwables.Predicate<String, E> columnNameFilter, String newColumnName, Throwables.Function<? super NoCachingNoUpdating.DisposableObjArray, ?, E2> combineFunc) throws E, E2 {
        this.combineColumns(N.filter(this._columnNameList, columnNameFilter), newColumnName, combineFunc);
    }

    @Override
    public <E extends Exception> void combineColumns(Tuple.Tuple2<String, String> columnNames, String newColumnName, Throwables.BiFunction<?, ?, ?, E> combineFunc) throws E {
        this.addColumn(newColumnName, columnNames, combineFunc);
        this.removeColumns(Arrays.asList((String)columnNames._1, (String)columnNames._2));
    }

    @Override
    public <E extends Exception> void combineColumns(Tuple.Tuple3<String, String, String> columnNames, String newColumnName, Throwables.TriFunction<?, ?, ?, ?, E> combineFunc) throws E {
        this.addColumn(newColumnName, columnNames, combineFunc);
        this.removeColumns(Arrays.asList((String)columnNames._1, (String)columnNames._2, (String)columnNames._3));
    }

    @Override
    public <T, E extends Exception> void divideColumn(String columnName, Collection<String> newColumnNames, Throwables.Function<T, ? extends List<?>, E> divideFunc) throws E {
        this.checkFrozen();
        int columnIndex = this.checkColumnName(columnName);
        if (N.isNullOrEmpty(newColumnNames)) {
            throw new IllegalArgumentException("New column names can't be null or empty.");
        }
        if (!N.disjoint(this._columnNameList, newColumnNames)) {
            throw new IllegalArgumentException("Column names: " + N.intersection(this._columnNameList, newColumnNames) + " already are included in this data set.");
        }
        Throwables.Function<Object, List<?>, E> divideFunc2 = divideFunc;
        int newColumnsLen = newColumnNames.size();
        ArrayList newColumns = new ArrayList(newColumnsLen);
        for (int i = 0; i < newColumnsLen; ++i) {
            newColumns.add(new ArrayList(this.size()));
        }
        List<Object> column = this._columnList.get(columnIndex);
        for (Object val : column) {
            List<?> newVals = divideFunc2.apply(val);
            for (int i = 0; i < newColumnsLen; ++i) {
                ((List)newColumns.get(i)).add(newVals.get(i));
            }
        }
        this._columnNameList.remove(columnIndex);
        this._columnNameList.addAll(columnIndex, newColumnNames);
        this._columnList.remove(columnIndex);
        this._columnList.addAll(columnIndex, newColumns);
        this._columnIndexMap = null;
        this._columnIndexes = null;
        ++this.modCount;
    }

    @Override
    public <T, E extends Exception> void divideColumn(String columnName, Collection<String> newColumnNames, Throwables.BiConsumer<T, Object[], E> output) throws E {
        this.checkFrozen();
        int columnIndex = this.checkColumnName(columnName);
        if (N.isNullOrEmpty(newColumnNames)) {
            throw new IllegalArgumentException("New column names can't be null or empty.");
        }
        if (!N.disjoint(this._columnNameList, newColumnNames)) {
            throw new IllegalArgumentException("Column names: " + N.intersection(this._columnNameList, newColumnNames) + " already are included in this data set.");
        }
        Throwables.BiConsumer<Object, Object[], E> output2 = output;
        int newColumnsLen = newColumnNames.size();
        ArrayList newColumns = new ArrayList(newColumnsLen);
        for (int i = 0; i < newColumnsLen; ++i) {
            newColumns.add(new ArrayList(this.size()));
        }
        List<Object> column = this._columnList.get(columnIndex);
        Object[] tmp = new Object[newColumnsLen];
        for (Object val : column) {
            output2.accept(val, tmp);
            for (int i = 0; i < newColumnsLen; ++i) {
                ((List)newColumns.get(i)).add(tmp[i]);
            }
        }
        this._columnNameList.remove(columnIndex);
        this._columnNameList.addAll(columnIndex, newColumnNames);
        this._columnList.remove(columnIndex);
        this._columnList.addAll(columnIndex, newColumns);
        this._columnIndexMap = null;
        this._columnIndexes = null;
        ++this.modCount;
    }

    @Override
    public <T, E extends Exception> void divideColumn(String columnName, Tuple.Tuple2<String, String> newColumnNames, Throwables.BiConsumer<T, Pair<Object, Object>, E> output) throws E {
        this.checkFrozen();
        int columnIndex = this.checkColumnName(columnName);
        this.checkNewColumnName((String)newColumnNames._1);
        this.checkNewColumnName((String)newColumnNames._2);
        Throwables.BiConsumer<Object, Pair<Object, Object>, E> output2 = output;
        ArrayList newColumn1 = new ArrayList(this.size());
        ArrayList newColumn2 = new ArrayList(this.size());
        List<Object> column = this._columnList.get(columnIndex);
        Pair tmp = new Pair();
        for (Object val : column) {
            output2.accept(val, tmp);
            newColumn1.add(tmp.left);
            newColumn2.add(tmp.right);
        }
        this._columnNameList.remove(columnIndex);
        this._columnNameList.addAll(columnIndex, Arrays.asList((String)newColumnNames._1, (String)newColumnNames._2));
        this._columnList.remove(columnIndex);
        this._columnList.addAll(columnIndex, Arrays.asList(newColumn1, newColumn2));
        this._columnIndexMap = null;
        this._columnIndexes = null;
        ++this.modCount;
    }

    @Override
    public <T, E extends Exception> void divideColumn(String columnName, Tuple.Tuple3<String, String, String> newColumnNames, Throwables.BiConsumer<T, Triple<Object, Object, Object>, E> output) throws E {
        this.checkFrozen();
        int columnIndex = this.checkColumnName(columnName);
        this.checkNewColumnName((String)newColumnNames._1);
        this.checkNewColumnName((String)newColumnNames._2);
        this.checkNewColumnName((String)newColumnNames._3);
        Throwables.BiConsumer<Object, Triple<Object, Object, Object>, E> output2 = output;
        ArrayList newColumn1 = new ArrayList(this.size());
        ArrayList newColumn2 = new ArrayList(this.size());
        ArrayList newColumn3 = new ArrayList(this.size());
        List<Object> column = this._columnList.get(columnIndex);
        Triple tmp = new Triple();
        for (Object val : column) {
            output2.accept(val, tmp);
            newColumn1.add(tmp.left);
            newColumn2.add(tmp.middle);
            newColumn3.add(tmp.right);
        }
        this._columnNameList.remove(columnIndex);
        this._columnNameList.addAll(columnIndex, Arrays.asList((String)newColumnNames._1, (String)newColumnNames._2, (String)newColumnNames._3));
        this._columnList.remove(columnIndex);
        this._columnList.addAll(columnIndex, Arrays.asList(newColumn1, newColumn2, newColumn3));
        this._columnIndexMap = null;
        this._columnIndexes = null;
        ++this.modCount;
    }

    @Override
    public void addRow(Object row) {
        this.addRow(this.size(), row);
    }

    @Override
    public void addRow(int rowIndex, Object row) {
        this.checkFrozen();
        if (rowIndex < 0 || rowIndex > this.size()) {
            throw new IllegalArgumentException("Invalid row index: " + rowIndex + ". It must be >= 0 and <= " + this.size());
        }
        Class<?> rowClass = row.getClass();
        Type rowType = N.typeOf(rowClass);
        if (rowType.isObjectArray()) {
            Object[] a = (Object[])row;
            if (a.length < this._columnNameList.size()) {
                throw new IllegalArgumentException("The size of array (" + a.length + ") is less than the size of column (" + this._columnNameList.size() + ")");
            }
            if (rowIndex == this.size()) {
                int len = this._columnNameList.size();
                for (int i = 0; i < len; ++i) {
                    this._columnList.get(i).add(a[i]);
                }
            } else {
                int len = this._columnNameList.size();
                for (int i = 0; i < len; ++i) {
                    this._columnList.get(i).add(rowIndex, a[i]);
                }
            }
        } else if (rowType.isCollection()) {
            Collection c = (Collection)row;
            if (c.size() < this._columnNameList.size()) {
                throw new IllegalArgumentException("The size of collection (" + c.size() + ") is less than the size of column (" + this._columnNameList.size() + ")");
            }
            Iterator it = c.iterator();
            if (rowIndex == this.size()) {
                int len = this._columnNameList.size();
                for (int i = 0; i < len; ++i) {
                    this._columnList.get(i).add(it.next());
                }
            } else {
                int len = this._columnNameList.size();
                for (int i = 0; i < len; ++i) {
                    this._columnList.get(i).add(rowIndex, it.next());
                }
            }
        } else if (rowType.isMap()) {
            Map map = (Map)row;
            Object[] a = new Object[this._columnNameList.size()];
            int idx = 0;
            for (String columnName : this._columnNameList) {
                a[idx] = map.get(columnName);
                if (a[idx] == null && !map.containsKey(columnName)) {
                    throw new IllegalArgumentException("Column (" + columnName + ") is not found in map (" + map.keySet() + ")");
                }
                ++idx;
            }
            if (rowIndex == this.size()) {
                int len = this._columnNameList.size();
                for (int i = 0; i < len; ++i) {
                    this._columnList.get(i).add(a[i]);
                }
            } else {
                int len = this._columnNameList.size();
                for (int i = 0; i < len; ++i) {
                    this._columnList.get(i).add(rowIndex, a[i]);
                }
            }
        } else if (rowType.isEntity()) {
            ParserUtil.EntityInfo entityInfo = ParserUtil.getEntityInfo(rowClass);
            Object[] a = new Object[this._columnNameList.size()];
            ParserUtil.PropInfo propInfo = null;
            int idx = 0;
            for (String columnName : this._columnNameList) {
                propInfo = entityInfo.getPropInfo(columnName);
                if (propInfo == null) {
                    throw new IllegalArgumentException("Column (" + columnName + ") is not found in entity (" + rowClass + ")");
                }
                a[idx++] = propInfo.getPropValue(row);
            }
            if (rowIndex == this.size()) {
                int len = this._columnNameList.size();
                for (int i = 0; i < len; ++i) {
                    this._columnList.get(i).add(a[i]);
                }
            } else {
                int len = this._columnNameList.size();
                for (int i = 0; i < len; ++i) {
                    this._columnList.get(i).add(rowIndex, a[i]);
                }
            }
        } else {
            throw new IllegalArgumentException("Unsupported row type: " + ClassUtil.getCanonicalClassName(rowClass) + ". Only Array, List/Set, Map and entity class are supported");
        }
        ++this.modCount;
    }

    @Override
    public void removeRow(int rowIndex) {
        this.checkFrozen();
        this.checkRowNum(rowIndex);
        int len = this._columnList.size();
        for (int i = 0; i < len; ++i) {
            this._columnList.get(i).remove(rowIndex);
        }
        ++this.modCount;
    }

    @Override
    @SafeVarargs
    public final void removeRows(int ... indices) {
        this.checkFrozen();
        for (int rowIndex : indices) {
            this.checkRowNum(rowIndex);
        }
        int len = this._columnList.size();
        for (int i = 0; i < len; ++i) {
            N.deleteAll(this._columnList.get(i), indices);
        }
        ++this.modCount;
    }

    @Override
    public void removeRowRange(int inclusiveFromRowIndex, int exclusiveToRowIndex) {
        this.checkFrozen();
        this.checkRowIndex(inclusiveFromRowIndex, exclusiveToRowIndex);
        int len = this._columnList.size();
        for (int i = 0; i < len; ++i) {
            this._columnList.get(i).subList(inclusiveFromRowIndex, exclusiveToRowIndex).clear();
        }
        ++this.modCount;
    }

    @Override
    public <E extends Exception> void updateRow(int rowIndex, Throwables.Function<?, ?, E> func) throws E {
        this.checkFrozen();
        this.checkRowNum(rowIndex);
        Throwables.Function<?, ?, E> func2 = func;
        for (List<Object> column : this._columnList) {
            column.set(rowIndex, func2.apply(column.get(rowIndex)));
        }
        ++this.modCount;
    }

    @Override
    public <E extends Exception> void updateRows(int[] indices, Throwables.Function<?, ?, E> func) throws E {
        this.checkFrozen();
        for (int rowIndex : indices) {
            this.checkRowNum(rowIndex);
        }
        Throwables.Function<?, ?, E> func2 = func;
        for (List<Object> column : this._columnList) {
            for (int rowIndex : indices) {
                column.set(rowIndex, func2.apply(column.get(rowIndex)));
            }
        }
        ++this.modCount;
    }

    @Override
    public <E extends Exception> void updateAll(Throwables.Function<?, ?, E> func) throws E {
        this.checkFrozen();
        Throwables.Function<?, ?, E> func2 = func;
        int size = this.size();
        for (List<Object> column : this._columnList) {
            for (int i = 0; i < size; ++i) {
                column.set(i, func2.apply(column.get(i)));
            }
        }
        ++this.modCount;
    }

    @Override
    public <E extends Exception> void replaceIf(Throwables.Predicate<?, E> predicate, Object newValue) throws E {
        this.checkFrozen();
        Throwables.Predicate<?, E> Predicate2 = predicate;
        int size = this.size();
        Object val = null;
        for (List<Object> column : this._columnList) {
            for (int i = 0; i < size; ++i) {
                val = column.get(i);
                column.set(i, Predicate2.test(val) ? newValue : val);
            }
        }
        ++this.modCount;
    }

    @Override
    public int currentRowNum() {
        return this._currentRowNum;
    }

    @Override
    public DataSet absolute(int rowNum) {
        this.checkRowNum(rowNum);
        this._currentRowNum = rowNum;
        return this;
    }

    @Override
    public Object[] getRow(int rowNum) {
        return this.getRow(Object[].class, rowNum);
    }

    @Override
    public <T> T getRow(Class<? extends T> rowClass, int rowNum) {
        return this.getRow(rowClass, this._columnNameList, rowNum);
    }

    @Override
    public <T> T getRow(Class<? extends T> rowClass, Collection<String> columnNames, int rowNum) {
        this.checkRowNum(rowNum);
        Type rowType = N.typeOf(rowClass);
        boolean isAbstractRowClass = Modifier.isAbstract(rowClass.getModifiers());
        Constructor<? extends T> intConstructor = isAbstractRowClass ? null : ClassUtil.getDeclaredConstructor(rowClass, Integer.TYPE);
        Constructor<? extends T> constructor = isAbstractRowClass ? null : ClassUtil.getDeclaredConstructor(rowClass, new Class[0]);
        int columnCount = columnNames.size();
        Object result = null;
        if (rowType.isObjectArray()) {
            result = N.newArray(rowClass.getComponentType(), columnCount);
        } else if (rowType.isList() || rowType.isSet()) {
            result = isAbstractRowClass ? (rowType.isList() ? new ArrayList(columnCount) : N.newHashSet(columnCount)) : (intConstructor == null ? ClassUtil.invokeConstructor(constructor, new Object[0]) : ClassUtil.invokeConstructor(intConstructor, columnCount));
        } else if (rowType.isMap()) {
            result = isAbstractRowClass ? N.newHashMap(columnCount) : (intConstructor == null ? ClassUtil.invokeConstructor(constructor, new Object[0]) : ClassUtil.invokeConstructor(intConstructor, columnCount));
        } else if (rowType.isEntity()) {
            result = N.newInstance(rowClass);
        } else {
            throw new IllegalArgumentException("Unsupported row type: " + ClassUtil.getCanonicalClassName(rowClass) + ". Only Array, List/Set, Map and entity class are supported");
        }
        this.getRow(rowType, result, this.checkColumnName(columnNames), columnNames, rowNum);
        return (T)result;
    }

    @Override
    public <T> T getRow(IntFunction<? extends T> rowSupplier, int rowNum) {
        return this.getRow(rowSupplier, this._columnNameList, rowNum);
    }

    @Override
    public <T> T getRow(IntFunction<? extends T> rowSupplier, Collection<String> columnNames, int rowNum) {
        this.checkRowNum(rowNum);
        T row = rowSupplier.apply(columnNames.size());
        this.getRow(N.typeOf(row.getClass()), row, this.checkColumnName(columnNames), columnNames, rowNum);
        return row;
    }

    @Override
    public u.Optional<Object[]> firstRow() {
        return this.firstRow(Object[].class);
    }

    @Override
    public <T> u.Optional<T> firstRow(Class<? extends T> rowClass) {
        return this.firstRow(rowClass, this._columnNameList);
    }

    @Override
    public <T> u.Optional<T> firstRow(Class<? extends T> rowClass, Collection<String> columnNames) {
        return this.size() == 0 ? u.Optional.empty() : u.Optional.of(this.getRow(rowClass, columnNames, 0));
    }

    @Override
    public <T> u.Optional<T> firstRow(IntFunction<? extends T> rowSupplier) {
        return this.firstRow(rowSupplier, this._columnNameList);
    }

    @Override
    public <T> u.Optional<T> firstRow(IntFunction<? extends T> rowSupplier, Collection<String> columnNames) {
        if (this.size() == 0) {
            return u.Optional.empty();
        }
        T row = this.getRow(rowSupplier, columnNames, 0);
        return u.Optional.of(row);
    }

    @Override
    public u.Optional<Object[]> lastRow() {
        return this.lastRow(Object[].class);
    }

    @Override
    public <T> u.Optional<T> lastRow(Class<? extends T> rowClass) {
        return this.lastRow(rowClass, this._columnNameList);
    }

    @Override
    public <T> u.Optional<T> lastRow(Class<? extends T> rowClass, Collection<String> columnNames) {
        return this.size() == 0 ? u.Optional.empty() : u.Optional.of(this.getRow(rowClass, columnNames, this.size() - 1));
    }

    private void getRow(Type<?> rowType, Object output, int[] columnIndexes, Collection<String> columnNames, int rowNum) {
        this.checkRowNum(rowNum);
        if (columnIndexes == null) {
            columnIndexes = this.checkColumnName(columnNames);
        }
        int columnCount = columnIndexes.length;
        if (rowType.isObjectArray()) {
            Object[] result = (Object[])output;
            for (int i = 0; i < columnCount; ++i) {
                result[i] = this._columnList.get(columnIndexes[i]).get(rowNum);
            }
        } else if (rowType.isCollection()) {
            Collection result = (Collection)output;
            for (int i = 0; i < columnCount; ++i) {
                result.add(this._columnList.get(columnIndexes[i]).get(rowNum));
            }
        } else if (rowType.isMap()) {
            Map result = (Map)output;
            for (int i = 0; i < columnCount; ++i) {
                result.put(this._columnNameList.get(columnIndexes[i]), this._columnList.get(columnIndexes[i]).get(rowNum));
            }
        } else if (rowType.isEntity()) {
            boolean ignoreUnmatchedProperty = columnNames == this._columnNameList;
            ParserUtil.EntityInfo entityInfo = ParserUtil.getEntityInfo(rowType.clazz());
            Object result = output;
            String propName = null;
            Object propValue = null;
            for (int i = 0; i < columnCount; ++i) {
                propName = this._columnNameList.get(columnIndexes[i]);
                propValue = this._columnList.get(columnIndexes[i]).get(rowNum);
                entityInfo.setPropValue(result, propName, propValue, ignoreUnmatchedProperty);
            }
            if (result instanceof DirtyMarker) {
                DirtyMarkerUtil.markDirty((DirtyMarker)result, false);
            }
        } else {
            throw new IllegalArgumentException("Unsupported row type: " + rowType.clazz().getCanonicalName() + ". Only Array, Collection, Map and entity class are supported");
        }
    }

    @Override
    public <T> u.Optional<T> lastRow(IntFunction<? extends T> rowSupplier) {
        return this.lastRow(rowSupplier, this._columnNameList);
    }

    @Override
    public <T> u.Optional<T> lastRow(IntFunction<? extends T> rowSupplier, Collection<String> columnNames) {
        if (this.size() == 0) {
            return u.Optional.empty();
        }
        T row = this.getRow(rowSupplier, columnNames, this.size() - 1);
        return u.Optional.of(row);
    }

    @Override
    public <A, B> BiIterator<A, B> iterator(String columnNameA, String columnNameB) {
        return this.iterator(columnNameA, columnNameB, 0, this.size());
    }

    @Override
    public <A, B> BiIterator<A, B> iterator(String columnNameA, String columnNameB, int fromRowIndex, int toRowIndex) {
        this.checkRowIndex(fromRowIndex, toRowIndex);
        final List<Object> columnA = this._columnList.get(this.checkColumnName(columnNameA));
        final List<Object> columnB = this._columnList.get(this.checkColumnName(columnNameB));
        IndexedConsumer output = new IndexedConsumer<Pair<A, B>>(){
            private final int expectedModCount;
            {
                this.expectedModCount = RowDataSet.this.modCount;
            }

            @Override
            public void accept(int rowIndex, Pair<A, B> output) {
                if (RowDataSet.this.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                output.set(columnA.get(rowIndex), columnB.get(rowIndex));
            }
        };
        return BiIterator.generate(fromRowIndex, toRowIndex, output);
    }

    @Override
    public <E extends Exception> void forEach(Throwables.Consumer<? super NoCachingNoUpdating.DisposableObjArray, E> action) throws E {
        this.forEach(this._columnNameList, action);
    }

    @Override
    public <E extends Exception> void forEach(Collection<String> columnNames, Throwables.Consumer<? super NoCachingNoUpdating.DisposableObjArray, E> action) throws E {
        this.forEach(columnNames, 0, this.size(), action);
    }

    @Override
    public <E extends Exception> void forEach(int fromRowIndex, int toRowIndex, Throwables.Consumer<? super NoCachingNoUpdating.DisposableObjArray, E> action) throws E {
        this.forEach(this._columnNameList, fromRowIndex, toRowIndex, action);
    }

    @Override
    public <E extends Exception> void forEach(Collection<String> columnNames, int fromRowIndex, int toRowIndex, Throwables.Consumer<? super NoCachingNoUpdating.DisposableObjArray, E> action) throws E {
        int[] columnIndexes = this.checkColumnName(columnNames);
        this.checkRowIndex(fromRowIndex < toRowIndex ? fromRowIndex : (toRowIndex == -1 ? 0 : toRowIndex), fromRowIndex < toRowIndex ? toRowIndex : fromRowIndex);
        N.checkArgNotNull(action);
        if (this.size() == 0) {
            return;
        }
        int columnCount = columnIndexes.length;
        Object[] row = new Object[columnCount];
        NoCachingNoUpdating.DisposableObjArray disposableArray = NoCachingNoUpdating.DisposableObjArray.wrap(row);
        if (fromRowIndex <= toRowIndex) {
            for (int rowIndex = fromRowIndex; rowIndex < toRowIndex; ++rowIndex) {
                for (int i = 0; i < columnCount; ++i) {
                    row[i] = this._columnList.get(columnIndexes[i]).get(rowIndex);
                }
                action.accept(disposableArray);
            }
        } else {
            for (int rowIndex = N.min(this.size() - 1, fromRowIndex); rowIndex > toRowIndex; --rowIndex) {
                for (int i = 0; i < columnCount; ++i) {
                    row[i] = this._columnList.get(columnIndexes[i]).get(rowIndex);
                }
                action.accept(disposableArray);
            }
        }
    }

    @Override
    public <E extends Exception> void forEach(Tuple.Tuple2<String, String> columnNames, Throwables.BiConsumer<?, ?, E> action) throws E {
        this.forEach(columnNames, 0, this.size(), action);
    }

    @Override
    public <E extends Exception> void forEach(Tuple.Tuple2<String, String> columnNames, int fromRowIndex, int toRowIndex, Throwables.BiConsumer<?, ?, E> action) throws E {
        List<Object> column1 = this._columnList.get(this.checkColumnName((String)columnNames._1));
        List<Object> column2 = this._columnList.get(this.checkColumnName((String)columnNames._2));
        this.checkRowIndex(fromRowIndex < toRowIndex ? fromRowIndex : (toRowIndex == -1 ? 0 : toRowIndex), fromRowIndex < toRowIndex ? toRowIndex : fromRowIndex);
        N.checkArgNotNull(action);
        if (this.size() == 0) {
            return;
        }
        Throwables.BiConsumer<?, ?, E> action2 = action;
        if (fromRowIndex <= toRowIndex) {
            for (int rowIndex = fromRowIndex; rowIndex < toRowIndex; ++rowIndex) {
                action2.accept(column1.get(rowIndex), column2.get(rowIndex));
            }
        } else {
            for (int rowIndex = N.min(this.size() - 1, fromRowIndex); rowIndex > toRowIndex; --rowIndex) {
                action2.accept(column1.get(rowIndex), column2.get(rowIndex));
            }
        }
    }

    @Override
    public <E extends Exception> void forEach(Tuple.Tuple3<String, String, String> columnNames, Throwables.TriConsumer<?, ?, ?, E> action) throws E {
        this.forEach(columnNames, 0, this.size(), action);
    }

    @Override
    public <E extends Exception> void forEach(Tuple.Tuple3<String, String, String> columnNames, int fromRowIndex, int toRowIndex, Throwables.TriConsumer<?, ?, ?, E> action) throws E {
        List<Object> column1 = this._columnList.get(this.checkColumnName((String)columnNames._1));
        List<Object> column2 = this._columnList.get(this.checkColumnName((String)columnNames._2));
        List<Object> column3 = this._columnList.get(this.checkColumnName((String)columnNames._3));
        this.checkRowIndex(fromRowIndex < toRowIndex ? fromRowIndex : (toRowIndex == -1 ? 0 : toRowIndex), fromRowIndex < toRowIndex ? toRowIndex : fromRowIndex);
        N.checkArgNotNull(action);
        if (this.size() == 0) {
            return;
        }
        Throwables.TriConsumer<?, ?, ?, E> action2 = action;
        if (fromRowIndex <= toRowIndex) {
            for (int rowIndex = fromRowIndex; rowIndex < toRowIndex; ++rowIndex) {
                action2.accept(column1.get(rowIndex), column2.get(rowIndex), column3.get(rowIndex));
            }
        } else {
            for (int rowIndex = N.min(this.size() - 1, fromRowIndex); rowIndex > toRowIndex; --rowIndex) {
                action2.accept(column1.get(rowIndex), column2.get(rowIndex), column3.get(rowIndex));
            }
        }
    }

    @Override
    public List<Object[]> toList() {
        return this.toList(Object[].class);
    }

    @Override
    public List<Object[]> toList(int fromRowIndex, int toRowIndex) {
        return this.toList(Object[].class, fromRowIndex, toRowIndex);
    }

    @Override
    public <T> List<T> toList(Class<? extends T> rowClass) {
        return this.toList(rowClass, 0, this.size());
    }

    @Override
    public <T> List<T> toList(Class<? extends T> rowClass, int fromRowIndex, int toRowIndex) {
        return this.toList(rowClass, this._columnNameList, fromRowIndex, toRowIndex);
    }

    @Override
    public <T> List<T> toList(Class<? extends T> rowClass, Collection<String> columnNames) {
        return this.toList(rowClass, columnNames, 0, this.size());
    }

    @Override
    public <T> List<T> toList(Class<? extends T> rowClass, Collection<String> columnNames, int fromRowIndex, int toRowIndex) {
        this.checkRowIndex(fromRowIndex, toRowIndex);
        int[] columnIndexes = this.checkColumnName(columnNames);
        int columnCount = columnIndexes.length;
        ArrayList<Object> rowList = new ArrayList<Object>(toRowIndex - fromRowIndex);
        if (fromRowIndex == toRowIndex) {
            return rowList;
        }
        Type rowType = N.typeOf(rowClass);
        if (rowType.isObjectArray()) {
            Class<?> componentType = rowClass.getComponentType();
            Object[] row = null;
            for (int rowIndex = fromRowIndex; rowIndex < toRowIndex; ++rowIndex) {
                row = (Object[])N.newArray(componentType, columnCount);
                for (int i = 0; i < columnCount; ++i) {
                    row[i] = this._columnList.get(columnIndexes[i]).get(rowIndex);
                }
                rowList.add(row);
            }
        } else if (rowType.isList() || rowType.isSet()) {
            boolean isAbstractRowClass = Modifier.isAbstract(rowClass.getModifiers());
            Constructor<? extends T> intConstructor = isAbstractRowClass ? null : ClassUtil.getDeclaredConstructor(rowClass, Integer.TYPE);
            Constructor<? extends T> constructor = isAbstractRowClass ? null : ClassUtil.getDeclaredConstructor(rowClass, new Class[0]);
            Collection row = null;
            for (int rowIndex = fromRowIndex; rowIndex < toRowIndex; ++rowIndex) {
                row = isAbstractRowClass ? (rowType.isList() ? new ArrayList(columnCount) : N.newHashSet(columnCount)) : (intConstructor == null ? ClassUtil.invokeConstructor(constructor, new Object[0]) : ClassUtil.invokeConstructor(intConstructor, columnCount));
                for (int i = 0; i < columnCount; ++i) {
                    row.add(this._columnList.get(columnIndexes[i]).get(rowIndex));
                }
                rowList.add(row);
            }
        } else if (rowType.isMap()) {
            String[] mapKeyNames = new String[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                mapKeyNames[i] = this._columnNameList.get(columnIndexes[i]);
            }
            boolean isAbstractRowClass = Modifier.isAbstract(rowClass.getModifiers());
            Constructor<? extends T> intConstructor = isAbstractRowClass ? null : ClassUtil.getDeclaredConstructor(rowClass, Integer.TYPE);
            Constructor<? extends T> constructor = isAbstractRowClass ? null : ClassUtil.getDeclaredConstructor(rowClass, new Class[0]);
            Map<String, Object> row = null;
            for (int rowIndex = fromRowIndex; rowIndex < toRowIndex; ++rowIndex) {
                row = isAbstractRowClass ? N.newHashMap(columnCount) : (intConstructor == null ? ClassUtil.invokeConstructor(constructor, new Object[0]) : ClassUtil.invokeConstructor(intConstructor, columnCount));
                for (int i = 0; i < columnCount; ++i) {
                    row.put(mapKeyNames[i], this._columnList.get(columnIndexes[i]).get(rowIndex));
                }
                rowList.add(row);
            }
        } else if (rowType.isEntity()) {
            for (int rowNum = fromRowIndex; rowNum < toRowIndex; ++rowNum) {
                rowList.add(N.newInstance(rowClass));
            }
            boolean ignoreUnmatchedProperty = columnNames == this._columnNameList;
            ParserUtil.EntityInfo entityInfo = ParserUtil.getEntityInfo(rowClass);
            List<Object> column = null;
            String propName = null;
            ParserUtil.PropInfo propInfo = null;
            for (int columnIndex : columnIndexes) {
                int rowIndex;
                column = this._columnList.get(columnIndex);
                propName = this._columnNameList.get(columnIndex);
                propInfo = entityInfo.getPropInfo(propName);
                if (propInfo == null) {
                    for (rowIndex = fromRowIndex; rowIndex < toRowIndex && entityInfo.setPropValue(rowList.get(rowIndex - fromRowIndex), propName, column.get(rowIndex), ignoreUnmatchedProperty); ++rowIndex) {
                    }
                    continue;
                }
                for (rowIndex = fromRowIndex; rowIndex < toRowIndex; ++rowIndex) {
                    propInfo.setPropValue(rowList.get(rowIndex - fromRowIndex), column.get(rowIndex));
                }
            }
            if (rowList.size() > 0 && rowList.get(0) instanceof DirtyMarker) {
                Object object = rowList.iterator();
                while (object.hasNext()) {
                    Object e = object.next();
                    DirtyMarkerUtil.markDirty((DirtyMarker)e, false);
                }
            }
        } else {
            throw new IllegalArgumentException("Unsupported row type: " + ClassUtil.getCanonicalClassName(rowClass) + ". Only Array, List/Set, Map and entity class are supported");
        }
        return rowList;
    }

    @Override
    public <T, E extends Exception, E2 extends Exception> List<T> toList(Class<? extends T> rowClass, Throwables.Predicate<? super String, E> columnNameFilter, Throwables.Function<? super String, String, E2> columnNameConverter) throws E, E2 {
        return this.toList(rowClass, columnNameFilter, columnNameConverter, 0, this.size());
    }

    @Override
    public <T, E extends Exception, E2 extends Exception> List<T> toList(Class<? extends T> rowClass, Throwables.Predicate<? super String, E> columnNameFilter, Throwables.Function<? super String, String, E2> columnNameConverter, int fromRowIndex, int toRowIndex) throws E, E2 {
        this.checkRowIndex(fromRowIndex, toRowIndex);
        if ((columnNameFilter == null || Objects.equals(columnNameFilter, Fn.Fnn.alwaysTrue())) && columnNameConverter == null && Objects.equals(columnNameConverter, Fn.Fnn.identity())) {
            return this.toList(rowClass, this._columnNameList, fromRowIndex, toRowIndex);
        }
        ArrayList<Map<String, Object>> rowList = new ArrayList<Map<String, Object>>(toRowIndex - fromRowIndex);
        if (fromRowIndex == toRowIndex) {
            return rowList;
        }
        Type rowType = N.typeOf(rowClass);
        if (rowType.isObjectArray() || rowType.isList() || rowType.isSet() || columnNameConverter == null && Objects.equals(columnNameConverter, Fn.Fnn.identity())) {
            return this.toList(rowClass, columnNameFilter == null ? this._columnNameList : N.filter(this._columnNameList, columnNameFilter), fromRowIndex, toRowIndex);
        }
        Throwables.Predicate columnNameFilterToBeUsed = columnNameFilter == null ? Fn.Fnn.alwaysTrue() : columnNameFilter;
        Throwables.Function<Object, Object, Object> columnNameConverterToBeUsed = columnNameConverter == null ? Fn.Fnn.identity() : columnNameConverter;
        ArrayList<Integer> columnIndexList = new ArrayList<Integer>();
        int len = this._columnNameList.size();
        for (int i = 0; i < len; ++i) {
            if (!columnNameFilterToBeUsed.test(this._columnNameList.get(i))) continue;
            columnIndexList.add(i);
        }
        int columnCount = columnIndexList.size();
        int[] columnIndexes = new int[columnCount];
        String[] newColumnNames = new String[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            columnIndexes[i] = (Integer)columnIndexList.get(i);
            newColumnNames[i] = (String)columnNameConverterToBeUsed.apply(this._columnNameList.get(columnIndexes[i]));
        }
        if (rowType.isMap()) {
            boolean isAbstractRowClass = Modifier.isAbstract(rowClass.getModifiers());
            Constructor<T> intConstructor = isAbstractRowClass ? null : ClassUtil.getDeclaredConstructor(rowClass, Integer.TYPE);
            Constructor<T> constructor = isAbstractRowClass ? null : ClassUtil.getDeclaredConstructor(rowClass, new Class[0]);
            Map<String, Object> row = null;
            for (int rowIndex = fromRowIndex; rowIndex < toRowIndex; ++rowIndex) {
                row = isAbstractRowClass ? N.newHashMap(columnCount) : (intConstructor == null ? ClassUtil.invokeConstructor(constructor, new Object[0]) : ClassUtil.invokeConstructor(intConstructor, columnCount));
                for (int i = 0; i < columnCount; ++i) {
                    row.put(newColumnNames[i], this._columnList.get(columnIndexes[i]).get(rowIndex));
                }
                rowList.add(row);
            }
        } else if (rowType.isEntity()) {
            for (int rowNum = fromRowIndex; rowNum < toRowIndex; ++rowNum) {
                rowList.add((Map<String, Object>)N.newInstance(rowClass));
            }
            boolean ignoreUnmatchedProperty = false;
            ParserUtil.EntityInfo entityInfo = ParserUtil.getEntityInfo(rowClass);
            int columnIndex = -1;
            String propName = null;
            List<Object> column = null;
            ParserUtil.PropInfo propInfo = null;
            for (int i = 0; i < columnCount; ++i) {
                int n;
                columnIndex = columnIndexes[i];
                propName = newColumnNames[i];
                column = this._columnList.get(columnIndex);
                propInfo = entityInfo.getPropInfo(propName);
                if (propInfo == null) {
                    for (n = fromRowIndex; n < toRowIndex && entityInfo.setPropValue(rowList.get(n - fromRowIndex), propName, column.get(n), false); ++n) {
                    }
                    continue;
                }
                for (n = fromRowIndex; n < toRowIndex; ++n) {
                    propInfo.setPropValue(rowList.get(n - fromRowIndex), column.get(n));
                }
            }
            if (rowList.size() > 0 && rowList.get(0) instanceof DirtyMarker) {
                for (Object e : rowList) {
                    DirtyMarkerUtil.markDirty((DirtyMarker)e, false);
                }
            }
        } else {
            throw new IllegalArgumentException("Unsupported row type: " + ClassUtil.getCanonicalClassName(rowClass) + ". Only Array, List/Set, Map and entity class are supported");
        }
        return rowList;
    }

    @Override
    public <T> List<T> toList(IntFunction<? extends T> rowSupplier) {
        return this.toList(rowSupplier, this._columnNameList);
    }

    @Override
    public <T> List<T> toList(IntFunction<? extends T> rowSupplier, int fromRowIndex, int toRowIndex) {
        return this.toList(rowSupplier, this._columnNameList, fromRowIndex, toRowIndex);
    }

    @Override
    public <T> List<T> toList(IntFunction<? extends T> rowSupplier, Collection<String> columnNames) {
        return this.toList(rowSupplier, columnNames, 0, this.size());
    }

    @Override
    public <T> List<T> toList(IntFunction<? extends T> rowSupplier, Collection<String> columnNames, int fromRowIndex, int toRowIndex) {
        this.checkRowIndex(fromRowIndex, toRowIndex);
        ArrayList<Object> rowList = new ArrayList<Object>(toRowIndex - fromRowIndex);
        int[] columnIndexes = this.checkColumnName(columnNames);
        int columnCount = columnIndexes.length;
        if (fromRowIndex == toRowIndex) {
            return rowList;
        }
        Class<?> rowClass = rowSupplier.apply(0).getClass();
        Type rowType = N.typeOf(rowClass);
        if (rowType.isObjectArray()) {
            Object[] row = null;
            for (int rowIndex = fromRowIndex; rowIndex < toRowIndex; ++rowIndex) {
                row = (Object[])rowSupplier.apply(columnCount);
                for (int i = 0; i < columnCount; ++i) {
                    row[i] = this._columnList.get(columnIndexes[i]).get(rowIndex);
                }
                rowList.add(row);
            }
        } else if (rowType.isList() || rowType.isSet()) {
            Collection row = null;
            for (int rowIndex = fromRowIndex; rowIndex < toRowIndex; ++rowIndex) {
                row = (Collection)rowSupplier.apply(columnCount);
                for (int i = 0; i < columnCount; ++i) {
                    row.add(this._columnList.get(columnIndexes[i]).get(rowIndex));
                }
                rowList.add(row);
            }
        } else if (rowType.isMap()) {
            String[] mapKeyNames = new String[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                mapKeyNames[i] = this._columnNameList.get(columnIndexes[i]);
            }
            Map row = null;
            for (int rowIndex = fromRowIndex; rowIndex < toRowIndex; ++rowIndex) {
                row = (Map)rowSupplier.apply(columnCount);
                for (int i = 0; i < columnCount; ++i) {
                    row.put(mapKeyNames[i], this._columnList.get(columnIndexes[i]).get(rowIndex));
                }
                rowList.add(row);
            }
        } else if (rowType.isEntity()) {
            for (int rowNum = fromRowIndex; rowNum < toRowIndex; ++rowNum) {
                rowList.add(rowSupplier.apply(columnCount));
            }
            boolean ignoreUnmatchedProperty = columnNames == this._columnNameList;
            ParserUtil.EntityInfo entityInfo = ParserUtil.getEntityInfo(rowClass);
            List<Object> column = null;
            String propName = null;
            ParserUtil.PropInfo propInfo = null;
            for (int columnIndex : columnIndexes) {
                int rowIndex;
                column = this._columnList.get(columnIndex);
                propName = this._columnNameList.get(columnIndex);
                propInfo = entityInfo.getPropInfo(propName);
                if (propInfo == null) {
                    for (rowIndex = fromRowIndex; rowIndex < toRowIndex && entityInfo.setPropValue(rowList.get(rowIndex - fromRowIndex), propName, column.get(rowIndex), ignoreUnmatchedProperty); ++rowIndex) {
                    }
                    continue;
                }
                for (rowIndex = fromRowIndex; rowIndex < toRowIndex; ++rowIndex) {
                    propInfo.setPropValue(rowList.get(rowIndex - fromRowIndex), column.get(rowIndex));
                }
            }
            if (rowList.size() > 0 && rowList.get(0) instanceof DirtyMarker) {
                Object object = rowList.iterator();
                while (object.hasNext()) {
                    Object e = object.next();
                    DirtyMarkerUtil.markDirty((DirtyMarker)e, false);
                }
            }
        } else {
            throw new IllegalArgumentException("Unsupported row type: " + ClassUtil.getCanonicalClassName(rowClass) + ". Only Array, List/Set, Map and entity class are supported");
        }
        return rowList;
    }

    @Override
    public <K, V> Map<K, V> toMap(String keyColumnName, String valueColumnName) {
        return this.toMap(keyColumnName, valueColumnName, 0, this.size());
    }

    @Override
    public <K, V> Map<K, V> toMap(String keyColumnName, String valueColumnName, int fromRowIndex, int toRowIndex) {
        return this.toMap(keyColumnName, valueColumnName, fromRowIndex, toRowIndex, new IntFunction<Map<K, V>>(){

            @Override
            public Map<K, V> apply(int len) {
                return N.newLinkedHashMap(len);
            }
        });
    }

    @Override
    public <K, V, M extends Map<K, V>> M toMap(String keyColumnName, String valueColumnName, int fromRowIndex, int toRowIndex, IntFunction<? extends M> supplier) {
        this.checkRowIndex(fromRowIndex, toRowIndex);
        int keyColumnIndex = this.checkColumnName(keyColumnName);
        int valueColumnIndex = this.checkColumnName(valueColumnName);
        Map resultMap = (Map)supplier.apply(toRowIndex - fromRowIndex);
        for (int rowIndex = fromRowIndex; rowIndex < toRowIndex; ++rowIndex) {
            resultMap.put(this._columnList.get(keyColumnIndex).get(rowIndex), this._columnList.get(valueColumnIndex).get(rowIndex));
        }
        return (M)resultMap;
    }

    @Override
    public <K, V> Map<K, V> toMap(Class<? extends V> rowClass, String keyColumnName, Collection<String> valueColumnNames) {
        return this.toMap(rowClass, keyColumnName, valueColumnNames, 0, this.size());
    }

    @Override
    public <K, V> Map<K, V> toMap(Class<? extends V> rowClass, String keyColumnName, Collection<String> valueColumnNames, int fromRowIndex, int toRowIndex) {
        return this.toMap(rowClass, keyColumnName, valueColumnNames, fromRowIndex, toRowIndex, new IntFunction<Map<K, V>>(){

            @Override
            public Map<K, V> apply(int len) {
                return N.newLinkedHashMap(len);
            }
        });
    }

    @Override
    public <K, V, M extends Map<K, V>> M toMap(Class<? extends V> rowClass, String keyColumnName, Collection<String> valueColumnNames, int fromRowIndex, int toRowIndex, IntFunction<? extends M> supplier) {
        this.checkRowIndex(fromRowIndex, toRowIndex);
        int keyColumnIndex = this.checkColumnName(keyColumnName);
        int[] valueColumnIndexes = this.checkColumnName(valueColumnNames);
        Type valueType = N.typeOf(rowClass);
        int valueColumnCount = valueColumnIndexes.length;
        Map resultMap = (Map)supplier.apply(toRowIndex - fromRowIndex);
        if (valueType.isObjectArray()) {
            Object[] value = null;
            for (int rowIndex = fromRowIndex; rowIndex < toRowIndex; ++rowIndex) {
                value = (Object[])N.newArray(rowClass.getComponentType(), valueColumnCount);
                for (int i = 0; i < valueColumnCount; ++i) {
                    value[i] = this._columnList.get(valueColumnIndexes[i]).get(rowIndex);
                }
                resultMap.put(this._columnList.get(keyColumnIndex).get(rowIndex), value);
            }
        } else if (valueType.isList() || valueType.isSet()) {
            boolean isAbstractRowClass = Modifier.isAbstract(rowClass.getModifiers());
            Constructor<V> intConstructor = isAbstractRowClass ? null : ClassUtil.getDeclaredConstructor(rowClass, Integer.TYPE);
            Constructor<V> constructor = isAbstractRowClass ? null : ClassUtil.getDeclaredConstructor(rowClass, new Class[0]);
            Collection value = null;
            for (int rowIndex = fromRowIndex; rowIndex < toRowIndex; ++rowIndex) {
                value = isAbstractRowClass ? (valueType.isList() ? new ArrayList(valueColumnCount) : N.newHashSet(valueColumnCount)) : (intConstructor == null ? ClassUtil.invokeConstructor(constructor, new Object[0]) : ClassUtil.invokeConstructor(intConstructor, valueColumnCount));
                for (int columIndex : valueColumnIndexes) {
                    value.add(this._columnList.get(columIndex).get(rowIndex));
                }
                resultMap.put(this._columnList.get(keyColumnIndex).get(rowIndex), value);
            }
        } else if (valueType.isMap()) {
            boolean isAbstractRowClass = Modifier.isAbstract(rowClass.getModifiers());
            Constructor<V> intConstructor = isAbstractRowClass ? null : ClassUtil.getDeclaredConstructor(rowClass, Integer.TYPE);
            Constructor<V> constructor = isAbstractRowClass ? null : ClassUtil.getDeclaredConstructor(rowClass, new Class[0]);
            Map<String, Object> value = null;
            for (int rowIndex = fromRowIndex; rowIndex < toRowIndex; ++rowIndex) {
                value = isAbstractRowClass ? N.newHashMap(valueColumnCount) : (intConstructor == null ? ClassUtil.invokeConstructor(constructor, new Object[0]) : ClassUtil.invokeConstructor(intConstructor, valueColumnCount));
                for (int columIndex : valueColumnIndexes) {
                    value.put(this._columnNameList.get(columIndex), this._columnList.get(columIndex).get(rowIndex));
                }
                resultMap.put(this._columnList.get(keyColumnIndex).get(rowIndex), value);
            }
        } else if (valueType.isEntity()) {
            boolean ignoreUnmatchedProperty = valueColumnNames == this._columnNameList;
            boolean isDirtyMarker = DirtyMarkerUtil.isDirtyMarker(rowClass);
            ParserUtil.EntityInfo entityInfo = ParserUtil.getEntityInfo(rowClass);
            Object value = null;
            String propName = null;
            for (int rowIndex = fromRowIndex; rowIndex < toRowIndex; ++rowIndex) {
                value = N.newInstance(rowClass);
                for (int columIndex : valueColumnIndexes) {
                    propName = this._columnNameList.get(columIndex);
                    entityInfo.setPropValue(value, propName, this._columnList.get(columIndex).get(rowIndex), ignoreUnmatchedProperty);
                }
                if (isDirtyMarker) {
                    DirtyMarkerUtil.markDirty((DirtyMarker)value, false);
                }
                resultMap.put(this._columnList.get(keyColumnIndex).get(rowIndex), value);
            }
        } else {
            throw new IllegalArgumentException("Unsupported row type: " + rowClass.getCanonicalName() + ". Only Array, List/Set, Map and entity class are supported");
        }
        return (M)resultMap;
    }

    @Override
    public <K, V> Map<K, V> toMap(IntFunction<? extends V> rowSupplier, String keyColumnName, Collection<String> valueColumnNames) {
        return this.toMap(rowSupplier, keyColumnName, valueColumnNames, 0, this.size());
    }

    @Override
    public <K, V> Map<K, V> toMap(IntFunction<? extends V> rowSupplier, String keyColumnName, Collection<String> valueColumnNames, int fromRowIndex, int toRowIndex) {
        return this.toMap(rowSupplier, keyColumnName, valueColumnNames, fromRowIndex, toRowIndex, new IntFunction<Map<K, V>>(){

            @Override
            public Map<K, V> apply(int len) {
                return N.newLinkedHashMap(len);
            }
        });
    }

    @Override
    public <K, V, M extends Map<K, V>> M toMap(IntFunction<? extends V> rowSupplier, String keyColumnName, Collection<String> valueColumnNames, int fromRowIndex, int toRowIndex, IntFunction<? extends M> supplier) {
        this.checkRowIndex(fromRowIndex, toRowIndex);
        int keyColumnIndex = this.checkColumnName(keyColumnName);
        int[] valueColumnIndexes = this.checkColumnName(valueColumnNames);
        Class<?> rowClass = rowSupplier.apply(0).getClass();
        Type valueType = N.typeOf(rowClass);
        int valueColumnCount = valueColumnIndexes.length;
        Map resultMap = (Map)supplier.apply(toRowIndex - fromRowIndex);
        if (valueType.isObjectArray()) {
            Object[] value = null;
            for (int rowIndex = fromRowIndex; rowIndex < toRowIndex; ++rowIndex) {
                value = (Object[])rowSupplier.apply(valueColumnCount);
                for (int i = 0; i < valueColumnCount; ++i) {
                    value[i] = this._columnList.get(valueColumnIndexes[i]).get(rowIndex);
                }
                resultMap.put(this._columnList.get(keyColumnIndex).get(rowIndex), value);
            }
        } else if (valueType.isList() || valueType.isSet()) {
            Collection value = null;
            for (int rowIndex = fromRowIndex; rowIndex < toRowIndex; ++rowIndex) {
                value = (Collection)rowSupplier.apply(valueColumnCount);
                for (int columIndex : valueColumnIndexes) {
                    value.add(this._columnList.get(columIndex).get(rowIndex));
                }
                resultMap.put(this._columnList.get(keyColumnIndex).get(rowIndex), value);
            }
        } else if (valueType.isMap()) {
            Map value = null;
            for (int rowIndex = fromRowIndex; rowIndex < toRowIndex; ++rowIndex) {
                value = (Map)rowSupplier.apply(valueColumnCount);
                for (int columIndex : valueColumnIndexes) {
                    value.put(this._columnNameList.get(columIndex), this._columnList.get(columIndex).get(rowIndex));
                }
                resultMap.put(this._columnList.get(keyColumnIndex).get(rowIndex), value);
            }
        } else if (valueType.isEntity()) {
            boolean ignoreUnmatchedProperty = valueColumnNames == this._columnNameList;
            boolean isDirtyMarker = DirtyMarkerUtil.isDirtyMarker(rowClass);
            ParserUtil.EntityInfo entityInfo = ParserUtil.getEntityInfo(rowClass);
            Object value = null;
            String propName = null;
            for (int rowIndex = fromRowIndex; rowIndex < toRowIndex; ++rowIndex) {
                value = rowSupplier.apply(valueColumnCount);
                for (int columIndex : valueColumnIndexes) {
                    propName = this._columnNameList.get(columIndex);
                    entityInfo.setPropValue(value, propName, this._columnList.get(columIndex).get(rowIndex), ignoreUnmatchedProperty);
                }
                if (isDirtyMarker) {
                    DirtyMarkerUtil.markDirty((DirtyMarker)value, false);
                }
                resultMap.put(this._columnList.get(keyColumnIndex).get(rowIndex), value);
            }
        } else {
            throw new IllegalArgumentException("Unsupported row type: " + rowClass.getCanonicalName() + ". Only Array, List/Set, Map and entity class are supported");
        }
        return (M)resultMap;
    }

    @Override
    public <K, E> ListMultimap<K, E> toMultimap(String keyColumnName, String valueColumnName) {
        return this.toMultimap(keyColumnName, valueColumnName, 0, this.size());
    }

    @Override
    public <K, E> ListMultimap<K, E> toMultimap(String keyColumnName, String valueColumnName, int fromRowIndex, int toRowIndex) {
        return (ListMultimap)this.toMultimap(keyColumnName, valueColumnName, fromRowIndex, toRowIndex, new IntFunction<ListMultimap<K, E>>(){

            @Override
            public ListMultimap<K, E> apply(int len) {
                return N.newLinkedListMultimap();
            }
        });
    }

    @Override
    public <K, E, V extends Collection<E>, M extends Multimap<K, E, V>> M toMultimap(String keyColumnName, String valueColumnName, int fromRowIndex, int toRowIndex, IntFunction<? extends M> supplier) {
        this.checkRowIndex(fromRowIndex, toRowIndex);
        Multimap resultMap = (Multimap)supplier.apply(toRowIndex - fromRowIndex);
        int keyColumnIndex = this.checkColumnName(keyColumnName);
        int valueColumnIndex = this.checkColumnName(valueColumnName);
        for (int rowIndex = fromRowIndex; rowIndex < toRowIndex; ++rowIndex) {
            resultMap.put(this._columnList.get(keyColumnIndex).get(rowIndex), this._columnList.get(valueColumnIndex).get(rowIndex));
        }
        return (M)resultMap;
    }

    @Override
    public <K, E> ListMultimap<K, E> toMultimap(Class<? extends E> rowClass, String keyColumnName, Collection<String> valueColumnNames) {
        return this.toMultimap(rowClass, keyColumnName, valueColumnNames, 0, this.size());
    }

    @Override
    public <K, E> ListMultimap<K, E> toMultimap(Class<? extends E> rowClass, String keyColumnName, Collection<String> valueColumnNames, int fromRowIndex, int toRowIndex) {
        return (ListMultimap)this.toMultimap(rowClass, keyColumnName, valueColumnNames, fromRowIndex, toRowIndex, new IntFunction<ListMultimap<K, E>>(){

            @Override
            public ListMultimap<K, E> apply(int len) {
                return N.newLinkedListMultimap();
            }
        });
    }

    @Override
    public <K, E, V extends Collection<E>, M extends Multimap<K, E, V>> M toMultimap(Class<? extends E> rowClass, String keyColumnName, Collection<String> valueColumnNames, int fromRowIndex, int toRowIndex, IntFunction<? extends M> supplier) {
        this.checkRowIndex(fromRowIndex, toRowIndex);
        int keyColumnIndex = this.checkColumnName(keyColumnName);
        int[] valueColumnIndexes = this.checkColumnName(valueColumnNames);
        Type elementType = N.typeOf(rowClass);
        int valueColumnCount = valueColumnIndexes.length;
        Multimap resultMap = (Multimap)supplier.apply(toRowIndex - fromRowIndex);
        if (elementType.isObjectArray()) {
            Object[] value = null;
            for (int rowIndex = fromRowIndex; rowIndex < toRowIndex; ++rowIndex) {
                value = (Object[])N.newArray(rowClass.getComponentType(), valueColumnCount);
                for (int i = 0; i < valueColumnCount; ++i) {
                    value[i] = this._columnList.get(valueColumnIndexes[i]).get(rowIndex);
                }
                resultMap.put(this._columnList.get(keyColumnIndex).get(rowIndex), value);
            }
        } else if (elementType.isList() || elementType.isSet()) {
            boolean isAbstractRowClass = Modifier.isAbstract(rowClass.getModifiers());
            Constructor<E> intConstructor = isAbstractRowClass ? null : ClassUtil.getDeclaredConstructor(rowClass, Integer.TYPE);
            Constructor<E> constructor = isAbstractRowClass ? null : ClassUtil.getDeclaredConstructor(rowClass, new Class[0]);
            Collection value = null;
            for (int rowIndex = fromRowIndex; rowIndex < toRowIndex; ++rowIndex) {
                value = isAbstractRowClass ? (elementType.isList() ? new ArrayList(valueColumnCount) : N.newHashSet(valueColumnCount)) : (intConstructor == null ? ClassUtil.invokeConstructor(constructor, new Object[0]) : ClassUtil.invokeConstructor(intConstructor, valueColumnCount));
                for (int columIndex : valueColumnIndexes) {
                    value.add(this._columnList.get(columIndex).get(rowIndex));
                }
                resultMap.put(this._columnList.get(keyColumnIndex).get(rowIndex), value);
            }
        } else if (elementType.isMap()) {
            boolean isAbstractRowClass = Modifier.isAbstract(rowClass.getModifiers());
            Constructor<E> intConstructor = isAbstractRowClass ? null : ClassUtil.getDeclaredConstructor(rowClass, Integer.TYPE);
            Constructor<E> constructor = isAbstractRowClass ? null : ClassUtil.getDeclaredConstructor(rowClass, new Class[0]);
            Map<String, Object> value = null;
            for (int rowIndex = fromRowIndex; rowIndex < toRowIndex; ++rowIndex) {
                value = isAbstractRowClass ? N.newHashMap(valueColumnCount) : (intConstructor == null ? ClassUtil.invokeConstructor(constructor, new Object[0]) : ClassUtil.invokeConstructor(intConstructor, valueColumnCount));
                for (int columIndex : valueColumnIndexes) {
                    value.put(this._columnNameList.get(columIndex), this._columnList.get(columIndex).get(rowIndex));
                }
                resultMap.put(this._columnList.get(keyColumnIndex).get(rowIndex), value);
            }
        } else if (elementType.isEntity()) {
            boolean ignoreUnmatchedProperty = valueColumnNames == this._columnNameList;
            boolean isDirtyMarker = DirtyMarkerUtil.isDirtyMarker(rowClass);
            ParserUtil.EntityInfo entityInfo = ParserUtil.getEntityInfo(rowClass);
            Object value = null;
            String propName = null;
            for (int rowIndex = fromRowIndex; rowIndex < toRowIndex; ++rowIndex) {
                value = N.newInstance(rowClass);
                for (int columIndex : valueColumnIndexes) {
                    propName = this._columnNameList.get(columIndex);
                    entityInfo.setPropValue(value, propName, this._columnList.get(columIndex).get(rowIndex), ignoreUnmatchedProperty);
                }
                if (isDirtyMarker) {
                    DirtyMarkerUtil.markDirty((DirtyMarker)value, false);
                }
                resultMap.put(this._columnList.get(keyColumnIndex).get(rowIndex), value);
            }
        } else {
            throw new IllegalArgumentException("Unsupported row type: " + rowClass.getCanonicalName() + ". Only Array, List/Set, Map and entity class are supported");
        }
        return (M)resultMap;
    }

    @Override
    public <K, E> ListMultimap<K, E> toMultimap(IntFunction<? extends E> rowSupplier, String keyColumnName, Collection<String> valueColumnNames) {
        return this.toMultimap(rowSupplier, keyColumnName, valueColumnNames, 0, this.size());
    }

    @Override
    public <K, E> ListMultimap<K, E> toMultimap(IntFunction<? extends E> rowSupplier, String keyColumnName, Collection<String> valueColumnNames, int fromRowIndex, int toRowIndex) {
        return (ListMultimap)this.toMultimap(rowSupplier, keyColumnName, valueColumnNames, fromRowIndex, toRowIndex, new IntFunction<ListMultimap<K, E>>(){

            @Override
            public ListMultimap<K, E> apply(int len) {
                return N.newLinkedListMultimap();
            }
        });
    }

    @Override
    public <K, E, V extends Collection<E>, M extends Multimap<K, E, V>> M toMultimap(IntFunction<? extends E> rowSupplier, String keyColumnName, Collection<String> valueColumnNames, int fromRowIndex, int toRowIndex, IntFunction<? extends M> supplier) {
        this.checkRowIndex(fromRowIndex, toRowIndex);
        int keyColumnIndex = this.checkColumnName(keyColumnName);
        int[] valueColumnIndexes = this.checkColumnName(valueColumnNames);
        Class<?> rowClass = rowSupplier.apply(0).getClass();
        Type elementType = N.typeOf(rowClass);
        int valueColumnCount = valueColumnIndexes.length;
        Multimap resultMap = (Multimap)supplier.apply(toRowIndex - fromRowIndex);
        if (elementType.isObjectArray()) {
            Object[] value = null;
            for (int rowIndex = fromRowIndex; rowIndex < toRowIndex; ++rowIndex) {
                value = (Object[])rowSupplier.apply(valueColumnCount);
                for (int i = 0; i < valueColumnCount; ++i) {
                    value[i] = this._columnList.get(valueColumnIndexes[i]).get(rowIndex);
                }
                resultMap.put(this._columnList.get(keyColumnIndex).get(rowIndex), value);
            }
        } else if (elementType.isList() || elementType.isSet()) {
            Collection value = null;
            for (int rowIndex = fromRowIndex; rowIndex < toRowIndex; ++rowIndex) {
                value = (Collection)rowSupplier.apply(valueColumnCount);
                for (int columIndex : valueColumnIndexes) {
                    value.add(this._columnList.get(columIndex).get(rowIndex));
                }
                resultMap.put(this._columnList.get(keyColumnIndex).get(rowIndex), value);
            }
        } else if (elementType.isMap()) {
            Map value = null;
            for (int rowIndex = fromRowIndex; rowIndex < toRowIndex; ++rowIndex) {
                value = (Map)rowSupplier.apply(valueColumnCount);
                for (int columIndex : valueColumnIndexes) {
                    value.put(this._columnNameList.get(columIndex), this._columnList.get(columIndex).get(rowIndex));
                }
                resultMap.put(this._columnList.get(keyColumnIndex).get(rowIndex), value);
            }
        } else if (elementType.isEntity()) {
            boolean ignoreUnmatchedProperty = valueColumnNames == this._columnNameList;
            boolean isDirtyMarker = DirtyMarkerUtil.isDirtyMarker(rowClass);
            ParserUtil.EntityInfo entityInfo = ParserUtil.getEntityInfo(rowClass);
            Object value = null;
            String propName = null;
            for (int rowIndex = fromRowIndex; rowIndex < toRowIndex; ++rowIndex) {
                value = rowSupplier.apply(valueColumnCount);
                for (int columIndex : valueColumnIndexes) {
                    propName = this._columnNameList.get(columIndex);
                    entityInfo.setPropValue(value, propName, this._columnList.get(columIndex).get(rowIndex), ignoreUnmatchedProperty);
                }
                if (isDirtyMarker) {
                    DirtyMarkerUtil.markDirty((DirtyMarker)value, false);
                }
                resultMap.put(this._columnList.get(keyColumnIndex).get(rowIndex), value);
            }
        } else {
            throw new IllegalArgumentException("Unsupported row type: " + rowClass.getCanonicalName() + ". Only Array, List/Set, Map and entity class are supported");
        }
        return (M)resultMap;
    }

    @Override
    public <T> List<T> toMergedEntities(Class<T> entityClass) {
        return this.toMergedEntities(entityClass, this._columnNameList);
    }

    @Override
    public <T> List<T> toMergedEntities(Class<T> entityClass, Collection<String> selectPropNames) {
        N.checkArgNotNull(entityClass, "entityClass");
        List<String> idPropNames = ClassUtil.getIdFieldNames(entityClass);
        if (N.isNullOrEmpty(idPropNames)) {
            throw new IllegalArgumentException("No id property defined in class: " + entityClass);
        }
        return this.toMergedEntities(entityClass, idPropNames, selectPropNames);
    }

    @Override
    public <T> List<T> toMergedEntities(Class<T> entityClass, String idPropName) {
        return this.toMergedEntities(entityClass, idPropName, this._columnNameList);
    }

    @Override
    public <T> List<T> toMergedEntities(Class<T> entityClass, String idPropName, Collection<String> selectPropNames) {
        return this.toMergedEntities(entityClass, N.asList(idPropName), selectPropNames);
    }

    @Override
    public <T> List<T> toMergedEntities(Class<T> entityClass, List<String> idPropNames, Collection<String> selectPropNames) {
        return this.toMergedEntities(entityClass, idPropNames, selectPropNames, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> List<T> toMergedEntities(Class<T> entityClass, List<String> idPropNames, Collection<String> selectPropNames, boolean returnAllList) {
        N.checkArgNotNull(entityClass, "entityClass");
        N.checkArgNotNull(idPropNames, "idPropNames");
        N.checkArgument(this._columnNameList.containsAll(idPropNames), "Some id properties {} are not found in DataSet: {}", idPropNames, this._columnNameList);
        N.checkArgument(N.isNullOrEmpty(selectPropNames) || selectPropNames == this._columnNameList || this._columnNameList.containsAll(selectPropNames), "Some select properties {} are not found in DataSet: {}", selectPropNames, this._columnNameList);
        selectPropNames = N.isNullOrEmpty(selectPropNames) ? this._columnNameList : selectPropNames;
        ParserUtil.EntityInfo entityInfo = ParserUtil.getEntityInfo(entityClass);
        int rowCount = this.size();
        int columnCount = this._columnList.size();
        int[] idColumnIndexes = this.getColumnIndexes(idPropNames);
        boolean ignoreUnmatchedProperty = selectPropNames == this._columnNameList;
        Object[] resultEntities = new Object[rowCount];
        Map idEntityMap = N.newLinkedHashMap(N.min(64, rowCount));
        Object entity = null;
        if (idColumnIndexes.length == 1) {
            List<Object> idColumn = this._columnList.get(idColumnIndexes[0]);
            Object rowKey = null;
            Object key = null;
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                key = idColumn.get(rowIndex);
                if (key == null) continue;
                rowKey = RowDataSet.getHashKey(key);
                entity = idEntityMap.get(rowKey);
                if (entity == null) {
                    entity = N.newInstance(entityClass);
                    idEntityMap.put(rowKey, entity);
                }
                resultEntities[rowIndex] = entity;
            }
        } else {
            int idColumnCount = idColumnIndexes.length;
            Object[] keyRow = Objectory.createObjectArray(idColumnCount);
            Wrapper<Object[]> rowKey = null;
            boolean isAllKeyNull = true;
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                isAllKeyNull = true;
                for (int i = 0; i < idColumnCount; ++i) {
                    keyRow[i] = this._columnList.get(idColumnIndexes[i]).get(rowIndex);
                    if (keyRow[i] == null) continue;
                    isAllKeyNull = false;
                }
                if (isAllKeyNull) continue;
                rowKey = Wrapper.of(keyRow);
                entity = idEntityMap.get(rowKey);
                if (entity == null) {
                    entity = N.newInstance(entityClass);
                    idEntityMap.put(rowKey, entity);
                    keyRow = Objectory.createObjectArray(idColumnCount);
                }
                resultEntities[rowIndex] = entity;
            }
            if (keyRow != null) {
                Objectory.recycle(keyRow);
                keyRow = null;
            }
        }
        ArrayList<Collection> listPropValuesToDeduplicate = new ArrayList<Collection>();
        try {
            HashSet<String> mergedPropNames = new HashSet<String>();
            List<Object> curColumn = null;
            int curColumnIndex = 0;
            ParserUtil.PropInfo propInfo = null;
            for (String propName : selectPropNames) {
                Type<Object> propEntityType;
                if (mergedPropNames.contains(propName)) continue;
                curColumnIndex = this.checkColumnName(propName);
                curColumn = this._columnList.get(curColumnIndex);
                propInfo = entityInfo.getPropInfo(propName);
                if (propInfo != null) {
                    for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                        if (resultEntities[rowIndex] == null) continue;
                        propInfo.setPropValue(resultEntities[rowIndex], curColumn.get(rowIndex));
                    }
                    continue;
                }
                int idx = propName.indexOf(46);
                if (idx <= 0) {
                    if (ignoreUnmatchedProperty) continue;
                    throw new IllegalArgumentException("Property " + propName + " is not found in class: " + entityClass);
                }
                String realPropName = propName.substring(0, idx);
                propInfo = entityInfo.getPropInfo(realPropName);
                if (propInfo == null) {
                    if (ignoreUnmatchedProperty) continue;
                    throw new IllegalArgumentException("Property " + propName + " is not found in class: " + entityClass);
                }
                Type<Object> type = propEntityType = propInfo.type.isCollection() ? propInfo.type.getElementType() : propInfo.type;
                if (!propEntityType.isEntity()) {
                    throw new UnsupportedOperationException("Property: " + propInfo.name + " in class: " + entityClass + " is not an entity type");
                }
                Class<Object> propEntityClass = propEntityType.clazz();
                ArrayList<String> propEntityIdPropNames = ClassUtil.getIdFieldNames(propEntityClass);
                ArrayList<String> newPropEntityIdNames = N.isNullOrEmpty(propEntityIdPropNames) ? new ArrayList<String>() : propEntityIdPropNames;
                ArrayList<String> newTmpColumnNameList = new ArrayList<String>();
                ArrayList<List<Object>> newTmpColumnList = new ArrayList<List<Object>>();
                String columnName = null;
                String newColumnName = null;
                for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
                    columnName = this._columnNameList.get(columnIndex);
                    if (columnName.length() <= idx || columnName.charAt(idx) != '.' || !columnName.startsWith(realPropName)) continue;
                    newColumnName = columnName.substring(idx + 1);
                    newTmpColumnNameList.add(newColumnName);
                    newTmpColumnList.add(this._columnList.get(columnIndex));
                    mergedPropNames.add(columnName);
                    if (!N.isNullOrEmpty(propEntityIdPropNames) || newColumnName.indexOf(46) >= 0) continue;
                    newPropEntityIdNames.add(newColumnName);
                }
                RowDataSet tmp = new RowDataSet(newTmpColumnNameList, newTmpColumnList);
                List<Object> propValueList = tmp.toMergedEntities(propEntityClass, newPropEntityIdNames, tmp._columnNameList, true);
                if (propInfo.type.isCollection()) {
                    Collection c = null;
                    for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                        if (resultEntities[rowIndex] == null || propValueList.get(rowIndex) == null) continue;
                        c = (Collection)propInfo.getPropValue(resultEntities[rowIndex]);
                        if (c == null) {
                            c = (Collection)N.newInstance(propInfo.clazz);
                            propInfo.setPropValue(resultEntities[rowIndex], c);
                            if (!(c instanceof Set)) {
                                listPropValuesToDeduplicate.add(c);
                            }
                        }
                        c.add(propValueList.get(rowIndex));
                    }
                    continue;
                }
                for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                    if (resultEntities[rowIndex] == null || propValueList.get(rowIndex) == null) continue;
                    propInfo.setPropValue(resultEntities[rowIndex], propValueList.get(rowIndex));
                }
            }
            if (N.notNullOrEmpty(listPropValuesToDeduplicate)) {
                for (Collection list : listPropValuesToDeduplicate) {
                    N.removeDuplicates(list);
                }
            }
            ArrayList arrayList = returnAllList ? N.asList(resultEntities) : new ArrayList(idEntityMap.values());
            return arrayList;
        }
        finally {
            if (idColumnIndexes.length > 1) {
                for (Wrapper e : idEntityMap.keySet()) {
                    Objectory.recycle((Object[])e.value());
                }
            }
        }
    }

    @Override
    public String toJSON() {
        return this.toJSON(0, this.size());
    }

    @Override
    public String toJSON(int fromRowIndex, int toRowIndex) {
        return this.toJSON(this._columnNameList, fromRowIndex, toRowIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toJSON(Collection<String> columnNames, int fromRowIndex, int toRowIndex) {
        BufferedJSONWriter writer = Objectory.createBufferedJSONWriter();
        try {
            this.toJSON(writer, columnNames, fromRowIndex, toRowIndex);
            String string = writer.toString();
            return string;
        }
        finally {
            Objectory.recycle(writer);
        }
    }

    @Override
    public void toJSON(File output) {
        this.toJSON(output, 0, this.size());
    }

    @Override
    public void toJSON(File output, int fromRowIndex, int toRowIndex) {
        this.toJSON(output, this._columnNameList, fromRowIndex, toRowIndex);
    }

    @Override
    public void toJSON(File output, Collection<String> columnNames, int fromRowIndex, int toRowIndex) throws UncheckedIOException {
        FileOutputStream os = null;
        try {
            if (!output.exists()) {
                output.createNewFile();
            }
            os = new FileOutputStream(output);
            this.toJSON(os, columnNames, fromRowIndex, toRowIndex);
            os.flush();
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException(e);
            }
            catch (Throwable throwable) {
                IOUtil.close(os);
                throw throwable;
            }
        }
        IOUtil.close(os);
    }

    @Override
    public void toJSON(OutputStream output) {
        this.toJSON(output, 0, this.size());
    }

    @Override
    public void toJSON(OutputStream output, int fromRowIndex, int toRowIndex) {
        this.toJSON(output, this._columnNameList, fromRowIndex, toRowIndex);
    }

    @Override
    public void toJSON(OutputStream output, Collection<String> columnNames, int fromRowIndex, int toRowIndex) throws UncheckedIOException {
        BufferedJSONWriter writer = Objectory.createBufferedJSONWriter(output);
        try {
            this.toJSON(writer, columnNames, fromRowIndex, toRowIndex);
            writer.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            Objectory.recycle(writer);
        }
    }

    @Override
    public void toJSON(Writer output) {
        this.toJSON(output, 0, this.size());
    }

    @Override
    public void toJSON(Writer output, int fromRowIndex, int toRowIndex) {
        this.toJSON(output, this._columnNameList, fromRowIndex, toRowIndex);
    }

    @Override
    public void toJSON(Writer output, Collection<String> columnNames, int fromRowIndex, int toRowIndex) throws UncheckedIOException {
        this.checkRowIndex(fromRowIndex, toRowIndex);
        if (N.isNullOrEmpty(columnNames)) {
            try {
                IOUtil.write(output, (CharSequence)"[]");
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return;
        }
        int[] columnIndexes = this.checkColumnName(columnNames);
        int columnCount = columnIndexes.length;
        char[][] charArrayOfColumnNames = new char[columnCount][];
        for (int i = 0; i < columnCount; ++i) {
            charArrayOfColumnNames[i] = ("\"" + this._columnNameList.get(columnIndexes[i]) + "\"").toCharArray();
        }
        boolean isBufferedWriter = output instanceof BufferedJSONWriter;
        BufferedJSONWriter bw = isBufferedWriter ? (BufferedJSONWriter)output : Objectory.createBufferedJSONWriter(output);
        try {
            bw.write('[');
            Type<Object> type = null;
            Object element = null;
            for (int rowIndex = fromRowIndex; rowIndex < toRowIndex; ++rowIndex) {
                if (rowIndex > fromRowIndex) {
                    bw.write(N.ELEMENT_SEPARATOR_CHAR_ARRAY);
                }
                bw.write('{');
                for (int i = 0; i < columnCount; ++i) {
                    element = this._columnList.get(columnIndexes[i]).get(rowIndex);
                    Type<Object> type2 = type = element == null ? null : N.typeOf(element.getClass());
                    if (i > 0) {
                        bw.write(N.ELEMENT_SEPARATOR_CHAR_ARRAY);
                    }
                    bw.write(charArrayOfColumnNames[i]);
                    bw.write(':');
                    if (type == null) {
                        bw.write(NULL_CHAR_ARRAY);
                        continue;
                    }
                    if (type.isSerializable()) {
                        type.writeCharacter(bw, element, jsc);
                        continue;
                    }
                    try {
                        jsonParser.serialize(bw, element, jsc);
                        continue;
                    }
                    catch (Exception e) {
                        strType.writeCharacter(bw, N.toString(element), jsc);
                    }
                }
                bw.write('}');
            }
            bw.write(']');
            bw.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            if (!isBufferedWriter) {
                Objectory.recycle(bw);
            }
        }
    }

    @Override
    public String toXML() {
        return this.toXML(ROW);
    }

    @Override
    public String toXML(String rowElementName) {
        return this.toXML(rowElementName, 0, this.size());
    }

    @Override
    public String toXML(int fromRowIndex, int toRowIndex) {
        return this.toXML(ROW, fromRowIndex, toRowIndex);
    }

    @Override
    public String toXML(String rowElementName, int fromRowIndex, int toRowIndex) {
        return this.toXML(rowElementName, this._columnNameList, fromRowIndex, toRowIndex);
    }

    @Override
    public String toXML(Collection<String> columnNames, int fromRowIndex, int toRowIndex) {
        return this.toXML(ROW, columnNames, fromRowIndex, toRowIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toXML(String rowElementName, Collection<String> columnNames, int fromRowIndex, int toRowIndex) {
        BufferedXMLWriter writer = Objectory.createBufferedXMLWriter();
        try {
            this.toXML(writer, rowElementName, columnNames, fromRowIndex, toRowIndex);
            String string = writer.toString();
            return string;
        }
        finally {
            Objectory.recycle(writer);
        }
    }

    @Override
    public void toXML(File output) {
        this.toXML(output, 0, this.size());
    }

    @Override
    public void toXML(File output, String rowElementName) {
        this.toXML(output, rowElementName, 0, this.size());
    }

    @Override
    public void toXML(File output, int fromRowIndex, int toRowIndex) {
        this.toXML(output, ROW, fromRowIndex, toRowIndex);
    }

    @Override
    public void toXML(File output, String rowElementName, int fromRowIndex, int toRowIndex) {
        this.toXML(output, rowElementName, this._columnNameList, fromRowIndex, toRowIndex);
    }

    @Override
    public void toXML(File output, Collection<String> columnNames, int fromRowIndex, int toRowIndex) {
        this.toXML(output, ROW, columnNames, fromRowIndex, toRowIndex);
    }

    @Override
    public void toXML(File output, String rowElementName, Collection<String> columnNames, int fromRowIndex, int toRowIndex) throws UncheckedIOException {
        FileOutputStream os = null;
        try {
            if (!output.exists()) {
                output.createNewFile();
            }
            os = new FileOutputStream(output);
            this.toXML(os, rowElementName, columnNames, fromRowIndex, toRowIndex);
            os.flush();
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException(e);
            }
            catch (Throwable throwable) {
                IOUtil.close(os);
                throw throwable;
            }
        }
        IOUtil.close(os);
    }

    @Override
    public void toXML(OutputStream output) {
        this.toXML(output, 0, this.size());
    }

    @Override
    public void toXML(OutputStream output, String rowElementName) {
        this.toXML(output, rowElementName, 0, this.size());
    }

    @Override
    public void toXML(OutputStream output, int fromRowIndex, int toRowIndex) {
        this.toXML(output, ROW, fromRowIndex, toRowIndex);
    }

    @Override
    public void toXML(OutputStream output, String rowElementName, int fromRowIndex, int toRowIndex) {
        this.toXML(output, rowElementName, this._columnNameList, fromRowIndex, toRowIndex);
    }

    @Override
    public void toXML(OutputStream output, Collection<String> columnNames, int fromRowIndex, int toRowIndex) {
        this.toXML(output, ROW, columnNames, fromRowIndex, toRowIndex);
    }

    @Override
    public void toXML(OutputStream output, String rowElementName, Collection<String> columnNames, int fromRowIndex, int toRowIndex) throws UncheckedIOException {
        BufferedXMLWriter writer = Objectory.createBufferedXMLWriter(output);
        try {
            this.toXML(writer, rowElementName, columnNames, fromRowIndex, toRowIndex);
            writer.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            Objectory.recycle(writer);
        }
    }

    @Override
    public void toXML(Writer output) {
        this.toXML(output, 0, this.size());
    }

    @Override
    public void toXML(Writer output, String rowElementName) {
        this.toXML(output, rowElementName, 0, this.size());
    }

    @Override
    public void toXML(Writer output, int fromRowIndex, int toRowIndex) {
        this.toXML(output, ROW, fromRowIndex, toRowIndex);
    }

    @Override
    public void toXML(Writer output, String rowElementName, int fromRowIndex, int toRowIndex) {
        this.toXML(output, rowElementName, this._columnNameList, fromRowIndex, toRowIndex);
    }

    @Override
    public void toXML(Writer output, Collection<String> columnNames, int fromRowIndex, int toRowIndex) {
        this.toXML(output, ROW, columnNames, fromRowIndex, toRowIndex);
    }

    @Override
    public void toXML(Writer output, String rowElementName, Collection<String> columnNames, int fromRowIndex, int toRowIndex) throws UncheckedIOException {
        this.checkRowIndex(fromRowIndex, toRowIndex);
        if (N.isNullOrEmpty(columnNames)) {
            try {
                IOUtil.write(output, (CharSequence)"<dataSet>");
                IOUtil.write(output, (CharSequence)"</dataSet>");
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return;
        }
        int[] columnIndexes = this.checkColumnName(columnNames);
        int columnCount = columnIndexes.length;
        char[] rowElementNameHead = ("<" + rowElementName + ">").toCharArray();
        char[] rowElementNameTail = ("</" + rowElementName + ">").toCharArray();
        char[][] charArrayOfColumnNames = new char[columnCount][];
        for (int i = 0; i < columnCount; ++i) {
            charArrayOfColumnNames[i] = this._columnNameList.get(columnIndexes[i]).toCharArray();
        }
        boolean isBufferedWriter = output instanceof BufferedXMLWriter;
        BufferedXMLWriter bw = isBufferedWriter ? (BufferedXMLWriter)output : Objectory.createBufferedXMLWriter(output);
        try {
            bw.write("<dataSet>");
            Type<Object> type = null;
            Object element = null;
            for (int rowIndex = fromRowIndex; rowIndex < toRowIndex; ++rowIndex) {
                bw.write(rowElementNameHead);
                for (int i = 0; i < columnCount; ++i) {
                    element = this._columnList.get(columnIndexes[i]).get(rowIndex);
                    type = element == null ? null : N.typeOf(element.getClass());
                    bw.write('<');
                    bw.write(charArrayOfColumnNames[i]);
                    bw.write('>');
                    if (type == null) {
                        bw.write(NULL_CHAR_ARRAY);
                    } else if (type.isSerializable()) {
                        type.writeCharacter(bw, element, xsc);
                    } else {
                        try {
                            xmlParser.serialize(bw, element, xsc);
                        }
                        catch (Exception e) {
                            strType.writeCharacter(bw, N.toString(element), xsc);
                        }
                    }
                    bw.write('<');
                    bw.write('/');
                    bw.write(charArrayOfColumnNames[i]);
                    bw.write('>');
                }
                bw.write(rowElementNameTail);
            }
            bw.write("</dataSet>");
            bw.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            if (!isBufferedWriter) {
                Objectory.recycle(bw);
            }
        }
    }

    @Override
    public String toCSV() {
        return this.toCSV(this.columnNameList(), 0, this.size());
    }

    @Override
    public String toCSV(Collection<String> columnNames, int fromRowIndex, int toRowIndex) {
        return this.toCSV(columnNames, fromRowIndex, toRowIndex, true, true);
    }

    @Override
    public String toCSV(boolean writeTitle, boolean quoted) {
        return this.toCSV(this.columnNameList(), 0, this.size(), writeTitle, quoted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toCSV(Collection<String> columnNames, int fromRowIndex, int toRowIndex, boolean writeTitle, boolean quoted) {
        com.landawn.abacus.util.BufferedWriter bw = Objectory.createBufferedWriter();
        try {
            this.toCSV(bw, columnNames, fromRowIndex, toRowIndex, writeTitle, quoted);
            String string = bw.toString();
            return string;
        }
        finally {
            Objectory.recycle(bw);
        }
    }

    @Override
    public void toCSV(File output) {
        this.toCSV(output, this._columnNameList, 0, this.size());
    }

    @Override
    public void toCSV(File output, Collection<String> columnNames, int fromRowIndex, int toRowIndex) {
        this.toCSV(output, columnNames, fromRowIndex, toRowIndex, true, true);
    }

    @Override
    public void toCSV(File output, boolean writeTitle, boolean quoted) {
        this.toCSV(output, this._columnNameList, 0, this.size(), writeTitle, quoted);
    }

    @Override
    public void toCSV(File output, Collection<String> columnNames, int fromRowIndex, int toRowIndex, boolean writeTitle, boolean quoted) {
        FileOutputStream os = null;
        try {
            if (!output.exists()) {
                output.createNewFile();
            }
            os = new FileOutputStream(output);
            this.toCSV(os, columnNames, fromRowIndex, toRowIndex, writeTitle, quoted);
            os.flush();
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException(e);
            }
            catch (Throwable throwable) {
                IOUtil.close(os);
                throw throwable;
            }
        }
        IOUtil.close(os);
    }

    @Override
    public void toCSV(OutputStream output) {
        this.toCSV(output, this._columnNameList, 0, this.size());
    }

    @Override
    public void toCSV(OutputStream output, Collection<String> columnNames, int fromRowIndex, int toRowIndex) {
        this.toCSV(output, columnNames, fromRowIndex, toRowIndex, true, true);
    }

    @Override
    public void toCSV(OutputStream output, boolean writeTitle, boolean quoted) {
        this.toCSV(output, this._columnNameList, 0, this.size(), writeTitle, quoted);
    }

    @Override
    public void toCSV(OutputStream output, Collection<String> columnNames, int fromRowIndex, int toRowIndex, boolean writeTitle, boolean quoted) throws UncheckedIOException {
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter(output);
            this.toCSV(writer, columnNames, fromRowIndex, toRowIndex, writeTitle, quoted);
            ((Writer)writer).flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void toCSV(Writer output) {
        this.toCSV(output, this._columnNameList, 0, this.size());
    }

    @Override
    public void toCSV(Writer output, Collection<String> columnNames, int fromRowIndex, int toRowIndex) {
        this.toCSV(output, columnNames, fromRowIndex, toRowIndex, true, true);
    }

    @Override
    public void toCSV(Writer output, boolean writeTitle, boolean quoted) {
        this.toCSV(output, this._columnNameList, 0, this.size(), writeTitle, quoted);
    }

    @Override
    public void toCSV(Writer output, Collection<String> columnNames, int fromRowIndex, int toRowIndex, boolean writeTitle, boolean quoted) throws UncheckedIOException {
        this.checkRowIndex(fromRowIndex, toRowIndex);
        if (N.isNullOrEmpty(columnNames)) {
            return;
        }
        int[] columnIndexes = this.checkColumnName(columnNames);
        int columnCount = columnIndexes.length;
        JSONSerializationConfig config = JSONSerializationConfig.JSC.create();
        config.setDateTimeFormat(DateTimeFormat.ISO_8601_TIMESTAMP);
        if (quoted) {
            config.setQuoteMapKey(true);
            config.setQuotePropName(true);
            config.setCharQuotation('\"');
            config.setStringQuotation('\"');
        } else {
            config.setQuoteMapKey(false);
            config.setQuotePropName(false);
            config.setCharQuotation('\u0000');
            config.setStringQuotation('\u0000');
        }
        boolean isBufferedWriter = output instanceof BufferedJSONWriter;
        BufferedJSONWriter bw = isBufferedWriter ? (BufferedJSONWriter)output : Objectory.createBufferedJSONWriter(output);
        try {
            if (writeTitle) {
                for (int i = 0; i < columnCount; ++i) {
                    if (i > 0) {
                        bw.write(N.ELEMENT_SEPARATOR_CHAR_ARRAY);
                    }
                    bw.write(this.getColumnName(columnIndexes[i]));
                }
                bw.write(IOUtil.LINE_SEPARATOR);
            }
            Type<Object> type = null;
            Object element = null;
            for (int rowIndex = fromRowIndex; rowIndex < toRowIndex; ++rowIndex) {
                if (rowIndex > fromRowIndex) {
                    bw.write(IOUtil.LINE_SEPARATOR);
                }
                for (int i = 0; i < columnCount; ++i) {
                    if (i > 0) {
                        bw.write(N.ELEMENT_SEPARATOR_CHAR_ARRAY);
                    }
                    if ((element = this._columnList.get(columnIndexes[i]).get(rowIndex)) == null) {
                        bw.write(NULL_CHAR_ARRAY);
                        continue;
                    }
                    type = N.typeOf(element.getClass());
                    if (type.isSerializable()) {
                        type.writeCharacter(bw, element, config);
                        continue;
                    }
                    try {
                        strType.writeCharacter(bw, jsonParser.serialize(element, config), config);
                        continue;
                    }
                    catch (Exception e) {
                        strType.writeCharacter(bw, N.toString(element), config);
                    }
                }
            }
            bw.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            if (!isBufferedWriter) {
                Objectory.recycle(bw);
            }
        }
    }

    @Override
    public DataSet groupBy(String columnName) {
        return this.groupBy(columnName, (Function)null);
    }

    @Override
    public <T> DataSet groupBy(String columnName, String aggregateResultColumnName, String aggregateOnColumnName, Collector<T, ?, ?> collector) {
        return this.groupBy(columnName, (Function)null, aggregateResultColumnName, aggregateOnColumnName, collector);
    }

    @Override
    public DataSet groupBy(String columnName, String aggregateResultColumnName, Collection<String> aggregateOnColumnNames, Class<?> rowClass) {
        ImmutableList keyColumn = this.getColumn(columnName);
        List<?> valueColumn = this.toList(rowClass, aggregateOnColumnNames);
        Map map = N.newLinkedHashMap(N.min(9, this.size()));
        ArrayList keyList = new ArrayList(N.min(9, this.size()));
        Object key = null;
        ArrayList val = null;
        int size = keyColumn.size();
        for (int i = 0; i < size; ++i) {
            key = RowDataSet.getHashKey(keyColumn.get(i));
            val = (ArrayList)map.get(key);
            if (val == null) {
                val = new ArrayList();
                map.put(key, val);
                keyList.add(keyColumn.get(i));
            }
            val.add(valueColumn.get(i));
        }
        List<String> newColumnNameList = N.asList(columnName, aggregateResultColumnName);
        List<List<Object>> newColumnList = N.asList(keyList, new ArrayList(map.values()));
        return new RowDataSet(newColumnNameList, newColumnList);
    }

    @Override
    public DataSet groupBy(String columnName, String aggregateResultColumnName, Collection<String> aggregateOnColumnNames, Collector<? super Object[], ?, ?> collector) {
        return this.groupBy(columnName, aggregateResultColumnName, aggregateOnColumnNames, CLONE, collector);
    }

    @Override
    public <U, E extends Exception> DataSet groupBy(String columnName, String aggregateResultColumnName, Collection<String> aggregateOnColumnNames, Throwables.Function<? super NoCachingNoUpdating.DisposableObjArray, U, E> rowMapper, Collector<? super U, ?, ?> collector) throws E {
        return this.groupBy(columnName, (Function)null, aggregateResultColumnName, aggregateOnColumnNames, rowMapper, collector);
    }

    @Override
    public <K, E extends Exception> DataSet groupBy(String columnName, Throwables.Function<K, ?, E> keyMapper) throws E {
        int columnIndex = this.checkColumnName(columnName);
        int size = this.size();
        boolean newColumnCount = true;
        ArrayList<String> newColumnNameList = new ArrayList<String>(1);
        newColumnNameList.add(columnName);
        ArrayList<List<Object>> newColumnList = new ArrayList<List<Object>>(1);
        for (int i = 0; i < 1; ++i) {
            newColumnList.add(new ArrayList());
        }
        if (size == 0) {
            return new RowDataSet(newColumnNameList, newColumnList);
        }
        Throwables.Function<Object, Object, RuntimeException> keyMapper2 = keyMapper == null ? Fn.identity() : keyMapper;
        List keyColumn = (List)newColumnList.get(0);
        Set keySet = N.newHashSet();
        List<Object> groupByColumn = this._columnList.get(columnIndex);
        Object value = null;
        for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
            value = groupByColumn.get(rowIndex);
            if (!keySet.add(RowDataSet.getHashKey(keyMapper2.apply(value)))) continue;
            keyColumn.add(value);
        }
        return new RowDataSet(newColumnNameList, newColumnList);
    }

    @Override
    public <K, T, E extends Exception> DataSet groupBy(String columnName, Throwables.Function<K, ?, E> keyMapper, String aggregateResultColumnName, String aggregateOnColumnName, Collector<T, ?, ?> collector) throws E {
        int columnIndex = this.checkColumnName(columnName);
        int aggOnColumnIndex = this.checkColumnName(aggregateOnColumnName);
        if (N.equals(columnName, aggregateResultColumnName)) {
            throw new IllegalArgumentException("Duplicated Property name: " + aggregateResultColumnName);
        }
        int size = this.size();
        int newColumnCount = 2;
        ArrayList<String> newColumnNameList = new ArrayList<String>(2);
        newColumnNameList.add(columnName);
        newColumnNameList.add(aggregateResultColumnName);
        ArrayList<List<Object>> newColumnList = new ArrayList<List<Object>>(2);
        for (int i = 0; i < 2; ++i) {
            newColumnList.add(new ArrayList());
        }
        if (size == 0) {
            return new RowDataSet(newColumnNameList, newColumnList);
        }
        Throwables.Function<Object, Object, RuntimeException> keyMapper2 = keyMapper == null ? Fn.identity() : keyMapper;
        List keyColumn = (List)newColumnList.get(0);
        List aggResultColumn = (List)newColumnList.get(1);
        Supplier<?> supplier = collector.supplier();
        BiConsumer accumulator = collector.accumulator();
        Function<?, ?> finisher = collector.finisher();
        HashMap<Object, Integer> keyRowIndexMap = new HashMap<Object, Integer>();
        List<Object> groupByColumn = this._columnList.get(columnIndex);
        List<Object> aggOnColumn = this._columnList.get(aggOnColumnIndex);
        Object key = null;
        Object value = null;
        Integer collectorRowIndex = -1;
        for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
            value = groupByColumn.get(rowIndex);
            key = RowDataSet.getHashKey(keyMapper2.apply(value));
            collectorRowIndex = (Integer)keyRowIndexMap.get(key);
            if (collectorRowIndex == null) {
                collectorRowIndex = aggResultColumn.size();
                keyRowIndexMap.put(key, collectorRowIndex);
                keyColumn.add(value);
                aggResultColumn.add(supplier.get());
            }
            accumulator.accept(aggResultColumn.get(collectorRowIndex), aggOnColumn.get(rowIndex));
        }
        int len = aggResultColumn.size();
        for (int i = 0; i < len; ++i) {
            aggResultColumn.set(i, finisher.apply(aggResultColumn.get(i)));
        }
        return new RowDataSet(newColumnNameList, newColumnList);
    }

    @Override
    public <K, E extends Exception> DataSet groupBy(String columnName, Throwables.Function<K, ?, E> keyMapper, String aggregateResultColumnName, Collection<String> aggregateOnColumnNames, Class<?> rowClass) throws E {
        Throwables.Function<Object, Object, RuntimeException> keyMapper2 = keyMapper == null ? Fn.identity() : keyMapper;
        ImmutableList keyColumn = this.getColumn(columnName);
        List<?> valueColumn = this.toList(rowClass, aggregateOnColumnNames);
        Map map = N.newLinkedHashMap(N.min(9, this.size()));
        ArrayList keyList = new ArrayList(N.min(9, this.size()));
        Object key = null;
        ArrayList val = null;
        int size = keyColumn.size();
        for (int i = 0; i < size; ++i) {
            key = RowDataSet.getHashKey(keyMapper2.apply(keyColumn.get(i)));
            val = (ArrayList)map.get(key);
            if (val == null) {
                val = new ArrayList();
                map.put(key, val);
                keyList.add(keyColumn.get(i));
            }
            val.add(valueColumn.get(i));
        }
        List<String> newColumnNameList = N.asList(columnName, aggregateResultColumnName);
        List<List<Object>> newColumnList = N.asList(keyList, new ArrayList(map.values()));
        return new RowDataSet(newColumnNameList, newColumnList);
    }

    @Override
    public <K, E extends Exception> DataSet groupBy(String columnName, Throwables.Function<K, ?, E> keyMapper, String aggregateResultColumnName, Collection<String> aggregateOnColumnNames, Collector<? super Object[], ?, ?> collector) throws E {
        return this.groupBy(columnName, keyMapper, aggregateResultColumnName, aggregateOnColumnNames, CLONE, collector);
    }

    @Override
    public <K, U, E extends Exception, E2 extends Exception> DataSet groupBy(String columnName, Throwables.Function<K, ?, E> keyMapper, String aggregateResultColumnName, Collection<String> aggregateOnColumnNames, Throwables.Function<? super NoCachingNoUpdating.DisposableObjArray, U, E2> rowMapper, Collector<? super U, ?, ?> collector) throws E, E2 {
        int columnIndex = this.checkColumnName(columnName);
        int[] aggOnColumnIndexes = this.checkColumnName(aggregateOnColumnNames);
        if (N.equals(columnName, aggregateResultColumnName)) {
            throw new IllegalArgumentException("Duplicated Property name: " + aggregateResultColumnName);
        }
        N.checkArgNotNull(rowMapper, "rowMapper");
        N.checkArgNotNull(collector, "collector");
        int size = this.size();
        int aggOnColumnCount = aggOnColumnIndexes.length;
        int newColumnCount = 2;
        ArrayList<String> newColumnNameList = new ArrayList<String>(2);
        newColumnNameList.add(columnName);
        newColumnNameList.add(aggregateResultColumnName);
        ArrayList<List<Object>> newColumnList = new ArrayList<List<Object>>(2);
        for (int i = 0; i < 2; ++i) {
            newColumnList.add(new ArrayList());
        }
        if (size == 0) {
            return new RowDataSet(newColumnNameList, newColumnList);
        }
        Throwables.Function<Object, Object, RuntimeException> keyMapper2 = keyMapper == null ? Fn.identity() : keyMapper;
        List keyColumn = (List)newColumnList.get(0);
        List aggResultColumn = (List)newColumnList.get(1);
        Supplier<?> supplier = collector.supplier();
        BiConsumer<?, U> accumulator = collector.accumulator();
        Function<?, ?> finisher = collector.finisher();
        HashMap<Object, Integer> keyRowIndexMap = new HashMap<Object, Integer>();
        List<Object> groupByColumn = this._columnList.get(columnIndex);
        Object[] aggRow = new Object[aggOnColumnCount];
        NoCachingNoUpdating.DisposableObjArray disposableArray = NoCachingNoUpdating.DisposableObjArray.wrap(aggRow);
        Object key = null;
        Object value = null;
        Integer collectorRowIndex = -1;
        for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
            value = groupByColumn.get(rowIndex);
            key = RowDataSet.getHashKey(keyMapper2.apply(value));
            collectorRowIndex = (Integer)keyRowIndexMap.get(key);
            if (collectorRowIndex == null) {
                collectorRowIndex = aggResultColumn.size();
                keyRowIndexMap.put(key, collectorRowIndex);
                keyColumn.add(value);
                aggResultColumn.add(supplier.get());
            }
            for (int i = 0; i < aggOnColumnCount; ++i) {
                aggRow[i] = this._columnList.get(aggOnColumnIndexes[i]).get(rowIndex);
            }
            accumulator.accept(aggResultColumn.get(collectorRowIndex), rowMapper.apply(disposableArray));
        }
        int len = aggResultColumn.size();
        for (int i = 0; i < len; ++i) {
            aggResultColumn.set(i, finisher.apply(aggResultColumn.get(i)));
        }
        return new RowDataSet(newColumnNameList, newColumnList);
    }

    @Override
    public DataSet groupBy(Collection<String> columnNames) {
        return this.groupBy(columnNames, (Function)null);
    }

    @Override
    public <T> DataSet groupBy(Collection<String> columnNames, String aggregateResultColumnName, String aggregateOnColumnName, Collector<T, ?, ?> collector) {
        return this.groupBy(columnNames, (Function)null, aggregateResultColumnName, aggregateOnColumnName, collector);
    }

    @Override
    public DataSet groupBy(Collection<String> columnNames, String aggregateResultColumnName, Collection<String> aggregateOnColumnNames, Class<?> rowClass) {
        N.checkArgNotNullOrEmpty(columnNames, "columnNames");
        N.checkArgNotNullOrEmpty(aggregateOnColumnNames, "aggregateOnColumnNames");
        if (columnNames.size() == 1) {
            return this.groupBy(columnNames.iterator().next(), aggregateResultColumnName, aggregateOnColumnNames, rowClass);
        }
        int size = this.size();
        int[] columnIndexes = this.checkColumnName(columnNames);
        int columnCount = columnIndexes.length;
        int newColumnCount = columnIndexes.length + 1;
        ArrayList<String> newColumnNameList = N.newArrayList(newColumnCount);
        newColumnNameList.addAll(columnNames);
        newColumnNameList.add(aggregateResultColumnName);
        ArrayList<List<Object>> newColumnList = new ArrayList<List<Object>>(newColumnCount);
        for (int i = 0; i < columnCount; ++i) {
            newColumnList.add(new ArrayList());
        }
        if (size == 0) {
            newColumnList.add(new ArrayList());
            return new RowDataSet(newColumnNameList, newColumnList);
        }
        List<?> valueColumnList = this.toList(rowClass, aggregateOnColumnNames);
        Map keyRowMap = N.newLinkedHashMap(N.min(9, this.size()));
        Object[] keyRow = Objectory.createObjectArray(columnCount);
        Wrapper<Object[]> key = null;
        ArrayList val = null;
        for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
            int i;
            for (i = 0; i < newColumnCount; ++i) {
                keyRow[i] = this._columnList.get(columnIndexes[i]).get(rowIndex);
            }
            key = Wrapper.of(keyRow);
            val = (ArrayList)keyRowMap.get(key);
            if (val == null) {
                val = new ArrayList();
                keyRowMap.put(key, val);
                for (i = 0; i < newColumnCount; ++i) {
                    ((List)newColumnList.get(i)).add(keyRow[i]);
                }
                keyRow = Objectory.createObjectArray(columnCount);
            }
            val.add(valueColumnList.get(rowIndex));
        }
        if (keyRow != null) {
            Objectory.recycle(keyRow);
            keyRow = null;
        }
        for (Wrapper e : keyRowMap.keySet()) {
            Objectory.recycle((Object[])e.value());
        }
        newColumnList.add(new ArrayList(keyRowMap.values()));
        return new RowDataSet(newColumnNameList, newColumnList);
    }

    @Override
    public DataSet groupBy(Collection<String> columnNames, String aggregateResultColumnName, Collection<String> aggregateOnColumnNames, Collector<? super Object[], ?, ?> collector) {
        return this.groupBy(columnNames, aggregateResultColumnName, aggregateOnColumnNames, CLONE, collector);
    }

    @Override
    public <U, E extends Exception> DataSet groupBy(Collection<String> columnNames, String aggregateResultColumnName, Collection<String> aggregateOnColumnNames, Throwables.Function<? super NoCachingNoUpdating.DisposableObjArray, U, E> rowMapper, Collector<? super U, ?, ?> collector) throws E {
        return this.groupBy(columnNames, (Function)null, aggregateResultColumnName, aggregateOnColumnNames, rowMapper, collector);
    }

    @Override
    public <E extends Exception> DataSet groupBy(Collection<String> columnNames, Throwables.Function<? super NoCachingNoUpdating.DisposableObjArray, ?, E> keyMapper) throws E {
        boolean isNullOrIdentityKeyMapper;
        N.checkArgNotNullOrEmpty(columnNames, "columnNames");
        boolean bl = isNullOrIdentityKeyMapper = keyMapper == null || keyMapper == Fn.identity();
        if (columnNames.size() == 1 && isNullOrIdentityKeyMapper) {
            return this.groupBy(columnNames.iterator().next(), keyMapper);
        }
        int size = this.size();
        int[] columnIndexes = this.checkColumnName(columnNames);
        int columnCount = columnIndexes.length;
        int newColumnCount = columnIndexes.length;
        ArrayList<String> newColumnNameList = N.newArrayList(columnNames);
        ArrayList<List<Object>> newColumnList = new ArrayList<List<Object>>(newColumnCount);
        for (int i = 0; i < newColumnCount; ++i) {
            newColumnList.add(new ArrayList());
        }
        if (size == 0) {
            return new RowDataSet(newColumnNameList, newColumnList);
        }
        Set<Wrapper> keyRowSet = N.newHashSet();
        Object[] keyRow = Objectory.createObjectArray(columnCount);
        NoCachingNoUpdating.DisposableObjArray disposableArray = NoCachingNoUpdating.DisposableObjArray.wrap(keyRow);
        for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
            int i;
            for (i = 0; i < newColumnCount; ++i) {
                keyRow[i] = this._columnList.get(columnIndexes[i]).get(rowIndex);
            }
            if (isNullOrIdentityKeyMapper) {
                if (!keyRowSet.add(Wrapper.of(keyRow))) continue;
                for (i = 0; i < newColumnCount; ++i) {
                    ((List)newColumnList.get(i)).add(keyRow[i]);
                }
                keyRow = Objectory.createObjectArray(columnCount);
                continue;
            }
            if (!keyRowSet.add((Wrapper)RowDataSet.getHashKey(keyMapper.apply(disposableArray)))) continue;
            for (i = 0; i < newColumnCount; ++i) {
                ((List)newColumnList.get(i)).add(keyRow[i]);
            }
        }
        if (keyRow != null) {
            Objectory.recycle(keyRow);
            keyRow = null;
        }
        if (isNullOrIdentityKeyMapper) {
            Set<Wrapper> tmp = keyRowSet;
            for (Wrapper e : tmp) {
                Objectory.recycle((Object[])e.value());
            }
        }
        return new RowDataSet(newColumnNameList, newColumnList);
    }

    @Override
    public <T, E extends Exception> DataSet groupBy(Collection<String> columnNames, Throwables.Function<? super NoCachingNoUpdating.DisposableObjArray, ?, E> keyMapper, String aggregateResultColumnName, String aggregateOnColumnName, Collector<T, ?, ?> collector) throws E {
        boolean isNullOrIdentityKeyMapper;
        N.checkArgNotNullOrEmpty(columnNames, "columnNames");
        if (N.notNullOrEmpty(columnNames) && columnNames.contains(aggregateResultColumnName)) {
            throw new IllegalArgumentException("Duplicated Property name: " + aggregateResultColumnName);
        }
        boolean bl = isNullOrIdentityKeyMapper = keyMapper == null || keyMapper == Fn.identity();
        if (columnNames.size() == 1 && isNullOrIdentityKeyMapper) {
            return this.groupBy(columnNames.iterator().next(), keyMapper, aggregateResultColumnName, aggregateOnColumnName, collector);
        }
        int size = this.size();
        int[] columnIndexes = this.checkColumnName(columnNames);
        int aggOnColumnIndex = this.checkColumnName(aggregateOnColumnName);
        int columnCount = columnIndexes.length;
        int newColumnCount = columnIndexes.length + 1;
        ArrayList<String> newColumnNameList = new ArrayList<String>(columnNames);
        newColumnNameList.add(aggregateResultColumnName);
        ArrayList<List<Object>> newColumnList = new ArrayList<List<Object>>(newColumnCount);
        for (int i = 0; i < newColumnCount; ++i) {
            newColumnList.add(new ArrayList());
        }
        if (size == 0) {
            return new RowDataSet(newColumnNameList, newColumnList);
        }
        Supplier<?> supplier = collector.supplier();
        BiConsumer accumulator = collector.accumulator();
        Function<?, ?> finisher = collector.finisher();
        List aggResultColumn = (List)newColumnList.get(newColumnList.size() - 1);
        List<Object> aggOnColumn = this._columnList.get(aggOnColumnIndex);
        HashMap<Wrapper<Object[]>, Integer> keyRowIndexMap = new HashMap<Wrapper<Object[]>, Integer>();
        Object[] keyRow = Objectory.createObjectArray(columnCount);
        NoCachingNoUpdating.DisposableObjArray disposableArray = NoCachingNoUpdating.DisposableObjArray.wrap(keyRow);
        Object key = null;
        Integer collectorRowIndex = -1;
        for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
            int i;
            for (i = 0; i < columnCount; ++i) {
                keyRow[i] = this._columnList.get(columnIndexes[i]).get(rowIndex);
            }
            key = isNullOrIdentityKeyMapper ? Wrapper.of(keyRow) : RowDataSet.getHashKey(keyMapper.apply(disposableArray));
            collectorRowIndex = (Integer)keyRowIndexMap.get(key);
            if (collectorRowIndex == null) {
                collectorRowIndex = aggResultColumn.size();
                keyRowIndexMap.put((Wrapper<Object[]>)key, collectorRowIndex);
                aggResultColumn.add(supplier.get());
                for (i = 0; i < columnCount; ++i) {
                    ((List)newColumnList.get(i)).add(keyRow[i]);
                }
                keyRow = Objectory.createObjectArray(columnCount);
            }
            accumulator.accept(aggResultColumn.get(collectorRowIndex), aggOnColumn.get(rowIndex));
        }
        int len = aggResultColumn.size();
        for (int i = 0; i < len; ++i) {
            aggResultColumn.set(i, finisher.apply(aggResultColumn.get(i)));
        }
        if (keyRow != null) {
            Objectory.recycle(keyRow);
            keyRow = null;
        }
        if (isNullOrIdentityKeyMapper) {
            Set tmp = keyRowIndexMap.keySet();
            for (Wrapper e : tmp) {
                Objectory.recycle((Object[])e.value());
            }
        }
        return new RowDataSet(newColumnNameList, newColumnList);
    }

    @Override
    public <E extends Exception> DataSet groupBy(Collection<String> columnNames, Throwables.Function<? super NoCachingNoUpdating.DisposableObjArray, ?, E> keyMapper, String aggregateResultColumnName, Collection<String> aggregateOnColumnNames, Class<?> rowClass) throws E {
        boolean isNullOrIdentityKeyMapper;
        N.checkArgNotNullOrEmpty(columnNames, "columnNames");
        N.checkArgNotNullOrEmpty(aggregateOnColumnNames, "aggregateOnColumnNames");
        boolean bl = isNullOrIdentityKeyMapper = keyMapper == null || keyMapper == Fn.identity();
        if (isNullOrIdentityKeyMapper) {
            if (columnNames.size() == 1) {
                return this.groupBy(columnNames.iterator().next(), aggregateResultColumnName, aggregateOnColumnNames, rowClass);
            }
            return this.groupBy(columnNames, aggregateResultColumnName, aggregateOnColumnNames, rowClass);
        }
        int size = this.size();
        int[] columnIndexes = this.checkColumnName(columnNames);
        int columnCount = columnIndexes.length;
        int newColumnCount = columnIndexes.length + 1;
        ArrayList<String> newColumnNameList = N.newArrayList(newColumnCount);
        newColumnNameList.addAll(columnNames);
        newColumnNameList.add(aggregateResultColumnName);
        ArrayList<List<Object>> newColumnList = new ArrayList<List<Object>>(newColumnCount);
        for (int i = 0; i < columnCount; ++i) {
            newColumnList.add(new ArrayList());
        }
        if (size == 0) {
            newColumnList.add(new ArrayList());
            return new RowDataSet(newColumnNameList, newColumnList);
        }
        List<?> valueColumnList = this.toList(rowClass, aggregateOnColumnNames);
        Map keyRowMap = N.newLinkedHashMap();
        Object[] keyRow = Objectory.createObjectArray(columnCount);
        NoCachingNoUpdating.DisposableObjArray keyDisposableArray = NoCachingNoUpdating.DisposableObjArray.wrap(keyRow);
        Object key = null;
        ArrayList val = null;
        for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
            int i;
            for (i = 0; i < newColumnCount; ++i) {
                keyRow[i] = this._columnList.get(columnIndexes[i]).get(rowIndex);
            }
            key = RowDataSet.getHashKey(keyMapper.apply(keyDisposableArray));
            val = (ArrayList)keyRowMap.get(key);
            if (val == null) {
                val = new ArrayList();
                keyRowMap.put(key, val);
                for (i = 0; i < newColumnCount; ++i) {
                    ((List)newColumnList.get(i)).add(keyRow[i]);
                }
            }
            val.add(valueColumnList.get(rowIndex));
        }
        if (keyRow != null) {
            Objectory.recycle(keyRow);
        }
        newColumnList.add(new ArrayList(keyRowMap.values()));
        return new RowDataSet(newColumnNameList, newColumnList);
    }

    @Override
    public <E extends Exception> DataSet groupBy(Collection<String> columnNames, Throwables.Function<? super NoCachingNoUpdating.DisposableObjArray, ?, E> keyMapper, String aggregateResultColumnName, Collection<String> aggregateOnColumnNames, Collector<? super Object[], ?, ?> collector) throws E {
        return this.groupBy(aggregateOnColumnNames, keyMapper, aggregateResultColumnName, aggregateOnColumnNames, CLONE, collector);
    }

    @Override
    public <U, E extends Exception, E2 extends Exception> DataSet groupBy(Collection<String> columnNames, Throwables.Function<? super NoCachingNoUpdating.DisposableObjArray, ?, E> keyMapper, String aggregateResultColumnName, Collection<String> aggregateOnColumnNames, Throwables.Function<? super NoCachingNoUpdating.DisposableObjArray, U, E2> rowMapper, Collector<? super U, ?, ?> collector) throws E, E2 {
        boolean isNullOrIdentityKeyMapper;
        N.checkArgNotNullOrEmpty(columnNames, "columnNames");
        if (N.notNullOrEmpty(columnNames) && columnNames.contains(aggregateResultColumnName)) {
            throw new IllegalArgumentException("Duplicated Property name: " + aggregateResultColumnName);
        }
        N.checkArgNotNull(rowMapper, "rowMapper");
        N.checkArgNotNull(collector, "collector");
        boolean bl = isNullOrIdentityKeyMapper = keyMapper == null || keyMapper == Fn.identity();
        if (columnNames.size() == 1 && isNullOrIdentityKeyMapper) {
            return this.groupBy(columnNames.iterator().next(), keyMapper, aggregateResultColumnName, aggregateOnColumnNames, rowMapper, collector);
        }
        int size = this.size();
        int[] columnIndexes = this.checkColumnName(columnNames);
        int[] aggOnColumnIndexes = this.checkColumnName(aggregateOnColumnNames);
        int columnCount = columnIndexes.length;
        int newColumnCount = columnIndexes.length + 1;
        ArrayList<String> newColumnNameList = new ArrayList<String>(columnNames);
        newColumnNameList.add(aggregateResultColumnName);
        ArrayList<List<Object>> newColumnList = new ArrayList<List<Object>>(newColumnCount);
        for (int i = 0; i < newColumnCount; ++i) {
            newColumnList.add(new ArrayList());
        }
        if (size == 0) {
            return new RowDataSet(newColumnNameList, newColumnList);
        }
        Supplier<?> supplier = collector.supplier();
        BiConsumer<?, U> accumulator = collector.accumulator();
        Function<?, ?> finisher = collector.finisher();
        int aggOnColumnCount = aggOnColumnIndexes.length;
        List aggResultColumn = (List)newColumnList.get(newColumnList.size() - 1);
        HashMap<Wrapper<Object[]>, Integer> keyRowIndexMap = new HashMap<Wrapper<Object[]>, Integer>();
        Object[] keyRow = Objectory.createObjectArray(columnCount);
        NoCachingNoUpdating.DisposableObjArray keyDisposableArray = NoCachingNoUpdating.DisposableObjArray.wrap(keyRow);
        Object[] aggOnRow = new Object[aggOnColumnCount];
        NoCachingNoUpdating.DisposableObjArray aggOnRowDisposableArray = NoCachingNoUpdating.DisposableObjArray.wrap(aggOnRow);
        Object key = null;
        Integer collectorRowIndex = -1;
        for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
            int i;
            for (i = 0; i < columnCount; ++i) {
                keyRow[i] = this._columnList.get(columnIndexes[i]).get(rowIndex);
            }
            key = isNullOrIdentityKeyMapper ? Wrapper.of(keyRow) : RowDataSet.getHashKey(keyMapper.apply(keyDisposableArray));
            collectorRowIndex = (Integer)keyRowIndexMap.get(key);
            if (collectorRowIndex == null) {
                collectorRowIndex = aggResultColumn.size();
                keyRowIndexMap.put((Wrapper<Object[]>)key, collectorRowIndex);
                aggResultColumn.add(supplier.get());
                for (i = 0; i < columnCount; ++i) {
                    ((List)newColumnList.get(i)).add(keyRow[i]);
                }
                keyRow = Objectory.createObjectArray(columnCount);
            }
            for (i = 0; i < aggOnColumnCount; ++i) {
                aggOnRow[i] = this._columnList.get(aggOnColumnIndexes[i]).get(rowIndex);
            }
            accumulator.accept(aggResultColumn.get(collectorRowIndex), rowMapper.apply(aggOnRowDisposableArray));
        }
        int len = aggResultColumn.size();
        for (int i = 0; i < len; ++i) {
            aggResultColumn.set(i, finisher.apply(aggResultColumn.get(i)));
        }
        if (keyRow != null) {
            Objectory.recycle(keyRow);
            keyRow = null;
        }
        if (isNullOrIdentityKeyMapper) {
            Set tmp = keyRowIndexMap.keySet();
            for (Wrapper e : tmp) {
                Objectory.recycle((Object[])e.value());
            }
        }
        return new RowDataSet(newColumnNameList, newColumnList);
    }

    @Override
    public void sortBy(String columnName) {
        this.sortBy(columnName, Comparators.naturalOrder());
    }

    @Override
    public <T> void sortBy(String columnName, Comparator<T> cmp) {
        this.sort(columnName, cmp, false);
    }

    @Override
    public void sortBy(Collection<String> columnNames) {
        this.sortBy(columnNames, (Comparator<? super Object[]>)null);
    }

    @Override
    public void sortBy(Collection<String> columnNames, Comparator<? super Object[]> cmp) {
        this.sort(columnNames, cmp, false);
    }

    @Override
    public void sortBy(Collection<String> columnNames, Function<? super NoCachingNoUpdating.DisposableObjArray, ? extends Comparable> keyMapper) {
        this.sort(columnNames, keyMapper, false);
    }

    private <T> void sort(String columnName, Comparator<T> cmp, boolean isParallelSort) {
        this.checkFrozen();
        int columnIndex = this.checkColumnName(columnName);
        int size = this.size();
        if (size == 0) {
            return;
        }
        Indexed[] arrayOfPair = new Indexed[size];
        List<Object> orderByColumn = this._columnList.get(columnIndex);
        for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
            arrayOfPair[rowIndex] = Indexed.of(orderByColumn.get(rowIndex), rowIndex);
        }
        final Comparator<T> cmp2 = cmp;
        Comparator<Indexed<Object>> pairCmp = cmp == null ? new Comparator<Indexed<Comparable>>(){

            @Override
            public int compare(Indexed<Comparable> o1, Indexed<Comparable> o2) {
                return N.compare(o1.value(), o2.value());
            }
        } : new Comparator<Indexed<Object>>(){

            @Override
            public int compare(Indexed<Object> o1, Indexed<Object> o2) {
                return cmp2.compare(o1.value(), o2.value());
            }
        };
        this.sort(arrayOfPair, pairCmp, isParallelSort);
    }

    private void sort(Collection<String> columnNames, final Comparator<? super Object[]> cmp, boolean isParallelSort) {
        this.checkFrozen();
        int[] columnIndexes = this.checkColumnName(columnNames);
        int size = this.size();
        if (size == 0) {
            return;
        }
        int sortByColumnCount = columnIndexes.length;
        Indexed[] arrayOfPair = new Indexed[size];
        for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
            arrayOfPair[rowIndex] = Indexed.of(Objectory.createObjectArray(sortByColumnCount), rowIndex);
        }
        for (int i = 0; i < sortByColumnCount; ++i) {
            List<Object> orderByColumn = this._columnList.get(columnIndexes[i]);
            for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
                ((Object[])arrayOfPair[rowIndex].value())[i] = orderByColumn.get(rowIndex);
            }
        }
        Comparator<Indexed<Object[]>> pairCmp = cmp == null ? new Comparator<Indexed<Object[]>>(){

            @Override
            public int compare(Indexed<Object[]> o1, Indexed<Object[]> o2) {
                return MULTI_COLUMN_COMPARATOR.compare(o1.value(), o2.value());
            }
        } : new Comparator<Indexed<Object[]>>(){

            @Override
            public int compare(Indexed<Object[]> o1, Indexed<Object[]> o2) {
                return cmp.compare(o1.value(), o2.value());
            }
        };
        this.sort(arrayOfPair, pairCmp, isParallelSort);
        for (Indexed p : arrayOfPair) {
            Objectory.recycle((Object[])p.value());
        }
    }

    private void sort(Collection<String> columnNames, Function<? super NoCachingNoUpdating.DisposableObjArray, ? extends Comparable> keyMapper, boolean isParallelSort) {
        this.checkFrozen();
        int[] columnIndexes = this.checkColumnName(columnNames);
        int size = this.size();
        if (size == 0) {
            return;
        }
        int sortByColumnCount = columnIndexes.length;
        Indexed[] arrayOfPair = new Indexed[size];
        Object[] sortByRow = new Object[sortByColumnCount];
        NoCachingNoUpdating.DisposableObjArray disposableArray = NoCachingNoUpdating.DisposableObjArray.wrap(sortByRow);
        for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
            for (int i = 0; i < sortByColumnCount; ++i) {
                sortByRow[i] = this._columnList.get(columnIndexes[i]).get(rowIndex);
            }
            arrayOfPair[rowIndex] = Indexed.of(keyMapper.apply(disposableArray), rowIndex);
        }
        Comparator pairCmp = Comparators.comparingBy(new Function<Indexed<Comparable>, Comparable>(){

            @Override
            public Comparable apply(Indexed<Comparable> t) {
                return t.value();
            }
        });
        this.sort(arrayOfPair, pairCmp, isParallelSort);
    }

    private <T> void sort(Indexed<T>[] arrayOfPair, Comparator<Indexed<T>> pairCmp, boolean isParallelSort) {
        N.sort(arrayOfPair, pairCmp);
        int size = this.size();
        int columnCount = this._columnNameList.size();
        Set ordered = N.newHashSet(size);
        Object[] tempRow = new Object[columnCount];
        int index = 0;
        for (int i = 0; i < size; ++i) {
            int j;
            index = arrayOfPair[i].index();
            if (index == i || ordered.contains(i)) continue;
            for (int j2 = 0; j2 < columnCount; ++j2) {
                tempRow[j2] = this._columnList.get(j2).get(i);
            }
            int previous = i;
            int next = index;
            do {
                for (j = 0; j < columnCount; ++j) {
                    this._columnList.get(j).set(previous, this._columnList.get(j).get(next));
                }
                ordered.add(next);
                previous = next;
            } while ((next = arrayOfPair[next].index()) != i);
            for (j = 0; j < columnCount; ++j) {
                this._columnList.get(j).set(previous, tempRow[j]);
            }
            ordered.add(i);
        }
        ++this.modCount;
    }

    @Override
    public DataSet topBy(String columnName, int n) {
        return this.topBy(columnName, n, Comparators.naturalOrder());
    }

    @Override
    public <T> DataSet topBy(String columnName, int n, Comparator<T> cmp) {
        if (n < 1) {
            throw new IllegalArgumentException("'n' can not be less than 1");
        }
        int columnIndex = this.checkColumnName(columnName);
        int size = this.size();
        if (n >= size) {
            return this.copy();
        }
        final Comparator<T> cmp2 = cmp;
        Comparator<Indexed<Object>> pairCmp = cmp == null ? new Comparator<Indexed<Comparable>>(){

            @Override
            public int compare(Indexed<Comparable> o1, Indexed<Comparable> o2) {
                return N.compare(o1.value(), o2.value());
            }
        } : new Comparator<Indexed<Object>>(){

            @Override
            public int compare(Indexed<Object> o1, Indexed<Object> o2) {
                return cmp2.compare(o1.value(), o2.value());
            }
        };
        final List<Object> orderByColumn = this._columnList.get(columnIndex);
        return this.top(n, pairCmp, new IntFunction<Object>(){

            @Override
            public Object apply(int rowIndex) {
                return orderByColumn.get(rowIndex);
            }
        });
    }

    @Override
    public DataSet topBy(Collection<String> columnNames, int n) {
        return this.topBy(columnNames, n, (Comparator<? super Object[]>)null);
    }

    @Override
    public DataSet topBy(Collection<String> columnNames, int n, final Comparator<? super Object[]> cmp) {
        if (n < 1) {
            throw new IllegalArgumentException("'n' can not be less than 1");
        }
        final int[] sortByColumnIndexes = this.checkColumnName(columnNames);
        int size = this.size();
        if (n >= size) {
            return this.copy();
        }
        Comparator<Indexed<Object[]>> pairCmp = cmp == null ? new Comparator<Indexed<Object[]>>(){

            @Override
            public int compare(Indexed<Object[]> o1, Indexed<Object[]> o2) {
                return MULTI_COLUMN_COMPARATOR.compare(o1.value(), o2.value());
            }
        } : new Comparator<Indexed<Object[]>>(){

            @Override
            public int compare(Indexed<Object[]> o1, Indexed<Object[]> o2) {
                return cmp.compare(o1.value(), o2.value());
            }
        };
        final ArrayList keyRowList = new ArrayList(n);
        final int sortByColumnCount = sortByColumnIndexes.length;
        DataSet result = this.top(n, pairCmp, new IntFunction<Object[]>(){

            @Override
            public Object[] apply(int rowIndex) {
                Object[] keyRow = Objectory.createObjectArray(sortByColumnCount);
                keyRowList.add(keyRow);
                for (int i = 0; i < sortByColumnCount; ++i) {
                    keyRow[i] = RowDataSet.this._columnList.get(sortByColumnIndexes[i]).get(rowIndex);
                }
                return keyRow;
            }
        });
        for (Object[] a : keyRowList) {
            Objectory.recycle(a);
        }
        return result;
    }

    @Override
    public DataSet topBy(Collection<String> columnNames, int n, final Function<? super NoCachingNoUpdating.DisposableObjArray, ? extends Comparable> keyMapper) {
        if (n < 1) {
            throw new IllegalArgumentException("'n' can not be less than 1");
        }
        final int[] columnIndexes = this.checkColumnName(columnNames);
        int size = this.size();
        if (n >= size) {
            return this.copy();
        }
        Comparator pairCmp = Comparators.comparingBy(new Function<Indexed<Comparable>, Comparable>(){

            @Override
            public Comparable apply(Indexed<Comparable> t) {
                return t.value();
            }
        });
        final int sortByColumnCount = columnIndexes.length;
        final Object[] keyRow = new Object[sortByColumnCount];
        final NoCachingNoUpdating.DisposableObjArray disposableObjArray = NoCachingNoUpdating.DisposableObjArray.wrap(keyRow);
        return this.top(n, pairCmp, new IntFunction<Comparable>(){

            @Override
            public Comparable apply(int rowIndex) {
                for (int i = 0; i < sortByColumnCount; ++i) {
                    keyRow[i] = RowDataSet.this._columnList.get(columnIndexes[i]).get(rowIndex);
                }
                return (Comparable)keyMapper.apply(disposableObjArray);
            }
        });
    }

    private <T> DataSet top(int n, Comparator<Indexed<T>> pairCmp, IntFunction<T> keyFunc) {
        int size = this.size();
        PriorityQueue<Indexed<Indexed>> heap = new PriorityQueue<Indexed<Indexed>>(n, pairCmp);
        Indexed<T> pair = null;
        for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
            pair = Indexed.of(keyFunc.apply(rowIndex), rowIndex);
            if (heap.size() >= n) {
                if (pairCmp.compare((Indexed<Indexed<T>>)heap.peek(), (Indexed<Indexed<T>>)pair) >= 0) continue;
                heap.poll();
                heap.add(pair);
                continue;
            }
            heap.offer(pair);
        }
        Indexed[] arrayOfPair = heap.toArray(new Indexed[heap.size()]);
        N.sort(arrayOfPair, new Comparator<Indexed<Object>>(){

            @Override
            public int compare(Indexed<Object> o1, Indexed<Object> o2) {
                return o1.index() - o2.index();
            }
        });
        int columnCount = this._columnNameList.size();
        ArrayList<String> newColumnNameList = new ArrayList<String>(this._columnNameList);
        ArrayList<List<Object>> newColumnList = new ArrayList<List<Object>>(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            newColumnList.add(new ArrayList(arrayOfPair.length));
        }
        int rowIndex = 0;
        for (Indexed e : arrayOfPair) {
            rowIndex = e.index();
            for (int i = 0; i < columnCount; ++i) {
                ((List)newColumnList.get(i)).add(this._columnList.get(i).get(rowIndex));
            }
        }
        Properties<String, Object> newProperties = N.isNullOrEmpty(this._properties) ? null : this._properties.copy();
        return new RowDataSet(newColumnNameList, newColumnList, newProperties);
    }

    @Override
    public DataSet distinct() {
        return this.distinctBy(this._columnNameList);
    }

    @Override
    public DataSet distinctBy(String columnName) {
        return this.distinctBy(columnName, Fn.identity());
    }

    @Override
    public <K, E extends Exception> DataSet distinctBy(String columnName, Throwables.Function<K, ?, E> keyMapper) throws E {
        Properties<String, Object> newProperties;
        int columnIndex = this.checkColumnName(columnName);
        int size = this.size();
        int columnCount = this._columnNameList.size();
        ArrayList<String> newColumnNameList = new ArrayList<String>(this._columnNameList);
        ArrayList<List<Object>> newColumnList = new ArrayList<List<Object>>(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            newColumnList.add(new ArrayList());
        }
        Properties<String, Object> properties = newProperties = N.isNullOrEmpty(this._properties) ? null : this._properties.copy();
        if (size == 0) {
            return new RowDataSet(newColumnNameList, newColumnList, newProperties);
        }
        Throwables.Function<K, ?, E> keyMapper2 = keyMapper;
        Set rowSet = N.newHashSet();
        Object key = null;
        Object value = null;
        for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
            value = this._columnList.get(columnIndex).get(rowIndex);
            key = RowDataSet.getHashKey(keyMapper2 == null ? value : keyMapper2.apply(value));
            if (!rowSet.add(key)) continue;
            for (int i = 0; i < columnCount; ++i) {
                ((List)newColumnList.get(i)).add(this._columnList.get(i).get(rowIndex));
            }
        }
        return new RowDataSet(newColumnNameList, newColumnList, newProperties);
    }

    @Override
    public DataSet distinctBy(Collection<String> columnNames) {
        return this.distinctBy(columnNames, (Function)null);
    }

    @Override
    public <E extends Exception> DataSet distinctBy(Collection<String> columnNames, Throwables.Function<? super NoCachingNoUpdating.DisposableObjArray, ?, E> keyMapper) throws E {
        Properties<String, Object> newProperties;
        boolean isNullOrIdentityKeyMapper;
        boolean bl = isNullOrIdentityKeyMapper = keyMapper == null || keyMapper == Fn.identity();
        if (columnNames.size() == 1 && isNullOrIdentityKeyMapper) {
            return this.distinctBy(columnNames.iterator().next());
        }
        int size = this.size();
        int[] columnIndexes = this.checkColumnName(columnNames);
        int columnCount = this._columnNameList.size();
        ArrayList<String> newColumnNameList = new ArrayList<String>(this._columnNameList);
        ArrayList<List<Object>> newColumnList = new ArrayList<List<Object>>(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            newColumnList.add(new ArrayList());
        }
        Properties<String, Object> properties = newProperties = N.isNullOrEmpty(this._properties) ? null : this._properties.copy();
        if (size == 0) {
            return new RowDataSet(newColumnNameList, newColumnList, newProperties);
        }
        Set<Wrapper> rowSet = N.newHashSet();
        Object[] row = Objectory.createObjectArray(columnCount);
        NoCachingNoUpdating.DisposableObjArray disposableArray = NoCachingNoUpdating.DisposableObjArray.wrap(row);
        for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
            int columnIndex;
            int len = columnIndexes.length;
            for (int i = 0; i < len; ++i) {
                row[i] = this._columnList.get(columnIndexes[i]).get(rowIndex);
            }
            if (isNullOrIdentityKeyMapper) {
                if (!rowSet.add(Wrapper.of(row))) continue;
                for (columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
                    ((List)newColumnList.get(columnIndex)).add(this._columnList.get(columnIndex).get(rowIndex));
                }
                row = Objectory.createObjectArray(columnCount);
                continue;
            }
            if (!rowSet.add((Wrapper)RowDataSet.getHashKey(keyMapper.apply(disposableArray)))) continue;
            for (columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
                ((List)newColumnList.get(columnIndex)).add(this._columnList.get(columnIndex).get(rowIndex));
            }
        }
        if (row != null) {
            Objectory.recycle(row);
            row = null;
        }
        if (isNullOrIdentityKeyMapper) {
            Set<Wrapper> tmp = rowSet;
            for (Wrapper e : tmp) {
                Objectory.recycle((Object[])e.value());
            }
        }
        return new RowDataSet(newColumnNameList, newColumnList, newProperties);
    }

    @Override
    public <E extends Exception> DataSet filter(Throwables.Predicate<? super NoCachingNoUpdating.DisposableObjArray, E> filter) throws E {
        return this.filter(filter, this.size());
    }

    @Override
    public <E extends Exception> DataSet filter(Throwables.Predicate<? super NoCachingNoUpdating.DisposableObjArray, E> filter, int max) throws E {
        return this.filter(0, this.size(), filter);
    }

    @Override
    public <E extends Exception> DataSet filter(int fromRowIndex, int toRowIndex, Throwables.Predicate<? super NoCachingNoUpdating.DisposableObjArray, E> filter) throws E {
        return this.filter(fromRowIndex, toRowIndex, filter, this.size());
    }

    @Override
    public <E extends Exception> DataSet filter(int fromRowIndex, int toRowIndex, Throwables.Predicate<? super NoCachingNoUpdating.DisposableObjArray, E> filter, int max) throws E {
        return this.filter(this._columnNameList, fromRowIndex, toRowIndex, filter, max);
    }

    @Override
    public <E extends Exception> DataSet filter(Tuple.Tuple2<String, String> columnNames, Throwables.BiPredicate<?, ?, E> filter) throws E {
        return this.filter(columnNames, filter, this.size());
    }

    @Override
    public <E extends Exception> DataSet filter(Tuple.Tuple2<String, String> columnNames, Throwables.BiPredicate<?, ?, E> filter, int max) throws E {
        return this.filter(columnNames, 0, this.size(), filter, max);
    }

    @Override
    public <E extends Exception> DataSet filter(Tuple.Tuple2<String, String> columnNames, int fromRowIndex, int toRowIndex, Throwables.BiPredicate<?, ?, E> filter) throws E {
        return this.filter(columnNames, fromRowIndex, toRowIndex, filter, this.size());
    }

    @Override
    public <E extends Exception> DataSet filter(Tuple.Tuple2<String, String> columnNames, int fromRowIndex, int toRowIndex, Throwables.BiPredicate<?, ?, E> filter, int max) throws E {
        Properties<String, Object> newProperties;
        List<Object> column1 = this._columnList.get(this.checkColumnName((String)columnNames._1));
        List<Object> column2 = this._columnList.get(this.checkColumnName((String)columnNames._2));
        this.checkRowIndex(fromRowIndex, toRowIndex);
        N.checkArgNotNull(filter);
        Throwables.BiPredicate<?, ?, E> filter2 = filter;
        int size = this.size();
        int columnCount = this._columnNameList.size();
        ArrayList<String> newColumnNameList = new ArrayList<String>(this._columnNameList);
        ArrayList<List<Object>> newColumnList = new ArrayList<List<Object>>(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            newColumnList.add(new ArrayList(N.min(max, size == 0 ? 0 : (int)((double)size * 0.8) + 1)));
        }
        Properties<String, Object> properties = newProperties = N.isNullOrEmpty(this._properties) ? null : this._properties.copy();
        if (size == 0 || max == 0) {
            return new RowDataSet(newColumnNameList, newColumnList, newProperties);
        }
        int count = max;
        for (int rowIndex = fromRowIndex; rowIndex < toRowIndex; ++rowIndex) {
            if (!filter2.test(column1.get(rowIndex), column2.get(rowIndex))) continue;
            if (--count < 0) break;
            for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
                ((List)newColumnList.get(columnIndex)).add(this._columnList.get(columnIndex).get(rowIndex));
            }
        }
        return new RowDataSet(newColumnNameList, newColumnList, newProperties);
    }

    @Override
    public <E extends Exception> DataSet filter(Tuple.Tuple3<String, String, String> columnNames, Throwables.TriPredicate<?, ?, ?, E> filter) throws E {
        return this.filter(columnNames, filter, this.size());
    }

    @Override
    public <E extends Exception> DataSet filter(Tuple.Tuple3<String, String, String> columnNames, Throwables.TriPredicate<?, ?, ?, E> filter, int max) throws E {
        return this.filter(columnNames, 0, this.size(), filter, max);
    }

    @Override
    public <E extends Exception> DataSet filter(Tuple.Tuple3<String, String, String> columnNames, int fromRowIndex, int toRowIndex, Throwables.TriPredicate<?, ?, ?, E> filter) throws E {
        return this.filter(columnNames, fromRowIndex, toRowIndex, filter, this.size());
    }

    @Override
    public <E extends Exception> DataSet filter(Tuple.Tuple3<String, String, String> columnNames, int fromRowIndex, int toRowIndex, Throwables.TriPredicate<?, ?, ?, E> filter, int max) throws E {
        Properties<String, Object> newProperties;
        List<Object> column1 = this._columnList.get(this.checkColumnName((String)columnNames._1));
        List<Object> column2 = this._columnList.get(this.checkColumnName((String)columnNames._2));
        List<Object> column3 = this._columnList.get(this.checkColumnName((String)columnNames._3));
        this.checkRowIndex(fromRowIndex, toRowIndex);
        N.checkArgNotNull(filter);
        Throwables.TriPredicate<?, ?, ?, E> filter2 = filter;
        int size = this.size();
        int columnCount = this._columnNameList.size();
        ArrayList<String> newColumnNameList = new ArrayList<String>(this._columnNameList);
        ArrayList<List<Object>> newColumnList = new ArrayList<List<Object>>(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            newColumnList.add(new ArrayList(N.min(max, size == 0 ? 0 : (int)((double)size * 0.8) + 1)));
        }
        Properties<String, Object> properties = newProperties = N.isNullOrEmpty(this._properties) ? null : this._properties.copy();
        if (size == 0 || max == 0) {
            return new RowDataSet(newColumnNameList, newColumnList, newProperties);
        }
        int count = max;
        for (int rowIndex = fromRowIndex; rowIndex < toRowIndex; ++rowIndex) {
            if (!filter2.test(column1.get(rowIndex), column2.get(rowIndex), column3.get(rowIndex))) continue;
            if (--count < 0) break;
            for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
                ((List)newColumnList.get(columnIndex)).add(this._columnList.get(columnIndex).get(rowIndex));
            }
        }
        return new RowDataSet(newColumnNameList, newColumnList, newProperties);
    }

    @Override
    public <T, E extends Exception> DataSet filter(String columnName, Throwables.Predicate<T, E> filter) throws E {
        return this.filter(columnName, filter, this.size());
    }

    @Override
    public <T, E extends Exception> DataSet filter(String columnName, Throwables.Predicate<T, E> filter, int max) throws E {
        return this.filter(columnName, 0, this.size(), filter, max);
    }

    @Override
    public <T, E extends Exception> DataSet filter(String columnName, int fromRowIndex, int toRowIndex, Throwables.Predicate<T, E> filter) throws E {
        return this.filter(columnName, fromRowIndex, toRowIndex, filter, this.size());
    }

    @Override
    public <T, E extends Exception> DataSet filter(String columnName, int fromRowIndex, int toRowIndex, Throwables.Predicate<T, E> filter, int max) throws E {
        Properties<String, Object> newProperties;
        int filterColumnIndex = this.checkColumnName(columnName);
        this.checkRowIndex(fromRowIndex, toRowIndex);
        N.checkArgNotNull(filter, "filter");
        N.checkArgNotNegative(max, "max");
        int size = this.size();
        int columnCount = this._columnNameList.size();
        ArrayList<String> newColumnNameList = new ArrayList<String>(this._columnNameList);
        ArrayList<List<Object>> newColumnList = new ArrayList<List<Object>>(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            newColumnList.add(new ArrayList(N.min(max, size == 0 ? 0 : (int)((double)size * 0.8) + 1)));
        }
        Properties<String, Object> properties = newProperties = N.isNullOrEmpty(this._properties) ? null : this._properties.copy();
        if (size == 0) {
            return new RowDataSet(newColumnNameList, newColumnList, newProperties);
        }
        for (int rowIndex = fromRowIndex; rowIndex < toRowIndex; ++rowIndex) {
            if (!filter.test(this._columnList.get(filterColumnIndex).get(rowIndex))) continue;
            if (--max < 0) break;
            for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
                ((List)newColumnList.get(columnIndex)).add(this._columnList.get(columnIndex).get(rowIndex));
            }
        }
        return new RowDataSet(newColumnNameList, newColumnList, newProperties);
    }

    @Override
    public <E extends Exception> DataSet filter(Collection<String> columnNames, Throwables.Predicate<? super NoCachingNoUpdating.DisposableObjArray, E> filter) throws E {
        return this.filter(columnNames, filter, this.size());
    }

    @Override
    public <E extends Exception> DataSet filter(Collection<String> columnNames, Throwables.Predicate<? super NoCachingNoUpdating.DisposableObjArray, E> filter, int max) throws E {
        return this.filter(columnNames, 0, this.size(), filter, max);
    }

    @Override
    public <E extends Exception> DataSet filter(Collection<String> columnNames, int fromRowIndex, int toRowIndex, Throwables.Predicate<? super NoCachingNoUpdating.DisposableObjArray, E> filter) throws E {
        return this.filter(columnNames, fromRowIndex, toRowIndex, filter, this.size());
    }

    @Override
    public <E extends Exception> DataSet filter(Collection<String> columnNames, int fromRowIndex, int toRowIndex, Throwables.Predicate<? super NoCachingNoUpdating.DisposableObjArray, E> filter, int max) throws E {
        Properties<String, Object> newProperties;
        int[] filterColumnIndexes = this.checkColumnName(columnNames);
        this.checkRowIndex(fromRowIndex, toRowIndex);
        N.checkArgNotNull(filter, "filter");
        N.checkArgNotNegative(max, "max");
        int size = this.size();
        int columnCount = this._columnNameList.size();
        ArrayList<String> newColumnNameList = new ArrayList<String>(this._columnNameList);
        ArrayList<List<Object>> newColumnList = new ArrayList<List<Object>>(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            newColumnList.add(new ArrayList(N.min(max, size == 0 ? 0 : (int)((double)size * 0.8) + 1)));
        }
        Properties<String, Object> properties = newProperties = N.isNullOrEmpty(this._properties) ? null : this._properties.copy();
        if (size == 0) {
            return new RowDataSet(newColumnNameList, newColumnList, newProperties);
        }
        int filterColumnCount = filterColumnIndexes.length;
        Object[] values = new Object[filterColumnCount];
        NoCachingNoUpdating.DisposableObjArray disposableArray = NoCachingNoUpdating.DisposableObjArray.wrap(values);
        for (int rowIndex = fromRowIndex; rowIndex < toRowIndex; ++rowIndex) {
            for (int i = 0; i < filterColumnCount; ++i) {
                values[i] = this._columnList.get(filterColumnIndexes[i]).get(rowIndex);
            }
            if (!filter.test(disposableArray)) continue;
            if (--max < 0) break;
            for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
                ((List)newColumnList.get(columnIndex)).add(this._columnList.get(columnIndex).get(rowIndex));
            }
        }
        return new RowDataSet(newColumnNameList, newColumnList, newProperties);
    }

    @Override
    public <E extends Exception> DataSet map(String fromColumnName, Throwables.Function<?, ?, E> func, String newColumnName, String copyingColumnName) throws E {
        return this.map(fromColumnName, func, newColumnName, Array.asList(copyingColumnName));
    }

    @Override
    public <E extends Exception> DataSet map(String fromColumnName, Throwables.Function<?, ?, E> func, String newColumnName, Collection<String> copyingColumnNames) throws E {
        N.checkArgNotNull(func, "func");
        int fromColumnIndex = this.checkColumnName(fromColumnName);
        int[] copyingColumnIndices = N.isNullOrEmpty(copyingColumnNames) ? N.EMPTY_INT_ARRAY : this.checkColumnName(copyingColumnNames);
        Throwables.Function<?, ?, E> mapper = func;
        int size = this.size();
        int copyingColumnCount = copyingColumnIndices.length;
        ArrayList mappedColumn = new ArrayList(size);
        for (Object val : this._columnList.get(fromColumnIndex)) {
            mappedColumn.add(mapper.apply(val));
        }
        ArrayList<String> newColumnNameList = new ArrayList<String>(copyingColumnCount + 1);
        newColumnNameList.add(newColumnName);
        ArrayList<List<Object>> newColumnList = new ArrayList<List<Object>>(copyingColumnCount + 1);
        newColumnList.add(mappedColumn);
        if (N.notNullOrEmpty(copyingColumnNames)) {
            newColumnNameList.addAll(copyingColumnNames);
            for (int columnIndex : copyingColumnIndices) {
                newColumnList.add(new ArrayList(this._columnList.get(columnIndex)));
            }
        }
        return new RowDataSet(newColumnNameList, newColumnList);
    }

    @Override
    public <E extends Exception> DataSet map(Tuple.Tuple2<String, String> fromColumnNames, Throwables.BiFunction<?, ?, ?, E> func, String newColumnName, Collection<String> copyingColumnNames) throws E {
        N.checkArgNotNull(func, "func");
        List<Object> fromColumn1 = this._columnList.get(this.checkColumnName((String)fromColumnNames._1));
        List<Object> fromColumn2 = this._columnList.get(this.checkColumnName((String)fromColumnNames._2));
        int[] copyingColumnIndices = N.isNullOrEmpty(copyingColumnNames) ? N.EMPTY_INT_ARRAY : this.checkColumnName(copyingColumnNames);
        Throwables.BiFunction<?, ?, ?, E> mapper = func;
        int size = this.size();
        int copyingColumnCount = copyingColumnIndices.length;
        ArrayList mappedColumn = new ArrayList(size);
        for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
            mappedColumn.add(mapper.apply(fromColumn1.get(rowIndex), fromColumn2.get(rowIndex)));
        }
        ArrayList<String> newColumnNameList = new ArrayList<String>(copyingColumnCount + 1);
        newColumnNameList.add(newColumnName);
        ArrayList<List<Object>> newColumnList = new ArrayList<List<Object>>(copyingColumnCount + 1);
        newColumnList.add(mappedColumn);
        if (N.notNullOrEmpty(copyingColumnNames)) {
            newColumnNameList.addAll(copyingColumnNames);
            for (int columnIndex : copyingColumnIndices) {
                newColumnList.add(new ArrayList(this._columnList.get(columnIndex)));
            }
        }
        return new RowDataSet(newColumnNameList, newColumnList);
    }

    @Override
    public <E extends Exception> DataSet map(Tuple.Tuple3<String, String, String> fromColumnNames, Throwables.TriFunction<?, ?, ?, ?, E> func, String newColumnName, Collection<String> copyingColumnNames) throws E {
        N.checkArgNotNull(func, "func");
        List<Object> fromColumn1 = this._columnList.get(this.checkColumnName((String)fromColumnNames._1));
        List<Object> fromColumn2 = this._columnList.get(this.checkColumnName((String)fromColumnNames._2));
        List<Object> fromColumn3 = this._columnList.get(this.checkColumnName((String)fromColumnNames._3));
        int[] copyingColumnIndices = N.isNullOrEmpty(copyingColumnNames) ? N.EMPTY_INT_ARRAY : this.checkColumnName(copyingColumnNames);
        Throwables.TriFunction<?, ?, ?, ?, E> mapper = func;
        int size = this.size();
        int copyingColumnCount = copyingColumnIndices.length;
        ArrayList mappedColumn = new ArrayList(size);
        for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
            mappedColumn.add(mapper.apply(fromColumn1.get(rowIndex), fromColumn2.get(rowIndex), fromColumn3.get(rowIndex)));
        }
        ArrayList<String> newColumnNameList = new ArrayList<String>(copyingColumnCount + 1);
        newColumnNameList.add(newColumnName);
        ArrayList<List<Object>> newColumnList = new ArrayList<List<Object>>(copyingColumnCount + 1);
        newColumnList.add(mappedColumn);
        if (N.notNullOrEmpty(copyingColumnNames)) {
            newColumnNameList.addAll(copyingColumnNames);
            for (int columnIndex : copyingColumnIndices) {
                newColumnList.add(new ArrayList(this._columnList.get(columnIndex)));
            }
        }
        return new RowDataSet(newColumnNameList, newColumnList);
    }

    @Override
    public <E extends Exception> DataSet map(Collection<String> fromColumnNames, Throwables.Function<NoCachingNoUpdating.DisposableObjArray, ?, E> func, String newColumnName, Collection<String> copyingColumnNames) throws E {
        N.checkArgNotNull(func, "func");
        int[] fromColumnIndices = this.checkColumnName(fromColumnNames);
        int[] copyingColumnIndices = N.isNullOrEmpty(copyingColumnNames) ? N.EMPTY_INT_ARRAY : this.checkColumnName(copyingColumnNames);
        Throwables.Function<NoCachingNoUpdating.DisposableObjArray, ?, E> mapper = func;
        int size = this.size();
        int fromColumnCount = fromColumnIndices.length;
        int copyingColumnCount = copyingColumnIndices.length;
        ArrayList mappedColumn = new ArrayList(size);
        Object[] tmpRow = new Object[fromColumnCount];
        NoCachingNoUpdating.DisposableObjArray disposableArray = NoCachingNoUpdating.DisposableObjArray.wrap(tmpRow);
        for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
            for (int i = 0; i < fromColumnCount; ++i) {
                tmpRow[i] = this._columnList.get(fromColumnIndices[i]).get(rowIndex);
            }
            mappedColumn.add(mapper.apply(disposableArray));
        }
        ArrayList<String> newColumnNameList = new ArrayList<String>(copyingColumnCount + 1);
        newColumnNameList.add(newColumnName);
        ArrayList<List<Object>> newColumnList = new ArrayList<List<Object>>(copyingColumnCount + 1);
        newColumnList.add(mappedColumn);
        if (N.notNullOrEmpty(copyingColumnNames)) {
            newColumnNameList.addAll(copyingColumnNames);
            for (int columnIndex : copyingColumnIndices) {
                newColumnList.add(new ArrayList(this._columnList.get(columnIndex)));
            }
        }
        return new RowDataSet(newColumnNameList, newColumnList);
    }

    @Override
    public <E extends Exception> DataSet flatMap(String fromColumnName, Throwables.Function<?, ? extends Collection<?>, E> func, String newColumnName, String copyingColumnName) throws E {
        return this.flatMap(fromColumnName, func, newColumnName, Array.asList(copyingColumnName));
    }

    @Override
    public <E extends Exception> DataSet flatMap(String fromColumnName, Throwables.Function<?, ? extends Collection<?>, E> func, String newColumnName, Collection<String> copyingColumnNames) throws E {
        N.checkArgNotNull(func, "func");
        int fromColumnIndex = this.checkColumnName(fromColumnName);
        int[] copyingColumnIndices = N.isNullOrEmpty(copyingColumnNames) ? N.EMPTY_INT_ARRAY : this.checkColumnName(copyingColumnNames);
        Throwables.Function<?, Collection<?>, E> mapper = func;
        int size = this.size();
        int copyingColumnCount = copyingColumnIndices.length;
        ArrayList mappedColumn = new ArrayList(size);
        ArrayList<String> newColumnNameList = new ArrayList<String>(copyingColumnCount + 1);
        newColumnNameList.add(newColumnName);
        ArrayList<List<Object>> newColumnList = new ArrayList<List<Object>>(copyingColumnCount + 1);
        newColumnList.add(mappedColumn);
        if (N.isNullOrEmpty(copyingColumnNames)) {
            Collection<?> c = null;
            for (Object val : this._columnList.get(fromColumnIndex)) {
                c = mapper.apply(val);
                if (!N.notNullOrEmpty(c)) continue;
                mappedColumn.addAll(c);
            }
        } else {
            newColumnNameList.addAll(copyingColumnNames);
            for (int i = 0; i < copyingColumnCount; ++i) {
                newColumnList.add(new ArrayList(size));
            }
            List<Object> fromColumn = this._columnList.get(fromColumnIndex);
            Collection<?> c = null;
            List copyingColumn = null;
            Object val = null;
            for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
                c = mapper.apply(fromColumn.get(rowIndex));
                if (!N.notNullOrEmpty(c)) continue;
                mappedColumn.addAll(c);
                for (int i = 0; i < copyingColumnCount; ++i) {
                    val = this._columnList.get(copyingColumnIndices[i]).get(rowIndex);
                    copyingColumn = (List)newColumnList.get(i + 1);
                    int len = c.size();
                    for (int j = 0; j < len; ++j) {
                        copyingColumn.add(val);
                    }
                }
            }
        }
        return new RowDataSet(newColumnNameList, newColumnList);
    }

    @Override
    public <E extends Exception> DataSet flatMap(Tuple.Tuple2<String, String> fromColumnNames, Throwables.BiFunction<?, ?, ? extends Collection<?>, E> func, String newColumnName, Collection<String> copyingColumnNames) throws E {
        N.checkArgNotNull(func, "func");
        List<Object> fromColumn1 = this._columnList.get(this.checkColumnName((String)fromColumnNames._1));
        List<Object> fromColumn2 = this._columnList.get(this.checkColumnName((String)fromColumnNames._2));
        int[] copyingColumnIndices = N.isNullOrEmpty(copyingColumnNames) ? N.EMPTY_INT_ARRAY : this.checkColumnName(copyingColumnNames);
        Throwables.BiFunction<?, ?, Collection<?>, E> mapper = func;
        int size = this.size();
        int copyingColumnCount = copyingColumnIndices.length;
        ArrayList mappedColumn = new ArrayList(size);
        ArrayList<String> newColumnNameList = new ArrayList<String>(copyingColumnCount + 1);
        newColumnNameList.add(newColumnName);
        ArrayList<List<Object>> newColumnList = new ArrayList<List<Object>>(copyingColumnCount + 1);
        newColumnList.add(mappedColumn);
        if (N.isNullOrEmpty(copyingColumnNames)) {
            Collection<?> c = null;
            for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
                c = mapper.apply(fromColumn1.get(rowIndex), fromColumn2.get(rowIndex));
                if (!N.notNullOrEmpty(c)) continue;
                mappedColumn.addAll(c);
            }
        } else {
            newColumnNameList.addAll(copyingColumnNames);
            for (int i = 0; i < copyingColumnCount; ++i) {
                newColumnList.add(new ArrayList(size));
            }
            Collection<?> c = null;
            List copyingColumn = null;
            Object val = null;
            for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
                c = mapper.apply(fromColumn1.get(rowIndex), fromColumn2.get(rowIndex));
                if (!N.notNullOrEmpty(c)) continue;
                mappedColumn.addAll(c);
                for (int i = 0; i < copyingColumnCount; ++i) {
                    val = this._columnList.get(copyingColumnIndices[i]).get(rowIndex);
                    copyingColumn = (List)newColumnList.get(i + 1);
                    int len = c.size();
                    for (int j = 0; j < len; ++j) {
                        copyingColumn.add(val);
                    }
                }
            }
        }
        return new RowDataSet(newColumnNameList, newColumnList);
    }

    @Override
    public <E extends Exception> DataSet flatMap(Tuple.Tuple3<String, String, String> fromColumnNames, Throwables.TriFunction<?, ?, ?, ? extends Collection<?>, E> func, String newColumnName, Collection<String> copyingColumnNames) throws E {
        N.checkArgNotNull(func, "func");
        List<Object> fromColumn1 = this._columnList.get(this.checkColumnName((String)fromColumnNames._1));
        List<Object> fromColumn2 = this._columnList.get(this.checkColumnName((String)fromColumnNames._2));
        List<Object> fromColumn3 = this._columnList.get(this.checkColumnName((String)fromColumnNames._3));
        int[] copyingColumnIndices = N.isNullOrEmpty(copyingColumnNames) ? N.EMPTY_INT_ARRAY : this.checkColumnName(copyingColumnNames);
        Throwables.TriFunction<?, ?, ?, Collection<?>, E> mapper = func;
        int size = this.size();
        int copyingColumnCount = copyingColumnIndices.length;
        ArrayList mappedColumn = new ArrayList(size);
        ArrayList<String> newColumnNameList = new ArrayList<String>(copyingColumnCount + 1);
        newColumnNameList.add(newColumnName);
        ArrayList<List<Object>> newColumnList = new ArrayList<List<Object>>(copyingColumnCount + 1);
        newColumnList.add(mappedColumn);
        if (N.isNullOrEmpty(copyingColumnNames)) {
            Collection<?> c = null;
            for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
                c = mapper.apply(fromColumn1.get(rowIndex), fromColumn2.get(rowIndex), fromColumn3.get(rowIndex));
                if (!N.notNullOrEmpty(c)) continue;
                mappedColumn.addAll(c);
            }
        } else {
            newColumnNameList.addAll(copyingColumnNames);
            for (int i = 0; i < copyingColumnCount; ++i) {
                newColumnList.add(new ArrayList(size));
            }
            Collection<?> c = null;
            List copyingColumn = null;
            Object val = null;
            for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
                c = mapper.apply(fromColumn1.get(rowIndex), fromColumn2.get(rowIndex), fromColumn3.get(rowIndex));
                if (!N.notNullOrEmpty(c)) continue;
                mappedColumn.addAll(c);
                for (int i = 0; i < copyingColumnCount; ++i) {
                    val = this._columnList.get(copyingColumnIndices[i]).get(rowIndex);
                    copyingColumn = (List)newColumnList.get(i + 1);
                    int len = c.size();
                    for (int j = 0; j < len; ++j) {
                        copyingColumn.add(val);
                    }
                }
            }
        }
        return new RowDataSet(newColumnNameList, newColumnList);
    }

    @Override
    public <E extends Exception> DataSet flatMap(Collection<String> fromColumnNames, Throwables.Function<NoCachingNoUpdating.DisposableObjArray, ? extends Collection<?>, E> func, String newColumnName, Collection<String> copyingColumnNames) throws E {
        N.checkArgNotNull(func, "func");
        int[] fromColumnIndices = this.checkColumnName(fromColumnNames);
        int[] copyingColumnIndices = N.isNullOrEmpty(copyingColumnNames) ? N.EMPTY_INT_ARRAY : this.checkColumnName(copyingColumnNames);
        Throwables.Function<NoCachingNoUpdating.DisposableObjArray, Collection<?>, E> mapper = func;
        int size = this.size();
        int fromColumnCount = fromColumnIndices.length;
        int copyingColumnCount = copyingColumnIndices.length;
        ArrayList mappedColumn = new ArrayList(size);
        ArrayList<String> newColumnNameList = new ArrayList<String>(copyingColumnCount + 1);
        newColumnNameList.add(newColumnName);
        ArrayList<List<Object>> newColumnList = new ArrayList<List<Object>>(copyingColumnCount + 1);
        newColumnList.add(mappedColumn);
        Object[] tmpRow = new Object[fromColumnCount];
        NoCachingNoUpdating.DisposableObjArray disposableArray = NoCachingNoUpdating.DisposableObjArray.wrap(tmpRow);
        if (N.isNullOrEmpty(copyingColumnNames)) {
            Collection<?> c = null;
            for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
                for (int j = 0; j < fromColumnCount; ++j) {
                    tmpRow[j] = this._columnList.get(fromColumnIndices[j]).get(rowIndex);
                }
                c = mapper.apply(disposableArray);
                if (!N.notNullOrEmpty(c)) continue;
                mappedColumn.addAll(c);
            }
        } else {
            newColumnNameList.addAll(copyingColumnNames);
            for (int i = 0; i < copyingColumnCount; ++i) {
                newColumnList.add(new ArrayList(size));
            }
            Collection<?> c = null;
            List copyingColumn = null;
            Object val = null;
            for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
                for (int j = 0; j < fromColumnCount; ++j) {
                    tmpRow[j] = this._columnList.get(fromColumnIndices[j]).get(rowIndex);
                }
                c = mapper.apply(disposableArray);
                if (!N.notNullOrEmpty(c)) continue;
                mappedColumn.addAll(c);
                for (int i = 0; i < copyingColumnCount; ++i) {
                    val = this._columnList.get(copyingColumnIndices[i]).get(rowIndex);
                    copyingColumn = (List)newColumnList.get(i + 1);
                    int len = c.size();
                    for (int j = 0; j < len; ++j) {
                        copyingColumn.add(val);
                    }
                }
            }
        }
        return new RowDataSet(newColumnNameList, newColumnList);
    }

    @Override
    public DataSet copy() {
        return this.copy(this._columnNameList, 0, this.size());
    }

    @Override
    public DataSet copy(Collection<String> columnNames) {
        return this.copy(columnNames, 0, this.size());
    }

    @Override
    public DataSet copy(int fromRowIndex, int toRowIndex) {
        return this.copy(this._columnNameList, fromRowIndex, toRowIndex);
    }

    @Override
    public DataSet copy(Collection<String> columnNames, int fromRowIndex, int toRowIndex) {
        return this.copy(columnNames, fromRowIndex, toRowIndex, true);
    }

    private RowDataSet copy(Collection<String> columnNames, int fromRowIndex, int toRowIndex, boolean copyProperties) {
        this.checkRowIndex(fromRowIndex, toRowIndex);
        ArrayList<String> newColumnNameList = new ArrayList<String>(columnNames);
        ArrayList<List<Object>> newColumnList = new ArrayList<List<Object>>(newColumnNameList.size());
        if (fromRowIndex == 0 && toRowIndex == this.size()) {
            for (String columnName : newColumnNameList) {
                newColumnList.add(new ArrayList(this._columnList.get(this.checkColumnName(columnName))));
            }
        } else {
            for (String columnName : newColumnNameList) {
                newColumnList.add(new ArrayList<Object>(this._columnList.get(this.checkColumnName(columnName)).subList(fromRowIndex, toRowIndex)));
            }
        }
        Properties<String, Object> newProperties = copyProperties && N.notNullOrEmpty(this._properties) ? this._properties.copy() : null;
        return new RowDataSet(newColumnNameList, newColumnList, newProperties);
    }

    @Override
    public DataSet clone() {
        return this.clone(this._isFrozen);
    }

    @Override
    public DataSet clone(boolean freeze) {
        RowDataSet dataSet = null;
        dataSet = kryoParser != null ? kryoParser.clone(this) : jsonParser.deserialize(RowDataSet.class, jsonParser.serialize(this));
        dataSet._isFrozen = freeze;
        return dataSet;
    }

    @Override
    public DataSet innerJoin(DataSet right, String columnName, String refColumnName) {
        Map<String, String> onColumnNames = N.asMap(columnName, refColumnName);
        return this.innerJoin(right, onColumnNames);
    }

    @Override
    public DataSet innerJoin(DataSet right, Map<String, String> onColumnNames) {
        return this.join(right, onColumnNames, false);
    }

    @Override
    public DataSet innerJoin(DataSet right, Map<String, String> onColumnNames, String newColumnName, Class<?> newColumnClass) {
        return this.join(right, onColumnNames, newColumnName, newColumnClass, false);
    }

    @Override
    public DataSet innerJoin(DataSet right, Map<String, String> onColumnNames, String newColumnName, Class<?> newColumnClass, IntFunction<? extends Collection> collSupplier) {
        return this.join(right, onColumnNames, newColumnName, newColumnClass, collSupplier, false);
    }

    @Override
    public DataSet leftJoin(DataSet right, String columnName, String refColumnName) {
        Map<String, String> onColumnNames = N.asMap(columnName, refColumnName);
        return this.leftJoin(right, onColumnNames);
    }

    @Override
    public DataSet leftJoin(DataSet right, Map<String, String> onColumnNames) {
        return this.join(right, onColumnNames, true);
    }

    private DataSet join(DataSet right, Map<String, String> onColumnNames, boolean isLeftJoin) {
        this.checkJoinOnColumnNames(onColumnNames);
        if (onColumnNames.size() == 1) {
            Map.Entry<String, String> onColumnEntry = onColumnNames.entrySet().iterator().next();
            int leftJoinColumnIndex = this.checkColumnName(onColumnEntry.getKey());
            int rightJoinColumnIndex = this.checkRefColumnName(right, onColumnEntry.getValue());
            List<String> rightColumnNames = this.getRightColumnNames(right, onColumnEntry.getValue());
            ArrayList<String> newColumnNameList = new ArrayList<String>(this._columnNameList.size() + rightColumnNames.size());
            ArrayList<List<Object>> newColumnList = new ArrayList<List<Object>>(this._columnNameList.size() + rightColumnNames.size());
            this.initNewColumnList(newColumnNameList, newColumnList, rightColumnNames);
            ImmutableList leftJoinColumn = this.getColumn(leftJoinColumnIndex);
            ImmutableList rightJoinColumn = right.getColumn(rightJoinColumnIndex);
            HashMap<Object, List<Integer>> joinColumnRightRowIndexMap = new HashMap<Object, List<Integer>>();
            Object hashKey = null;
            int rightDataSetSize = right.size();
            for (int rightRowIndex = 0; rightRowIndex < rightDataSetSize; ++rightRowIndex) {
                hashKey = RowDataSet.getHashKey(rightJoinColumn.get(rightRowIndex));
                this.putRowIndex(joinColumnRightRowIndexMap, hashKey, rightRowIndex);
            }
            int[] rightColumnIndexes = right.getColumnIndexes(rightColumnNames);
            List rightRowIndexList = null;
            int size = this.size();
            for (int leftRowIndex = 0; leftRowIndex < size; ++leftRowIndex) {
                hashKey = RowDataSet.getHashKey(leftJoinColumn.get(leftRowIndex));
                rightRowIndexList = (List)joinColumnRightRowIndexMap.get(hashKey);
                this.join(newColumnList, right, isLeftJoin, leftRowIndex, rightRowIndexList, rightColumnIndexes);
            }
            return new RowDataSet(newColumnNameList, newColumnList);
        }
        int[] leftJoinColumnIndexes = new int[onColumnNames.size()];
        int[] rightJoinColumnIndexes = new int[onColumnNames.size()];
        ArrayList<String> rightColumnNames = new ArrayList<String>(right.columnNameList());
        this.initColumnIndexes(leftJoinColumnIndexes, rightJoinColumnIndexes, right, onColumnNames, rightColumnNames);
        ArrayList<String> newColumnNameList = new ArrayList<String>(this._columnNameList.size() + rightColumnNames.size());
        ArrayList<List<Object>> newColumnList = new ArrayList<List<Object>>(this._columnNameList.size() + rightColumnNames.size());
        this.initNewColumnList(newColumnNameList, newColumnList, rightColumnNames);
        ArrayHashMap<Object[], List<Integer>> joinColumnRightRowIndexMap = new ArrayHashMap<Object[], List<Integer>>();
        Object[] row = null;
        int rightDataSetSize = right.size();
        for (int rightRowIndex = 0; rightRowIndex < rightDataSetSize; ++rightRowIndex) {
            row = row == null ? Objectory.createObjectArray(rightJoinColumnIndexes.length) : row;
            int len = rightJoinColumnIndexes.length;
            for (int i = 0; i < len; ++i) {
                row[i] = right.get(rightRowIndex, rightJoinColumnIndexes[i]);
            }
            row = this.putRowIndex((Map<Object[], List<Integer>>)joinColumnRightRowIndexMap, row, rightRowIndex);
        }
        if (row != null) {
            Objectory.recycle(row);
            row = null;
        }
        int[] rightColumnIndexes = right.getColumnIndexes(rightColumnNames);
        row = Objectory.createObjectArray(leftJoinColumnIndexes.length);
        List rightRowIndexList = null;
        int size = this.size();
        for (int leftRowIndex = 0; leftRowIndex < size; ++leftRowIndex) {
            int len = leftJoinColumnIndexes.length;
            for (int i = 0; i < len; ++i) {
                row[i] = this.get(leftRowIndex, leftJoinColumnIndexes[i]);
            }
            rightRowIndexList = (List)joinColumnRightRowIndexMap.get(row);
            this.join(newColumnList, right, isLeftJoin, leftRowIndex, rightRowIndexList, rightColumnIndexes);
        }
        if (row != null) {
            Objectory.recycle(row);
            row = null;
        }
        for (Object[] a : joinColumnRightRowIndexMap.keySet()) {
            Objectory.recycle(a);
        }
        return new RowDataSet(newColumnNameList, newColumnList);
    }

    private void join(List<List<Object>> newColumnList, DataSet right, boolean isLeftJoin, int leftRowIndex, List<Integer> rightRowIndexList, int[] rightColumnIndexes) {
        block6: {
            int i;
            block5: {
                if (!N.notNullOrEmpty(rightRowIndexList)) break block5;
                for (int rightRowIndex : rightRowIndexList) {
                    int i2;
                    int leftColumnLength = this._columnNameList.size();
                    for (i2 = 0; i2 < leftColumnLength; ++i2) {
                        newColumnList.get(i2).add(this._columnList.get(i2).get(leftRowIndex));
                    }
                    leftColumnLength = this._columnNameList.size();
                    int rightColumnLength = rightColumnIndexes.length;
                    for (i2 = 0; i2 < rightColumnLength; ++i2) {
                        newColumnList.get(leftColumnLength + i2).add(right.get(rightRowIndex, rightColumnIndexes[i2]));
                    }
                }
                break block6;
            }
            if (!isLeftJoin) break block6;
            int leftColumnLength = this._columnNameList.size();
            for (i = 0; i < leftColumnLength; ++i) {
                newColumnList.get(i).add(this._columnList.get(i).get(leftRowIndex));
            }
            leftColumnLength = this._columnNameList.size();
            int rightColumnLength = rightColumnIndexes.length;
            for (i = 0; i < rightColumnLength; ++i) {
                newColumnList.get(leftColumnLength + i).add(null);
            }
        }
    }

    private DataSet join(DataSet right, Map<String, String> onColumnNames, String newColumnName, Class<?> newColumnClass, boolean isLeftJoin) {
        this.checkJoinOnColumnNames(onColumnNames);
        this.checkNewColumnName(newColumnName);
        if (onColumnNames.size() == 1) {
            Map.Entry<String, String> onColumnEntry = onColumnNames.entrySet().iterator().next();
            int leftJoinColumnIndex = this.checkColumnName(onColumnEntry.getKey());
            int rightJoinColumnIndex = this.checkRefColumnName(right, onColumnEntry.getValue());
            ArrayList<String> newColumnNameList = new ArrayList<String>(this._columnNameList.size() + 1);
            ArrayList<List<Object>> newColumnList = new ArrayList<List<Object>>(this._columnNameList.size() + 1);
            this.initNewColumnList(newColumnNameList, newColumnList, newColumnName);
            ImmutableList leftJoinColumn = this.getColumn(leftJoinColumnIndex);
            ImmutableList rightJoinColumn = right.getColumn(rightJoinColumnIndex);
            HashMap<Object, List<Integer>> joinColumnRightRowIndexMap = new HashMap<Object, List<Integer>>();
            Object hashKey = null;
            int rightDataSetSize = right.size();
            for (int rightRowIndex = 0; rightRowIndex < rightDataSetSize; ++rightRowIndex) {
                hashKey = RowDataSet.getHashKey(rightJoinColumn.get(rightRowIndex));
                this.putRowIndex(joinColumnRightRowIndexMap, hashKey, rightRowIndex);
            }
            int newColumnIndex = newColumnList.size() - 1;
            List rightRowIndexList = null;
            int size = this.size();
            for (int leftRowIndex = 0; leftRowIndex < size; ++leftRowIndex) {
                hashKey = RowDataSet.getHashKey(leftJoinColumn.get(leftRowIndex));
                rightRowIndexList = (List)joinColumnRightRowIndexMap.get(hashKey);
                this.join(newColumnList, right, isLeftJoin, newColumnClass, newColumnIndex, leftRowIndex, rightRowIndexList);
            }
            return new RowDataSet(newColumnNameList, newColumnList);
        }
        int[] leftJoinColumnIndexes = new int[onColumnNames.size()];
        int[] rightJoinColumnIndexes = new int[onColumnNames.size()];
        this.initColumnIndexes(leftJoinColumnIndexes, rightJoinColumnIndexes, right, onColumnNames);
        ArrayList<String> newColumnNameList = new ArrayList<String>(this._columnNameList.size() + 1);
        ArrayList<List<Object>> newColumnList = new ArrayList<List<Object>>(this._columnNameList.size() + 1);
        this.initNewColumnList(newColumnNameList, newColumnList, newColumnName);
        ArrayHashMap<Object[], List<Integer>> joinColumnRightRowIndexMap = new ArrayHashMap<Object[], List<Integer>>();
        Object[] row = null;
        int rightDataSetSize = right.size();
        for (int rightRowIndex = 0; rightRowIndex < rightDataSetSize; ++rightRowIndex) {
            row = row == null ? Objectory.createObjectArray(rightJoinColumnIndexes.length) : row;
            int len = rightJoinColumnIndexes.length;
            for (int i = 0; i < len; ++i) {
                row[i] = right.get(rightRowIndex, rightJoinColumnIndexes[i]);
            }
            row = this.putRowIndex((Map<Object[], List<Integer>>)joinColumnRightRowIndexMap, row, rightRowIndex);
        }
        if (row != null) {
            Objectory.recycle(row);
            row = null;
        }
        int newColumnIndex = newColumnList.size() - 1;
        List rightRowIndexList = null;
        row = Objectory.createObjectArray(leftJoinColumnIndexes.length);
        int size = this.size();
        for (int leftRowIndex = 0; leftRowIndex < size; ++leftRowIndex) {
            int len = leftJoinColumnIndexes.length;
            for (int i = 0; i < len; ++i) {
                row[i] = this.get(leftRowIndex, leftJoinColumnIndexes[i]);
            }
            rightRowIndexList = (List)joinColumnRightRowIndexMap.get(row);
            this.join(newColumnList, right, isLeftJoin, newColumnClass, newColumnIndex, leftRowIndex, rightRowIndexList);
        }
        if (row != null) {
            Objectory.recycle(row);
            row = null;
        }
        for (Object[] a : joinColumnRightRowIndexMap.keySet()) {
            Objectory.recycle(a);
        }
        return new RowDataSet(newColumnNameList, newColumnList);
    }

    private void join(List<List<Object>> newColumnList, DataSet right, boolean isLeftJoin, Class<?> newColumnClass, int newColumnIndex, int leftRowIndex, List<Integer> rightRowIndexList) {
        if (N.notNullOrEmpty(rightRowIndexList)) {
            for (int rightRowIndex : rightRowIndexList) {
                int leftColumnLength = this._columnNameList.size();
                for (int i = 0; i < leftColumnLength; ++i) {
                    newColumnList.get(i).add(this._columnList.get(i).get(leftRowIndex));
                }
                newColumnList.get(newColumnIndex).add(right.getRow(newColumnClass, rightRowIndex));
            }
        } else if (isLeftJoin) {
            int leftColumnLength = this._columnNameList.size();
            for (int i = 0; i < leftColumnLength; ++i) {
                newColumnList.get(i).add(this._columnList.get(i).get(leftRowIndex));
            }
            newColumnList.get(newColumnIndex).add(null);
        }
    }

    private void checkJoinOnColumnNames(Map<String, String> onColumnNames) {
        if (N.isNullOrEmpty(onColumnNames)) {
            throw new IllegalArgumentException("The joining column names can't be null or empty");
        }
    }

    private int checkRefColumnName(DataSet right, String refColumnName) {
        int rightJoinColumnIndex = right.getColumnIndex(refColumnName);
        if (rightJoinColumnIndex < 0) {
            throw new IllegalArgumentException("The specified column: " + refColumnName + " is not included in the right DataSet " + right.columnNameList());
        }
        return rightJoinColumnIndex;
    }

    private void checkNewColumnName(String newColumnName) {
        if (this.containsColumn(newColumnName)) {
            throw new IllegalArgumentException("The new column: " + newColumnName + " is already included in this DataSet: " + this._columnNameList);
        }
    }

    private List<String> getRightColumnNames(DataSet right, String refColumnName) {
        ArrayList<String> rightColumnNames = new ArrayList<String>(right.columnNameList());
        if (this.containsColumn(refColumnName)) {
            rightColumnNames.remove(refColumnName);
        }
        return rightColumnNames;
    }

    private void initColumnIndexes(int[] leftJoinColumnIndexes, int[] rightJoinColumnIndexes, DataSet right, Map<String, String> onColumnNames, List<String> rightColumnNames) {
        int i = 0;
        for (Map.Entry<String, String> entry : onColumnNames.entrySet()) {
            leftJoinColumnIndexes[i] = this.checkColumnName(entry.getKey());
            rightJoinColumnIndexes[i] = right.getColumnIndex(entry.getValue());
            if (rightJoinColumnIndexes[i] < 0) {
                throw new IllegalArgumentException("The specified column: " + entry.getValue() + " is not included in the right DataSet " + right.columnNameList());
            }
            if (entry.getKey().equals(entry.getValue())) {
                rightColumnNames.remove(entry.getValue());
            }
            ++i;
        }
    }

    private void initColumnIndexes(int[] leftJoinColumnIndexes, int[] rightJoinColumnIndexes, DataSet right, Map<String, String> onColumnNames) {
        int i = 0;
        for (Map.Entry<String, String> entry : onColumnNames.entrySet()) {
            leftJoinColumnIndexes[i] = this.checkColumnName(entry.getKey());
            rightJoinColumnIndexes[i] = right.getColumnIndex(entry.getValue());
            if (rightJoinColumnIndexes[i] < 0) {
                throw new IllegalArgumentException("The specified column: " + entry.getValue() + " is not included in the right DataSet " + right.columnNameList());
            }
            ++i;
        }
    }

    private void initNewColumnList(List<String> newColumnNameList, List<List<Object>> newColumnList, List<String> rightColumnNames) {
        int len = this._columnNameList.size();
        for (int i = 0; i < len; ++i) {
            newColumnNameList.add(this._columnNameList.get(i));
            newColumnList.add(new ArrayList());
        }
        for (String rightColumnName : rightColumnNames) {
            if (this.containsColumn(rightColumnName)) {
                throw new IllegalArgumentException("The column in right DataSet: " + rightColumnName + " is already included in this DataSet: " + this._columnNameList);
            }
            newColumnNameList.add(rightColumnName);
            newColumnList.add(new ArrayList());
        }
    }

    private void initNewColumnList(List<String> newColumnNameList, List<List<Object>> newColumnList, String newColumnName) {
        int len = this._columnNameList.size();
        for (int i = 0; i < len; ++i) {
            newColumnNameList.add(this._columnNameList.get(i));
            newColumnList.add(new ArrayList());
        }
        newColumnNameList.add(newColumnName);
        newColumnList.add(new ArrayList());
    }

    private void putRowIndex(Map<Object, List<Integer>> joinColumnRightRowIndexMap, Object hashKey, int rightRowIndex) {
        List<Integer> rightRowIndexList = joinColumnRightRowIndexMap.get(hashKey);
        if (rightRowIndexList == null) {
            joinColumnRightRowIndexMap.put(hashKey, N.asList(Integer.valueOf(rightRowIndex)));
        } else {
            rightRowIndexList.add(rightRowIndex);
        }
    }

    private Object[] putRowIndex(Map<Object[], List<Integer>> joinColumnRightRowIndexMap, Object[] row, int rightRowIndex) {
        List<Integer> rightRowIndexList = joinColumnRightRowIndexMap.get(row);
        if (rightRowIndexList == null) {
            joinColumnRightRowIndexMap.put(row, N.asList(Integer.valueOf(rightRowIndex)));
            row = null;
        } else {
            rightRowIndexList.add(rightRowIndex);
        }
        return row;
    }

    @Override
    public DataSet leftJoin(DataSet right, Map<String, String> onColumnNames, String newColumnName, Class<?> newColumnClass) {
        return this.join(right, onColumnNames, newColumnName, newColumnClass, true);
    }

    @Override
    public DataSet leftJoin(DataSet right, Map<String, String> onColumnNames, String newColumnName, Class<?> newColumnClass, IntFunction<? extends Collection> collSupplier) {
        return this.join(right, onColumnNames, newColumnName, newColumnClass, collSupplier, true);
    }

    private DataSet join(DataSet right, Map<String, String> onColumnNames, String newColumnName, Class<?> newColumnClass, IntFunction<? extends Collection> collSupplier, boolean isLeftJoin) {
        this.checkJoinOnColumnNames(onColumnNames);
        this.checkNewColumnName(newColumnName);
        N.checkArgNotNull(collSupplier);
        if (onColumnNames.size() == 1) {
            Map.Entry<String, String> onColumnEntry = onColumnNames.entrySet().iterator().next();
            int leftJoinColumnIndex = this.checkColumnName(onColumnEntry.getKey());
            int rightJoinColumnIndex = this.checkRefColumnName(right, onColumnEntry.getValue());
            ArrayList<String> newColumnNameList = new ArrayList<String>(this._columnNameList.size() + 1);
            ArrayList<List<Object>> newColumnList = new ArrayList<List<Object>>(this._columnNameList.size() + 1);
            this.initNewColumnList(newColumnNameList, newColumnList, newColumnName);
            ImmutableList leftJoinColumn = this.getColumn(leftJoinColumnIndex);
            ImmutableList rightJoinColumn = right.getColumn(rightJoinColumnIndex);
            HashMap<Object, List<Integer>> joinColumnRightRowIndexMap = new HashMap<Object, List<Integer>>();
            List rightRowIndexList = null;
            Object hashKey = null;
            int rightDataSetSize = right.size();
            for (int rightRowIndex = 0; rightRowIndex < rightDataSetSize; ++rightRowIndex) {
                hashKey = RowDataSet.getHashKey(rightJoinColumn.get(rightRowIndex));
                this.putRowIndex(joinColumnRightRowIndexMap, hashKey, rightRowIndex);
            }
            int newColumnIndex = newColumnList.size() - 1;
            int size = this.size();
            for (int leftRowIndex = 0; leftRowIndex < size; ++leftRowIndex) {
                hashKey = RowDataSet.getHashKey(leftJoinColumn.get(leftRowIndex));
                rightRowIndexList = (List)joinColumnRightRowIndexMap.get(hashKey);
                this.join(newColumnList, right, isLeftJoin, newColumnClass, collSupplier, newColumnIndex, leftRowIndex, rightRowIndexList);
            }
            return new RowDataSet(newColumnNameList, newColumnList);
        }
        int[] leftJoinColumnIndexes = new int[onColumnNames.size()];
        int[] rightJoinColumnIndexes = new int[onColumnNames.size()];
        this.initColumnIndexes(leftJoinColumnIndexes, rightJoinColumnIndexes, right, onColumnNames);
        ArrayList<String> newColumnNameList = new ArrayList<String>(this._columnNameList.size() + 1);
        ArrayList<List<Object>> newColumnList = new ArrayList<List<Object>>(this._columnNameList.size() + 1);
        this.initNewColumnList(newColumnNameList, newColumnList, newColumnName);
        ArrayHashMap<Object[], List<Integer>> joinColumnRightRowIndexMap = new ArrayHashMap<Object[], List<Integer>>();
        List rightRowIndexList = null;
        Object[] row = null;
        int rightDataSetSize = right.size();
        for (int rightRowIndex = 0; rightRowIndex < rightDataSetSize; ++rightRowIndex) {
            row = row == null ? Objectory.createObjectArray(rightJoinColumnIndexes.length) : row;
            int len = rightJoinColumnIndexes.length;
            for (int i = 0; i < len; ++i) {
                row[i] = right.get(rightRowIndex, rightJoinColumnIndexes[i]);
            }
            row = this.putRowIndex((Map<Object[], List<Integer>>)joinColumnRightRowIndexMap, row, rightRowIndex);
        }
        if (row != null) {
            Objectory.recycle(row);
            row = null;
        }
        int newColumnIndex = newColumnList.size() - 1;
        row = Objectory.createObjectArray(leftJoinColumnIndexes.length);
        int size = this.size();
        for (int leftRowIndex = 0; leftRowIndex < size; ++leftRowIndex) {
            int len = leftJoinColumnIndexes.length;
            for (int i = 0; i < len; ++i) {
                row[i] = this.get(leftRowIndex, leftJoinColumnIndexes[i]);
            }
            rightRowIndexList = (List)joinColumnRightRowIndexMap.get(row);
            this.join(newColumnList, right, isLeftJoin, newColumnClass, collSupplier, newColumnIndex, leftRowIndex, rightRowIndexList);
        }
        if (row != null) {
            Objectory.recycle(row);
            row = null;
        }
        for (Object[] a : joinColumnRightRowIndexMap.keySet()) {
            Objectory.recycle(a);
        }
        return new RowDataSet(newColumnNameList, newColumnList);
    }

    private void join(List<List<Object>> newColumnList, DataSet right, boolean isLeftJoin, Class<?> newColumnClass, IntFunction<? extends Collection> collSupplier, int newColumnIndex, int leftRowIndex, List<Integer> rightRowIndexList) {
        if (N.notNullOrEmpty(rightRowIndexList)) {
            int leftColumnLength = this._columnNameList.size();
            for (int i = 0; i < leftColumnLength; ++i) {
                newColumnList.get(i).add(this._columnList.get(i).get(leftRowIndex));
            }
            Collection coll = collSupplier.apply(rightRowIndexList.size());
            for (int rightRowIndex : rightRowIndexList) {
                coll.add(right.getRow(newColumnClass, rightRowIndex));
            }
            newColumnList.get(newColumnIndex).add(coll);
        } else if (isLeftJoin) {
            int leftColumnLength = this._columnNameList.size();
            for (int i = 0; i < leftColumnLength; ++i) {
                newColumnList.get(i).add(this._columnList.get(i).get(leftRowIndex));
            }
            newColumnList.get(newColumnIndex).add(null);
        }
    }

    @Override
    public DataSet rightJoin(DataSet right, String columnName, String refColumnName) {
        Map<String, String> onColumnNames = N.asMap(columnName, refColumnName);
        return this.rightJoin(right, onColumnNames);
    }

    @Override
    public DataSet rightJoin(DataSet right, Map<String, String> onColumnNames) {
        this.checkJoinOnColumnNames(onColumnNames);
        if (onColumnNames.size() == 0) {
            Map.Entry<String, String> onColumnEntry = onColumnNames.entrySet().iterator().next();
            int leftJoinColumnIndex = this.checkColumnName(onColumnEntry.getKey());
            int rightJoinColumnIndex = this.checkRefColumnName(right, onColumnEntry.getValue());
            List<String> leftColumnNames = this.getLeftColumnNamesForRightJoin(onColumnEntry.getValue());
            ImmutableList<String> rightColumnNames = right.columnNameList();
            ArrayList<String> newColumnNameList = new ArrayList<String>(leftColumnNames.size() + rightColumnNames.size());
            ArrayList<List<Object>> newColumnList = new ArrayList<List<Object>>(leftColumnNames.size() + rightColumnNames.size());
            this.initNewColumnListForRightJoin(newColumnNameList, newColumnList, right, leftColumnNames, rightColumnNames);
            ImmutableList leftJoinColumn = this.getColumn(leftJoinColumnIndex);
            ImmutableList rightJoinColumn = right.getColumn(rightJoinColumnIndex);
            HashMap<Object, List<Integer>> joinColumnLeftRowIndexMap = new HashMap<Object, List<Integer>>();
            List leftRowIndexList = null;
            Object hashKey = null;
            int leftDataSetSize = this.size();
            for (int leftRowIndex = 0; leftRowIndex < leftDataSetSize; ++leftRowIndex) {
                hashKey = RowDataSet.getHashKey(leftJoinColumn.get(leftRowIndex));
                this.putRowIndex(joinColumnLeftRowIndexMap, hashKey, leftRowIndex);
            }
            int[] leftColumnIndexes = this.getColumnIndexes(leftColumnNames);
            int[] rightColumnIndexes = right.getColumnIndexes(rightColumnNames);
            int rightDataSetSize = right.size();
            for (int rightRowIndex = 0; rightRowIndex < rightDataSetSize; ++rightRowIndex) {
                hashKey = RowDataSet.getHashKey(rightJoinColumn.get(rightRowIndex));
                leftRowIndexList = (List)joinColumnLeftRowIndexMap.get(hashKey);
                this.rightJoin(newColumnList, right, rightRowIndex, rightColumnIndexes, leftColumnIndexes, leftRowIndexList);
            }
            return new RowDataSet(newColumnNameList, newColumnList);
        }
        ArrayList<String> leftColumnNames = new ArrayList<String>(this._columnNameList);
        ImmutableList<String> rightColumnNames = right.columnNameList();
        int[] leftJoinColumnIndexes = new int[onColumnNames.size()];
        int[] rightJoinColumnIndexes = new int[onColumnNames.size()];
        this.initColumnIndexesForRightJoin(leftJoinColumnIndexes, rightJoinColumnIndexes, right, onColumnNames, leftColumnNames);
        ArrayList<String> newColumnNameList = new ArrayList<String>(leftColumnNames.size() + rightColumnNames.size());
        ArrayList<List<Object>> newColumnList = new ArrayList<List<Object>>(leftColumnNames.size() + rightColumnNames.size());
        this.initNewColumnListForRightJoin(newColumnNameList, newColumnList, right, leftColumnNames, rightColumnNames);
        ArrayHashMap<Object[], List<Integer>> joinColumnLeftRowIndexMap = new ArrayHashMap<Object[], List<Integer>>();
        Object[] row = null;
        int leftDataSetSize = this.size();
        for (int leftRowIndex = 0; leftRowIndex < leftDataSetSize; ++leftRowIndex) {
            row = row == null ? Objectory.createObjectArray(leftJoinColumnIndexes.length) : row;
            int len = leftJoinColumnIndexes.length;
            for (int i = 0; i < len; ++i) {
                row[i] = this.get(leftRowIndex, leftJoinColumnIndexes[i]);
            }
            row = this.putRowIndex((Map<Object[], List<Integer>>)joinColumnLeftRowIndexMap, row, leftRowIndex);
        }
        if (row != null) {
            Objectory.recycle(row);
            row = null;
        }
        int[] leftColumnIndexes = this.getColumnIndexes(leftColumnNames);
        int[] rightColumnIndexes = right.getColumnIndexes(rightColumnNames);
        row = Objectory.createObjectArray(rightJoinColumnIndexes.length);
        List leftRowIndexList = null;
        int rightDataSetSize = right.size();
        for (int rightRowIndex = 0; rightRowIndex < rightDataSetSize; ++rightRowIndex) {
            int len = rightJoinColumnIndexes.length;
            for (int i = 0; i < len; ++i) {
                row[i] = right.get(rightRowIndex, rightJoinColumnIndexes[i]);
            }
            leftRowIndexList = (List)joinColumnLeftRowIndexMap.get(row);
            this.rightJoin(newColumnList, right, rightRowIndex, rightColumnIndexes, leftColumnIndexes, leftRowIndexList);
        }
        if (row != null) {
            Objectory.recycle(row);
            row = null;
        }
        for (Object[] a : joinColumnLeftRowIndexMap.keySet()) {
            Objectory.recycle(a);
        }
        return new RowDataSet(newColumnNameList, newColumnList);
    }

    private void rightJoin(List<List<Object>> newColumnList, DataSet right, int rightRowIndex, int[] rightColumnIndexes, int[] leftColumnIndexes, List<Integer> leftRowIndexList) {
        if (N.notNullOrEmpty(leftRowIndexList)) {
            for (int leftRowIndex : leftRowIndexList) {
                int i;
                int leftColumnLength = leftColumnIndexes.length;
                for (i = 0; i < leftColumnLength; ++i) {
                    newColumnList.get(i).add(this.get(leftRowIndex, leftColumnIndexes[i]));
                }
                leftColumnLength = leftColumnIndexes.length;
                int rightColumnLength = rightColumnIndexes.length;
                for (i = 0; i < rightColumnLength; ++i) {
                    newColumnList.get(i + leftColumnLength).add(right.get(rightRowIndex, rightColumnIndexes[i]));
                }
            }
        } else {
            int i;
            int leftColumnLength = leftColumnIndexes.length;
            for (i = 0; i < leftColumnLength; ++i) {
                newColumnList.get(i).add(null);
            }
            leftColumnLength = leftColumnIndexes.length;
            int rightColumnLength = rightColumnIndexes.length;
            for (i = 0; i < rightColumnLength; ++i) {
                newColumnList.get(i + leftColumnLength).add(right.get(rightRowIndex, rightColumnIndexes[i]));
            }
        }
    }

    private void initColumnIndexesForRightJoin(int[] leftJoinColumnIndexes, int[] rightJoinColumnIndexes, DataSet right, Map<String, String> onColumnNames, List<String> leftColumnNames) {
        int i = 0;
        for (Map.Entry<String, String> entry : onColumnNames.entrySet()) {
            leftJoinColumnIndexes[i] = this.checkColumnName(entry.getKey());
            rightJoinColumnIndexes[i] = right.getColumnIndex(entry.getValue());
            if (rightJoinColumnIndexes[i] < 0) {
                throw new IllegalArgumentException("The specified column: " + entry.getValue() + " is not included in the right DataSet " + right.columnNameList());
            }
            if (entry.getKey().equals(entry.getValue())) {
                leftColumnNames.remove(entry.getKey());
            }
            ++i;
        }
    }

    private void initNewColumnListForRightJoin(List<String> newColumnNameList, List<List<Object>> newColumnList, DataSet right, List<String> leftColumnNames, List<String> rightColumnNames) {
        for (String leftColumnName : leftColumnNames) {
            if (right.containsColumn(leftColumnName)) {
                throw new IllegalArgumentException("The column in this DataSet: " + leftColumnName + " is already included in right DataSet: " + rightColumnNames);
            }
            newColumnNameList.add(leftColumnName);
            newColumnList.add(new ArrayList());
        }
        for (String rightColumnName : rightColumnNames) {
            newColumnNameList.add(rightColumnName);
            newColumnList.add(new ArrayList());
        }
    }

    private List<String> getLeftColumnNamesForRightJoin(String refColumnName) {
        ArrayList<String> leftColumnNames = new ArrayList<String>(this._columnNameList);
        if (this.containsColumn(refColumnName)) {
            leftColumnNames.remove(refColumnName);
        }
        return leftColumnNames;
    }

    @Override
    public DataSet rightJoin(DataSet right, Map<String, String> onColumnNames, String newColumnName, Class<?> newColumnClass) {
        this.checkJoinOnColumnNames(onColumnNames);
        this.checkNewColumnName(newColumnName);
        if (onColumnNames.size() == 1) {
            Map.Entry<String, String> onColumnEntry = onColumnNames.entrySet().iterator().next();
            int leftJoinColumnIndex = this.checkColumnName(onColumnEntry.getKey());
            int rightJoinColumnIndex = this.checkRefColumnName(right, onColumnEntry.getValue());
            ArrayList<String> leftColumnNames = new ArrayList<String>(this._columnNameList);
            ArrayList<String> newColumnNameList = new ArrayList<String>(leftColumnNames.size() + 1);
            ArrayList<List<Object>> newColumnList = new ArrayList<List<Object>>(leftColumnNames.size() + 1);
            this.initNewColumnListForRightJoin(newColumnNameList, newColumnList, leftColumnNames, newColumnName);
            ImmutableList leftJoinColumn = this.getColumn(leftJoinColumnIndex);
            ImmutableList rightJoinColumn = right.getColumn(rightJoinColumnIndex);
            HashMap<Object, List<Integer>> joinColumnLeftRowIndexMap = new HashMap<Object, List<Integer>>();
            Object hashKey = null;
            int leftDataSetSize = this.size();
            for (int leftRowIndex = 0; leftRowIndex < leftDataSetSize; ++leftRowIndex) {
                hashKey = RowDataSet.getHashKey(leftJoinColumn.get(leftRowIndex));
                this.putRowIndex(joinColumnLeftRowIndexMap, hashKey, leftRowIndex);
            }
            int newColumnIndex = newColumnList.size() - 1;
            int[] leftColumnIndexes = this.getColumnIndexes(leftColumnNames);
            List leftRowIndexList = null;
            int rightDataSetSize = right.size();
            for (int rightRowIndex = 0; rightRowIndex < rightDataSetSize; ++rightRowIndex) {
                hashKey = RowDataSet.getHashKey(rightJoinColumn.get(rightRowIndex));
                leftRowIndexList = (List)joinColumnLeftRowIndexMap.get(hashKey);
                this.rightJoin(newColumnList, right, newColumnClass, newColumnIndex, rightRowIndex, leftRowIndexList, leftColumnIndexes);
            }
            return new RowDataSet(newColumnNameList, newColumnList);
        }
        ArrayList<String> leftColumnNames = new ArrayList<String>(this._columnNameList);
        int[] leftJoinColumnIndexes = new int[onColumnNames.size()];
        int[] rightJoinColumnIndexes = new int[onColumnNames.size()];
        this.initColumnIndexes(leftJoinColumnIndexes, rightJoinColumnIndexes, right, onColumnNames);
        ArrayList<String> newColumnNameList = new ArrayList<String>(leftColumnNames.size() + 1);
        ArrayList<List<Object>> newColumnList = new ArrayList<List<Object>>(leftColumnNames.size() + 1);
        this.initNewColumnListForRightJoin(newColumnNameList, newColumnList, leftColumnNames, newColumnName);
        ArrayHashMap<Object[], List<Integer>> joinColumnLeftRowIndexMap = new ArrayHashMap<Object[], List<Integer>>();
        Object[] row = null;
        int leftDataSetSize = this.size();
        for (int leftRowIndex = 0; leftRowIndex < leftDataSetSize; ++leftRowIndex) {
            row = row == null ? Objectory.createObjectArray(leftJoinColumnIndexes.length) : row;
            int len = leftJoinColumnIndexes.length;
            for (int i = 0; i < len; ++i) {
                row[i] = this.get(leftRowIndex, leftJoinColumnIndexes[i]);
            }
            row = this.putRowIndex((Map<Object[], List<Integer>>)joinColumnLeftRowIndexMap, row, leftRowIndex);
        }
        if (row != null) {
            Objectory.recycle(row);
            row = null;
        }
        int newColumnIndex = newColumnList.size() - 1;
        int[] leftColumnIndexes = this.getColumnIndexes(leftColumnNames);
        row = Objectory.createObjectArray(rightJoinColumnIndexes.length);
        List leftRowIndexList = null;
        int rightDataSetSize = right.size();
        for (int rightRowIndex = 0; rightRowIndex < rightDataSetSize; ++rightRowIndex) {
            int len = rightJoinColumnIndexes.length;
            for (int i = 0; i < len; ++i) {
                row[i] = right.get(rightRowIndex, rightJoinColumnIndexes[i]);
            }
            leftRowIndexList = (List)joinColumnLeftRowIndexMap.get(row);
            this.rightJoin(newColumnList, right, newColumnClass, newColumnIndex, rightRowIndex, leftRowIndexList, leftColumnIndexes);
        }
        if (row != null) {
            Objectory.recycle(row);
            row = null;
        }
        for (Object[] a : joinColumnLeftRowIndexMap.keySet()) {
            Objectory.recycle(a);
        }
        return new RowDataSet(newColumnNameList, newColumnList);
    }

    private void rightJoin(List<List<Object>> newColumnList, DataSet right, Class<?> newColumnClass, int newColumnIndex, int rightRowIndex, List<Integer> leftRowIndexList, int[] leftColumnIndexes) {
        if (N.notNullOrEmpty(leftRowIndexList)) {
            for (int leftRowIndex : leftRowIndexList) {
                int leftColumnLength = leftColumnIndexes.length;
                for (int i = 0; i < leftColumnLength; ++i) {
                    newColumnList.get(i).add(this.get(leftRowIndex, leftColumnIndexes[i]));
                }
                newColumnList.get(newColumnIndex).add(right.getRow(newColumnClass, rightRowIndex));
            }
        } else {
            int leftColumnLength = leftColumnIndexes.length;
            for (int i = 0; i < leftColumnLength; ++i) {
                newColumnList.get(i).add(null);
            }
            newColumnList.get(newColumnIndex).add(right.getRow(newColumnClass, rightRowIndex));
        }
    }

    private void initNewColumnListForRightJoin(List<String> newColumnNameList, List<List<Object>> newColumnList, List<String> leftColumnNames, String newColumnName) {
        for (String leftColumnName : leftColumnNames) {
            newColumnNameList.add(leftColumnName);
            newColumnList.add(new ArrayList());
        }
        newColumnNameList.add(newColumnName);
        newColumnList.add(new ArrayList());
    }

    @Override
    public DataSet rightJoin(DataSet right, Map<String, String> onColumnNames, String newColumnName, Class<?> newColumnClass, IntFunction<? extends Collection> collSupplier) {
        this.checkJoinOnColumnNames(onColumnNames);
        this.checkNewColumnName(newColumnName);
        N.checkArgNotNull(collSupplier);
        if (onColumnNames.size() == 1) {
            Map.Entry<String, String> onColumnEntry = onColumnNames.entrySet().iterator().next();
            int leftJoinColumnIndex = this.checkColumnName(onColumnEntry.getKey());
            int rightJoinColumnIndex = this.checkRefColumnName(right, onColumnEntry.getValue());
            ArrayList<String> leftColumnNames = new ArrayList<String>(this._columnNameList);
            ArrayList<String> newColumnNameList = new ArrayList<String>(leftColumnNames.size() + 1);
            ArrayList<List<Object>> newColumnList = new ArrayList<List<Object>>(leftColumnNames.size() + 1);
            this.initNewColumnListForRightJoin(newColumnNameList, newColumnList, leftColumnNames, newColumnName);
            ImmutableList leftJoinColumn = this.getColumn(leftJoinColumnIndex);
            ImmutableList rightJoinColumn = right.getColumn(rightJoinColumnIndex);
            HashMap<Object, List<Integer>> joinColumnLeftRowIndexMap = new HashMap<Object, List<Integer>>();
            Object hashKey = null;
            int leftDataSetSize = this.size();
            for (int leftRowIndex = 0; leftRowIndex < leftDataSetSize; ++leftRowIndex) {
                hashKey = RowDataSet.getHashKey(leftJoinColumn.get(leftRowIndex));
                this.putRowIndex(joinColumnLeftRowIndexMap, hashKey, leftRowIndex);
            }
            LinkedHashMap<Object, List<Integer>> joinColumnRightRowIndexMap = new LinkedHashMap<Object, List<Integer>>();
            int rightDataSetSize = right.size();
            for (int rightRowIndex = 0; rightRowIndex < rightDataSetSize; ++rightRowIndex) {
                hashKey = RowDataSet.getHashKey(rightJoinColumn.get(rightRowIndex));
                this.putRowIndex(joinColumnRightRowIndexMap, hashKey, rightRowIndex);
            }
            int newColumnIndex = newColumnList.size() - 1;
            int[] leftColumnIndexes = this.getColumnIndexes(leftColumnNames);
            List leftRowIndexList = null;
            List rightRowIndexList = null;
            for (Map.Entry rightRowIndexEntry : joinColumnRightRowIndexMap.entrySet()) {
                leftRowIndexList = (List)joinColumnLeftRowIndexMap.get(rightRowIndexEntry.getKey());
                rightRowIndexList = (List)rightRowIndexEntry.getValue();
                this.rightJoin(newColumnList, right, newColumnClass, collSupplier, newColumnIndex, leftColumnIndexes, leftRowIndexList, rightRowIndexList);
            }
            return new RowDataSet(newColumnNameList, newColumnList);
        }
        ArrayList<String> leftColumnNames = new ArrayList<String>(this._columnNameList);
        int[] leftJoinColumnIndexes = new int[onColumnNames.size()];
        int[] rightJoinColumnIndexes = new int[onColumnNames.size()];
        this.initColumnIndexes(leftJoinColumnIndexes, rightJoinColumnIndexes, right, onColumnNames);
        ArrayList<String> newColumnNameList = new ArrayList<String>(leftColumnNames.size() + 1);
        ArrayList<List<Object>> newColumnList = new ArrayList<List<Object>>(leftColumnNames.size() + 1);
        this.initNewColumnListForRightJoin(newColumnNameList, newColumnList, leftColumnNames, newColumnName);
        ArrayHashMap<Object[], List<Integer>> joinColumnLeftRowIndexMap = new ArrayHashMap<Object[], List<Integer>>();
        Object[] row = null;
        int leftDataSetSize = this.size();
        for (int leftRowIndex = 0; leftRowIndex < leftDataSetSize; ++leftRowIndex) {
            row = row == null ? Objectory.createObjectArray(leftJoinColumnIndexes.length) : row;
            int len = leftJoinColumnIndexes.length;
            for (int i = 0; i < len; ++i) {
                row[i] = this.get(leftRowIndex, leftJoinColumnIndexes[i]);
            }
            row = this.putRowIndex((Map<Object[], List<Integer>>)joinColumnLeftRowIndexMap, row, leftRowIndex);
        }
        if (row != null) {
            Objectory.recycle(row);
            row = null;
        }
        ArrayHashMap<Object[], List<Integer>> joinColumnRightRowIndexMap = new ArrayHashMap<Object[], List<Integer>>(LinkedHashMap.class);
        int rightDataSetSize = right.size();
        for (int rightRowIndex = 0; rightRowIndex < rightDataSetSize; ++rightRowIndex) {
            row = row == null ? Objectory.createObjectArray(rightJoinColumnIndexes.length) : row;
            int len = rightJoinColumnIndexes.length;
            for (int i = 0; i < len; ++i) {
                row[i] = right.get(rightRowIndex, rightJoinColumnIndexes[i]);
            }
            row = this.putRowIndex((Map<Object[], List<Integer>>)joinColumnRightRowIndexMap, row, rightRowIndex);
        }
        if (row != null) {
            Objectory.recycle(row);
            row = null;
        }
        int newColumnIndex = newColumnList.size() - 1;
        int[] leftColumnIndexes = this.getColumnIndexes(leftColumnNames);
        List leftRowIndexList = null;
        List rightRowIndexList = null;
        for (Map.Entry rightRowIndexEntry : joinColumnRightRowIndexMap.entrySet()) {
            leftRowIndexList = (List)joinColumnLeftRowIndexMap.get(rightRowIndexEntry.getKey());
            rightRowIndexList = (List)rightRowIndexEntry.getValue();
            this.rightJoin(newColumnList, right, newColumnClass, collSupplier, newColumnIndex, leftColumnIndexes, leftRowIndexList, rightRowIndexList);
        }
        for (Object[] a : joinColumnLeftRowIndexMap.keySet()) {
            Objectory.recycle(a);
        }
        for (Object[] a : joinColumnRightRowIndexMap.keySet()) {
            Objectory.recycle(a);
        }
        return new RowDataSet(newColumnNameList, newColumnList);
    }

    private void rightJoin(List<List<Object>> newColumnList, DataSet right, Class<?> newColumnClass, IntFunction<? extends Collection> collSupplier, int newColumnIndex, int[] leftColumnIndexes, List<Integer> leftRowIndexList, List<Integer> rightRowIndexList) {
        if (N.notNullOrEmpty(leftRowIndexList)) {
            for (int leftRowIndex : leftRowIndexList) {
                int leftColumnLength = leftColumnIndexes.length;
                for (int i = 0; i < leftColumnLength; ++i) {
                    newColumnList.get(i).add(this.get(leftRowIndex, leftColumnIndexes[i]));
                }
                Collection coll = collSupplier.apply(rightRowIndexList.size());
                for (int righRowIndex : rightRowIndexList) {
                    coll.add(right.getRow(newColumnClass, righRowIndex));
                }
                newColumnList.get(newColumnIndex).add(coll);
            }
        } else {
            int leftColumnLength = leftColumnIndexes.length;
            for (int i = 0; i < leftColumnLength; ++i) {
                newColumnList.get(i).add(null);
            }
            Collection coll = collSupplier.apply(rightRowIndexList.size());
            for (int righRowIndex : rightRowIndexList) {
                coll.add(right.getRow(newColumnClass, righRowIndex));
            }
            newColumnList.get(newColumnIndex).add(coll);
        }
    }

    @Override
    public DataSet fullJoin(DataSet right, String columnName, String refColumnName) {
        Map<String, String> onColumnNames = N.asMap(columnName, refColumnName);
        return this.fullJoin(right, onColumnNames);
    }

    @Override
    public DataSet fullJoin(DataSet right, Map<String, String> onColumnNames) {
        this.checkJoinOnColumnNames(onColumnNames);
        if (onColumnNames.size() == 1) {
            Map.Entry<String, String> onColumnEntry = onColumnNames.entrySet().iterator().next();
            int leftJoinColumnIndex = this.checkColumnName(onColumnEntry.getKey());
            int rightJoinColumnIndex = this.checkRefColumnName(right, onColumnEntry.getValue());
            List<String> rightColumnNames = this.getRightColumnNames(right, onColumnEntry.getValue());
            ArrayList<String> newColumnNameList = new ArrayList<String>(this._columnNameList.size() + rightColumnNames.size());
            ArrayList<List<Object>> newColumnList = new ArrayList<List<Object>>(this._columnNameList.size() + rightColumnNames.size());
            this.initNewColumnList(newColumnNameList, newColumnList, rightColumnNames);
            ImmutableList leftJoinColumn = this.getColumn(leftJoinColumnIndex);
            ImmutableList rightJoinColumn = right.getColumn(rightJoinColumnIndex);
            HashMap<Object, List<Integer>> joinColumnRightRowIndexMap = new HashMap<Object, List<Integer>>();
            List rightRowIndexList = null;
            Object hashKey = null;
            int rightDataSetSize = right.size();
            for (int rightRowIndex = 0; rightRowIndex < rightDataSetSize; ++rightRowIndex) {
                hashKey = RowDataSet.getHashKey(rightJoinColumn.get(rightRowIndex));
                this.putRowIndex(joinColumnRightRowIndexMap, hashKey, rightRowIndex);
            }
            int[] rightColumnIndexes = right.getColumnIndexes(rightColumnNames);
            Set joinColumnLeftRowIndexSet = N.newHashSet();
            int size = this.size();
            for (int leftRowIndex = 0; leftRowIndex < size; ++leftRowIndex) {
                hashKey = RowDataSet.getHashKey(leftJoinColumn.get(leftRowIndex));
                rightRowIndexList = (List)joinColumnRightRowIndexMap.get(hashKey);
                this.fullJoin(newColumnList, right, leftRowIndex, rightRowIndexList, rightColumnIndexes);
                joinColumnLeftRowIndexSet.add(hashKey);
            }
            for (Map.Entry rightRowIndexEntry : joinColumnRightRowIndexMap.entrySet()) {
                if (joinColumnLeftRowIndexSet.contains(rightRowIndexEntry.getKey())) continue;
                this.fullJoin(newColumnList, right, (List)rightRowIndexEntry.getValue(), rightColumnIndexes);
            }
            return new RowDataSet(newColumnNameList, newColumnList);
        }
        int[] leftJoinColumnIndexes = new int[onColumnNames.size()];
        int[] rightJoinColumnIndexes = new int[onColumnNames.size()];
        ArrayList<String> rightColumnNames = new ArrayList<String>(right.columnNameList());
        this.initColumnIndexes(leftJoinColumnIndexes, rightJoinColumnIndexes, right, onColumnNames, rightColumnNames);
        ArrayList<String> newColumnNameList = new ArrayList<String>(this._columnNameList.size() + rightColumnNames.size());
        ArrayList<List<Object>> newColumnList = new ArrayList<List<Object>>(this._columnNameList.size() + rightColumnNames.size());
        this.initNewColumnList(newColumnNameList, newColumnList, rightColumnNames);
        ArrayHashMap<Object[], List<Integer>> joinColumnRightRowIndexMap = new ArrayHashMap<Object[], List<Integer>>(LinkedHashMap.class);
        List rightRowIndexList = null;
        Object[] row = null;
        int rightDataSetSize = right.size();
        for (int rightRowIndex = 0; rightRowIndex < rightDataSetSize; ++rightRowIndex) {
            row = row == null ? Objectory.createObjectArray(rightJoinColumnIndexes.length) : row;
            int len = rightJoinColumnIndexes.length;
            for (int i = 0; i < len; ++i) {
                row[i] = right.get(rightRowIndex, rightJoinColumnIndexes[i]);
            }
            row = this.putRowIndex((Map<Object[], List<Integer>>)joinColumnRightRowIndexMap, row, rightRowIndex);
        }
        if (row != null) {
            Objectory.recycle(row);
            row = null;
        }
        int[] rightColumnIndexes = right.getColumnIndexes(rightColumnNames);
        ArrayHashMap<Object[], Integer> joinColumnLeftRowIndexMap = new ArrayHashMap<Object[], Integer>();
        int size = this.size();
        for (int leftRowIndex = 0; leftRowIndex < size; ++leftRowIndex) {
            row = row == null ? Objectory.createObjectArray(rightJoinColumnIndexes.length) : row;
            int len = leftJoinColumnIndexes.length;
            for (int i = 0; i < len; ++i) {
                row[i] = this.get(leftRowIndex, leftJoinColumnIndexes[i]);
            }
            rightRowIndexList = (List)joinColumnRightRowIndexMap.get(row);
            this.fullJoin(newColumnList, right, leftRowIndex, rightRowIndexList, rightColumnIndexes);
            if (joinColumnLeftRowIndexMap.containsKey(row)) continue;
            joinColumnLeftRowIndexMap.put(row, leftRowIndex);
            row = null;
        }
        if (row != null) {
            Objectory.recycle(row);
            row = null;
        }
        for (Map.Entry rightRowIndexEntry : joinColumnRightRowIndexMap.entrySet()) {
            if (joinColumnLeftRowIndexMap.containsKey(rightRowIndexEntry.getKey())) continue;
            this.fullJoin(newColumnList, right, (List)rightRowIndexEntry.getValue(), rightColumnIndexes);
        }
        for (Object[] a : joinColumnRightRowIndexMap.keySet()) {
            Objectory.recycle(a);
        }
        for (Object[] a : joinColumnLeftRowIndexMap.keySet()) {
            Objectory.recycle(a);
        }
        return new RowDataSet(newColumnNameList, newColumnList);
    }

    private void fullJoin(List<List<Object>> newColumnList, DataSet right, List<Integer> rightRowIndexList, int[] rightColumnIndexes) {
        for (int rightRowIndex : rightRowIndexList) {
            int i;
            int leftColumnLength = this._columnNameList.size();
            for (i = 0; i < leftColumnLength; ++i) {
                newColumnList.get(i).add(null);
            }
            leftColumnLength = this._columnNameList.size();
            int rightColumnLength = rightColumnIndexes.length;
            for (i = 0; i < rightColumnLength; ++i) {
                newColumnList.get(leftColumnLength + i).add(right.get(rightRowIndex, rightColumnIndexes[i]));
            }
        }
    }

    private void fullJoin(List<List<Object>> newColumnList, DataSet right, int leftRowIndex, List<Integer> rightRowIndexList, int[] rightColumnIndexes) {
        if (N.notNullOrEmpty(rightRowIndexList)) {
            for (int rightRowIndex : rightRowIndexList) {
                int i;
                int leftColumnLength = this._columnNameList.size();
                for (i = 0; i < leftColumnLength; ++i) {
                    newColumnList.get(i).add(this._columnList.get(i).get(leftRowIndex));
                }
                leftColumnLength = this._columnNameList.size();
                int rightColumnLength = rightColumnIndexes.length;
                for (i = 0; i < rightColumnLength; ++i) {
                    newColumnList.get(leftColumnLength + i).add(right.get(rightRowIndex, rightColumnIndexes[i]));
                }
            }
        } else {
            int i;
            int leftColumnLength = this._columnNameList.size();
            for (i = 0; i < leftColumnLength; ++i) {
                newColumnList.get(i).add(this._columnList.get(i).get(leftRowIndex));
            }
            leftColumnLength = this._columnNameList.size();
            int rightColumnLength = rightColumnIndexes.length;
            for (i = 0; i < rightColumnLength; ++i) {
                newColumnList.get(leftColumnLength + i).add(null);
            }
        }
    }

    @Override
    public DataSet fullJoin(DataSet right, Map<String, String> onColumnNames, String newColumnName, Class<?> newColumnClass) {
        this.checkJoinOnColumnNames(onColumnNames);
        this.checkNewColumnName(newColumnName);
        if (onColumnNames.size() == 1) {
            Map.Entry<String, String> onColumnEntry = onColumnNames.entrySet().iterator().next();
            int leftJoinColumnIndex = this.checkColumnName(onColumnEntry.getKey());
            int rightJoinColumnIndex = this.checkRefColumnName(right, onColumnEntry.getValue());
            ArrayList<String> newColumnNameList = new ArrayList<String>(this._columnNameList.size() + 1);
            ArrayList<List<Object>> newColumnList = new ArrayList<List<Object>>(this._columnNameList.size() + 1);
            this.initNewColumnList(newColumnNameList, newColumnList, newColumnName);
            ImmutableList leftJoinColumn = this.getColumn(leftJoinColumnIndex);
            ImmutableList rightJoinColumn = right.getColumn(rightJoinColumnIndex);
            HashMap<Object, List<Integer>> joinColumnRightRowIndexMap = new HashMap<Object, List<Integer>>();
            List rightRowIndexList = null;
            Object hashKey = null;
            int rightDataSetSize = right.size();
            for (int rightRowIndex = 0; rightRowIndex < rightDataSetSize; ++rightRowIndex) {
                hashKey = RowDataSet.getHashKey(rightJoinColumn.get(rightRowIndex));
                this.putRowIndex(joinColumnRightRowIndexMap, hashKey, rightRowIndex);
            }
            int newColumnIndex = newColumnList.size() - 1;
            Set joinColumnLeftRowIndexSet = N.newHashSet();
            int size = this.size();
            for (int leftRowIndex = 0; leftRowIndex < size; ++leftRowIndex) {
                hashKey = RowDataSet.getHashKey(leftJoinColumn.get(leftRowIndex));
                rightRowIndexList = (List)joinColumnRightRowIndexMap.get(hashKey);
                this.fullJoin(newColumnList, right, newColumnClass, newColumnIndex, leftRowIndex, (List<Integer>)rightRowIndexList);
                joinColumnLeftRowIndexSet.add(hashKey);
            }
            for (Map.Entry rightRowIndexEntry : joinColumnRightRowIndexMap.entrySet()) {
                if (joinColumnLeftRowIndexSet.contains(rightRowIndexEntry.getKey())) continue;
                this.fullJoin(newColumnList, right, newColumnClass, newColumnIndex, (List)rightRowIndexEntry.getValue());
            }
            return new RowDataSet(newColumnNameList, newColumnList);
        }
        int[] leftJoinColumnIndexes = new int[onColumnNames.size()];
        int[] rightJoinColumnIndexes = new int[onColumnNames.size()];
        this.initColumnIndexes(leftJoinColumnIndexes, rightJoinColumnIndexes, right, onColumnNames);
        ArrayList<String> newColumnNameList = new ArrayList<String>(this._columnNameList.size() + 1);
        ArrayList<List<Object>> newColumnList = new ArrayList<List<Object>>(this._columnNameList.size() + 1);
        this.initNewColumnList(newColumnNameList, newColumnList, newColumnName);
        ArrayHashMap<Object[], List<Integer>> joinColumnRightRowIndexMap = new ArrayHashMap<Object[], List<Integer>>(LinkedHashMap.class);
        List rightRowIndexList = null;
        Object[] row = null;
        int rightDataSetSize = right.size();
        for (int rightRowIndex = 0; rightRowIndex < rightDataSetSize; ++rightRowIndex) {
            row = row == null ? Objectory.createObjectArray(rightJoinColumnIndexes.length) : row;
            int len = rightJoinColumnIndexes.length;
            for (int i = 0; i < len; ++i) {
                row[i] = right.get(rightRowIndex, rightJoinColumnIndexes[i]);
            }
            row = this.putRowIndex((Map<Object[], List<Integer>>)joinColumnRightRowIndexMap, row, rightRowIndex);
        }
        if (row != null) {
            Objectory.recycle(row);
            row = null;
        }
        int newColumnIndex = newColumnList.size() - 1;
        ArrayHashMap<Object[], Integer> joinColumnLeftRowIndexMap = new ArrayHashMap<Object[], Integer>();
        int size = this.size();
        for (int leftRowIndex = 0; leftRowIndex < size; ++leftRowIndex) {
            row = row == null ? Objectory.createObjectArray(rightJoinColumnIndexes.length) : row;
            int len = leftJoinColumnIndexes.length;
            for (int i = 0; i < len; ++i) {
                row[i] = this.get(leftRowIndex, leftJoinColumnIndexes[i]);
            }
            rightRowIndexList = (List)joinColumnRightRowIndexMap.get(row);
            this.fullJoin(newColumnList, right, newColumnClass, newColumnIndex, leftRowIndex, (List<Integer>)rightRowIndexList);
            if (joinColumnLeftRowIndexMap.containsKey(row)) continue;
            joinColumnLeftRowIndexMap.put(row, leftRowIndex);
            row = null;
        }
        if (row != null) {
            Objectory.recycle(row);
            row = null;
        }
        for (Map.Entry rightRowIndexEntry : joinColumnRightRowIndexMap.entrySet()) {
            if (joinColumnLeftRowIndexMap.containsKey(rightRowIndexEntry.getKey())) continue;
            this.fullJoin(newColumnList, right, newColumnClass, newColumnIndex, (List)rightRowIndexEntry.getValue());
        }
        for (Object[] a : joinColumnRightRowIndexMap.keySet()) {
            Objectory.recycle(a);
        }
        for (Object[] a : joinColumnLeftRowIndexMap.keySet()) {
            Objectory.recycle(a);
        }
        return new RowDataSet(newColumnNameList, newColumnList);
    }

    private void fullJoin(List<List<Object>> newColumnList, DataSet right, Class<?> newColumnClass, int newColumnIndex, List<Integer> rightRowIndexList) {
        for (int rightRowIndex : rightRowIndexList) {
            int leftColumnLength = this._columnNameList.size();
            for (int i = 0; i < leftColumnLength; ++i) {
                newColumnList.get(i).add(null);
            }
            newColumnList.get(newColumnIndex).add(right.getRow(newColumnClass, rightRowIndex));
        }
    }

    private void fullJoin(List<List<Object>> newColumnList, DataSet right, Class<?> newColumnClass, int newColumnIndex, int leftRowIndex, List<Integer> rightRowIndexList) {
        if (N.notNullOrEmpty(rightRowIndexList)) {
            for (int rightRowIndex : rightRowIndexList) {
                int leftColumnLength = this._columnNameList.size();
                for (int i = 0; i < leftColumnLength; ++i) {
                    newColumnList.get(i).add(this._columnList.get(i).get(leftRowIndex));
                }
                newColumnList.get(newColumnIndex).add(right.getRow(newColumnClass, rightRowIndex));
            }
        } else {
            int leftColumnLength = this._columnNameList.size();
            for (int i = 0; i < leftColumnLength; ++i) {
                newColumnList.get(i).add(this._columnList.get(i).get(leftRowIndex));
            }
            newColumnList.get(newColumnIndex).add(null);
        }
    }

    @Override
    public DataSet fullJoin(DataSet right, Map<String, String> onColumnNames, String newColumnName, Class<?> newColumnClass, IntFunction<? extends Collection> collSupplier) {
        this.checkJoinOnColumnNames(onColumnNames);
        this.checkNewColumnName(newColumnName);
        N.checkArgNotNull(collSupplier);
        if (onColumnNames.size() == 1) {
            Map.Entry<String, String> onColumnEntry = onColumnNames.entrySet().iterator().next();
            int leftJoinColumnIndex = this.checkColumnName(onColumnEntry.getKey());
            int rightJoinColumnIndex = this.checkRefColumnName(right, onColumnEntry.getValue());
            ArrayList<String> newColumnNameList = new ArrayList<String>(this._columnNameList.size() + 1);
            ArrayList<List<Object>> newColumnList = new ArrayList<List<Object>>(this._columnNameList.size() + 1);
            this.initNewColumnList(newColumnNameList, newColumnList, newColumnName);
            ImmutableList leftJoinColumn = this.getColumn(leftJoinColumnIndex);
            ImmutableList rightJoinColumn = right.getColumn(rightJoinColumnIndex);
            HashMap<Object, List<Integer>> joinColumnRightRowIndexMap = new HashMap<Object, List<Integer>>();
            Object hashKey = null;
            int rightDataSetSize = right.size();
            for (int rightRowIndex = 0; rightRowIndex < rightDataSetSize; ++rightRowIndex) {
                hashKey = RowDataSet.getHashKey(rightJoinColumn.get(rightRowIndex));
                this.putRowIndex(joinColumnRightRowIndexMap, hashKey, rightRowIndex);
            }
            int newColumnIndex = newColumnList.size() - 1;
            Set joinColumnLeftRowIndexSet = N.newHashSet();
            List rightRowIndexList = null;
            int size = this.size();
            for (int leftRowIndex = 0; leftRowIndex < size; ++leftRowIndex) {
                hashKey = RowDataSet.getHashKey(leftJoinColumn.get(leftRowIndex));
                rightRowIndexList = (List)joinColumnRightRowIndexMap.get(hashKey);
                this.fullJoin(newColumnList, right, newColumnClass, collSupplier, newColumnIndex, leftRowIndex, rightRowIndexList);
                joinColumnLeftRowIndexSet.add(hashKey);
            }
            for (Map.Entry rightRowIndexEntry : joinColumnRightRowIndexMap.entrySet()) {
                if (joinColumnLeftRowIndexSet.contains(rightRowIndexEntry.getKey())) continue;
                this.fullJoin(newColumnList, right, newColumnClass, collSupplier, newColumnIndex, (List<Integer>)((List)rightRowIndexEntry.getValue()));
            }
            return new RowDataSet(newColumnNameList, newColumnList);
        }
        int[] leftJoinColumnIndexes = new int[onColumnNames.size()];
        int[] rightJoinColumnIndexes = new int[onColumnNames.size()];
        this.initColumnIndexes(leftJoinColumnIndexes, rightJoinColumnIndexes, right, onColumnNames);
        ArrayList<String> newColumnNameList = new ArrayList<String>(this._columnNameList.size() + 1);
        ArrayList<List<Object>> newColumnList = new ArrayList<List<Object>>(this._columnNameList.size() + 1);
        this.initNewColumnList(newColumnNameList, newColumnList, newColumnName);
        ArrayHashMap<Object[], List<Integer>> joinColumnRightRowIndexMap = new ArrayHashMap<Object[], List<Integer>>(LinkedHashMap.class);
        List rightRowIndexList = null;
        Object[] row = null;
        int rightDataSetSize = right.size();
        for (int rightRowIndex = 0; rightRowIndex < rightDataSetSize; ++rightRowIndex) {
            row = row == null ? Objectory.createObjectArray(rightJoinColumnIndexes.length) : row;
            int len = rightJoinColumnIndexes.length;
            for (int i = 0; i < len; ++i) {
                row[i] = right.get(rightRowIndex, rightJoinColumnIndexes[i]);
            }
            row = this.putRowIndex((Map<Object[], List<Integer>>)joinColumnRightRowIndexMap, row, rightRowIndex);
        }
        if (row != null) {
            Objectory.recycle(row);
            row = null;
        }
        int newColumnIndex = newColumnList.size() - 1;
        ArrayHashMap<Object[], Integer> joinColumnLeftRowIndexMap = new ArrayHashMap<Object[], Integer>();
        int size = this.size();
        for (int leftRowIndex = 0; leftRowIndex < size; ++leftRowIndex) {
            row = row == null ? Objectory.createObjectArray(rightJoinColumnIndexes.length) : row;
            int len = leftJoinColumnIndexes.length;
            for (int i = 0; i < len; ++i) {
                row[i] = this.get(leftRowIndex, leftJoinColumnIndexes[i]);
            }
            rightRowIndexList = (List)joinColumnRightRowIndexMap.get(row);
            this.fullJoin(newColumnList, right, newColumnClass, collSupplier, newColumnIndex, leftRowIndex, rightRowIndexList);
            if (joinColumnLeftRowIndexMap.containsKey(row)) continue;
            joinColumnLeftRowIndexMap.put(row, leftRowIndex);
            row = null;
        }
        if (row != null) {
            Objectory.recycle(row);
            row = null;
        }
        for (Map.Entry rightRowIndexEntry : joinColumnRightRowIndexMap.entrySet()) {
            if (joinColumnLeftRowIndexMap.containsKey(rightRowIndexEntry.getKey())) continue;
            this.fullJoin(newColumnList, right, newColumnClass, collSupplier, newColumnIndex, (List<Integer>)((List)rightRowIndexEntry.getValue()));
        }
        for (Object[] a : joinColumnRightRowIndexMap.keySet()) {
            Objectory.recycle(a);
        }
        for (Object[] a : joinColumnLeftRowIndexMap.keySet()) {
            Objectory.recycle(a);
        }
        return new RowDataSet(newColumnNameList, newColumnList);
    }

    private void fullJoin(List<List<Object>> newColumnList, DataSet right, Class<?> newColumnClass, IntFunction<? extends Collection> collSupplier, int newColumnIndex, List<Integer> rightRowIndexList) {
        int leftColumnLength = this._columnNameList.size();
        for (int i = 0; i < leftColumnLength; ++i) {
            newColumnList.get(i).add(null);
        }
        Collection coll = collSupplier.apply(rightRowIndexList.size());
        for (int rightRowIndex : rightRowIndexList) {
            coll.add(right.getRow(newColumnClass, rightRowIndex));
        }
        newColumnList.get(newColumnIndex).add(coll);
    }

    private void fullJoin(List<List<Object>> newColumnList, DataSet right, Class<?> newColumnClass, IntFunction<? extends Collection> collSupplier, int newColumnIndex, int leftRowIndex, List<Integer> rightRowIndexList) {
        if (N.notNullOrEmpty(rightRowIndexList)) {
            int leftColumnLength = this._columnNameList.size();
            for (int i = 0; i < leftColumnLength; ++i) {
                newColumnList.get(i).add(this._columnList.get(i).get(leftRowIndex));
            }
            Collection coll = collSupplier.apply(rightRowIndexList.size());
            for (int rightRowIndex : rightRowIndexList) {
                coll.add(right.getRow(newColumnClass, rightRowIndex));
            }
            newColumnList.get(newColumnIndex).add(coll);
        } else {
            int leftColumnLength = this._columnNameList.size();
            for (int i = 0; i < leftColumnLength; ++i) {
                newColumnList.get(i).add(this._columnList.get(i).get(leftRowIndex));
            }
            newColumnList.get(newColumnIndex).add(null);
        }
    }

    @Override
    public DataSet union(DataSet dataSet) {
        return this.merge(dataSet.difference(this));
    }

    @Override
    public DataSet unionAll(DataSet dataSet) {
        return this.merge(dataSet);
    }

    @Override
    public DataSet intersect(DataSet other) {
        ArrayList<String> commonColumnNameList = new ArrayList<String>(this._columnNameList);
        commonColumnNameList.retainAll(other.columnNameList());
        if (N.isNullOrEmpty(commonColumnNameList)) {
            throw new IllegalArgumentException("These two DataSets don't have common column names: " + this._columnNameList + ", " + other.columnNameList());
        }
        int newColumnCount = this.columnNameList().size();
        ArrayList<String> newColumnNameList = new ArrayList<String>(this._columnNameList);
        ArrayList<List<Object>> newColumnList = new ArrayList<List<Object>>(newColumnCount);
        for (int i = 0; i < newColumnCount; ++i) {
            newColumnList.add(new ArrayList());
        }
        int size = this.size();
        if (size == 0) {
            return new RowDataSet(newColumnNameList, newColumnList);
        }
        int commonColumnCount = commonColumnNameList.size();
        if (commonColumnCount == 1) {
            int columnIndex = this.getColumnIndex((String)commonColumnNameList.get(0));
            int otherColumnIndex = other.getColumnIndex((String)commonColumnNameList.get(0));
            List<Object> column = this._columnList.get(columnIndex);
            Set rowSet = N.newHashSet();
            for (Object e : other.getColumn(otherColumnIndex)) {
                rowSet.add(RowDataSet.getHashKey(e));
            }
            for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
                if (!rowSet.remove(RowDataSet.getHashKey(column.get(rowIndex)))) continue;
                for (int i = 0; i < newColumnCount; ++i) {
                    ((List)newColumnList.get(i)).add(this._columnList.get(i).get(rowIndex));
                }
            }
        } else {
            int[] columnIndexes = this.getColumnIndexes(commonColumnNameList);
            int[] otherColumnIndexes = other.getColumnIndexes(commonColumnNameList);
            ArrayHashSet<Object[]> rowSet = new ArrayHashSet<Object[]>();
            Object[] row = null;
            int otherSize = other.size();
            for (int otherRowIndex = 0; otherRowIndex < otherSize; ++otherRowIndex) {
                row = row == null ? new Object[commonColumnCount] : row;
                for (int i = 0; i < commonColumnCount; ++i) {
                    row[i] = other.get(otherRowIndex, otherColumnIndexes[i]);
                }
                if (!rowSet.add(row)) continue;
                row = null;
            }
            row = new Object[commonColumnCount];
            for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
                int i;
                for (i = 0; i < commonColumnCount; ++i) {
                    row[i] = this._columnList.get(columnIndexes[i]).get(rowIndex);
                }
                if (!rowSet.remove(row)) continue;
                for (i = 0; i < newColumnCount; ++i) {
                    ((List)newColumnList.get(i)).add(this._columnList.get(i).get(rowIndex));
                }
            }
        }
        return new RowDataSet(newColumnNameList, newColumnList);
    }

    @Override
    public DataSet intersectAll(DataSet other) {
        return this.remove2(other, true);
    }

    @Override
    public DataSet intersection(DataSet other) {
        return this.remove(other, true);
    }

    @Override
    public DataSet difference(DataSet other) {
        return this.remove(other, false);
    }

    private DataSet remove(DataSet other, boolean retain) {
        ArrayList<String> commonColumnNameList = new ArrayList<String>(this._columnNameList);
        commonColumnNameList.retainAll(other.columnNameList());
        if (N.isNullOrEmpty(commonColumnNameList)) {
            throw new IllegalArgumentException("These two DataSets don't have common column names: " + this._columnNameList + ", " + other.columnNameList());
        }
        int newColumnCount = this.columnNameList().size();
        ArrayList<String> newColumnNameList = new ArrayList<String>(this._columnNameList);
        ArrayList<List<Object>> newColumnList = new ArrayList<List<Object>>(newColumnCount);
        for (int i = 0; i < newColumnCount; ++i) {
            newColumnList.add(new ArrayList());
        }
        int size = this.size();
        if (size == 0) {
            return new RowDataSet(newColumnNameList, newColumnList);
        }
        int commonColumnCount = commonColumnNameList.size();
        if (commonColumnCount == 1) {
            int columnIndex = this.getColumnIndex((String)commonColumnNameList.get(0));
            int otherColumnIndex = other.getColumnIndex((String)commonColumnNameList.get(0));
            List<Object> column = this._columnList.get(columnIndex);
            Multiset<Object> rowSet = new Multiset<Object>();
            for (Object val : other.getColumn(otherColumnIndex)) {
                rowSet.add(RowDataSet.getHashKey(val));
            }
            for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
                if (rowSet.getAndRemove(RowDataSet.getHashKey(column.get(rowIndex))) > 0 != retain) continue;
                for (int i = 0; i < newColumnCount; ++i) {
                    ((List)newColumnList.get(i)).add(this._columnList.get(i).get(rowIndex));
                }
            }
        } else {
            int[] columnIndexes = this.getColumnIndexes(commonColumnNameList);
            int[] otherColumnIndexes = other.getColumnIndexes(commonColumnNameList);
            Multiset<Object[]> rowSet = new Multiset<Object[]>(ArrayHashMap.class);
            Object[] row = null;
            int otherSize = other.size();
            for (int otherRowIndex = 0; otherRowIndex < otherSize; ++otherRowIndex) {
                row = row == null ? Objectory.createObjectArray(commonColumnCount) : row;
                for (int i = 0; i < commonColumnCount; ++i) {
                    row[i] = other.get(otherRowIndex, otherColumnIndexes[i]);
                }
                if (rowSet.getAndAdd(row) != 0) continue;
                row = null;
            }
            if (row != null) {
                Objectory.recycle(row);
                row = null;
            }
            row = Objectory.createObjectArray(commonColumnCount);
            for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
                int i;
                for (i = 0; i < commonColumnCount; ++i) {
                    row[i] = this._columnList.get(columnIndexes[i]).get(rowIndex);
                }
                if (rowSet.getAndRemove(row) > 0 != retain) continue;
                for (i = 0; i < newColumnCount; ++i) {
                    ((List)newColumnList.get(i)).add(this._columnList.get(i).get(rowIndex));
                }
            }
            Objectory.recycle(row);
            row = null;
            for (Object[] a : rowSet) {
                Objectory.recycle(a);
            }
        }
        return new RowDataSet(newColumnNameList, newColumnList);
    }

    @Override
    public DataSet symmetricDifference(DataSet dataSet) {
        return this.difference(dataSet).merge(dataSet.difference(this));
    }

    @Override
    public DataSet except(DataSet other) {
        return this.remove2(other, false);
    }

    private DataSet remove2(DataSet other, boolean retain) {
        ArrayList<String> commonColumnNameList = new ArrayList<String>(this._columnNameList);
        commonColumnNameList.retainAll(other.columnNameList());
        if (N.isNullOrEmpty(commonColumnNameList)) {
            throw new IllegalArgumentException("These two DataSets don't have common column names: " + this._columnNameList + ", " + other.columnNameList());
        }
        int newColumnCount = this.columnNameList().size();
        ArrayList<String> newColumnNameList = new ArrayList<String>(this._columnNameList);
        ArrayList<List<Object>> newColumnList = new ArrayList<List<Object>>(newColumnCount);
        for (int i = 0; i < newColumnCount; ++i) {
            newColumnList.add(new ArrayList());
        }
        int size = this.size();
        if (size == 0) {
            return new RowDataSet(newColumnNameList, newColumnList);
        }
        int commonColumnCount = commonColumnNameList.size();
        if (commonColumnCount == 1) {
            int columnIndex = this.getColumnIndex((String)commonColumnNameList.get(0));
            int otherColumnIndex = other.getColumnIndex((String)commonColumnNameList.get(0));
            List<Object> column = this._columnList.get(columnIndex);
            Set rowSet = N.newHashSet();
            for (Object e : other.getColumn(otherColumnIndex)) {
                rowSet.add(RowDataSet.getHashKey(e));
            }
            for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
                if (rowSet.contains(RowDataSet.getHashKey(column.get(rowIndex))) != retain) continue;
                for (int i = 0; i < newColumnCount; ++i) {
                    ((List)newColumnList.get(i)).add(this._columnList.get(i).get(rowIndex));
                }
            }
        } else {
            int[] columnIndexes = this.getColumnIndexes(commonColumnNameList);
            int[] otherColumnIndexes = other.getColumnIndexes(commonColumnNameList);
            ArrayHashSet<Object[]> rowSet = new ArrayHashSet<Object[]>();
            Object[] row = null;
            int otherSize = other.size();
            for (int otherRowIndex = 0; otherRowIndex < otherSize; ++otherRowIndex) {
                row = row == null ? Objectory.createObjectArray(commonColumnCount) : row;
                for (int i = 0; i < commonColumnCount; ++i) {
                    row[i] = other.get(otherRowIndex, otherColumnIndexes[i]);
                }
                if (!rowSet.add(row)) continue;
                row = null;
            }
            if (row != null) {
                Objectory.recycle(row);
                row = null;
            }
            row = Objectory.createObjectArray(commonColumnCount);
            for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
                int i;
                for (i = 0; i < commonColumnCount; ++i) {
                    row[i] = this._columnList.get(columnIndexes[i]).get(rowIndex);
                }
                if (rowSet.contains(row) != retain) continue;
                for (i = 0; i < newColumnCount; ++i) {
                    ((List)newColumnList.get(i)).add(this._columnList.get(i).get(rowIndex));
                }
            }
            Objectory.recycle(row);
            row = null;
            for (Object[] a : rowSet) {
                Objectory.recycle(a);
            }
        }
        return new RowDataSet(newColumnNameList, newColumnList);
    }

    @Override
    @Deprecated
    public List<DataSet> splitt(int chunkSize) {
        return this.splitt(this._columnNameList, chunkSize);
    }

    @Override
    @Deprecated
    public List<DataSet> splitt(Collection<String> columnNames, int chunkSize) {
        N.checkArgPositive(chunkSize, "chunkSize");
        ArrayList<DataSet> res = new ArrayList<DataSet>();
        int totalSize = this.size();
        for (int i = 0; i < totalSize; i += chunkSize) {
            res.add(this.copy(columnNames, i, i <= totalSize - chunkSize ? i + chunkSize : totalSize));
        }
        return res;
    }

    @Override
    public List<DataSet> splitToList(int chunkSize) {
        return this.splitToList(this._columnNameList, chunkSize);
    }

    @Override
    public List<DataSet> splitToList(Collection<String> columnNames, int chunkSize) {
        N.checkArgPositive(chunkSize, "chunkSize");
        ArrayList<DataSet> res = new ArrayList<DataSet>();
        int totalSize = this.size();
        for (int i = 0; i < totalSize; i += chunkSize) {
            res.add(this.copy(columnNames, i, i <= totalSize - chunkSize ? i + chunkSize : totalSize));
        }
        return res;
    }

    @Override
    public DataSet merge(DataSet from) {
        return this.merge(from, from.columnNameList(), 0, from.size());
    }

    @Override
    public DataSet merge(DataSet from, Collection<String> columnNames) {
        return this.merge(from, columnNames, 0, from.size());
    }

    @Override
    public DataSet merge(DataSet from, int fromRowIndex, int toRowIndex) {
        return this.merge(from, from.columnNameList(), fromRowIndex, toRowIndex);
    }

    @Override
    public DataSet merge(DataSet from, Collection<String> columnNames, int fromRowIndex, int toRowIndex) {
        this.checkRowIndex(fromRowIndex, toRowIndex, from.size());
        RowDataSet result = this.copy(this._columnNameList, 0, this.size(), true);
        List<Object> column = null;
        for (String columnName : columnNames) {
            if (result.containsColumn(columnName)) continue;
            if (column == null) {
                column = new ArrayList<Object>(this.size() + (toRowIndex - fromRowIndex));
                N.fill(column, 0, this.size(), null);
            }
            result.addColumn(columnName, column);
        }
        for (String columnName : result._columnNameList) {
            column = result._columnList.get(result.getColumnIndex(columnName));
            int columnIndex = from.getColumnIndex(columnName);
            if (columnIndex >= 0) {
                if (fromRowIndex == 0 && toRowIndex == from.size()) {
                    column.addAll(from.getColumn(columnIndex));
                    continue;
                }
                column.addAll(from.getColumn(columnIndex).subList(fromRowIndex, toRowIndex));
                continue;
            }
            for (int i = fromRowIndex; i < toRowIndex; ++i) {
                column.add(null);
            }
        }
        if (N.notNullOrEmpty(from.properties())) {
            result.properties().putAll(from.properties());
        }
        return result;
    }

    @Override
    public DataSet merge(DataSet a, DataSet b) {
        return N.merge(this, a, b);
    }

    @Override
    public DataSet merge(Collection<? extends DataSet> dss) {
        if (N.isNullOrEmpty(dss)) {
            return N.newEmptyDataSet().merge(this);
        }
        ArrayList<? extends DataSet> dsList = new ArrayList<DataSet>(N.size(dss) + 1);
        dsList.add(this);
        dsList.addAll(dss);
        return N.merge(dsList);
    }

    @Override
    public DataSet cartesianProduct(DataSet b) {
        List<String> tmp = N.intersection(this._columnNameList, b.columnNameList());
        if (N.notNullOrEmpty(tmp)) {
            throw new IllegalArgumentException(tmp + " are included in both DataSets: " + this._columnNameList + " : " + b.columnNameList());
        }
        int aSize = this.size();
        int bSize = b.size();
        int aColumnCount = this._columnNameList.size();
        int bColumnCount = b.columnNameList().size();
        int newColumnCount = aColumnCount + bColumnCount;
        int newRowCount = aSize * bSize;
        ArrayList<String> newColumnNameList = new ArrayList<String>(newColumnCount);
        newColumnNameList.addAll(this._columnNameList);
        newColumnNameList.addAll(b.columnNameList());
        ArrayList<List<Object>> newColumnList = new ArrayList<List<Object>>();
        for (int i = 0; i < newColumnCount; ++i) {
            newColumnList.add(new ArrayList(newRowCount));
        }
        if (newRowCount == 0) {
            return new RowDataSet(newColumnNameList, newColumnList);
        }
        Object[] tmpArray = new Object[bSize];
        for (int rowIndex = 0; rowIndex < aSize; ++rowIndex) {
            int columnIndex;
            for (columnIndex = 0; columnIndex < aColumnCount; ++columnIndex) {
                N.fill(tmpArray, this.get(rowIndex, columnIndex));
                ((List)newColumnList.get(columnIndex)).addAll(Arrays.asList(tmpArray));
            }
            for (columnIndex = 0; columnIndex < bColumnCount; ++columnIndex) {
                ((List)newColumnList.get(columnIndex + aColumnCount)).addAll(b.getColumn(columnIndex));
            }
        }
        return new RowDataSet(newColumnNameList, newColumnList);
    }

    @Override
    public DataSet slice(Collection<String> columnNames) {
        return this.slice(columnNames, 0, this.size());
    }

    @Override
    public DataSet slice(int fromRowIndex, int toRowIndex) {
        return this.slice(this._columnNameList, fromRowIndex, toRowIndex);
    }

    @Override
    public DataSet slice(Collection<String> columnNames, int fromRowIndex, int toRowIndex) {
        N.checkFromToIndex(fromRowIndex, toRowIndex, this.size());
        DataSet ds = null;
        if (N.isNullOrEmpty(columnNames)) {
            ds = N.newEmptyDataSet();
        } else {
            int[] columnIndexes = this.checkColumnName(columnNames);
            ArrayList<String> newColumnNames = new ArrayList<String>(columnNames);
            ArrayList<List<Object>> newColumnList = new ArrayList<List<Object>>(newColumnNames.size());
            if (fromRowIndex > 0 || toRowIndex < this.size()) {
                for (int columnIndex : columnIndexes) {
                    newColumnList.add(this._columnList.get(columnIndex).subList(fromRowIndex, toRowIndex));
                }
            } else {
                for (int columnIndex : columnIndexes) {
                    newColumnList.add(this._columnList.get(columnIndex));
                }
            }
            ds = new RowDataSet(newColumnNames, newColumnList, this._properties);
        }
        ds.frozen();
        return ds;
    }

    @Override
    public PaginatedDataSet paginate(int pageSize) {
        return this.paginate(this._columnNameList, pageSize);
    }

    @Override
    public PaginatedDataSet paginate(Collection<String> columnNames, int pageSize) {
        return new PaginatedRowDataSet(N.isNullOrEmpty(columnNames) ? this._columnNameList : columnNames, pageSize);
    }

    @Override
    public <R, E extends Exception> R apply(Throwables.Function<? super DataSet, R, E> func) throws E {
        return func.apply(this);
    }

    @Override
    public <E extends Exception> void accept(Throwables.Consumer<? super DataSet, E> action) throws E {
        action.accept(this);
    }

    @Override
    public void freeze() {
        this._isFrozen = true;
    }

    @Override
    public boolean frozen() {
        return this._isFrozen;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void trimToSize() {
        if (this._columnList instanceof ArrayList) {
            ((ArrayList)this._columnList).trimToSize();
        }
        for (List<Object> column : this._columnList) {
            if (!(column instanceof ArrayList)) continue;
            ((ArrayList)column).trimToSize();
        }
    }

    @Override
    public int size() {
        return this._columnList.size() == 0 ? 0 : this._columnList.get(0).size();
    }

    @Override
    public void clear() {
        this.checkFrozen();
        for (int i = 0; i < this._columnList.size(); ++i) {
            this._columnList.get(i).clear();
        }
        ++this.modCount;
    }

    @Override
    public Properties<String, Object> properties() {
        if (this._properties == null) {
            this._properties = new Properties();
        }
        return this._properties;
    }

    @Override
    public Map<String, ImmutableList<Object>> columnMap() {
        LinkedHashMap<String, ImmutableList<Object>> result = new LinkedHashMap<String, ImmutableList<Object>>();
        for (String columnName : this._columnNameList) {
            result.put(columnName, this.getColumn(columnName));
        }
        return result;
    }

    @Override
    public void println() throws UncheckedIOException {
        this.println(this._columnNameList, 0, this.size());
    }

    @Override
    public void println(Collection<String> columnNames, int fromRowIndex, int toRowIndex) throws UncheckedIOException {
        this.println(new OutputStreamWriter(System.out), columnNames, fromRowIndex, toRowIndex);
    }

    @Override
    public <W extends Writer> W println(W outputWriter) throws UncheckedIOException {
        return this.println(outputWriter, this._columnNameList, 0, this.size());
    }

    @Override
    public <W extends Writer> W println(W outputWriter, Collection<String> columnNames, int fromRowIndex, int toRowIndex) throws UncheckedIOException {
        int[] columnIndexes = N.isNullOrEmpty(columnNames) ? N.EMPTY_INT_ARRAY : this.checkColumnName(columnNames);
        this.checkRowIndex(fromRowIndex, toRowIndex);
        N.checkArgNotNull(outputWriter, "outputWriter");
        boolean isBufferedWriter = outputWriter instanceof com.landawn.abacus.util.BufferedWriter || outputWriter instanceof BufferedWriter;
        Object bw = isBufferedWriter ? outputWriter : Objectory.createBufferedWriter(outputWriter);
        int rowLen = toRowIndex - fromRowIndex;
        int columnLen = columnIndexes.length;
        try {
            if (columnLen == 0) {
                ((Writer)bw).write("+---+");
                ((Writer)bw).write(IOUtil.LINE_SEPARATOR);
                ((Writer)bw).write("|   |");
                ((Writer)bw).write(IOUtil.LINE_SEPARATOR);
                ((Writer)bw).write("+---+");
            } else {
                int i;
                ArrayList<String> columnNameList = new ArrayList<String>(columnNames);
                ArrayList strColumnList = new ArrayList(columnLen);
                int[] maxColumnLens = new int[columnLen];
                for (int i2 = 0; i2 < columnLen; ++i2) {
                    List<Object> column = this._columnList.get(columnIndexes[i2]);
                    ArrayList<String> strColumn = new ArrayList<String>(rowLen);
                    int maxLen = N.len((CharSequence)columnNameList.get(i2));
                    String str = null;
                    for (int rowIndex = fromRowIndex; rowIndex < toRowIndex; ++rowIndex) {
                        str = N.toString(column.get(rowIndex));
                        maxLen = N.max(maxLen, N.len(str));
                        strColumn.add(str);
                    }
                    maxColumnLens[i2] = maxLen;
                    strColumnList.add(strColumn);
                }
                int hch = 45;
                int hchDelta = 2;
                for (i = 0; i < columnLen; ++i) {
                    ((Writer)bw).write(43);
                    ((Writer)bw).write(StringUtil.repeat('-', maxColumnLens[i] + 2));
                }
                ((Writer)bw).write(43);
                ((Writer)bw).write(IOUtil.LINE_SEPARATOR);
                for (i = 0; i < columnLen; ++i) {
                    if (i == 0) {
                        ((Writer)bw).write("| ");
                    } else {
                        ((Writer)bw).write(" | ");
                    }
                    ((Writer)bw).write(StringUtil.padEnd((String)columnNameList.get(i), maxColumnLens[i]));
                }
                ((Writer)bw).write(" |");
                ((Writer)bw).write(IOUtil.LINE_SEPARATOR);
                for (i = 0; i < columnLen; ++i) {
                    ((Writer)bw).write(43);
                    ((Writer)bw).write(StringUtil.repeat('-', maxColumnLens[i] + 2));
                }
                ((Writer)bw).write(43);
                for (int j = 0; j < rowLen; ++j) {
                    ((Writer)bw).write(IOUtil.LINE_SEPARATOR);
                    for (int i3 = 0; i3 < columnLen; ++i3) {
                        if (i3 == 0) {
                            ((Writer)bw).write("| ");
                        } else {
                            ((Writer)bw).write(" | ");
                        }
                        ((Writer)bw).write(StringUtil.padEnd((String)((List)strColumnList.get(i3)).get(j), maxColumnLens[i3]));
                    }
                    ((Writer)bw).write(" |");
                }
                if (rowLen == 0) {
                    ((Writer)bw).write(IOUtil.LINE_SEPARATOR);
                    for (i = 0; i < columnLen; ++i) {
                        if (i == 0) {
                            ((Writer)bw).write("| ");
                            ((Writer)bw).write(StringUtil.padEnd("", maxColumnLens[i]));
                            continue;
                        }
                        ((Writer)bw).write(StringUtil.padEnd("", maxColumnLens[i] + 3));
                    }
                    ((Writer)bw).write(" |");
                }
                ((Writer)bw).write(IOUtil.LINE_SEPARATOR);
                for (i = 0; i < columnLen; ++i) {
                    ((Writer)bw).write(43);
                    ((Writer)bw).write(StringUtil.repeat('-', maxColumnLens[i] + 2));
                }
                ((Writer)bw).write(43);
            }
            ((Writer)bw).write(IOUtil.LINE_SEPARATOR);
            ((Writer)bw).flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            if (!isBufferedWriter) {
                Objectory.recycle((com.landawn.abacus.util.BufferedWriter)bw);
            }
        }
        return outputWriter;
    }

    public int hashCode() {
        int h = 17;
        h = h * 31 + this._columnNameList.hashCode();
        h = h * 31 + this._columnList.hashCode();
        return h;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RowDataSet) {
            RowDataSet other = (RowDataSet)obj;
            return this.size() == other.size() && N.equals(this._columnNameList, other._columnNameList) && N.equals(this._columnList, other._columnList);
        }
        return false;
    }

    public String toString() {
        if (this._columnNameList.size() == 0) {
            return "[[]]";
        }
        com.landawn.abacus.util.BufferedWriter bw = Objectory.createBufferedWriter();
        try {
            this.toCSV(bw, true, false);
            String string = bw.toString();
            return string;
        }
        finally {
            Objectory.recycle(bw);
        }
    }

    void checkFrozen() {
        if (this._isFrozen) {
            throw new IllegalStateException("This DataSet is frozen, can't modify it.");
        }
    }

    int checkColumnName(String columnName) {
        int columnIndex = this.getColumnIndex(columnName);
        if (columnIndex < 0) {
            throw new IllegalArgumentException("The specified column(" + columnName + ") is not included in this DataSet " + this._columnNameList);
        }
        return columnIndex;
    }

    int[] checkColumnName(String ... columnNames) {
        if (N.isNullOrEmpty(columnNames)) {
            throw new IllegalArgumentException("The specified columnNames is null or empty");
        }
        int length = columnNames.length;
        int[] columnIndexes = new int[length];
        for (int i = 0; i < length; ++i) {
            columnIndexes[i] = this.checkColumnName(columnNames[i]);
        }
        return columnIndexes;
    }

    int[] checkColumnName(Collection<String> columnNames) {
        if (N.isNullOrEmpty(columnNames)) {
            throw new IllegalArgumentException("The specified columnNames is null or empty");
        }
        if (columnNames == this._columnNameList) {
            if (this._columnIndexes == null) {
                int count = columnNames.size();
                this._columnIndexes = new int[count];
                for (int i = 0; i < count; ++i) {
                    this._columnIndexes[i] = i;
                }
            }
            return this._columnIndexes;
        }
        int count = columnNames.size();
        int[] columnNameIndexes = new int[count];
        Iterator<String> it = columnNames.iterator();
        for (int i = 0; i < count; ++i) {
            columnNameIndexes[i] = this.checkColumnName(it.next());
        }
        return columnNameIndexes;
    }

    void checkRowNum(int rowNum) {
        if (rowNum < 0 || rowNum >= this.size()) {
            throw new IllegalArgumentException("Invalid row number: " + rowNum + ". It must be >= 0 and < " + this.size());
        }
    }

    void checkRowIndex(int fromRowIndex, int toRowIndex) {
        this.checkRowIndex(fromRowIndex, toRowIndex, this.size());
    }

    void checkRowIndex(int fromRowIndex, int toRowIndex, int size) {
        if (fromRowIndex < 0 || fromRowIndex > toRowIndex || toRowIndex > size) {
            throw new IllegalArgumentException("Invalid fromRowIndex : " + fromRowIndex + " or toRowIndex: " + toRowIndex);
        }
    }

    static Object getHashKey(Object obj) {
        return obj == null || !obj.getClass().isArray() ? obj : Wrapper.of(obj);
    }

    private class PaginatedRowDataSet
    implements PaginatedDataSet {
        private final int expectedModCount;
        private final Map<Integer, DataSet> pagePool;
        private final Collection<String> columnNames;
        private final int pageSize;
        private final int totalPages;
        private int currentPageNum;

        private PaginatedRowDataSet(Collection<String> columnNames, int pageSize) {
            this.expectedModCount = RowDataSet.this.modCount;
            this.pagePool = new HashMap<Integer, DataSet>();
            this.columnNames = columnNames;
            this.pageSize = pageSize;
            this.totalPages = RowDataSet.this.size() % pageSize == 0 ? RowDataSet.this.size() / pageSize : RowDataSet.this.size() / pageSize + 1;
            this.currentPageNum = 0;
        }

        @Override
        public Iterator<DataSet> iterator() {
            return new Itr();
        }

        @Override
        public boolean hasNext() {
            return this.currentPageNum < this.pageCount();
        }

        @Override
        public DataSet currentPage() {
            return this.getPage(this.currentPageNum);
        }

        @Override
        public DataSet nextPage() {
            return this.absolute(this.currentPageNum + 1).currentPage();
        }

        @Override
        public DataSet previousPage() {
            return this.absolute(this.currentPageNum - 1).currentPage();
        }

        @Override
        public u.Optional<DataSet> firstPage() {
            return this.pageCount() == 0 ? u.Optional.empty() : u.Optional.of(this.absolute(0).currentPage());
        }

        @Override
        public u.Optional<DataSet> lastPage() {
            return this.pageCount() == 0 ? u.Optional.empty() : u.Optional.of(this.absolute(this.pageCount() - 1).currentPage());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DataSet getPage(int pageNum) {
            this.ConcurrentModification();
            this.checkPageNumber(pageNum);
            Map<Integer, DataSet> map = this.pagePool;
            synchronized (map) {
                DataSet page = this.pagePool.get(pageNum);
                if (page == null) {
                    int offset = pageNum * this.pageSize;
                    page = RowDataSet.this.slice(this.columnNames, offset, Math.min(offset + this.pageSize, RowDataSet.this.size()));
                    this.pagePool.put(pageNum, page);
                }
                return page;
            }
        }

        @Override
        public PaginatedDataSet absolute(int pageNumber) {
            this.checkPageNumber(pageNumber);
            this.currentPageNum = pageNumber;
            return this;
        }

        @Override
        public int currentPageNum() {
            return this.currentPageNum;
        }

        @Override
        public int pageSize() {
            return this.pageSize;
        }

        @Override
        public int pageCount() {
            return this.totalPages;
        }

        @Override
        public int totalPages() {
            return this.totalPages;
        }

        final void ConcurrentModification() {
            if (RowDataSet.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }

        private void checkPageNumber(int pageNumber) {
            if (pageNumber < 0 || pageNumber >= this.pageCount()) {
                throw new IllegalArgumentException(pageNumber + " out of page index [0, " + this.pageCount() + ")");
            }
        }

        private class Itr
        implements Iterator<DataSet> {
            int cursor = 0;

            private Itr() {
            }

            @Override
            public boolean hasNext() {
                return this.cursor < PaginatedRowDataSet.this.pageCount();
            }

            @Override
            public DataSet next() {
                PaginatedRowDataSet.this.ConcurrentModification();
                try {
                    DataSet next = PaginatedRowDataSet.this.getPage(this.cursor);
                    ++this.cursor;
                    return next;
                }
                catch (IndexOutOfBoundsException e) {
                    PaginatedRowDataSet.this.ConcurrentModification();
                    throw new NoSuchElementException();
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

