/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.http;

import com.landawn.abacus.exception.UncheckedIOException;
import com.landawn.abacus.http.ContentFormat;
import com.landawn.abacus.http.HttpHeaders;
import com.landawn.abacus.http.HttpMethod;
import com.landawn.abacus.http.HttpResponse;
import com.landawn.abacus.http.HttpSettings;
import com.landawn.abacus.http.HttpUtil;
import com.landawn.abacus.logging.Logger;
import com.landawn.abacus.logging.LoggerFactory;
import com.landawn.abacus.type.Type;
import com.landawn.abacus.util.BufferedReader;
import com.landawn.abacus.util.BufferedWriter;
import com.landawn.abacus.util.IOUtil;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Objectory;
import com.landawn.abacus.util.URLEncodedUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

public final class HttpClient {
    static final Logger logger = LoggerFactory.getLogger(HttpClient.class);
    public static final int DEFAULT_MAX_CONNECTION = 16;
    public static final int DEFAULT_CONNECTION_TIMEOUT = 8000;
    public static final int DEFAULT_READ_TIMEOUT = 16000;
    protected final String _url;
    protected final int _maxConnection;
    protected final long _connectionTimeoutInMillis;
    protected final long _readTimeoutInMillis;
    protected final HttpSettings _settings;
    protected final URL _netURL;
    protected final AtomicInteger _activeConnectionCounter;

    protected HttpClient(String url) {
        this(url, 16);
    }

    protected HttpClient(String url, int maxConnection) {
        this(url, maxConnection, 8000L, 16000L);
    }

    protected HttpClient(String url, int maxConnection, long connectionTimeoutInMillis, long readTimeoutInMillis) {
        this(url, maxConnection, connectionTimeoutInMillis, readTimeoutInMillis, null);
    }

    protected HttpClient(String url, int maxConnection, long connectionTimeoutInMillis, long readTimeoutInMillis, HttpSettings settings) throws UncheckedIOException {
        this(url, maxConnection, connectionTimeoutInMillis, readTimeoutInMillis, settings, new AtomicInteger(0));
    }

    protected HttpClient(String url, int maxConnection, long connectionTimeoutInMillis, long readTimeoutInMillis, HttpSettings settings, AtomicInteger sharedActiveConnectionCounter) {
        if (N.isNullOrEmpty(url)) {
            throw new IllegalArgumentException("url can't be null or empty");
        }
        if (maxConnection < 0 || connectionTimeoutInMillis < 0L || readTimeoutInMillis < 0L) {
            throw new IllegalArgumentException("maxConnection, connectionTimeoutInMillis or readTimeoutInMillis can't be less than 0: " + maxConnection + ", " + connectionTimeoutInMillis + ", " + readTimeoutInMillis);
        }
        this._url = url;
        this._maxConnection = maxConnection == 0 ? 16 : maxConnection;
        this._connectionTimeoutInMillis = connectionTimeoutInMillis == 0L ? 8000L : connectionTimeoutInMillis;
        this._readTimeoutInMillis = readTimeoutInMillis == 0L ? 16000L : readTimeoutInMillis;
        this._settings = settings == null ? HttpSettings.create() : settings;
        try {
            this._netURL = new URL(url);
        }
        catch (MalformedURLException e) {
            throw N.toRuntimeException(e);
        }
        this._activeConnectionCounter = sharedActiveConnectionCounter;
    }

    public static HttpClient create(String url) {
        return new HttpClient(url);
    }

    public static HttpClient create(String url, int maxConnection) {
        return new HttpClient(url, maxConnection);
    }

    public static HttpClient create(String url, long connectionTimeoutInMillis, long readTimeoutInMillis) {
        return new HttpClient(url, 16, connectionTimeoutInMillis, readTimeoutInMillis);
    }

    public static HttpClient create(String url, int maxConnection, long connectionTimeoutInMillis, long readTimeoutInMillis) {
        return new HttpClient(url, maxConnection, connectionTimeoutInMillis, readTimeoutInMillis);
    }

    public static HttpClient create(String url, int maxConnection, long connectionTimeoutInMillis, long readTimeoutInMillis, HttpSettings settings) throws UncheckedIOException {
        return new HttpClient(url, maxConnection, connectionTimeoutInMillis, readTimeoutInMillis, settings);
    }

    public static HttpClient create(String url, int maxConnection, long connectionTimeoutInMillis, long readTimeoutInMillis, HttpSettings settings, AtomicInteger sharedActiveConnectionCounter) {
        return new HttpClient(url, maxConnection, connectionTimeoutInMillis, readTimeoutInMillis, settings, sharedActiveConnectionCounter);
    }

    public String url() {
        return this._url;
    }

    public String get() throws UncheckedIOException {
        return this.get(String.class);
    }

    public String get(HttpSettings settings) throws UncheckedIOException {
        return this.get(String.class, settings);
    }

    public String get(Object queryParameters) throws UncheckedIOException {
        return this.get(String.class, queryParameters);
    }

    public String get(Object queryParameters, HttpSettings settings) throws UncheckedIOException {
        return this.get(String.class, queryParameters, settings);
    }

    public <T> T get(Class<T> resultClass) throws UncheckedIOException {
        return this.get(resultClass, null, this._settings);
    }

    public <T> T get(Class<T> resultClass, HttpSettings settings) throws UncheckedIOException {
        return this.get(resultClass, null, settings);
    }

    public <T> T get(Class<T> resultClass, Object queryParameters) throws UncheckedIOException {
        return this.get(resultClass, queryParameters, this._settings);
    }

    public <T> T get(Class<T> resultClass, Object queryParameters, HttpSettings settings) throws UncheckedIOException {
        return this.execute(resultClass, HttpMethod.GET, queryParameters, settings);
    }

    public String delete() throws UncheckedIOException {
        return this.delete(String.class);
    }

    public String delete(HttpSettings settings) throws UncheckedIOException {
        return this.delete(String.class, settings);
    }

    public String delete(Object queryParameters) throws UncheckedIOException {
        return this.delete(String.class, queryParameters);
    }

    public String delete(Object queryParameters, HttpSettings settings) throws UncheckedIOException {
        return this.delete(String.class, queryParameters, settings);
    }

    public <T> T delete(Class<T> resultClass) throws UncheckedIOException {
        return this.delete(resultClass, null, this._settings);
    }

    public <T> T delete(Class<T> resultClass, HttpSettings settings) throws UncheckedIOException {
        return this.delete(resultClass, null, settings);
    }

    public <T> T delete(Class<T> resultClass, Object queryParameters) throws UncheckedIOException {
        return this.delete(resultClass, queryParameters, this._settings);
    }

    public <T> T delete(Class<T> resultClass, Object queryParameters, HttpSettings settings) throws UncheckedIOException {
        return this.execute(resultClass, HttpMethod.DELETE, queryParameters, settings);
    }

    public String post(Object request) throws UncheckedIOException {
        return this.post(String.class, request);
    }

    public String post(Object request, HttpSettings settings) throws UncheckedIOException {
        return this.post(String.class, request, settings);
    }

    public <T> T post(Class<T> resultClass, Object request) throws UncheckedIOException {
        return this.post(resultClass, request, this._settings);
    }

    public <T> T post(Class<T> resultClass, Object request, HttpSettings settings) throws UncheckedIOException {
        return this.execute(resultClass, HttpMethod.POST, request, settings);
    }

    public String put(Object request) throws UncheckedIOException {
        return this.put(String.class, request);
    }

    public String put(Object request, HttpSettings settings) throws UncheckedIOException {
        return this.put(String.class, request, settings);
    }

    public <T> T put(Class<T> resultClass, Object request) throws UncheckedIOException {
        return this.put(resultClass, request, this._settings);
    }

    public <T> T put(Class<T> resultClass, Object request, HttpSettings settings) throws UncheckedIOException {
        return this.execute(resultClass, HttpMethod.PUT, request, settings);
    }

    public String execute(HttpMethod httpMethod, Object request) throws UncheckedIOException {
        return this.execute(String.class, httpMethod, request);
    }

    public String execute(HttpMethod httpMethod, Object request, HttpSettings settings) throws UncheckedIOException {
        return this.execute(String.class, httpMethod, request, settings);
    }

    public <T> T execute(Class<T> resultClass, HttpMethod httpMethod, Object request) throws UncheckedIOException {
        return this.execute(resultClass, httpMethod, request, this._settings);
    }

    public <T> T execute(Class<T> resultClass, HttpMethod httpMethod, Object request, HttpSettings settings) throws UncheckedIOException {
        return this.execute(resultClass, null, null, httpMethod, request, settings);
    }

    public void execute(File output, HttpMethod httpMethod, Object request, HttpSettings settings) throws UncheckedIOException {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(output);
            this.execute(os, httpMethod, request, settings);
        }
        catch (FileNotFoundException e) {
            try {
                throw new UncheckedIOException(e);
            }
            catch (Throwable throwable) {
                IOUtil.close(os);
                throw throwable;
            }
        }
        IOUtil.close(os);
    }

    public void execute(OutputStream output, HttpMethod httpMethod, Object request, HttpSettings settings) throws UncheckedIOException {
        this.execute(null, output, null, httpMethod, request, settings);
    }

    public void execute(Writer output, HttpMethod httpMethod, Object request, HttpSettings settings) throws UncheckedIOException {
        this.execute(null, null, output, httpMethod, request, settings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private <T> T execute(Class<T> resultClass, OutputStream outputStream, Writer outputWriter, HttpMethod httpMethod, Object request, HttpSettings settings) throws UncheckedIOException {
        ContentFormat respContentFormat;
        Charset respCharset;
        OutputStream os;
        InputStream is;
        HttpURLConnection connection;
        block59: {
            block58: {
                block57: {
                    block56: {
                        block55: {
                            Map<String, List<String>> respHeaders;
                            int code;
                            long sentRequestAtMillis;
                            block53: {
                                block52: {
                                    block51: {
                                        Charset requestCharset = HttpUtil.getRequestCharset(settings == null || settings.headers().isEmpty() ? this._settings.headers() : settings.headers());
                                        ContentFormat requestContentFormat = this.getContentFormat(settings);
                                        boolean doOutput = request != null && !httpMethod.equals((Object)HttpMethod.GET) && !httpMethod.equals((Object)HttpMethod.DELETE);
                                        connection = this.openConnection(httpMethod, request, doOutput, settings);
                                        sentRequestAtMillis = System.currentTimeMillis();
                                        is = null;
                                        os = null;
                                        if (request != null && this.requireBody(httpMethod)) {
                                            os = HttpUtil.getOutputStream(connection, requestContentFormat, this.getContentType(settings), this.getContentEncoding(settings));
                                            Type type = N.typeOf(request.getClass());
                                            if (request instanceof File) {
                                                try (FileInputStream fileInputStream = new FileInputStream((File)request);){
                                                    IOUtil.write(os, (InputStream)fileInputStream);
                                                }
                                            }
                                            if (type.isInputStream()) {
                                                IOUtil.write(os, (InputStream)request);
                                            } else {
                                                BufferedWriter bw;
                                                if (type.isReader()) {
                                                    bw = Objectory.createBufferedWriter(new OutputStreamWriter(os, requestCharset));
                                                    try {
                                                        IOUtil.write((Writer)bw, (Reader)request);
                                                        bw.flush();
                                                    }
                                                    finally {
                                                        Objectory.recycle(bw);
                                                    }
                                                }
                                                if (request instanceof String) {
                                                    IOUtil.write(os, ((String)request).getBytes(requestCharset));
                                                } else if (request.getClass().equals(byte[].class)) {
                                                    IOUtil.write(os, (byte[])request);
                                                } else if (requestContentFormat == ContentFormat.KRYO && HttpUtil.kryoParser != null) {
                                                    HttpUtil.kryoParser.serialize(os, request);
                                                } else if (requestContentFormat == ContentFormat.FormUrlEncoded) {
                                                    IOUtil.write(os, URLEncodedUtil.encode(request, requestCharset).getBytes(requestCharset));
                                                } else {
                                                    bw = Objectory.createBufferedWriter(new OutputStreamWriter(os, requestCharset));
                                                    try {
                                                        HttpUtil.getParser(requestContentFormat).serialize(bw, request);
                                                        bw.flush();
                                                    }
                                                    finally {
                                                        Objectory.recycle(bw);
                                                    }
                                                }
                                            }
                                            HttpUtil.flush(os);
                                        }
                                        code = connection.getResponseCode();
                                        respHeaders = connection.getHeaderFields();
                                        respCharset = HttpUtil.getResponseCharset(respHeaders, requestCharset);
                                        respContentFormat = HttpUtil.getResponseContentFormat(respHeaders, requestContentFormat);
                                        is = HttpUtil.getInputStream(connection, respContentFormat);
                                        if (!(code >= 200 && code < 300 || resultClass != null && resultClass.equals(HttpResponse.class))) {
                                            throw new UncheckedIOException(new IOException(code + ": " + connection.getResponseMessage() + ". " + IOUtil.readString(is, respCharset)));
                                        }
                                        if (!this.isOneWayRequest(settings)) break block51;
                                        T t = null;
                                        this.close(os, is, connection);
                                        return t;
                                    }
                                    if (outputStream == null) break block52;
                                    IOUtil.write(outputStream, is, true);
                                    T t = null;
                                    this.close(os, is, connection);
                                    return t;
                                }
                                if (outputWriter == null) break block53;
                                BufferedReader br = Objectory.createBufferedReader(new InputStreamReader(is, respCharset));
                                try {
                                    IOUtil.write(outputWriter, (Reader)br, true);
                                }
                                finally {
                                    Objectory.recycle(br);
                                }
                                T t = null;
                                this.close(os, is, connection);
                                return t;
                            }
                            if (resultClass == null || !resultClass.equals(HttpResponse.class)) break block55;
                            HttpResponse br = new HttpResponse(sentRequestAtMillis, System.currentTimeMillis(), code, connection.getResponseMessage(), respHeaders, IOUtil.readAllBytes(is), respContentFormat, respCharset);
                            this.close(os, is, connection);
                            return (T)br;
                        }
                        if (resultClass != null && !resultClass.equals(String.class)) break block56;
                        String br = IOUtil.readString(is, respCharset);
                        this.close(os, is, connection);
                        return (T)br;
                    }
                    if (!byte[].class.equals(resultClass)) break block57;
                    byte[] br = IOUtil.readAllBytes(is);
                    this.close(os, is, connection);
                    return (T)br;
                }
                if (respContentFormat != ContentFormat.KRYO || HttpUtil.kryoParser == null) break block58;
                Object br = HttpUtil.kryoParser.deserialize((Class)resultClass, is);
                this.close(os, is, connection);
                return (T)br;
            }
            if (respContentFormat != ContentFormat.FormUrlEncoded) break block59;
            T br = URLEncodedUtil.decode(resultClass, IOUtil.readString(is, respCharset));
            this.close(os, is, connection);
            return br;
        }
        BufferedReader br = Objectory.createBufferedReader(new InputStreamReader(is, respCharset));
        T t = HttpUtil.getParser(respContentFormat).deserialize(resultClass, br);
        Objectory.recycle(br);
        this.close(os, is, connection);
        return t;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        Objectory.recycle(br);
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                catch (Throwable throwable2) {
                    this.close(os, is, connection);
                    throw throwable2;
                }
            }
        }
    }

    protected boolean isOneWayRequest(HttpSettings settings) {
        return this._settings.isOneWayRequest() || settings != null && settings.isOneWayRequest();
    }

    protected ContentFormat getContentFormat(HttpSettings settings) {
        ContentFormat contentFormat = null;
        if (settings != null) {
            contentFormat = settings.getContentFormat();
        }
        if (contentFormat == null || contentFormat == ContentFormat.NONE) {
            contentFormat = this._settings.getContentFormat();
        }
        return contentFormat;
    }

    protected String getContentType(HttpSettings settings) {
        String contentType = null;
        if (settings != null) {
            contentType = settings.getContentType();
        }
        if (N.isNullOrEmpty(contentType)) {
            contentType = this._settings.getContentType();
        }
        return contentType;
    }

    protected String getContentEncoding(HttpSettings settings) {
        String contentEncoding = null;
        if (settings != null) {
            contentEncoding = settings.getContentEncoding();
        }
        if (N.isNullOrEmpty(contentEncoding)) {
            contentEncoding = this._settings.getContentEncoding();
        }
        return contentEncoding;
    }

    HttpURLConnection openConnection(HttpMethod httpMethod) throws UncheckedIOException {
        return this.openConnection(httpMethod, this.requireBody(httpMethod));
    }

    private boolean requireBody(HttpMethod httpMethod) {
        return HttpMethod.POST.equals((Object)httpMethod) || HttpMethod.PUT.equals((Object)httpMethod) || HttpMethod.PATCH.equals((Object)httpMethod);
    }

    HttpURLConnection openConnection(HttpMethod httpMethod, boolean doOutput) throws UncheckedIOException {
        return this.openConnection(httpMethod, doOutput, this._settings);
    }

    HttpURLConnection openConnection(HttpMethod httpMethod, HttpSettings settings) throws UncheckedIOException {
        return this.openConnection(httpMethod, this.requireBody(httpMethod), settings);
    }

    HttpURLConnection openConnection(HttpMethod httpMethod, boolean doOutput, HttpSettings settings) throws UncheckedIOException {
        return this.openConnection(httpMethod, null, doOutput, settings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HttpURLConnection openConnection(HttpMethod httpMethod, Object queryParameters, boolean doOutput, HttpSettings settings) throws UncheckedIOException {
        HttpURLConnection connection = null;
        if (this._activeConnectionCounter.incrementAndGet() > this._maxConnection) {
            this._activeConnectionCounter.decrementAndGet();
            throw new RuntimeException("Can not get connection, exceeded max connection number: " + this._maxConnection);
        }
        try {
            int readTimeoutInMillis;
            int connectionTimeoutInMillis;
            SSLSocketFactory ssf;
            URL uRL = this._netURL;
            synchronized (uRL) {
                connection = queryParameters != null && (httpMethod.equals((Object)HttpMethod.GET) || httpMethod.equals((Object)HttpMethod.DELETE)) ? (HttpURLConnection)new URL(URLEncodedUtil.encode(this._url, queryParameters)).openConnection() : (HttpURLConnection)this._netURL.openConnection();
            }
            if (connection instanceof HttpsURLConnection && (ssf = (settings == null ? this._settings : settings).getSSLSocketFactory()) != null) {
                ((HttpsURLConnection)connection).setSSLSocketFactory(ssf);
            }
            int n = connectionTimeoutInMillis = this._connectionTimeoutInMillis > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this._connectionTimeoutInMillis;
            if (settings != null) {
                connectionTimeoutInMillis = settings.getConnectionTimeout();
            }
            if (connectionTimeoutInMillis > 0) {
                connection.setConnectTimeout(connectionTimeoutInMillis);
            }
            int n2 = readTimeoutInMillis = this._readTimeoutInMillis > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this._readTimeoutInMillis;
            if (settings != null) {
                readTimeoutInMillis = settings.getReadTimeout();
            }
            if (readTimeoutInMillis > 0) {
                connection.setReadTimeout(readTimeoutInMillis);
            }
            if (settings != null) {
                connection.setDoInput(settings.doInput());
                connection.setDoOutput(settings.doOutput());
            }
            connection.setUseCaches(settings != null && settings.getUseCaches() || this._settings != null && this._settings.getUseCaches());
            this.setHttpProperties(connection, settings == null || settings.headers().isEmpty() ? this._settings : settings);
            if (this.isOneWayRequest(settings)) {
                connection.setDoInput(false);
            }
            connection.setDoOutput(doOutput);
            connection.setRequestMethod(httpMethod.name());
            return connection;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    void setHttpProperties(HttpURLConnection connection, HttpSettings settings) throws UncheckedIOException {
        HttpHeaders headers = settings.headers();
        if (headers != null) {
            Object headerValue = null;
            for (String headerName : headers.headerNameSet()) {
                if ("Content-Encoding".equalsIgnoreCase(headerName)) continue;
                headerValue = headers.get(headerName);
                connection.setRequestProperty(headerName, HttpHeaders.valueOf(headerValue));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(OutputStream os, InputStream is, HttpURLConnection connection) {
        try {
            IOUtil.closeQuietly(os);
            IOUtil.closeQuietly(is);
        }
        finally {
            this._activeConnectionCounter.decrementAndGet();
        }
    }

    public synchronized void close() {
    }

    static {
        if (!IOUtil.IS_PLATFORM_ANDROID) {
            int maxConnections = IOUtil.CPU_CORES * 16;
            System.setProperty("http.keepAlive", "true");
            System.setProperty("http.maxConnections", String.valueOf(maxConnections));
        }
    }
}

