/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.http;

import com.landawn.abacus.annotation.Beta;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.StringUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class HttpHeaders {
    final Map<String, Object> map;

    HttpHeaders() {
        this.map = new HashMap<String, Object>();
    }

    HttpHeaders(Map<String, ?> headers) {
        this.map = headers;
    }

    public static HttpHeaders create() {
        return new HttpHeaders();
    }

    public static HttpHeaders of(Map<String, ?> headers) {
        N.checkArgNotNull(headers);
        return new HttpHeaders(headers);
    }

    public static HttpHeaders copyOf(Map<String, ?> headers) {
        N.checkArgNotNull(headers);
        return new HttpHeaders(new HashMap(headers));
    }

    public static String valueOf(Object headerValue) {
        if (headerValue instanceof String) {
            return (String)headerValue;
        }
        if (headerValue instanceof Collection) {
            return StringUtil.join((Collection)headerValue, "; ");
        }
        return N.stringOf(headerValue);
    }

    public HttpHeaders setAccept(String value) {
        this.set("Accept", value);
        return this;
    }

    public HttpHeaders setAcceptEncoding(String acceptEncoding) {
        this.set("Accept-Encoding", acceptEncoding);
        return this;
    }

    public HttpHeaders setAcceptCharset(String acceptCharset) {
        this.set("Accept-Charset", acceptCharset);
        return this;
    }

    public HttpHeaders setAcceptLanguage(String acceptLanguage) {
        this.set("Accept-Language", acceptLanguage);
        return this;
    }

    public HttpHeaders setAcceptRanges(String acceptRanges) {
        this.set("Accept-Ranges", acceptRanges);
        return this;
    }

    public HttpHeaders setContentType(String contentType) {
        this.set("Content-Type", contentType);
        return this;
    }

    public HttpHeaders setContentEncoding(String acceptEncoding) {
        this.set("Content-Encoding", acceptEncoding);
        return this;
    }

    public HttpHeaders setContentLanguage(String acceptLanguage) {
        this.set("Content-Language", acceptLanguage);
        return this;
    }

    public HttpHeaders setContentLength(long contentLength) {
        this.set("Content-Length", contentLength);
        return this;
    }

    public HttpHeaders setUserAgent(String userAgent) {
        this.set("User-Agent", userAgent);
        return this;
    }

    public HttpHeaders setCookie(String cookie) {
        this.set("Cookie", cookie);
        return this;
    }

    public HttpHeaders setAuthorization(String value) {
        this.set("Authorization", value);
        return this;
    }

    public HttpHeaders setProxyAuthorization(String value) {
        this.set("Proxy-Authorization", value);
        return this;
    }

    public HttpHeaders setCacheControl(String value) {
        this.set("Cache-Control", value);
        return this;
    }

    public HttpHeaders setConnection(String value) {
        this.set("Connection", value);
        return this;
    }

    public HttpHeaders setHost(String value) {
        this.set("Host", value);
        return this;
    }

    public HttpHeaders setFrom(String value) {
        this.set("From", value);
        return this;
    }

    public HttpHeaders set(String name, Object value) {
        this.map.put(name, value);
        return this;
    }

    public HttpHeaders setAll(Map<? extends String, ? extends Object> m) {
        this.map.putAll(m);
        return this;
    }

    public Object get(String headerName) {
        return this.map.get(headerName);
    }

    public Object remove(String headerName) {
        return this.map.remove(headerName);
    }

    public Set<String> headerNameSet() {
        return this.map.keySet();
    }

    public void clear() {
        this.map.clear();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public HttpHeaders copy() {
        return new HttpHeaders().setAll(this.map);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof HttpHeaders && this.map.equals(((HttpHeaders)obj).map);
    }

    public String toString() {
        return this.map.toString();
    }

    public static final class ReferrerPolicyValues {
        public static final String NO_REFERRER = "no-referrer";
        public static final String NO_REFFERER_WHEN_DOWNGRADE = "no-referrer-when-downgrade";
        public static final String SAME_ORIGIN = "same-origin";
        public static final String ORIGIN = "origin";
        public static final String STRICT_ORIGIN = "strict-origin";
        public static final String ORIGIN_WHEN_CROSS_ORIGIN = "origin-when-cross-origin";
        public static final String STRICT_ORIGIN_WHEN_CROSS_ORIGIN = "strict-origin-when-cross-origin";
        public static final String UNSAFE_URL = "unsafe-url";

        private ReferrerPolicyValues() {
        }
    }

    public static final class Values {
        public static final String APPLICATION_URL_ENCODED = "application/x-www-form-urlencoded";
        public static final String APPLICATION_XML = "application/xml";
        public static final String APPLICATION_JSON = "application/json";
        public static final String APPLICATION_KRYO = "application/kryo";
        public static final String TEXT_HTML = "text/html";
        public static final String TEXT_JSON = "text/json";
        public static final String TEXT_XML = "text/xml";
        public static final String IMAGE_GIF = "image/gif";
        public static final String IMAGE_JPG = "image/jpg";
        public static final String UTF_8 = "UTF-8";

        private Values() {
        }
    }

    public static final class Names {
        public static final String CACHE_CONTROL = "Cache-Control";
        public static final String CONTENT_LENGTH = "Content-Length";
        public static final String CONTENT_TYPE = "Content-Type";
        public static final String CONTENT_ENCODING = "Content-Encoding";
        static final String L_CONTENT_TYPE = "content-type";
        static final String L_CONTENT_ENCODING = "content-encoding";
        public static final String DATE = "Date";
        public static final String PRAGMA = "Pragma";
        public static final String VIA = "Via";
        public static final String WARNING = "Warning";
        public static final String ACCEPT = "Accept";
        static final String L_ACCEPT = "accept";
        public static final String ACCEPT_ENCODING = "Accept-Encoding";
        static final String L_ACCEPT_ENCODING = "accept-encoding";
        public static final String ACCEPT_CHARSET = "Accept-Charset";
        static final String L_ACCEPT_CHARSET = "accept-charset";
        public static final String ACCEPT_LANGUAGE = "Accept-Language";
        public static final String ACCESS_CONTROL_REQUEST_HEADERS = "Access-Control-Request-Headers";
        public static final String ACCESS_CONTROL_REQUEST_METHOD = "Access-Control-Request-Method";
        public static final String AUTHORIZATION = "Authorization";
        public static final String CONNECTION = "Connection";
        public static final String COOKIE = "Cookie";
        public static final String EARLY_DATA = "Early-Data";
        public static final String EXPECT = "Expect";
        public static final String FROM = "From";
        public static final String FORWARDED = "Forwarded";
        @Beta
        public static final String FOLLOW_ONLY_WHEN_PRERENDER_SHOWN = "Follow-Only-When-Prerender-Shown";
        public static final String HOST = "Host";
        public static final String HTTP2_SETTINGS = "HTTP2-Settings";
        public static final String IF_MATCH = "If-Match";
        public static final String IF_MODIFIED_SINCE = "If-Modified-Since";
        public static final String IF_NONE_MATCH = "If-None-Match";
        public static final String IF_RANGE = "If-Range";
        public static final String IF_UNMODIFIED_SINCE = "If-Unmodified-Since";
        public static final String LAST_EVENT_ID = "Last-Event-ID";
        public static final String MAX_FORWARDS = "Max-Forwards";
        public static final String ORIGIN = "Origin";
        public static final String PROXY_AUTHORIZATION = "Proxy-Authorization";
        public static final String RANGE = "Range";
        public static final String REFERER = "Referer";
        public static final String REFERRER_POLICY = "Referrer-Policy";
        public static final String SERVICE_WORKER = "Service-Worker";
        public static final String TE = "TE";
        public static final String UPGRADE = "Upgrade";
        public static final String USER_AGENT = "User-Agent";
        public static final String ACCEPT_RANGES = "Accept-Ranges";
        public static final String ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";
        public static final String ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
        public static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
        public static final String ACCESS_CONTROL_ALLOW_CREDENTIALS = "Access-Control-Allow-Credentials";
        public static final String ACCESS_CONTROL_EXPOSE_HEADERS = "Access-Control-Expose-Headers";
        public static final String ACCESS_CONTROL_MAX_AGE = "Access-Control-Max-Age";
        public static final String AGE = "Age";
        public static final String ALLOW = "Allow";
        public static final String CONTENT_DISPOSITION = "Content-Disposition";
        public static final String CONTENT_LANGUAGE = "Content-Language";
        public static final String CONTENT_LOCATION = "Content-Location";
        public static final String CONTENT_MD5 = "Content-MD5";
        public static final String CONTENT_RANGE = "Content-Range";
        public static final String CONTENT_SECURITY_POLICY = "Content-Security-Policy";
        public static final String CONTENT_SECURITY_POLICY_REPORT_ONLY = "Content-Security-Policy-Report-Only";
        public static final String X_CONTENT_SECURITY_POLICY = "X-Content-Security-Policy";
        public static final String X_CONTENT_SECURITY_POLICY_REPORT_ONLY = "X-Content-Security-Policy-Report-Only";
        public static final String X_WEBKIT_CSP = "X-WebKit-CSP";
        public static final String X_WEBKIT_CSP_REPORT_ONLY = "X-WebKit-CSP-Report-Only";
        public static final String ETAG = "ETag";
        public static final String EXPIRES = "Expires";
        public static final String LAST_MODIFIED = "Last-Modified";
        public static final String LINK = "Link";
        public static final String LOCATION = "Location";
        public static final String P3P = "P3P";
        public static final String PROXY_AUTHENTICATE = "Proxy-Authenticate";
        public static final String REFRESH = "Refresh";
        public static final String RETRY_AFTER = "Retry-After";
        public static final String SERVER = "Server";
        public static final String SERVER_TIMING = "Server-Timing";
        public static final String SERVICE_WORKER_ALLOWED = "Service-Worker-Allowed";
        public static final String SET_COOKIE = "Set-Cookie";
        public static final String SET_COOKIE2 = "Set-Cookie2";
        public static final String STRICT_TRANSPORT_SECURITY = "Strict-Transport-Security";
        public static final String TIMING_ALLOW_ORIGIN = "Timing-Allow-Origin";
        public static final String TRAILER = "Trailer";
        public static final String TRANSFER_ENCODING = "Transfer-Encoding";
        public static final String VARY = "Vary";
        public static final String WWW_AUTHENTICATE = "WWW-Authenticate";
        public static final String DNT = "DNT";
        public static final String X_CONTENT_TYPE_OPTIONS = "X-Content-Type-Options";
        public static final String X_DO_NOT_TRACK = "X-Do-Not-Track";
        public static final String X_FORWARDED_FOR = "X-Forwarded-For";
        public static final String X_FORWARDED_PROTO = "X-Forwarded-Proto";
        public static final String X_FORWARDED_HOST = "X-Forwarded-Host";
        public static final String X_FORWARDED_PORT = "X-Forwarded-Port";
        public static final String X_FRAME_OPTIONS = "X-Frame-Options";
        public static final String X_POWERED_BY = "X-Powered-By";
        @Beta
        public static final String PUBLIC_KEY_PINS = "Public-Key-Pins";
        @Beta
        public static final String PUBLIC_KEY_PINS_REPORT_ONLY = "Public-Key-Pins-Report-Only";
        public static final String X_REQUESTED_WITH = "X-Requested-With";
        public static final String X_USER_IP = "X-User-IP";
        @Beta
        public static final String X_DOWNLOAD_OPTIONS = "X-Download-Options";
        public static final String X_XSS_PROTECTION = "X-XSS-Protection";
        public static final String X_DNS_PREFETCH_CONTROL = "X-DNS-Prefetch-Control";
        public static final String PING_FROM = "Ping-From";
        public static final String PING_TO = "Ping-To";
        public static final String SEC_METADATA = "Sec-Metadata";
        public static final String SEC_TOKEN_BINDING = "Sec-Token-Binding";
        public static final String SEC_PROVIDED_TOKEN_BINDING_ID = "Sec-Provided-Token-Binding-ID";
        public static final String SEC_REFERRED_TOKEN_BINDING_ID = "Sec-Referred-Token-Binding-ID";

        private Names() {
        }
    }
}

