/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.http;

import com.landawn.abacus.exception.UncheckedIOException;
import com.landawn.abacus.http.HttpClient;
import com.landawn.abacus.http.HttpHeaders;
import com.landawn.abacus.http.HttpMethod;
import com.landawn.abacus.http.HttpSettings;
import com.landawn.abacus.util.N;
import java.io.File;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Map;

public final class HttpRequest {
    final HttpClient httpClient;
    HttpMethod httpMethod;
    HttpSettings settings;
    Object request;

    HttpRequest(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public static HttpRequest create(HttpClient httpClient) {
        return new HttpRequest(httpClient);
    }

    public static HttpRequest url(String url) {
        return HttpRequest.url(url, 8000L, 16000L);
    }

    public static HttpRequest url(String url, long connectionTimeoutInMillis, long readTimeoutInMillis) {
        return new HttpRequest(HttpClient.create(url, 1, connectionTimeoutInMillis, readTimeoutInMillis));
    }

    public HttpRequest basicAuth(String user, Object password) {
        this.checkSettings();
        this.settings.basicAuth(user, password);
        return this;
    }

    public HttpRequest header(String name, Object value) {
        this.checkSettings();
        this.settings.header(name, value);
        return this;
    }

    public HttpRequest headers(String name1, Object value1, String name2, Object value2) {
        this.checkSettings();
        this.settings.headers(name1, value1, name2, value2);
        return this;
    }

    public HttpRequest headers(String name1, Object value1, String name2, Object value2, String name3, Object value3) {
        this.checkSettings();
        this.settings.headers(name1, value1, name2, value2, name3, value3);
        return this;
    }

    public HttpRequest headers(Map<String, ?> headers) {
        this.checkSettings();
        this.settings.headers(headers);
        return this;
    }

    public HttpRequest headers(HttpHeaders headers) {
        this.checkSettings();
        this.settings.headers(headers);
        return this;
    }

    public String get() throws UncheckedIOException {
        return this.get(String.class);
    }

    public <T> T get(Class<T> resultClass) throws UncheckedIOException {
        return this.get(resultClass, null);
    }

    public String get(Object query) {
        return this.get(String.class, query);
    }

    public <T> T get(Class<T> resultClass, Object query) throws UncheckedIOException {
        this.httpMethod = HttpMethod.GET;
        this.request = query;
        return this.execute(resultClass);
    }

    public String post(Object body) {
        return this.post(String.class, body);
    }

    public <T> T post(Class<T> resultClass, Object body) throws UncheckedIOException {
        this.httpMethod = HttpMethod.POST;
        this.request = body;
        return this.execute(resultClass);
    }

    public String put(Object body) throws UncheckedIOException {
        return this.put(String.class, body);
    }

    public <T> T put(Class<T> resultClass, Object body) throws UncheckedIOException {
        this.httpMethod = HttpMethod.PUT;
        this.request = body;
        return this.execute(resultClass);
    }

    public String delete() throws UncheckedIOException {
        return this.delete(String.class);
    }

    public <T> T delete(Class<T> resultClass) throws UncheckedIOException {
        return this.delete(resultClass, null);
    }

    public String delete(Object query) throws UncheckedIOException {
        return this.delete(String.class, query);
    }

    public <T> T delete(Class<T> resultClass, Object query) throws UncheckedIOException {
        this.httpMethod = HttpMethod.DELETE;
        this.request = query;
        return this.execute(resultClass);
    }

    public String execute(HttpMethod httpMethod) throws UncheckedIOException {
        return this.execute(String.class, httpMethod);
    }

    public <T> T execute(Class<T> resultClass, HttpMethod httpMethod) throws UncheckedIOException {
        return this.execute(resultClass, httpMethod, null);
    }

    public String execute(HttpMethod httpMethod, Object body) throws UncheckedIOException {
        return this.execute(String.class, httpMethod, body);
    }

    public <T> T execute(Class<T> resultClass, HttpMethod httpMethod, Object body) throws UncheckedIOException {
        N.checkArgNotNull(httpMethod, "httpMethod");
        this.httpMethod = httpMethod;
        this.request = body;
        return this.execute(resultClass);
    }

    public void execute(File output, HttpMethod httpMethod, Object body) throws UncheckedIOException {
        N.checkArgNotNull(httpMethod, "httpMethod");
        this.httpMethod = httpMethod;
        this.request = body;
        this.httpClient.execute(output, this.httpMethod, this.request, this.settings);
    }

    public void execute(OutputStream output, HttpMethod httpMethod, Object body) throws UncheckedIOException {
        N.checkArgNotNull(httpMethod, "httpMethod");
        this.httpMethod = httpMethod;
        this.request = body;
        this.httpClient.execute(output, this.httpMethod, this.request, this.settings);
    }

    public void execute(Writer output, HttpMethod httpMethod, Object body) throws UncheckedIOException {
        N.checkArgNotNull(httpMethod, "httpMethod");
        this.httpMethod = httpMethod;
        this.request = body;
        this.httpClient.execute(output, this.httpMethod, this.request, this.settings);
    }

    protected <T> T execute(Class<T> resultClass) {
        if (this.httpMethod == null) {
            throw new RuntimeException("HTTP method is not set");
        }
        return this.httpClient.execute(resultClass, this.httpMethod, this.request, this.settings);
    }

    protected void checkSettings() {
        if (this.settings == null) {
            this.settings = new HttpSettings();
        }
    }

    public HttpRequest connectionTimeout(int connectionTimeout) {
        this.checkSettings();
        this.settings.setConnectionTimeout(connectionTimeout);
        return this;
    }

    public HttpRequest readTimeout(int readTimeout) {
        this.checkSettings();
        this.settings.setReadTimeout(readTimeout);
        return this;
    }

    public HttpRequest useCaches(boolean useCaches) {
        this.checkSettings();
        this.settings.setUseCaches(useCaches);
        return this;
    }
}

