/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.http;

import com.landawn.abacus.http.ContentFormat;
import com.landawn.abacus.http.HttpUtil;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.URLEncodedUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;

public class HttpResponse {
    private final long sentRequestAtMillis;
    private final long receivedResponseAtMillis;
    private final int code;
    private final String message;
    private final Map<String, List<String>> headers;
    private final byte[] body;
    private final ContentFormat bodyFormat;
    private final Charset respCharset;

    HttpResponse(long sentRequestAtMillis, long receivedResponseAtMillis, int code, String message, Map<String, List<String>> headers, byte[] body, ContentFormat bodyFormat, Charset respCharset) {
        this.sentRequestAtMillis = sentRequestAtMillis;
        this.receivedResponseAtMillis = receivedResponseAtMillis;
        this.code = code;
        this.message = message;
        this.headers = headers;
        this.body = body;
        this.bodyFormat = bodyFormat == null ? ContentFormat.NONE : bodyFormat;
        this.respCharset = respCharset;
    }

    public boolean isSuccessful() {
        return this.code >= 200 && this.code < 300;
    }

    public long sentRequestAtMillis() {
        return this.sentRequestAtMillis;
    }

    public long receivedResponseAtMillis() {
        return this.receivedResponseAtMillis;
    }

    public int code() {
        return this.code;
    }

    public String message() {
        return this.message;
    }

    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public byte[] body() {
        return this.body;
    }

    public <T> T body(Class<T> resultClass) {
        N.checkArgNotNull(resultClass, "resultClass");
        if (resultClass == null || resultClass.equals(String.class)) {
            return (T)new String(this.body, this.respCharset);
        }
        if (byte[].class.equals(resultClass)) {
            return (T)this.body;
        }
        if (this.bodyFormat == ContentFormat.KRYO && HttpUtil.kryoParser != null) {
            return (T)HttpUtil.kryoParser.deserialize((Class)resultClass, (InputStream)new ByteArrayInputStream(this.body));
        }
        if (this.bodyFormat == ContentFormat.FormUrlEncoded) {
            return URLEncodedUtil.decode(resultClass, new String(this.body, this.respCharset));
        }
        return HttpUtil.getParser(this.bodyFormat).deserialize(resultClass, new String(this.body, this.respCharset));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.code;
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + (this.headers == null ? 0 : this.headers.hashCode());
        result = 31 * result + (this.bodyFormat == null ? 0 : this.bodyFormat.hashCode());
        result = 31 * result + (this.body == null ? 0 : N.hashCode(this.body));
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof HttpResponse) {
            HttpResponse other = (HttpResponse)obj;
            return this.code == other.code && N.equals(this.message, other.message) && N.equals(this.headers, other.headers) && N.equals((Object)this.bodyFormat, (Object)other.bodyFormat) && N.equals(this.body, other.body);
        }
        return false;
    }

    public String toString() {
        return "{sentRequestAtMillis=" + this.sentRequestAtMillis + ", receivedResponseAtMillis=" + this.receivedResponseAtMillis + ", code=" + this.code + ", message=" + this.message + ", headers=" + this.headers + ", bodyFormat=" + (Object)((Object)this.bodyFormat) + ", body=" + this.body(String.class) + "}";
    }
}

