/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.http;

import com.landawn.abacus.util.Enumerations;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Numbers;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class HttpServletRequestHeaderWrapper
extends HttpServletRequestWrapper {
    private final Map<String, String> headers = new HashMap<String, String>();
    private final HttpServletRequest _httpServletRequest;

    public HttpServletRequestHeaderWrapper(HttpServletRequest request) {
        super(request);
        this._httpServletRequest = request;
    }

    public void setHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public void setHeader(String name, Object value) {
        this.headers.put(name, N.stringOf(value));
    }

    public String getHeader(String name) {
        String value = this.headers.get(name);
        if (N.notNullOrEmpty(value)) {
            return value;
        }
        return this._httpServletRequest.getHeader(name);
    }

    public Enumeration<String> getHeaders(String name) {
        String value = this.headers.get(name);
        if (N.notNullOrEmpty(value)) {
            return Enumerations.just(value);
        }
        return this._httpServletRequest.getHeaders(name);
    }

    public Enumeration<String> getHeaderNames() {
        return Enumerations.concat(Enumerations.of(this.headers.keySet()), this._httpServletRequest.getHeaderNames());
    }

    public long getDateHeader(String name) {
        String value = this.headers.get(name);
        if (N.notNullOrEmpty(value)) {
            return Numbers.toLong(value);
        }
        return this._httpServletRequest.getDateHeader(name);
    }

    public int getIntHeader(String name) {
        String value = this.headers.get(name);
        if (N.notNullOrEmpty(value)) {
            return Numbers.toInt(value);
        }
        return this._httpServletRequest.getIntHeader(name);
    }
}

