/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.http;

import com.landawn.abacus.http.ContentFormat;
import com.landawn.abacus.http.HttpHeaders;
import com.landawn.abacus.http.HttpUtil;
import com.landawn.abacus.util.N;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;

public final class HttpSettings
implements Cloneable {
    private int connectionTimeout;
    private int readTimeout;
    private SSLSocketFactory sslSocketFactory;
    private boolean useCaches = false;
    private boolean doInput = true;
    private boolean doOutput = true;
    private boolean isOneWayRequest = false;
    private ContentFormat contentFormat;
    private HttpHeaders headers = null;

    public static HttpSettings create() {
        return new HttpSettings();
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public HttpSettings setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public HttpSettings setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public SSLSocketFactory getSSLSocketFactory() {
        return this.sslSocketFactory;
    }

    public HttpSettings setSSLSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
        return this;
    }

    public boolean getUseCaches() {
        return this.useCaches;
    }

    public HttpSettings setUseCaches(boolean useCaches) {
        this.useCaches = useCaches;
        return this;
    }

    public boolean doInput() {
        return this.doInput;
    }

    public HttpSettings doInput(boolean doInput) {
        this.doInput = doInput;
        return this;
    }

    public boolean doOutput() {
        return this.doOutput;
    }

    public HttpSettings doOutput(boolean doOutput) {
        this.doOutput = doOutput;
        return this;
    }

    public boolean isOneWayRequest() {
        return this.isOneWayRequest;
    }

    public HttpSettings isOneWayRequest(boolean isOneWayRequest) {
        this.isOneWayRequest = isOneWayRequest;
        return this;
    }

    public ContentFormat getContentFormat() {
        if ((this.contentFormat == null || this.contentFormat == ContentFormat.NONE) && this.headers != null) {
            this.contentFormat = HttpUtil.getContentFormat(HttpUtil.getContentType(this.headers), HttpUtil.getContentEncoding(this.headers));
        }
        return this.contentFormat;
    }

    public HttpSettings setContentFormat(ContentFormat contentFormat) {
        this.contentFormat = contentFormat;
        return this;
    }

    public HttpSettings setContentType(String contentType) {
        this.header("Content-Type", contentType);
        return this;
    }

    public String getContentType() {
        String contentType = HttpUtil.getContentType(this.headers);
        if (N.isNullOrEmpty(contentType) && this.contentFormat != null && N.notNullOrEmpty(contentType = HttpUtil.getContentType(this.contentFormat))) {
            this.header("Content-Type", contentType);
        }
        return contentType;
    }

    public HttpSettings setContentEncoding(String contentEncoding) {
        this.header("Content-Encoding", contentEncoding);
        return this;
    }

    public String getContentEncoding() {
        String contentEncoding = HttpUtil.getContentEncoding(this.headers);
        if (N.isNullOrEmpty(contentEncoding) && this.contentFormat != null && N.notNullOrEmpty(contentEncoding = HttpUtil.getContentEncoding(this.contentFormat))) {
            this.header("Content-Encoding", contentEncoding);
        }
        return contentEncoding;
    }

    public HttpSettings basicAuth(String user, Object password) {
        return this.header("Authorization", "Basic " + N.base64Encode((user + ":" + password).getBytes()));
    }

    public HttpSettings header(String name, Object value) {
        this.headers().set(name, value);
        return this;
    }

    public HttpSettings headers(String name1, Object value1, String name2, Object value2) {
        this.headers().set(name1, value1);
        this.headers().set(name2, value2);
        return this;
    }

    public HttpSettings headers(String name1, Object value1, String name2, Object value2, String name3, Object value3) {
        this.headers().set(name1, value1);
        this.headers().set(name2, value2);
        this.headers().set(name3, value3);
        return this;
    }

    public HttpSettings headers(Map<String, ?> headers) {
        this.headers().setAll(headers);
        return this;
    }

    public HttpSettings headers(HttpHeaders headers) {
        this.headers().clear();
        if (headers != null) {
            this.headers().setAll(headers.map);
        }
        return this;
    }

    public HttpHeaders headers() {
        if (this.headers == null) {
            this.headers = HttpHeaders.create();
        }
        return this.headers;
    }

    public HttpSettings copy() {
        return new HttpSettings().setConnectionTimeout(this.connectionTimeout).setReadTimeout(this.readTimeout).setSSLSocketFactory(this.sslSocketFactory).setUseCaches(this.useCaches).doInput(this.doInput).doOutput(this.doOutput).isOneWayRequest(this.isOneWayRequest).setContentFormat(this.contentFormat).headers(this.headers == null ? null : this.headers.copy());
    }

    public String toString() {
        return "{connectionTimeout=" + this.connectionTimeout + ", readTimeout=" + this.readTimeout + ", sslSocketFactory=" + this.sslSocketFactory + ", useCaches=" + this.useCaches + ", doInput=" + this.doInput + ", doOutput=" + this.doOutput + ", isOneWayRequest=" + this.isOneWayRequest + ", contentFormat=" + (Object)((Object)this.contentFormat) + ", headers=" + this.headers + "}";
    }
}

