/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.http;

import com.landawn.abacus.annotation.Internal;
import com.landawn.abacus.http.ContentFormat;
import com.landawn.abacus.http.HttpHeaders;
import com.landawn.abacus.http.HttpMethod;
import com.landawn.abacus.http.HttpSettings;
import com.landawn.abacus.http.Path;
import com.landawn.abacus.http.WebMethod;
import com.landawn.abacus.http.WebService;
import com.landawn.abacus.parser.DeserializationConfig;
import com.landawn.abacus.parser.JSONParser;
import com.landawn.abacus.parser.KryoParser;
import com.landawn.abacus.parser.Parser;
import com.landawn.abacus.parser.ParserFactory;
import com.landawn.abacus.parser.SerializationConfig;
import com.landawn.abacus.parser.XMLParser;
import com.landawn.abacus.util.Charsets;
import com.landawn.abacus.util.IOUtil;
import com.landawn.abacus.util.LZ4BlockOutputStream;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.ObjectPool;
import com.landawn.abacus.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

@Internal
public final class HttpUtil {
    public static final Charset DEFAULT_CHARSET = Charsets.UTF_8;
    public static final ContentFormat DEFAULT_CONTENT_FORMAT = ContentFormat.JSON;
    static final String JSON = "json";
    static final String XML = "xml";
    static final String GZIP = "gzip";
    static final String SNAPPY = "snappy";
    static final String LZ4 = "lz4";
    static final String KRYO = "kryo";
    static final String URL_ENCODED = "urlencoded";
    static final JSONParser jsonParser = ParserFactory.createJSONParser();
    static final XMLParser xmlParser = ParserFactory.isXMLAvailable() ? ParserFactory.createXMLParser() : null;
    static final KryoParser kryoParser = ParserFactory.isKryoAvailable() ? ParserFactory.createKryoParser() : null;
    private static final Map<ContentFormat, Parser<?, ?>> contentFormat2Parser = new EnumMap(ContentFormat.class);
    private static final Map<ContentFormat, String> contentFormat2Type;
    private static final Map<ContentFormat, String> contentFormat2Encoding;
    private static final Map<String, Map<String, ContentFormat>> contentTypeEncoding2Format;
    private static final String CHARSET_SEQUAL = "charset=";

    private HttpUtil() {
    }

    private static String readValue(Object value) {
        if (value != null) {
            if (value instanceof Collection) {
                return (String)N.firstOrNullIfEmpty((Collection)value);
            }
            return N.stringOf(value);
        }
        return null;
    }

    public static String getContentType(Map<String, ?> httpHeaders) {
        if (httpHeaders == null) {
            return null;
        }
        Object value = httpHeaders.get("Content-Type");
        if (value == null) {
            value = httpHeaders.get("content-type");
        }
        return HttpUtil.readValue(value);
    }

    public static String getContentType(HttpHeaders httpHeaders) {
        if (httpHeaders == null) {
            return null;
        }
        Object value = httpHeaders.get("Content-Type");
        if (value == null) {
            value = httpHeaders.get("content-type");
        }
        return HttpUtil.readValue(value);
    }

    public static String getContentType(HttpSettings httpSettings) {
        if (httpSettings == null || httpSettings.headers() == null) {
            return null;
        }
        return HttpUtil.getContentType(httpSettings.headers());
    }

    public static String getContentType(HttpURLConnection connection) {
        return HttpUtil.getContentType(connection.getHeaderFields());
    }

    public static String getContentEncoding(Map<String, ?> httpHeaders) {
        if (httpHeaders == null) {
            return null;
        }
        Object value = httpHeaders.get("Content-Encoding");
        if (value == null) {
            value = httpHeaders.get("content-encoding");
        }
        return HttpUtil.readValue(value);
    }

    public static String getContentEncoding(HttpHeaders httpHeaders) {
        if (httpHeaders == null) {
            return null;
        }
        Object value = httpHeaders.get("Content-Encoding");
        if (value == null) {
            value = httpHeaders.get("content-encoding");
        }
        return HttpUtil.readValue(value);
    }

    public static String getContentEncoding(HttpSettings httpSettings) {
        if (httpSettings == null || httpSettings.headers() == null) {
            return null;
        }
        return HttpUtil.getContentEncoding(httpSettings.headers());
    }

    public static String getContentEncoding(HttpURLConnection connection) {
        return HttpUtil.getContentEncoding(connection.getHeaderFields());
    }

    public static String getAccept(Map<String, ?> httpHeaders) {
        if (httpHeaders == null) {
            return null;
        }
        Object value = httpHeaders.get("Accept");
        if (value == null) {
            value = httpHeaders.get("accept");
        }
        return HttpUtil.readValue(value);
    }

    public static String getAccept(HttpHeaders httpHeaders) {
        if (httpHeaders == null) {
            return null;
        }
        Object value = httpHeaders.get("Accept");
        if (value == null) {
            value = httpHeaders.get("accept");
        }
        return HttpUtil.readValue(value);
    }

    public static String getAccept(HttpSettings httpSettings) {
        if (httpSettings == null || httpSettings.headers() == null) {
            return null;
        }
        return HttpUtil.getAccept(httpSettings.headers());
    }

    public static String getAccept(HttpURLConnection connection) {
        return HttpUtil.getAccept(connection.getHeaderFields());
    }

    public static String getAcceptEncoding(Map<String, ?> httpHeaders) {
        if (httpHeaders == null) {
            return null;
        }
        Object value = httpHeaders.get("Accept-Encoding");
        if (value == null) {
            value = httpHeaders.get("accept-encoding");
        }
        return HttpUtil.readValue(value);
    }

    public static String getAcceptEncoding(HttpHeaders httpHeaders) {
        if (httpHeaders == null) {
            return null;
        }
        Object value = httpHeaders.get("Accept-Encoding");
        if (value == null) {
            value = httpHeaders.get("accept-encoding");
        }
        return HttpUtil.readValue(value);
    }

    public static String getAcceptEncoding(HttpSettings httpSettings) {
        if (httpSettings == null || httpSettings.headers() == null) {
            return null;
        }
        return HttpUtil.getAcceptEncoding(httpSettings.headers());
    }

    public static String getAcceptEncoding(HttpURLConnection connection) {
        return HttpUtil.getAcceptEncoding(connection.getHeaderFields());
    }

    public static String getAcceptCharset(Map<String, ?> httpHeaders) {
        if (httpHeaders == null) {
            return null;
        }
        Object value = httpHeaders.get("Accept-Charset");
        if (value == null) {
            value = httpHeaders.get("accept-charset");
        }
        return HttpUtil.readValue(value);
    }

    public static String getAcceptCharset(HttpHeaders httpHeaders) {
        if (httpHeaders == null) {
            return null;
        }
        Object value = httpHeaders.get("Accept-Charset");
        if (value == null) {
            value = httpHeaders.get("accept-charset");
        }
        return HttpUtil.readValue(value);
    }

    public static String getAcceptCharset(HttpSettings httpSettings) {
        if (httpSettings == null || httpSettings.headers() == null) {
            return null;
        }
        return HttpUtil.getAcceptCharset(httpSettings.headers());
    }

    public static String getAcceptCharset(HttpURLConnection connection) {
        return HttpUtil.getAcceptCharset(connection.getHeaderFields());
    }

    public static String getContentType(ContentFormat contentFormat) {
        if (contentFormat == null || contentFormat == ContentFormat.NONE) {
            return null;
        }
        return contentFormat.contentType();
    }

    public static String getContentEncoding(ContentFormat contentFormat) {
        if (contentFormat == null || contentFormat == ContentFormat.NONE) {
            return null;
        }
        return contentFormat.contentEncoding();
    }

    public static ContentFormat getContentFormat(String contentType, String contentEncoding) {
        ContentFormat contentFormat;
        Map<String, ContentFormat> contentEncoding2Format;
        if (contentType == null) {
            contentType = N.EMPTY_STRING;
        }
        if (contentEncoding == null) {
            contentEncoding = N.EMPTY_STRING;
        }
        if ((contentEncoding2Format = contentTypeEncoding2Format.get(contentType)) == null) {
            if (StringUtil.containsIgnoreCase(contentType, "application/json")) {
                contentEncoding2Format = contentTypeEncoding2Format.get("application/json");
            } else if (StringUtil.containsIgnoreCase(contentType, "application/xml")) {
                contentEncoding2Format = contentTypeEncoding2Format.get("application/xml");
            } else if (StringUtil.containsIgnoreCase(contentType, "application/x-www-form-urlencoded")) {
                contentEncoding2Format = contentTypeEncoding2Format.get("application/x-www-form-urlencoded");
            } else if (StringUtil.containsIgnoreCase(contentType, "application/kryo")) {
                contentEncoding2Format = contentTypeEncoding2Format.get("application/kryo");
            }
        }
        if (contentEncoding2Format == null) {
            contentEncoding2Format = StringUtil.containsIgnoreCase(contentType, JSON) ? contentTypeEncoding2Format.get("application/json") : (StringUtil.containsIgnoreCase(contentType, XML) ? contentTypeEncoding2Format.get("application/xml") : (StringUtil.containsIgnoreCase(contentType, URL_ENCODED) ? contentTypeEncoding2Format.get("application/x-www-form-urlencoded") : (StringUtil.containsIgnoreCase(contentType, KRYO) ? contentTypeEncoding2Format.get("application/kryo") : contentTypeEncoding2Format.get(N.EMPTY_STRING))));
        }
        if ((contentFormat = contentEncoding2Format.get(contentEncoding)) == null) {
            contentFormat = StringUtil.containsIgnoreCase(contentEncoding, GZIP) ? contentEncoding2Format.get(GZIP) : (StringUtil.containsIgnoreCase(contentEncoding, SNAPPY) ? contentEncoding2Format.get(SNAPPY) : (StringUtil.containsIgnoreCase(contentEncoding, LZ4) ? contentEncoding2Format.get(LZ4) : (StringUtil.containsIgnoreCase(contentEncoding, KRYO) ? contentEncoding2Format.get(KRYO) : contentEncoding2Format.get(N.EMPTY_STRING))));
        }
        return contentFormat == null ? ContentFormat.NONE : contentFormat;
    }

    public static ContentFormat getContentFormat(HttpURLConnection connection) {
        return HttpUtil.getContentFormat(HttpUtil.getContentType(connection), HttpUtil.getContentEncoding(connection));
    }

    public static ContentFormat getResponseContentFormat(Map<String, ?> respHeaders, ContentFormat requestContentFormat) {
        String contentType = HttpUtil.getContentType(respHeaders);
        if (N.isNullOrEmpty(contentType) && requestContentFormat != null) {
            contentType = requestContentFormat.contentType();
        }
        String contentEncoding = HttpUtil.getContentEncoding(respHeaders);
        return HttpUtil.getContentFormat(contentType, contentEncoding);
    }

    public static <SC extends SerializationConfig<?>, DC extends DeserializationConfig<?>> Parser<SC, DC> getParser(ContentFormat contentFormat) {
        if (contentFormat == null) {
            return jsonParser;
        }
        Parser<?, ?> parser = contentFormat2Parser.get((Object)contentFormat);
        if (parser == null) {
            throw new IllegalArgumentException("Unsupported content format: " + (Object)((Object)contentFormat));
        }
        return parser;
    }

    public static InputStream wrapInputStream(InputStream is, ContentFormat contentFormat) {
        if (contentFormat == null || contentFormat == ContentFormat.NONE || is == null) {
            return is;
        }
        String contentFormatName = contentFormat.name();
        if (StringUtil.containsIgnoreCase(contentFormatName, GZIP)) {
            return IOUtil.newGZIPInputStream(is);
        }
        if (StringUtil.containsIgnoreCase(contentFormatName, SNAPPY)) {
            return IOUtil.newSnappyInputStream(is);
        }
        if (StringUtil.containsIgnoreCase(contentFormatName, LZ4)) {
            return IOUtil.newLZ4BlockInputStream(is);
        }
        return is;
    }

    public static OutputStream wrapOutputStream(OutputStream os, ContentFormat contentFormat) {
        if (contentFormat == null || contentFormat == ContentFormat.NONE || os == null) {
            return os;
        }
        String contentFormatName = contentFormat.name();
        if (StringUtil.containsIgnoreCase(contentFormatName, GZIP)) {
            return IOUtil.newGZIPOutputStream(os);
        }
        if (StringUtil.containsIgnoreCase(contentFormatName, SNAPPY)) {
            return IOUtil.newSnappyOutputStream(os);
        }
        if (StringUtil.containsIgnoreCase(contentFormatName, LZ4)) {
            return IOUtil.newLZ4BlockOutputStream(os);
        }
        return os;
    }

    public static OutputStream getOutputStream(HttpURLConnection connection, ContentFormat contentFormat, String contentType, String contentEncoding) throws IOException {
        if (N.isNullOrEmpty(contentType) && contentFormat != null) {
            contentType = HttpUtil.getContentType(contentFormat);
        }
        if (N.notNullOrEmpty(contentType)) {
            connection.setRequestProperty("Content-Type", contentType);
        }
        if (N.isNullOrEmpty(contentEncoding) && contentFormat != null) {
            contentEncoding = HttpUtil.getContentEncoding(contentFormat);
        }
        if (N.notNullOrEmpty(contentEncoding)) {
            connection.setRequestProperty("Content-Encoding", contentEncoding);
        }
        return HttpUtil.wrapOutputStream(connection.getOutputStream(), contentFormat);
    }

    public static InputStream getInputStream(HttpURLConnection connection, ContentFormat contentFormat) throws IOException {
        try {
            return N.defaultIfNull(HttpUtil.wrapInputStream(connection.getInputStream(), contentFormat), N.emptyInputStream());
        }
        catch (IOException e) {
            return N.defaultIfNull(connection.getErrorStream(), N.emptyInputStream());
        }
    }

    public static void flush(OutputStream os) throws IOException {
        if (os instanceof LZ4BlockOutputStream) {
            ((LZ4BlockOutputStream)os).finish();
        } else if (os instanceof GZIPOutputStream) {
            ((GZIPOutputStream)os).finish();
        }
        os.flush();
    }

    public static Charset getRequestCharset(HttpHeaders headers) {
        return HttpUtil.getCharset(HttpUtil.getContentType(headers), DEFAULT_CHARSET);
    }

    public static Charset getResponseCharset(Map<String, ?> headers, Charset requestCharset) {
        return HttpUtil.getCharset(HttpUtil.getContentType(headers), requestCharset);
    }

    public static Charset getCharset(String contentType) {
        return HttpUtil.getCharset(contentType, DEFAULT_CHARSET);
    }

    public static Charset getCharset(String contentType, Charset defaultIfNull) {
        if (N.isNullOrEmpty(contentType)) {
            return defaultIfNull;
        }
        int fromIndex = StringUtil.indexOfIgnoreCase(contentType, CHARSET_SEQUAL);
        if (fromIndex < 0) {
            return defaultIfNull;
        }
        int toIndex = contentType.indexOf(59, fromIndex);
        return Charsets.get(contentType.substring(fromIndex + CHARSET_SEQUAL.length(), toIndex > 0 ? toIndex : contentType.length()));
    }

    public static HttpMethod getHttpMethod(Method method) {
        Set<HttpMethod> httpMethods = HttpUtil.getHttpMethods(method);
        return N.firstOrNullIfEmpty(httpMethods);
    }

    public static Set<HttpMethod> getHttpMethods(Method method) {
        Class<? extends Annotation> annotationType;
        HashSet<HttpMethod> result = new HashSet<HttpMethod>();
        for (Annotation methodAnnotation : N.nullToEmpty(method.getAnnotations(), Annotation[].class)) {
            String methodAttr;
            if (methodAnnotation.annotationType() != WebMethod.class || !N.notNullOrEmpty(methodAttr = ((WebMethod)methodAnnotation).httpMethod())) continue;
            result.add(HttpMethod.valueOf(methodAttr.toUpperCase()));
        }
        for (Annotation methodAnnotation : N.nullToEmpty(method.getAnnotations(), Annotation[].class)) {
            annotationType = methodAnnotation.annotationType();
            for (Annotation innerAnnotation : annotationType.getAnnotations()) {
                if (WebService.HttpMethod.class != innerAnnotation.annotationType()) continue;
                result.add(HttpMethod.valueOf(((WebService.HttpMethod)innerAnnotation).value().toUpperCase()));
            }
        }
        try {
            for (Annotation methodAnnotation : N.nullToEmpty(method.getAnnotations(), Annotation[].class)) {
                annotationType = methodAnnotation.annotationType();
                for (Annotation innerAnnotation : annotationType.getAnnotations()) {
                    if (javax.ws.rs.HttpMethod.class != innerAnnotation.annotationType()) continue;
                    result.add(HttpMethod.valueOf(((javax.ws.rs.HttpMethod)innerAnnotation).value().toUpperCase()));
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }

    public static String getHttpPath(Method method) {
        return HttpUtil.getHttpPath(method.getAnnotations());
    }

    public static String getHttpPath(Annotation[] annotations) {
        String value;
        if (N.isNullOrEmpty(annotations)) {
            return null;
        }
        String result = null;
        for (Annotation methodAnnotation : annotations) {
            if (methodAnnotation.annotationType() != WebService.class || !N.notNullOrEmpty(value = ((WebService)methodAnnotation).path())) continue;
            result = value;
            break;
        }
        for (Annotation methodAnnotation : annotations) {
            if (methodAnnotation.annotationType() != WebMethod.class || !N.notNullOrEmpty(value = ((WebMethod)methodAnnotation).path())) continue;
            result = value;
            break;
        }
        block6: for (Annotation methodAnnotation : annotations) {
            Class<? extends Annotation> annotationType = methodAnnotation.annotationType();
            for (Annotation innerAnnotation : annotationType.getAnnotations()) {
                if (WebService.HttpMethod.class != innerAnnotation.annotationType()) continue;
                try {
                    String value2 = (String)annotationType.getMethod("value", new Class[0]).invoke((Object)methodAnnotation, new Object[0]);
                    if (!N.notNullOrEmpty(value2)) continue;
                    result = value2;
                    continue block6;
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    throw new RuntimeException("Failed to extract String 'value' from @%s annotation:" + annotationType.getSimpleName());
                }
            }
        }
        for (Annotation methodAnnotation : annotations) {
            if (methodAnnotation.annotationType() != Path.class || !N.notNullOrEmpty(value = ((Path)methodAnnotation).value())) continue;
            result = value;
            break;
        }
        try {
            for (Annotation methodAnnotation : annotations) {
                if (methodAnnotation.annotationType() != javax.ws.rs.Path.class || !N.notNullOrEmpty(value = ((javax.ws.rs.Path)methodAnnotation).value())) continue;
                result = value;
                break;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }

    public static ContentFormat getContentFormat(Annotation[] annotations, ContentFormat defaultContentFormat) {
        ContentFormat value;
        if (N.isNullOrEmpty(annotations)) {
            return defaultContentFormat;
        }
        ContentFormat result = null;
        for (Annotation methodAnnotation : annotations) {
            if (methodAnnotation.annotationType() != WebService.class || (value = ((WebService)methodAnnotation).contentFormat()) == null || value == ContentFormat.NONE) continue;
            result = value;
            break;
        }
        for (Annotation methodAnnotation : annotations) {
            if (methodAnnotation.annotationType() != WebMethod.class || (value = ((WebMethod)methodAnnotation).contentFormat()) == null || value == ContentFormat.NONE) continue;
            result = value;
            break;
        }
        return result == null || result == ContentFormat.NONE ? defaultContentFormat : result;
    }

    public static ContentFormat getAcceptFormat(Annotation[] annotations, ContentFormat defaultContentFormat) {
        ContentFormat value;
        if (N.isNullOrEmpty(annotations)) {
            return defaultContentFormat;
        }
        ContentFormat result = null;
        for (Annotation methodAnnotation : annotations) {
            if (methodAnnotation.annotationType() != WebService.class || (value = ((WebService)methodAnnotation).acceptFormat()) == null || value == ContentFormat.NONE) continue;
            result = value;
            break;
        }
        for (Annotation methodAnnotation : annotations) {
            if (methodAnnotation.annotationType() != WebMethod.class || (value = ((WebMethod)methodAnnotation).acceptFormat()) == null || value == ContentFormat.NONE) continue;
            result = value;
            break;
        }
        return result == null || result == ContentFormat.NONE ? defaultContentFormat : result;
    }

    public static Map<String, String> getHttpHeaders(Annotation[] annotations) {
        Object[] value;
        if (N.isNullOrEmpty(annotations)) {
            return null;
        }
        Map result = null;
        for (Annotation methodAnnotation : annotations) {
            if (methodAnnotation.annotationType() != WebService.class || !N.notNullOrEmpty(value = ((WebService)methodAnnotation).headers())) continue;
            result = N.asMap(value);
            break;
        }
        for (Annotation methodAnnotation : annotations) {
            if (methodAnnotation.annotationType() != WebMethod.class || !N.notNullOrEmpty(value = ((WebMethod)methodAnnotation).headers())) continue;
            result = N.asMap(value);
            break;
        }
        return result;
    }

    @Deprecated
    public static void turnOffCertificateValidation() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HostnameVerifier allHostsValid = new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        contentFormat2Parser.put(ContentFormat.JSON, jsonParser);
        contentFormat2Parser.put(ContentFormat.JSON_LZ4, jsonParser);
        contentFormat2Parser.put(ContentFormat.JSON_SNAPPY, jsonParser);
        contentFormat2Parser.put(ContentFormat.JSON_GZIP, jsonParser);
        contentFormat2Parser.put(ContentFormat.XML, xmlParser);
        contentFormat2Parser.put(ContentFormat.XML_LZ4, xmlParser);
        contentFormat2Parser.put(ContentFormat.XML_SNAPPY, xmlParser);
        contentFormat2Parser.put(ContentFormat.XML_GZIP, xmlParser);
        contentFormat2Parser.put(ContentFormat.FormUrlEncoded, jsonParser);
        contentFormat2Parser.put(ContentFormat.KRYO, kryoParser);
        contentFormat2Parser.put(ContentFormat.NONE, jsonParser);
        contentFormat2Parser.put(ContentFormat.LZ4, jsonParser);
        contentFormat2Parser.put(ContentFormat.SNAPPY, jsonParser);
        contentFormat2Parser.put(ContentFormat.GZIP, jsonParser);
        contentFormat2Type = new EnumMap<ContentFormat, String>(ContentFormat.class);
        contentFormat2Type.put(ContentFormat.JSON, "application/json");
        contentFormat2Type.put(ContentFormat.JSON_LZ4, "application/json");
        contentFormat2Type.put(ContentFormat.JSON_SNAPPY, "application/json");
        contentFormat2Type.put(ContentFormat.JSON_GZIP, "application/json");
        contentFormat2Type.put(ContentFormat.XML, "application/xml");
        contentFormat2Type.put(ContentFormat.XML_LZ4, "application/xml");
        contentFormat2Type.put(ContentFormat.XML_SNAPPY, "application/xml");
        contentFormat2Type.put(ContentFormat.XML_GZIP, "application/xml");
        contentFormat2Type.put(ContentFormat.FormUrlEncoded, "application/x-www-form-urlencoded");
        contentFormat2Type.put(ContentFormat.KRYO, "application/kryo");
        contentFormat2Encoding = new EnumMap<ContentFormat, String>(ContentFormat.class);
        contentFormat2Encoding.put(ContentFormat.XML_GZIP, GZIP);
        contentFormat2Encoding.put(ContentFormat.XML_SNAPPY, SNAPPY);
        contentFormat2Encoding.put(ContentFormat.XML_LZ4, LZ4);
        contentFormat2Encoding.put(ContentFormat.JSON_GZIP, GZIP);
        contentFormat2Encoding.put(ContentFormat.JSON_SNAPPY, SNAPPY);
        contentFormat2Encoding.put(ContentFormat.JSON_LZ4, LZ4);
        contentFormat2Encoding.put(ContentFormat.GZIP, GZIP);
        contentFormat2Encoding.put(ContentFormat.SNAPPY, SNAPPY);
        contentFormat2Encoding.put(ContentFormat.LZ4, LZ4);
        contentFormat2Encoding.put(ContentFormat.KRYO, KRYO);
        contentTypeEncoding2Format = new ObjectPool<String, Map<String, ContentFormat>>(64);
        for (Map.Entry<ContentFormat, String> entry : contentFormat2Type.entrySet()) {
            Map<String, ContentFormat> contentEncoding2Format = contentTypeEncoding2Format.get(entry.getValue());
            if (contentEncoding2Format == null) {
                contentEncoding2Format = new HashMap<String, ContentFormat>();
                contentTypeEncoding2Format.put(entry.getValue(), contentEncoding2Format);
            }
            if (StringUtil.containsIgnoreCase(entry.getKey().name(), GZIP)) {
                contentEncoding2Format.put(GZIP, entry.getKey());
                continue;
            }
            if (StringUtil.containsIgnoreCase(entry.getKey().name(), SNAPPY)) {
                contentEncoding2Format.put(SNAPPY, entry.getKey());
                continue;
            }
            if (StringUtil.containsIgnoreCase(entry.getKey().name(), LZ4)) {
                contentEncoding2Format.put(LZ4, entry.getKey());
                continue;
            }
            if (StringUtil.containsIgnoreCase(entry.getKey().name(), KRYO)) {
                contentEncoding2Format.put(KRYO, entry.getKey());
                contentEncoding2Format.put(N.EMPTY_STRING, entry.getKey());
                continue;
            }
            contentEncoding2Format.put(N.EMPTY_STRING, entry.getKey());
        }
        Map<String, ContentFormat> contentEncoding2Format = contentTypeEncoding2Format.get(N.EMPTY_STRING);
        if (contentEncoding2Format == null) {
            contentEncoding2Format = new HashMap<String, ContentFormat>();
            contentTypeEncoding2Format.put(N.EMPTY_STRING, contentEncoding2Format);
        }
        contentEncoding2Format.put(GZIP, ContentFormat.GZIP);
        contentEncoding2Format.put(SNAPPY, ContentFormat.SNAPPY);
        contentEncoding2Format.put(LZ4, ContentFormat.LZ4);
        contentEncoding2Format.put(KRYO, ContentFormat.KRYO);
        contentEncoding2Format.put(N.EMPTY_STRING, ContentFormat.NONE);
    }
}

