/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.http.okhttp;

import com.landawn.abacus.http.ContentFormat;
import com.landawn.abacus.http.HttpHeaders;
import com.landawn.abacus.http.HttpMethod;
import com.landawn.abacus.http.HttpResponse;
import com.landawn.abacus.http.HttpUtil;
import com.landawn.abacus.logging.Logger;
import com.landawn.abacus.logging.LoggerFactory;
import com.landawn.abacus.parser.KryoParser;
import com.landawn.abacus.parser.ParserFactory;
import com.landawn.abacus.parser.ParserUtil;
import com.landawn.abacus.parser.XMLParser;
import com.landawn.abacus.util.AndroidUtil;
import com.landawn.abacus.util.BufferedReader;
import com.landawn.abacus.util.ClassUtil;
import com.landawn.abacus.util.IOUtil;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Objectory;
import com.landawn.abacus.util.URLEncodedUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import okhttp3.CacheControl;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.internal.Util;

public final class OkHttpRequest {
    private static final Logger logger = LoggerFactory.getLogger(OkHttpRequest.class);
    private static final MediaType APPLICATION_JSON_MEDIA_TYPE = MediaType.get((String)"application/json");
    private static final Executor DEFAULT_EXECUTOR = IOUtil.IS_PLATFORM_ANDROID ? AndroidUtil.getThreadPoolExecutor() : new ThreadPoolExecutor(Math.max(64, Math.min(IOUtil.CPU_CORES * 8, IOUtil.MAX_MEMORY_IN_MB / 1024) * 32), Math.max(256, IOUtil.MAX_MEMORY_IN_MB / 1024 * 64), 180L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    static final XMLParser xmlParser = ParserFactory.isXMLAvailable() ? ParserFactory.createXMLParser() : null;
    static final KryoParser kryoParser = ParserFactory.isKryoAvailable() ? ParserFactory.createKryoParser() : null;
    static final OkHttpClient defaultClient = new OkHttpClient();
    OkHttpClient httpClient;
    final Request.Builder builder = new Request.Builder();
    RequestBody body;
    Request request;

    OkHttpRequest(OkHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public static OkHttpRequest create(String url, OkHttpClient httpClient) {
        OkHttpRequest okHttpRequest = new OkHttpRequest(httpClient);
        okHttpRequest.builder.url(url);
        return okHttpRequest;
    }

    public static OkHttpRequest create(URL url, OkHttpClient httpClient) {
        OkHttpRequest okHttpRequest = new OkHttpRequest(httpClient);
        okHttpRequest.builder.url(url);
        return okHttpRequest;
    }

    public static OkHttpRequest create(HttpUrl url, OkHttpClient httpClient) {
        OkHttpRequest okHttpRequest = new OkHttpRequest(httpClient);
        okHttpRequest.builder.url(url);
        return okHttpRequest;
    }

    public static OkHttpRequest url(String url) {
        return OkHttpRequest.create(url, defaultClient);
    }

    public static OkHttpRequest url(URL url) {
        return OkHttpRequest.create(url, defaultClient);
    }

    public static OkHttpRequest url(HttpUrl url) {
        return OkHttpRequest.create(url, defaultClient);
    }

    public static OkHttpRequest url(String url, long connectionTimeoutInMillis, long readTimeoutInMillis) {
        return OkHttpRequest.create(url, new OkHttpClient.Builder().connectTimeout(connectionTimeoutInMillis, TimeUnit.MILLISECONDS).readTimeout(readTimeoutInMillis, TimeUnit.MILLISECONDS).build());
    }

    public static OkHttpRequest url(URL url, long connectionTimeoutInMillis, long readTimeoutInMillis) {
        return OkHttpRequest.create(url, new OkHttpClient.Builder().connectTimeout(connectionTimeoutInMillis, TimeUnit.MILLISECONDS).readTimeout(readTimeoutInMillis, TimeUnit.MILLISECONDS).build());
    }

    public static OkHttpRequest url(HttpUrl url, long connectionTimeoutInMillis, long readTimeoutInMillis) {
        return OkHttpRequest.create(url, new OkHttpClient.Builder().connectTimeout(connectionTimeoutInMillis, TimeUnit.MILLISECONDS).readTimeout(readTimeoutInMillis, TimeUnit.MILLISECONDS).build());
    }

    public OkHttpRequest cacheControl(CacheControl cacheControl) {
        this.builder.cacheControl(cacheControl);
        return this;
    }

    public OkHttpRequest tag(@Nullable Object tag) {
        this.builder.tag(tag);
        return this;
    }

    public <T> OkHttpRequest tag(Class<? super T> type, @Nullable T tag) {
        this.builder.tag(type, tag);
        return this;
    }

    public OkHttpRequest basicAuth(String user, Object password) {
        this.builder.header("Authorization", "Basic " + N.base64Encode((user + ":" + password).getBytes()));
        return this;
    }

    public OkHttpRequest header(String name, String value) {
        this.builder.header(name, value);
        return this;
    }

    public OkHttpRequest headers(String name1, String value1, String name2, String value2) {
        this.builder.header(name1, value1);
        this.builder.header(name2, value2);
        return this;
    }

    public OkHttpRequest headers(String name1, String value1, String name2, String value2, String name3, String value3) {
        this.builder.header(name1, value1);
        this.builder.header(name2, value2);
        this.builder.header(name3, value3);
        return this;
    }

    public OkHttpRequest headers(Map<String, ?> headers) {
        if (N.notNullOrEmpty(headers)) {
            for (Map.Entry<String, ?> entry : headers.entrySet()) {
                this.builder.header(entry.getKey(), HttpHeaders.valueOf(entry.getValue()));
            }
        }
        return this;
    }

    public OkHttpRequest headers(Headers headers) {
        this.builder.headers(headers);
        return this;
    }

    @Deprecated
    public OkHttpRequest addHeader(String name, String value) {
        this.builder.addHeader(name, value);
        return this;
    }

    @Deprecated
    public OkHttpRequest removeHeader(String name) {
        this.builder.removeHeader(name);
        return this;
    }

    public OkHttpRequest jsonBody(String json) {
        return this.body(json, APPLICATION_JSON_MEDIA_TYPE);
    }

    public OkHttpRequest jsonBody(Object obj) {
        return this.body(N.toJSON(obj), APPLICATION_JSON_MEDIA_TYPE);
    }

    public OkHttpRequest formBody(Map<?, ?> formBodyByMap) {
        if (N.isNullOrEmpty(formBodyByMap)) {
            this.body = Util.EMPTY_REQUEST;
            return this;
        }
        FormBody.Builder builder = new FormBody.Builder();
        for (Map.Entry<?, ?> entry : formBodyByMap.entrySet()) {
            builder.add(N.stringOf(entry.getKey()), N.stringOf(entry.getValue()));
        }
        this.body = builder.build();
        return this;
    }

    public OkHttpRequest formBody(Object formBodyByEntity) {
        if (formBodyByEntity == null) {
            this.body = Util.EMPTY_REQUEST;
            return this;
        }
        Class<?> cls = formBodyByEntity.getClass();
        N.checkArgument(ClassUtil.isEntity(cls), "{} is not an entity class with getter/setter methods", cls);
        ParserUtil.EntityInfo entityInfo = ParserUtil.getEntityInfo(cls);
        FormBody.Builder builder = new FormBody.Builder();
        for (ParserUtil.PropInfo propInfo : entityInfo.propInfoList) {
            builder.add(propInfo.name, N.stringOf(propInfo.getPropValue(formBodyByEntity)));
        }
        this.body = builder.build();
        return this;
    }

    @Deprecated
    public OkHttpRequest body(Map<?, ?> formBodyByMap) {
        return this.formBody(formBodyByMap);
    }

    @Deprecated
    public OkHttpRequest body(Object formBodyByEntity) {
        return this.formBody(formBodyByEntity);
    }

    public OkHttpRequest body(RequestBody body) {
        this.body = body;
        return this;
    }

    public OkHttpRequest body(String content, @Nullable MediaType contentType) {
        this.body = RequestBody.create((MediaType)contentType, (String)content);
        return this;
    }

    public OkHttpRequest body(byte[] content, @Nullable MediaType contentType) {
        this.body = RequestBody.create((MediaType)contentType, (byte[])content);
        return this;
    }

    public OkHttpRequest body(byte[] content, int offset, int byteCount, @Nullable MediaType contentType) {
        this.body = RequestBody.create((MediaType)contentType, (byte[])content, (int)offset, (int)byteCount);
        return this;
    }

    public OkHttpRequest body(File content, @Nullable MediaType contentType) {
        this.body = RequestBody.create((MediaType)contentType, (File)content);
        return this;
    }

    public Response get() throws IOException {
        return this.execute(HttpMethod.GET);
    }

    public <T> T get(Class<T> resultClass) throws IOException {
        return this.execute(resultClass, HttpMethod.GET);
    }

    public Response post() throws IOException {
        return this.execute(HttpMethod.POST);
    }

    public <T> T post(Class<T> resultClass) throws IOException {
        return this.execute(resultClass, HttpMethod.POST);
    }

    public Response put() throws IOException {
        return this.execute(HttpMethod.PUT);
    }

    public <T> T put(Class<T> resultClass) throws IOException {
        return this.execute(resultClass, HttpMethod.PUT);
    }

    public Response patch() throws IOException {
        return this.execute(HttpMethod.PATCH);
    }

    public <T> T patch(Class<T> resultClass) throws IOException {
        return this.execute(resultClass, HttpMethod.PATCH);
    }

    public Response delete() throws IOException {
        return this.execute(HttpMethod.DELETE);
    }

    public <T> T delete(Class<T> resultClass) throws IOException {
        return this.execute(resultClass, HttpMethod.DELETE);
    }

    public Response head() throws IOException {
        return this.execute(HttpMethod.HEAD);
    }

    public Response execute(HttpMethod httpMethod) throws IOException {
        this.request = this.builder.method(httpMethod.name(), this.body).build();
        return this.httpClient.newCall(this.request).execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> T execute(Class<T> resultClass, HttpMethod httpMethod) throws IOException {
        N.checkArgNotNull(resultClass, "resultClass");
        N.checkArgument(!HttpResponse.class.equals(resultClass), "Return type can't be HttpResponse");
        Throwable throwable = null;
        try (Response resp = this.execute(httpMethod);){
            T t;
            if (!resp.isSuccessful()) throw new IOException(resp.code() + ": " + resp.message());
            String contentType = this.request.header("Content-Type");
            String contentEncoding = this.request.header("Content-Encoding");
            ContentFormat requestContentFormat = HttpUtil.getContentFormat(contentType, contentEncoding);
            Charset requestCharset = HttpUtil.getCharset(contentType);
            Map respHeaders = resp.headers().toMultimap();
            Charset respCharset = HttpUtil.getResponseCharset(respHeaders, requestCharset);
            ContentFormat respContentFormat = HttpUtil.getResponseContentFormat(respHeaders, requestContentFormat);
            InputStream is = HttpUtil.wrapInputStream(resp.body().byteStream(), respContentFormat);
            if (resultClass == null || resultClass.equals(String.class)) {
                String string = IOUtil.readString(is, respCharset);
                return (T)string;
            }
            if (byte[].class.equals(resultClass)) {
                byte[] byArray = IOUtil.readAllBytes(is);
                return (T)byArray;
            }
            if (respContentFormat == ContentFormat.KRYO && kryoParser != null) {
                Object object = kryoParser.deserialize((Class)resultClass, is);
                return (T)object;
            }
            if (respContentFormat == ContentFormat.FormUrlEncoded) {
                T t2 = URLEncodedUtil.decode(resultClass, IOUtil.readString(is, respCharset));
                return t2;
            }
            BufferedReader br = Objectory.createBufferedReader(new InputStreamReader(is, respCharset));
            try {
                t = HttpUtil.getParser(respContentFormat).deserialize(resultClass, br);
            }
            catch (Throwable throwable2) {
                try {
                    Objectory.recycle(br);
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            Objectory.recycle(br);
            return t;
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (DEFAULT_EXECUTOR instanceof ExecutorService) {
                    ExecutorService executorService = (ExecutorService)DEFAULT_EXECUTOR;
                    logger.warn("Starting to shutdown task in OkHttpRequest");
                    try {
                        executorService.shutdown();
                        executorService.awaitTermination(60L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException e) {
                        logger.warn("Not all the requests/tasks executed in OkHttpRequest are completed successfully before shutdown.");
                    }
                    finally {
                        logger.warn("Completed to shutdown task in OkHttpRequest");
                    }
                }
            }
        });
    }
}

