/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.logging;

import android.util.Log;
import com.landawn.abacus.logging.AbstractLogger;
import com.landawn.abacus.util.N;

class AndroidLogger
extends AbstractLogger {
    private static final int MAX_TAG_SIZE = 23;

    public AndroidLogger(String name) {
        super(name.startsWith("com.landawn.abacus") ? "Abacus" : (name.length() > 23 ? name.substring(N.max(name.length() - 23, name.lastIndexOf(46) + 1)) : name));
        try {
            Class.forName("android.util.Log");
        }
        catch (Throwable e) {
            throw N.toRuntimeException(e);
        }
    }

    @Override
    public boolean isTraceEnabled() {
        return Log.isLoggable((String)this.name, (int)2);
    }

    @Override
    public void trace(String msg) {
        Log.v((String)this.name, (String)msg);
    }

    @Override
    public void trace(String msg, Throwable t) {
        Log.v((String)this.name, (String)msg, (Throwable)t);
    }

    @Override
    public boolean isDebugEnabled() {
        return Log.isLoggable((String)this.name, (int)3);
    }

    @Override
    public void debug(String msg) {
        Log.d((String)this.name, (String)msg);
    }

    @Override
    public void debug(String msg, Throwable t) {
        Log.d((String)this.name, (String)msg, (Throwable)t);
    }

    @Override
    public boolean isInfoEnabled() {
        return Log.isLoggable((String)this.name, (int)4);
    }

    @Override
    public void info(String msg) {
        Log.i((String)this.name, (String)msg);
    }

    @Override
    public void info(String msg, Throwable t) {
        Log.i((String)this.name, (String)msg, (Throwable)t);
    }

    @Override
    public boolean isWarnEnabled() {
        return Log.isLoggable((String)this.name, (int)5);
    }

    @Override
    public void warn(String msg) {
        Log.w((String)this.name, (String)msg);
    }

    @Override
    public void warn(String msg, Throwable t) {
        Log.w((String)this.name, (String)msg, (Throwable)t);
    }

    @Override
    public boolean isErrorEnabled() {
        return Log.isLoggable((String)this.name, (int)6);
    }

    @Override
    public void error(String msg) {
        Log.e((String)this.name, (String)msg);
    }

    @Override
    public void error(String msg, Throwable t) {
        Log.e((String)this.name, (String)msg, (Throwable)t);
    }
}

