/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.logging;

import com.landawn.abacus.logging.AbstractLogger;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

class JDKLogger
extends AbstractLogger {
    static final String SELF = JDKLogger.class.getName();
    static final String SUPER = AbstractLogger.class.getName();
    private final Logger loggerImpl;

    public JDKLogger(String name) {
        super(name);
        this.loggerImpl = Logger.getLogger(name);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.loggerImpl.isLoggable(Level.FINEST);
    }

    @Override
    public void trace(String msg) {
        this.log(Level.FINEST, msg);
    }

    @Override
    public void trace(String msg, Throwable t) {
        this.log(Level.FINEST, msg, t);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.loggerImpl.isLoggable(Level.FINE);
    }

    @Override
    public void debug(String msg) {
        this.log(Level.FINE, msg);
    }

    @Override
    public void debug(String msg, Throwable t) {
        this.log(Level.FINE, msg, t);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.loggerImpl.isLoggable(Level.INFO);
    }

    @Override
    public void info(String msg) {
        this.log(Level.INFO, msg);
    }

    @Override
    public void info(String msg, Throwable t) {
        this.log(Level.INFO, msg, t);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.loggerImpl.isLoggable(Level.WARNING);
    }

    @Override
    public void warn(String msg) {
        this.log(Level.WARNING, msg);
    }

    @Override
    public void warn(String msg, Throwable t) {
        this.log(Level.WARNING, msg, t);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.loggerImpl.isLoggable(Level.SEVERE);
    }

    @Override
    public void error(String msg) {
        this.log(Level.SEVERE, msg);
    }

    @Override
    public void error(String msg, Throwable t) {
        this.log(Level.SEVERE, msg, t);
    }

    private void log(Level level, String msg) {
        this.log(SELF, level, msg, null);
    }

    private void log(Level level, String msg, Throwable t) {
        this.log(SELF, level, msg, t);
    }

    private void log(String callerFQCN, Level level, String msg, Throwable t) {
        LogRecord record = new LogRecord(level, msg);
        record.setLoggerName(this.getName());
        record.setThrown(t);
        JDKLogger.fillCallerData(callerFQCN, record);
        this.loggerImpl.log(record);
    }

    private static void fillCallerData(String callerFQCN, LogRecord record) {
        StackTraceElement[] steArray = new Throwable().getStackTrace();
        int selfIndex = -1;
        for (int i = 0; i < steArray.length; ++i) {
            String className = steArray[i].getClassName();
            if (!className.equals(callerFQCN) && !className.equals(SUPER)) continue;
            selfIndex = i;
            break;
        }
        int found = -1;
        for (int i = selfIndex + 1; i < steArray.length; ++i) {
            String className = steArray[i].getClassName();
            if (className.equals(callerFQCN) || className.equals(SUPER)) continue;
            found = i;
            break;
        }
        if (found != -1) {
            StackTraceElement ste = steArray[found];
            record.setSourceClassName(ste.getClassName());
            record.setSourceMethodName(ste.getMethodName());
        }
    }
}

