/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.logging;

import com.landawn.abacus.logging.AbstractLogger;
import com.landawn.abacus.util.function.Supplier;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.spi.ExtendedLogger;

class Log4Jv2Logger
extends AbstractLogger {
    public static final String FQCN = Log4Jv2Logger.class.getName();
    private final ExtendedLogger loggerImpl;

    public Log4Jv2Logger(String name) {
        super(name);
        this.loggerImpl = (ExtendedLogger)LogManager.getLogger((String)name);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.loggerImpl.isEnabled(Level.TRACE);
    }

    @Override
    public void trace(String msg) {
        this.loggerImpl.logIfEnabled(FQCN, Level.TRACE, null, msg);
    }

    @Override
    public void trace(String msg, Throwable t) {
        this.loggerImpl.logIfEnabled(FQCN, Level.TRACE, null, msg, t);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.loggerImpl.isEnabled(Level.DEBUG);
    }

    @Override
    public void debug(String msg) {
        this.loggerImpl.logIfEnabled(FQCN, Level.DEBUG, null, msg);
    }

    @Override
    public void debug(String msg, Throwable t) {
        this.loggerImpl.logIfEnabled(FQCN, Level.DEBUG, null, msg, t);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.loggerImpl.isEnabled(Level.INFO);
    }

    @Override
    public void info(String msg) {
        this.loggerImpl.logIfEnabled(FQCN, Level.INFO, null, msg);
    }

    @Override
    public void info(String msg, Throwable t) {
        this.loggerImpl.logIfEnabled(FQCN, Level.INFO, null, msg, t);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.loggerImpl.isEnabled(Level.WARN);
    }

    @Override
    public void warn(String msg) {
        this.loggerImpl.logIfEnabled(FQCN, Level.WARN, null, msg);
    }

    @Override
    public void warn(String msg, Throwable t) {
        this.loggerImpl.logIfEnabled(FQCN, Level.WARN, null, msg, t);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.loggerImpl.isEnabled(Level.ERROR);
    }

    @Override
    public void error(String msg) {
        this.loggerImpl.logIfEnabled(FQCN, Level.ERROR, null, msg);
    }

    @Override
    public void error(String msg, Throwable t) {
        this.loggerImpl.logIfEnabled(FQCN, Level.ERROR, null, msg, t);
    }

    @Override
    public void trace(String template, Object arg) {
        if (this.isTraceEnabled()) {
            this.trace(Log4Jv2Logger.format(template, arg));
        }
    }

    @Override
    public void trace(String template, Object arg1, Object arg2) {
        if (this.isTraceEnabled()) {
            this.trace(Log4Jv2Logger.format(template, arg1, arg2));
        }
    }

    @Override
    public void trace(String template, Object arg1, Object arg2, Object arg3) {
        if (this.isTraceEnabled()) {
            this.trace(Log4Jv2Logger.format(template, arg1, arg2, arg3));
        }
    }

    @Override
    @SafeVarargs
    public final void trace(String template, Object ... args) {
        if (this.isTraceEnabled()) {
            this.trace(Log4Jv2Logger.format(template, args));
        }
    }

    @Override
    public void trace(Throwable t, String msg) {
        this.trace(msg, t);
    }

    @Override
    public void trace(Throwable t, String template, Object arg) {
        if (this.isTraceEnabled()) {
            this.trace(t, Log4Jv2Logger.format(template, arg));
        }
    }

    @Override
    public void trace(Throwable t, String template, Object arg1, Object arg2) {
        if (this.isTraceEnabled()) {
            this.trace(t, Log4Jv2Logger.format(template, arg1, arg2));
        }
    }

    @Override
    public void trace(Throwable t, String template, Object arg1, Object arg2, Object arg3) {
        if (this.isTraceEnabled()) {
            this.trace(t, Log4Jv2Logger.format(template, arg1, arg2, arg3));
        }
    }

    @Override
    public void trace(Supplier<String> supplier) {
        if (this.isTraceEnabled()) {
            this.trace(supplier.get());
        }
    }

    @Override
    public void trace(Supplier<String> supplier, Throwable t) {
        if (this.isTraceEnabled()) {
            this.trace(t, supplier.get());
        }
    }

    @Override
    public void trace(Throwable t, Supplier<String> supplier) {
        if (this.isTraceEnabled()) {
            this.trace(t, supplier.get());
        }
    }

    @Override
    public void debug(String template, Object arg) {
        if (this.isDebugEnabled()) {
            this.debug(Log4Jv2Logger.format(template, arg));
        }
    }

    @Override
    public void debug(String template, Object arg1, Object arg2) {
        if (this.isDebugEnabled()) {
            this.debug(Log4Jv2Logger.format(template, arg1, arg2));
        }
    }

    @Override
    public void debug(String template, Object arg1, Object arg2, Object arg3) {
        if (this.isDebugEnabled()) {
            this.debug(Log4Jv2Logger.format(template, arg1, arg2, arg3));
        }
    }

    @Override
    @SafeVarargs
    public final void debug(String template, Object ... args) {
        if (this.isDebugEnabled()) {
            this.debug(Log4Jv2Logger.format(template, args));
        }
    }

    @Override
    public void debug(Throwable t, String msg) {
        this.debug(msg, t);
    }

    @Override
    public void debug(Throwable t, String template, Object arg) {
        if (this.isDebugEnabled()) {
            this.debug(t, Log4Jv2Logger.format(template, arg));
        }
    }

    @Override
    public void debug(Throwable t, String template, Object arg1, Object arg2) {
        if (this.isDebugEnabled()) {
            this.debug(t, Log4Jv2Logger.format(template, arg1, arg2));
        }
    }

    @Override
    public void debug(Throwable t, String template, Object arg1, Object arg2, Object arg3) {
        if (this.isDebugEnabled()) {
            this.debug(t, Log4Jv2Logger.format(template, arg1, arg2, arg3));
        }
    }

    @Override
    public void debug(Supplier<String> supplier) {
        if (this.isDebugEnabled()) {
            this.debug(supplier.get());
        }
    }

    @Override
    public void debug(Supplier<String> supplier, Throwable t) {
        if (this.isDebugEnabled()) {
            this.debug(t, supplier.get());
        }
    }

    @Override
    public void debug(Throwable t, Supplier<String> supplier) {
        if (this.isDebugEnabled()) {
            this.debug(t, supplier.get());
        }
    }

    @Override
    public void info(String template, Object arg) {
        if (this.isInfoEnabled()) {
            this.info(Log4Jv2Logger.format(template, arg));
        }
    }

    @Override
    public void info(String template, Object arg1, Object arg2) {
        if (this.isInfoEnabled()) {
            this.info(Log4Jv2Logger.format(template, arg1, arg2));
        }
    }

    @Override
    public void info(String template, Object arg1, Object arg2, Object arg3) {
        if (this.isInfoEnabled()) {
            this.info(Log4Jv2Logger.format(template, arg1, arg2, arg3));
        }
    }

    @Override
    @SafeVarargs
    public final void info(String template, Object ... args) {
        if (this.isInfoEnabled()) {
            this.info(Log4Jv2Logger.format(template, args));
        }
    }

    @Override
    public void info(Throwable t, String msg) {
        this.info(msg, t);
    }

    @Override
    public void info(Throwable t, String template, Object arg) {
        if (this.isInfoEnabled()) {
            this.info(t, Log4Jv2Logger.format(template, arg));
        }
    }

    @Override
    public void info(Throwable t, String template, Object arg1, Object arg2) {
        if (this.isInfoEnabled()) {
            this.info(t, Log4Jv2Logger.format(template, arg1, arg2));
        }
    }

    @Override
    public void info(Throwable t, String template, Object arg1, Object arg2, Object arg3) {
        if (this.isInfoEnabled()) {
            this.info(t, Log4Jv2Logger.format(template, arg1, arg2, arg3));
        }
    }

    @Override
    public void info(Supplier<String> supplier) {
        if (this.isInfoEnabled()) {
            this.info(supplier.get());
        }
    }

    @Override
    public void info(Supplier<String> supplier, Throwable t) {
        if (this.isInfoEnabled()) {
            this.info(t, supplier.get());
        }
    }

    @Override
    public void info(Throwable t, Supplier<String> supplier) {
        if (this.isInfoEnabled()) {
            this.info(t, supplier.get());
        }
    }

    @Override
    public void warn(String template, Object arg) {
        if (this.isWarnEnabled()) {
            this.warn(Log4Jv2Logger.format(template, arg));
        }
    }

    @Override
    public void warn(String template, Object arg1, Object arg2) {
        if (this.isWarnEnabled()) {
            this.warn(Log4Jv2Logger.format(template, arg1, arg2));
        }
    }

    @Override
    public void warn(String template, Object arg1, Object arg2, Object arg3) {
        if (this.isWarnEnabled()) {
            this.warn(Log4Jv2Logger.format(template, arg1, arg2, arg3));
        }
    }

    @Override
    @SafeVarargs
    public final void warn(String template, Object ... args) {
        if (this.isWarnEnabled()) {
            this.warn(Log4Jv2Logger.format(template, args));
        }
    }

    @Override
    public void warn(Throwable t, String msg) {
        this.warn(msg, t);
    }

    @Override
    public void warn(Throwable t, String template, Object arg) {
        if (this.isWarnEnabled()) {
            this.warn(t, Log4Jv2Logger.format(template, arg));
        }
    }

    @Override
    public void warn(Throwable t, String template, Object arg1, Object arg2) {
        if (this.isWarnEnabled()) {
            this.warn(t, Log4Jv2Logger.format(template, arg1, arg2));
        }
    }

    @Override
    public void warn(Throwable t, String template, Object arg1, Object arg2, Object arg3) {
        if (this.isWarnEnabled()) {
            this.warn(t, Log4Jv2Logger.format(template, arg1, arg2, arg3));
        }
    }

    @Override
    public void warn(Supplier<String> supplier) {
        if (this.isWarnEnabled()) {
            this.warn(supplier.get());
        }
    }

    @Override
    public void warn(Supplier<String> supplier, Throwable t) {
        if (this.isWarnEnabled()) {
            this.warn(t, supplier.get());
        }
    }

    @Override
    public void warn(Throwable t, Supplier<String> supplier) {
        if (this.isWarnEnabled()) {
            this.warn(t, supplier.get());
        }
    }

    @Override
    public void error(String template, Object arg) {
        if (this.isErrorEnabled()) {
            this.error(Log4Jv2Logger.format(template, arg));
        }
    }

    @Override
    public void error(String template, Object arg1, Object arg2) {
        if (this.isErrorEnabled()) {
            this.error(Log4Jv2Logger.format(template, arg1, arg2));
        }
    }

    @Override
    public void error(String template, Object arg1, Object arg2, Object arg3) {
        if (this.isErrorEnabled()) {
            this.error(Log4Jv2Logger.format(template, arg1, arg2, arg3));
        }
    }

    @Override
    @SafeVarargs
    public final void error(String template, Object ... args) {
        if (this.isErrorEnabled()) {
            this.error(Log4Jv2Logger.format(template, args));
        }
    }

    @Override
    public void error(Throwable t, String msg) {
        this.error(msg, t);
    }

    @Override
    public void error(Throwable t, String template, Object arg) {
        if (this.isErrorEnabled()) {
            this.error(t, Log4Jv2Logger.format(template, arg));
        }
    }

    @Override
    public void error(Throwable t, String template, Object arg1, Object arg2) {
        if (this.isErrorEnabled()) {
            this.error(t, Log4Jv2Logger.format(template, arg1, arg2));
        }
    }

    @Override
    public void error(Throwable t, String template, Object arg1, Object arg2, Object arg3) {
        if (this.isErrorEnabled()) {
            this.error(t, Log4Jv2Logger.format(template, arg1, arg2, arg3));
        }
    }

    @Override
    public void error(Supplier<String> supplier) {
        if (this.isErrorEnabled()) {
            this.error(supplier.get());
        }
    }

    @Override
    public void error(Supplier<String> supplier, Throwable t) {
        if (this.isErrorEnabled()) {
            this.error(t, supplier.get());
        }
    }

    @Override
    public void error(Throwable t, Supplier<String> supplier) {
        if (this.isErrorEnabled()) {
            this.error(t, supplier.get());
        }
    }
}

