/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.logging;

import com.landawn.abacus.logging.AndroidLogger;
import com.landawn.abacus.logging.JDKLogger;
import com.landawn.abacus.logging.Log4Jv2Logger;
import com.landawn.abacus.logging.Logger;
import com.landawn.abacus.logging.SLF4JLogger;
import java.util.HashMap;
import java.util.Map;

public final class LoggerFactory {
    private static final String JAVA_VENDOR = System.getProperty("java.vendor");
    private static final String JAVA_VM_VENDOR = System.getProperty("java.vm.vendor");
    private static final boolean IS_ANDROID_PLATFORM = JAVA_VENDOR.toUpperCase().contains("ANDROID") || JAVA_VM_VENDOR.contains("ANDROID");
    private static final Logger jdkLogger = new JDKLogger(LoggerFactory.class.getName());
    private static final Map<String, Logger> namedLoggers = new HashMap<String, Logger>();
    private static volatile int logType = 0;
    private static volatile boolean initialized = false;

    public static synchronized Logger getLogger(Class<?> clazz) {
        return LoggerFactory.getLogger(clazz.getName());
    }

    public static synchronized Logger getLogger(String name) {
        Logger logger = namedLoggers.get(name);
        if (logger == null) {
            switch (logType) {
                case 0: {
                    if (IS_ANDROID_PLATFORM) {
                        try {
                            logger = new AndroidLogger(name);
                            if (!initialized) {
                                jdkLogger.info("Initialized with Android Logger");
                                logger.info("Initialized with Android Logger");
                            }
                            logType = 0;
                            initialized = true;
                            break;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
                case 1: {
                    if (logger == null) {
                        try {
                            logger = new SLF4JLogger(name);
                            if (!initialized) {
                                jdkLogger.info("Initialized with SLF4J Logger");
                                logger.info("Initialized with SLF4J Logger");
                            }
                            logType = 1;
                            initialized = true;
                            break;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
                case 2: {
                    if (logger == null) {
                        try {
                            logger = new Log4Jv2Logger(name);
                            if (!initialized) {
                                jdkLogger.info("Initialized with Log4j v2 Logger");
                                logger.info("Initialized with Log4j v2 Logger");
                            }
                            logType = 2;
                            initialized = true;
                            break;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
                default: {
                    if (logger != null) break;
                    logger = new JDKLogger(name);
                    if (!initialized) {
                        jdkLogger.info("Initialized with JDK Logger");
                        logger.info("Initialized with JDK Logger");
                    }
                    logType = 3;
                    initialized = true;
                }
            }
            namedLoggers.put(name, logger);
        }
        return logger;
    }
}

