/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.logging;

import com.landawn.abacus.logging.AbstractLogger;
import com.landawn.abacus.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.NOPLoggerFactory;
import org.slf4j.spi.LocationAwareLogger;

class SLF4JLogger
extends AbstractLogger {
    private static final String FQCN = SLF4JLogger.class.getName();
    private final Logger loggerImpl;
    private final LocationAwareLogger locationAwareLogger;

    public SLF4JLogger(String name) {
        super(name);
        if (LoggerFactory.getILoggerFactory() instanceof NOPLoggerFactory) {
            throw new RuntimeException("Failed to initilze SLF4J Logger Factory");
        }
        this.loggerImpl = LoggerFactory.getLogger((String)name);
        this.locationAwareLogger = this.loggerImpl instanceof LocationAwareLogger ? (LocationAwareLogger)this.loggerImpl : null;
    }

    @Override
    public boolean isTraceEnabled() {
        return this.loggerImpl.isTraceEnabled();
    }

    @Override
    public void trace(String msg) {
        this.loggerImpl.trace(msg);
    }

    @Override
    public void trace(String msg, Throwable t) {
        this.loggerImpl.trace(msg, t);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.loggerImpl.isDebugEnabled();
    }

    @Override
    public void debug(String msg) {
        this.loggerImpl.debug(msg);
    }

    @Override
    public void debug(String msg, Throwable t) {
        this.loggerImpl.debug(msg, t);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.loggerImpl.isInfoEnabled();
    }

    @Override
    public void info(String msg) {
        this.loggerImpl.info(msg);
    }

    @Override
    public void info(String msg, Throwable t) {
        this.loggerImpl.info(msg, t);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.loggerImpl.isWarnEnabled();
    }

    @Override
    public void warn(String msg) {
        if (this.locationAwareLogger == null) {
            this.loggerImpl.warn(msg);
        } else {
            this.locationAwareLogger.log(null, FQCN, 30, msg, null, null);
        }
    }

    @Override
    public void warn(String msg, Throwable t) {
        if (this.locationAwareLogger == null) {
            this.loggerImpl.warn(msg, t);
        } else {
            this.locationAwareLogger.log(null, FQCN, 30, msg, null, t);
        }
    }

    @Override
    public boolean isErrorEnabled() {
        return this.loggerImpl.isErrorEnabled();
    }

    @Override
    public void error(String msg) {
        if (this.locationAwareLogger == null) {
            this.loggerImpl.error(msg);
        } else {
            this.locationAwareLogger.log(null, FQCN, 40, msg, null, null);
        }
    }

    @Override
    public void error(String msg, Throwable t) {
        if (this.locationAwareLogger == null) {
            this.loggerImpl.error(msg, t);
        } else {
            this.locationAwareLogger.log(null, FQCN, 40, msg, null, t);
        }
    }

    @Override
    public void trace(String template, Object arg) {
        if (this.isTraceEnabled()) {
            this.trace(SLF4JLogger.format(template, arg));
        }
    }

    @Override
    public void trace(String template, Object arg1, Object arg2) {
        if (this.isTraceEnabled()) {
            this.trace(SLF4JLogger.format(template, arg1, arg2));
        }
    }

    @Override
    public void trace(String template, Object arg1, Object arg2, Object arg3) {
        if (this.isTraceEnabled()) {
            this.trace(SLF4JLogger.format(template, arg1, arg2, arg3));
        }
    }

    @Override
    @SafeVarargs
    public final void trace(String template, Object ... args) {
        if (this.isTraceEnabled()) {
            this.trace(SLF4JLogger.format(template, args));
        }
    }

    @Override
    public void trace(Throwable t, String msg) {
        this.trace(msg, t);
    }

    @Override
    public void trace(Throwable t, String template, Object arg) {
        if (this.isTraceEnabled()) {
            this.trace(t, SLF4JLogger.format(template, arg));
        }
    }

    @Override
    public void trace(Throwable t, String template, Object arg1, Object arg2) {
        if (this.isTraceEnabled()) {
            this.trace(t, SLF4JLogger.format(template, arg1, arg2));
        }
    }

    @Override
    public void trace(Throwable t, String template, Object arg1, Object arg2, Object arg3) {
        if (this.isTraceEnabled()) {
            this.trace(t, SLF4JLogger.format(template, arg1, arg2, arg3));
        }
    }

    @Override
    public void trace(Supplier<String> supplier) {
        if (this.isTraceEnabled()) {
            this.trace(supplier.get());
        }
    }

    @Override
    public void trace(Supplier<String> supplier, Throwable t) {
        if (this.isTraceEnabled()) {
            this.trace(t, supplier.get());
        }
    }

    @Override
    public void trace(Throwable t, Supplier<String> supplier) {
        if (this.isTraceEnabled()) {
            this.trace(t, supplier.get());
        }
    }

    @Override
    public void debug(String template, Object arg) {
        if (this.isDebugEnabled()) {
            this.debug(SLF4JLogger.format(template, arg));
        }
    }

    @Override
    public void debug(String template, Object arg1, Object arg2) {
        if (this.isDebugEnabled()) {
            this.debug(SLF4JLogger.format(template, arg1, arg2));
        }
    }

    @Override
    public void debug(String template, Object arg1, Object arg2, Object arg3) {
        if (this.isDebugEnabled()) {
            this.debug(SLF4JLogger.format(template, arg1, arg2, arg3));
        }
    }

    @Override
    @SafeVarargs
    public final void debug(String template, Object ... args) {
        if (this.isDebugEnabled()) {
            this.debug(SLF4JLogger.format(template, args));
        }
    }

    @Override
    public void debug(Throwable t, String msg) {
        this.debug(msg, t);
    }

    @Override
    public void debug(Throwable t, String template, Object arg) {
        if (this.isDebugEnabled()) {
            this.debug(t, SLF4JLogger.format(template, arg));
        }
    }

    @Override
    public void debug(Throwable t, String template, Object arg1, Object arg2) {
        if (this.isDebugEnabled()) {
            this.debug(t, SLF4JLogger.format(template, arg1, arg2));
        }
    }

    @Override
    public void debug(Throwable t, String template, Object arg1, Object arg2, Object arg3) {
        if (this.isDebugEnabled()) {
            this.debug(t, SLF4JLogger.format(template, arg1, arg2, arg3));
        }
    }

    @Override
    public void debug(Supplier<String> supplier) {
        if (this.isDebugEnabled()) {
            this.debug(supplier.get());
        }
    }

    @Override
    public void debug(Supplier<String> supplier, Throwable t) {
        if (this.isDebugEnabled()) {
            this.debug(t, supplier.get());
        }
    }

    @Override
    public void debug(Throwable t, Supplier<String> supplier) {
        if (this.isDebugEnabled()) {
            this.debug(t, supplier.get());
        }
    }

    @Override
    public void info(String template, Object arg) {
        if (this.isInfoEnabled()) {
            this.info(SLF4JLogger.format(template, arg));
        }
    }

    @Override
    public void info(String template, Object arg1, Object arg2) {
        if (this.isInfoEnabled()) {
            this.info(SLF4JLogger.format(template, arg1, arg2));
        }
    }

    @Override
    public void info(String template, Object arg1, Object arg2, Object arg3) {
        if (this.isInfoEnabled()) {
            this.info(SLF4JLogger.format(template, arg1, arg2, arg3));
        }
    }

    @Override
    @SafeVarargs
    public final void info(String template, Object ... args) {
        if (this.isInfoEnabled()) {
            this.info(SLF4JLogger.format(template, args));
        }
    }

    @Override
    public void info(Throwable t, String msg) {
        this.info(msg, t);
    }

    @Override
    public void info(Throwable t, String template, Object arg) {
        if (this.isInfoEnabled()) {
            this.info(t, SLF4JLogger.format(template, arg));
        }
    }

    @Override
    public void info(Throwable t, String template, Object arg1, Object arg2) {
        if (this.isInfoEnabled()) {
            this.info(t, SLF4JLogger.format(template, arg1, arg2));
        }
    }

    @Override
    public void info(Throwable t, String template, Object arg1, Object arg2, Object arg3) {
        if (this.isInfoEnabled()) {
            this.info(t, SLF4JLogger.format(template, arg1, arg2, arg3));
        }
    }

    @Override
    public void info(Supplier<String> supplier) {
        if (this.isInfoEnabled()) {
            this.info(supplier.get());
        }
    }

    @Override
    public void info(Supplier<String> supplier, Throwable t) {
        if (this.isInfoEnabled()) {
            this.info(t, supplier.get());
        }
    }

    @Override
    public void info(Throwable t, Supplier<String> supplier) {
        if (this.isInfoEnabled()) {
            this.info(t, supplier.get());
        }
    }

    @Override
    public void warn(String template, Object arg) {
        if (this.isWarnEnabled()) {
            this.warn(SLF4JLogger.format(template, arg));
        }
    }

    @Override
    public void warn(String template, Object arg1, Object arg2) {
        if (this.isWarnEnabled()) {
            this.warn(SLF4JLogger.format(template, arg1, arg2));
        }
    }

    @Override
    public void warn(String template, Object arg1, Object arg2, Object arg3) {
        if (this.isWarnEnabled()) {
            this.warn(SLF4JLogger.format(template, arg1, arg2, arg3));
        }
    }

    @Override
    @SafeVarargs
    public final void warn(String template, Object ... args) {
        if (this.isWarnEnabled()) {
            this.warn(SLF4JLogger.format(template, args));
        }
    }

    @Override
    public void warn(Throwable t, String msg) {
        this.warn(msg, t);
    }

    @Override
    public void warn(Throwable t, String template, Object arg) {
        if (this.isWarnEnabled()) {
            this.warn(t, SLF4JLogger.format(template, arg));
        }
    }

    @Override
    public void warn(Throwable t, String template, Object arg1, Object arg2) {
        if (this.isWarnEnabled()) {
            this.warn(t, SLF4JLogger.format(template, arg1, arg2));
        }
    }

    @Override
    public void warn(Throwable t, String template, Object arg1, Object arg2, Object arg3) {
        if (this.isWarnEnabled()) {
            this.warn(t, SLF4JLogger.format(template, arg1, arg2, arg3));
        }
    }

    @Override
    public void warn(Supplier<String> supplier) {
        if (this.isWarnEnabled()) {
            this.warn(supplier.get());
        }
    }

    @Override
    public void warn(Supplier<String> supplier, Throwable t) {
        if (this.isWarnEnabled()) {
            this.warn(t, supplier.get());
        }
    }

    @Override
    public void warn(Throwable t, Supplier<String> supplier) {
        if (this.isWarnEnabled()) {
            this.warn(t, supplier.get());
        }
    }

    @Override
    public void error(String template, Object arg) {
        if (this.isErrorEnabled()) {
            this.error(SLF4JLogger.format(template, arg));
        }
    }

    @Override
    public void error(String template, Object arg1, Object arg2) {
        if (this.isErrorEnabled()) {
            this.error(SLF4JLogger.format(template, arg1, arg2));
        }
    }

    @Override
    public void error(String template, Object arg1, Object arg2, Object arg3) {
        if (this.isErrorEnabled()) {
            this.error(SLF4JLogger.format(template, arg1, arg2, arg3));
        }
    }

    @Override
    @SafeVarargs
    public final void error(String template, Object ... args) {
        if (this.isErrorEnabled()) {
            this.error(SLF4JLogger.format(template, args));
        }
    }

    @Override
    public void error(Throwable t, String msg) {
        this.error(msg, t);
    }

    @Override
    public void error(Throwable t, String template, Object arg) {
        if (this.isErrorEnabled()) {
            this.error(t, SLF4JLogger.format(template, arg));
        }
    }

    @Override
    public void error(Throwable t, String template, Object arg1, Object arg2) {
        if (this.isErrorEnabled()) {
            this.error(t, SLF4JLogger.format(template, arg1, arg2));
        }
    }

    @Override
    public void error(Throwable t, String template, Object arg1, Object arg2, Object arg3) {
        if (this.isErrorEnabled()) {
            this.error(t, SLF4JLogger.format(template, arg1, arg2, arg3));
        }
    }

    @Override
    public void error(Supplier<String> supplier) {
        if (this.isErrorEnabled()) {
            this.error(supplier.get());
        }
    }

    @Override
    public void error(Supplier<String> supplier, Throwable t) {
        if (this.isErrorEnabled()) {
            this.error(t, supplier.get());
        }
    }

    @Override
    public void error(Throwable t, Supplier<String> supplier) {
        if (this.isErrorEnabled()) {
            this.error(t, supplier.get());
        }
    }
}

