/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.parser;

import com.landawn.abacus.parser.AbstractParser;
import com.landawn.abacus.parser.JSONDeserializationConfig;
import com.landawn.abacus.parser.JSONParser;
import com.landawn.abacus.parser.JSONSerializationConfig;
import com.landawn.abacus.type.Type;
import com.landawn.abacus.type.TypeFactory;
import com.landawn.abacus.util.ExceptionalStream;
import com.landawn.abacus.util.N;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

abstract class AbstractJSONParser
extends AbstractParser<JSONSerializationConfig, JSONDeserializationConfig>
implements JSONParser {
    protected static final char _BRACE_L = '{';
    protected static final char _BRACE_R = '}';
    protected static final char _BRACKET_L = '[';
    protected static final char _BRACKET_R = ']';
    protected static final char _D_QUOTATION = '\"';
    protected static final char _S_QUOTATION = '\'';
    protected static final char _COLON = ':';
    protected static final char _COMMA = ',';
    protected static final Type<Object> objType = TypeFactory.getType(Object.class);
    protected static final Type<String> strType = TypeFactory.getType(String.class);
    protected static final Type<Boolean> boolType = TypeFactory.getType(Boolean.class);
    protected static final Type<?> defaultKeyType = objType;
    protected static final Type<?> defaultValueType = objType;
    protected static final String[] REPLACEMENT_CHARS;
    protected static final Set<String> ignoredDirtyMarkerPropNames;
    protected final JSONSerializationConfig defaultJSONSerializationConfig;
    protected final JSONDeserializationConfig defaultJSONDeserializationConfig;

    protected AbstractJSONParser() {
        this(null, null);
    }

    protected AbstractJSONParser(JSONSerializationConfig jsc, JSONDeserializationConfig jdc) {
        this.defaultJSONSerializationConfig = jsc != null ? jsc : new JSONSerializationConfig();
        this.defaultJSONDeserializationConfig = jdc != null ? jdc : new JSONDeserializationConfig();
    }

    @Override
    public <T> T readString(Class<T> targetClass, String str) {
        return this.readString(targetClass, str, null);
    }

    @Override
    public <T> T readString(Class<T> targetClass, String str, JSONDeserializationConfig config) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void readString(Object[] outResult, String str) {
        this.readString(outResult, str, null);
    }

    @Override
    public void readString(Object[] outResult, String str, JSONDeserializationConfig config) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void readString(Collection<?> outResult, String str) {
        this.readString(outResult, str, null);
    }

    @Override
    public void readString(Collection<?> outResult, String str, JSONDeserializationConfig config) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void readString(Map<?, ?> outResult, String str) {
        this.readString(outResult, str, null);
    }

    @Override
    public void readString(Map<?, ?> outResult, String str, JSONDeserializationConfig config) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T deserialize(Class<T> targetClass, String str, int fromIndex, int toIndex) {
        return this.deserialize(targetClass, str, fromIndex, toIndex, null);
    }

    @Override
    public <T> T deserialize(Class<T> targetClass, String str, int fromIndex, int toIndex, JSONDeserializationConfig config) {
        return this.deserialize(targetClass, str.substring(fromIndex, toIndex), config);
    }

    @Override
    public <T> ExceptionalStream<T, IOException> stream(Class<T> elementClass, String json) {
        return this.stream(elementClass, json, null);
    }

    @Override
    public <T> ExceptionalStream<T, IOException> stream(Class<T> elementClass, File file) {
        return this.stream(elementClass, file, null);
    }

    @Override
    public <T> ExceptionalStream<T, IOException> stream(Class<T> elementClass, InputStream is) {
        return this.stream(elementClass, is, null);
    }

    @Override
    public <T> ExceptionalStream<T, IOException> stream(Class<T> elementClass, Reader reader) {
        return this.stream(elementClass, reader, null);
    }

    protected JSONSerializationConfig check(JSONSerializationConfig config) {
        if (config == null) {
            config = this.defaultJSONSerializationConfig;
        }
        return config;
    }

    protected JSONDeserializationConfig check(JSONDeserializationConfig config) {
        if (config == null) {
            config = this.defaultJSONDeserializationConfig;
        }
        return config;
    }

    static {
        int length = 128;
        REPLACEMENT_CHARS = new String[128];
        for (int i = 0; i < 128; ++i) {
            AbstractJSONParser.REPLACEMENT_CHARS[i] = String.format("\\u%04x", i);
        }
        ignoredDirtyMarkerPropNames = N.asSet("signedPropNames", "dirtyPropNames", "frozen", "version", "isDirty", "dirtyMarkerImpl");
    }
}

