/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.parser;

import com.landawn.abacus.exception.ParseException;
import com.landawn.abacus.logging.Logger;
import com.landawn.abacus.logging.LoggerFactory;
import com.landawn.abacus.parser.DeserializationConfig;
import com.landawn.abacus.parser.Parser;
import com.landawn.abacus.parser.SerializationConfig;
import com.landawn.abacus.type.Type;
import com.landawn.abacus.util.BiMap;
import com.landawn.abacus.util.ImmutableBiMap;
import com.landawn.abacus.util.ImmutableCollection;
import com.landawn.abacus.util.ImmutableList;
import com.landawn.abacus.util.ImmutableMap;
import com.landawn.abacus.util.ImmutableNavigableSet;
import com.landawn.abacus.util.ImmutableSet;
import com.landawn.abacus.util.ImmutableSortedMap;
import com.landawn.abacus.util.ImmutableSortedSet;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Tuple;
import com.landawn.abacus.util.function.Function;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

abstract class AbstractParser<SC extends SerializationConfig<?>, DC extends DeserializationConfig<?>>
implements Parser<SC, DC> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractParser.class);
    static final String ELEMENT_SEPARATOR = ", ".intern();
    static final char[] ELEMENT_SEPARATOR_CHAR_ARRAY = ELEMENT_SEPARATOR.toCharArray();
    static final String NULL_STRING = "null".intern();
    static final char[] NULL_CHAR_ARRAY = NULL_STRING.toCharArray();
    static final String TRUE = Boolean.TRUE.toString().intern();
    static final char[] TRUE_CHAR_ARRAY = TRUE.toCharArray();
    static final String FALSE = Boolean.FALSE.toString().intern();
    static final char[] FALSE_CHAR_ARRAY = FALSE.toCharArray();
    static final int POOL_SIZE = 1000;
    static final int CLS_POOL_SIZE = 3000;
    static final Map<Class<?>, Tuple.Tuple2<Function<Class<?>, Object>, Function<Object, Object>>> mapOfCreatorAndConvertorForTargetType = new HashMap();

    AbstractParser() {
    }

    @Override
    public String serialize(Object obj) {
        return this.serialize(obj, null);
    }

    @Override
    public void serialize(File file, Object obj) {
        this.serialize(file, obj, null);
    }

    @Override
    public void serialize(OutputStream os, Object obj) {
        this.serialize(os, obj, null);
    }

    @Override
    public void serialize(Writer writer, Object obj) {
        this.serialize(writer, obj, null);
    }

    @Override
    public <T> T deserialize(Class<T> targetClass, String st) {
        return this.deserialize(targetClass, st, null);
    }

    @Override
    public <T> T deserialize(Class<T> targetClass, File file) {
        return this.deserialize(targetClass, file, null);
    }

    @Override
    public <T> T deserialize(Class<T> targetClass, InputStream is) {
        return this.deserialize(targetClass, is, null);
    }

    @Override
    public <T> T deserialize(Class<T> targetClass, Reader reader) {
        return this.deserialize(targetClass, reader, null);
    }

    protected static Class<?> choosePropClass(Class<?> propClass, Class<?> attribeTypeClass) {
        if (attribeTypeClass != null && (propClass == null || propClass.isAssignableFrom(attribeTypeClass))) {
            return attribeTypeClass;
        }
        return propClass;
    }

    protected static Tuple.Tuple2<Function<Class<?>, Object>, Function<Object, Object>> getCreatorAndConvertorForTargetType(Class<?> propClass, Class<?> attribeTypeClass) {
        Class<?> t = AbstractParser.choosePropClass(propClass, attribeTypeClass);
        Tuple.Tuple2<Function<Class<?>, Object>, Function<Object, Object>> result = mapOfCreatorAndConvertorForTargetType.get(t);
        if (result == null) {
            result = mapOfCreatorAndConvertorForTargetType.get(Object.class);
        }
        return result;
    }

    protected static <T> T newPropInstance(Class<?> propClass, Class<?> attribeTypeClass) {
        block4: {
            if (attribeTypeClass != null && (propClass == null || propClass.isAssignableFrom(attribeTypeClass))) {
                try {
                    return (T)N.newInstance(attribeTypeClass);
                }
                catch (Exception e) {
                    if (!logger.isInfoEnabled()) break block4;
                    logger.info("Failed to new instance by type attribute: " + attribeTypeClass.getCanonicalName());
                }
            }
        }
        if (propClass != null) {
            return (T)N.newInstance(propClass);
        }
        throw new ParseException("Failed to create property instance with property class: " + propClass + " and attribute " + attribeTypeClass);
    }

    protected static Class<?> getConcreteClass(Class<?> targetClass, Class<?> typeClass) {
        if (typeClass == null) {
            return targetClass;
        }
        if (targetClass == null) {
            return typeClass;
        }
        if (targetClass == typeClass || targetClass.isAssignableFrom(typeClass)) {
            return typeClass;
        }
        return targetClass;
    }

    protected static <T> T collection2Array(Class<?> targetClass, Collection<?> c) {
        if (c == null) {
            return null;
        }
        Type targetType = N.typeOf(targetClass);
        if (targetType.isPrimitiveArray()) {
            return targetType.collection2Array(c);
        }
        for (Object e : c) {
            if (e == null) continue;
            if (targetClass.getComponentType().isAssignableFrom(e.getClass())) {
                return targetType.collection2Array(c);
            }
            return (T)c.toArray((Object[])N.newArray(e.getClass(), c.size()));
        }
        return targetType.collection2Array(c);
    }

    static {
        mapOfCreatorAndConvertorForTargetType.put(ImmutableList.class, Tuple.of(new Function<Class<?>, Object>(){

            @Override
            public Object apply(Class<?> t) {
                return new ArrayList();
            }
        }, new Function<Object, Object>(){

            @Override
            public Object apply(Object t) {
                return ImmutableList.of((List)t);
            }
        }));
        mapOfCreatorAndConvertorForTargetType.put(ImmutableSet.class, Tuple.of(new Function<Class<?>, Object>(){

            @Override
            public Object apply(Class<?> t) {
                return new HashSet();
            }
        }, new Function<Object, Object>(){

            @Override
            public Object apply(Object t) {
                return ImmutableSet.of((Set)t);
            }
        }));
        mapOfCreatorAndConvertorForTargetType.put(ImmutableSortedSet.class, Tuple.of(new Function<Class<?>, Object>(){

            @Override
            public Object apply(Class<?> t) {
                return new TreeSet();
            }
        }, new Function<Object, Object>(){

            @Override
            public Object apply(Object t) {
                return ImmutableSortedSet.of((SortedSet)t);
            }
        }));
        mapOfCreatorAndConvertorForTargetType.put(ImmutableNavigableSet.class, Tuple.of(new Function<Class<?>, Object>(){

            @Override
            public Object apply(Class<?> t) {
                return new TreeSet();
            }
        }, new Function<Object, Object>(){

            @Override
            public Object apply(Object t) {
                return ImmutableNavigableSet.of((NavigableSet)t);
            }
        }));
        mapOfCreatorAndConvertorForTargetType.put(ImmutableCollection.class, mapOfCreatorAndConvertorForTargetType.get(ImmutableList.class));
        mapOfCreatorAndConvertorForTargetType.put(ImmutableMap.class, Tuple.of(new Function<Class<?>, Object>(){

            @Override
            public Object apply(Class<?> t) {
                return new HashMap();
            }
        }, new Function<Object, Object>(){

            @Override
            public Object apply(Object t) {
                return ImmutableMap.of((Map)t);
            }
        }));
        mapOfCreatorAndConvertorForTargetType.put(ImmutableBiMap.class, Tuple.of(new Function<Class<?>, Object>(){

            @Override
            public Object apply(Class<?> t) {
                return new BiMap();
            }
        }, new Function<Object, Object>(){

            @Override
            public Object apply(Object t) {
                return ImmutableBiMap.of((BiMap)t);
            }
        }));
        mapOfCreatorAndConvertorForTargetType.put(ImmutableSortedMap.class, Tuple.of(new Function<Class<?>, Object>(){

            @Override
            public Object apply(Class<?> t) {
                return new TreeMap();
            }
        }, new Function<Object, Object>(){

            @Override
            public Object apply(Object t) {
                return ImmutableSortedMap.of((SortedMap)t);
            }
        }));
        mapOfCreatorAndConvertorForTargetType.put(Object.class, Tuple.of(new Function<Class<?>, Object>(){

            @Override
            public Object apply(Class<?> t) {
                return N.newInstance(t);
            }
        }, new Function<Object, Object>(){

            @Override
            public Object apply(Object t) {
                return t;
            }
        }));
    }
}

