/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.parser;

import com.landawn.abacus.parser.ParserConfig;
import com.landawn.abacus.type.Type;
import com.landawn.abacus.util.N;
import java.util.HashMap;
import java.util.Map;

public abstract class DeserializationConfig<C extends DeserializationConfig<C>>
extends ParserConfig<C> {
    boolean ignoreUnmatchedProperty = true;
    Type<?> elementType;
    Type<?> keyType;
    Type<?> valueType;
    Map<String, Type<?>> propTypes;

    public boolean isIgnoreUnmatchedProperty() {
        return this.ignoreUnmatchedProperty;
    }

    public C setIgnoreUnmatchedProperty(boolean ignoreUnmatchedProperty) {
        this.ignoreUnmatchedProperty = ignoreUnmatchedProperty;
        return (C)this;
    }

    public <T> Type<T> getElementType() {
        return this.elementType;
    }

    public C setElementType(Class<?> cls) {
        return this.setElementType(N.typeOf(cls));
    }

    public C setElementType(Type<?> type) {
        this.elementType = type;
        return (C)this;
    }

    public C setElementType(String type) {
        return this.setElementType(N.typeOf(type));
    }

    public <T> Type<T> getMapKeyType() {
        return this.keyType;
    }

    public C setMapKeyType(Class<?> cls) {
        return this.setMapKeyType(N.typeOf(cls));
    }

    public C setMapKeyType(Type<?> keyType) {
        this.keyType = keyType;
        return (C)this;
    }

    public C setMapKeyType(String keyType) {
        return this.setMapKeyType(N.typeOf(keyType));
    }

    public <T> Type<T> getMapValueType() {
        return this.valueType;
    }

    public C setMapValueType(Class<?> cls) {
        return this.setMapValueType(N.typeOf(cls));
    }

    public C setMapValueType(Type<?> valueType) {
        this.valueType = valueType;
        return (C)this;
    }

    public C setMapValueType(String valueType) {
        return this.setMapValueType(N.typeOf(valueType));
    }

    public Map<String, Type<?>> getPropTypes() {
        return this.propTypes;
    }

    public C setPropTypes(Map<String, Type<?>> propTypes) {
        this.propTypes = propTypes;
        return (C)this;
    }

    public <T> Type<T> getPropType(String propName) {
        return this.propTypes == null ? null : this.propTypes.get(propName);
    }

    public C setPropType(String propName, Class<?> cls) {
        return this.setPropType(propName, N.typeOf(cls));
    }

    public C setPropType(String propName, Type<?> type) {
        if (this.propTypes == null) {
            this.propTypes = new HashMap();
        }
        this.propTypes.put(propName, type);
        return (C)this;
    }

    public C setPropType(String propName, String type) {
        return this.setPropType(propName, N.typeOf(type));
    }

    public boolean hasPropType(String propName) {
        return this.propTypes != null && this.propTypes.containsKey(propName);
    }

    public int hashCode() {
        int h = 17;
        h = 31 * h + N.hashCode(this.getIgnoredPropNames());
        h = 31 * h + N.hashCode(this.ignoreUnmatchedProperty);
        h = 31 * h + N.hashCode(this.elementType);
        h = 31 * h + N.hashCode(this.keyType);
        h = 31 * h + N.hashCode(this.valueType);
        h = 31 * h + N.hashCode(this.propTypes);
        return h;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DeserializationConfig) {
            DeserializationConfig other = (DeserializationConfig)obj;
            if (N.equals(this.getIgnoredPropNames(), other.getIgnoredPropNames()) && N.equals(this.ignoreUnmatchedProperty, other.ignoreUnmatchedProperty) && N.equals(this.elementType, other.elementType) && N.equals(this.keyType, other.keyType) && N.equals(this.valueType, other.valueType) && N.equals(this.propTypes, other.propTypes)) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "{ignoredPropNames=" + N.toString(this.getIgnoredPropNames()) + ", ignoreUnmatchedProperty=" + N.toString(this.ignoreUnmatchedProperty) + ", elementType=" + N.toString(this.elementType) + ", keyType=" + N.toString(this.keyType) + ", valueType=" + N.toString(this.valueType) + ", propTypes=" + N.toString(this.propTypes) + "}";
    }
}

