/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.parser;

import com.landawn.abacus.exception.ParseException;
import com.landawn.abacus.parser.JSONReader;
import com.landawn.abacus.parser.JSONStringReader;
import com.landawn.abacus.util.IOUtil;
import com.landawn.abacus.util.N;
import java.io.IOException;
import java.io.Reader;

class JSONStreamReader
extends JSONStringReader {
    JSONStreamReader(Reader reader, char[] rbuf, char[] cbuf) {
        super(rbuf, 0, 0, cbuf, reader);
    }

    JSONStreamReader(Reader reader, char[] rbuf, int beginIndex, int endIndex, char[] cbuf) {
        super(rbuf, beginIndex, endIndex, cbuf, reader);
    }

    public static JSONReader parse(Reader reader, char[] rbuf, char[] cbuf) {
        return new JSONStreamReader(reader, rbuf, cbuf);
    }

    @Override
    public int nextToken() throws IOException {
        if (this.strBeginIndex >= this.strEndIndex) {
            this.refill();
        }
        this.nextChar = 0;
        this.strStart = this.strBeginIndex;
        if (this.nextEvent == 5 || this.nextEvent == 7) {
            char quoteChar = this.nextEvent == 5 ? (char)'\"' : '\'';
            char ch = '\u0000';
            while (this.strBeginIndex < this.strEndIndex) {
                if ((ch = this.strValue[this.strBeginIndex++]) == quoteChar) {
                    this.strEnd = this.strBeginIndex - 1;
                    this.nextEvent = quoteChar == '\"' ? 6 : 8;
                    return this.nextEvent;
                }
                if (this.nextChar > 0) {
                    if (this.nextChar >= this.cbufLen) {
                        this.enlargeCharBuffer();
                    }
                    this.cbuf[this.nextChar++] = ch == '\\' ? this.readEscapeCharacter() : (char)ch;
                } else if (ch == '\\') {
                    this.strEnd = this.strBeginIndex - 1;
                    if (this.strEnd - this.strStart + 1 >= this.cbufLen) {
                        this.enlargeCharBuffer();
                    }
                    N.copy(this.strValue, this.strStart, this.cbuf, 0, this.strEnd - this.strStart);
                    this.nextChar = this.strEnd - this.strStart;
                    this.cbuf[this.nextChar++] = this.readEscapeCharacter();
                }
                if (this.strBeginIndex < this.strEndIndex) continue;
                this.refill();
            }
        } else {
            char ch = '\u0000';
            while (this.strBeginIndex < this.strEndIndex) {
                if ((ch = this.strValue[this.strBeginIndex++]) < '\u0080') {
                    this.nextEvent = charEvents[ch];
                    if (this.nextEvent > 0) {
                        this.strEnd = this.strBeginIndex - 1;
                        return this.nextEvent;
                    }
                }
                if (this.nextChar > 0) {
                    if (ch == '\\') {
                        ch = this.readEscapeCharacter();
                    }
                    if (ch >= '!') {
                        if (this.nextChar >= this.cbufLen) {
                            this.enlargeCharBuffer();
                        }
                        this.cbuf[this.nextChar++] = ch;
                    }
                } else if (ch < '!') {
                    if (this.strStart == this.strBeginIndex - 1) {
                        ++this.strStart;
                    } else {
                        this.strEnd = this.strBeginIndex - 1;
                        if (this.strEnd - this.strStart + 1 >= this.cbufLen) {
                            this.enlargeCharBuffer();
                        }
                        N.copy(this.strValue, this.strStart, this.cbuf, 0, this.strEnd - this.strStart);
                        this.nextChar = this.strEnd - this.strStart;
                    }
                } else if (ch == '\\') {
                    this.strEnd = this.strBeginIndex - 1;
                    if (this.strEnd - this.strStart + 1 >= this.cbufLen) {
                        this.enlargeCharBuffer();
                    }
                    N.copy(this.strValue, this.strStart, this.cbuf, 0, this.strEnd - this.strStart);
                    this.nextChar = this.strEnd - this.strStart;
                    ch = this.readEscapeCharacter();
                    if (ch >= '!') {
                        this.cbuf[this.nextChar++] = ch;
                    }
                }
                if (this.strBeginIndex < this.strEndIndex) continue;
                this.refill();
            }
        }
        this.strEnd = this.strBeginIndex;
        this.nextEvent = -1;
        return this.nextEvent;
    }

    @Override
    protected char readEscapeCharacter() throws IOException {
        if (this.strBeginIndex >= this.strEndIndex) {
            this.refill();
        }
        char escaped = this.strValue[this.strBeginIndex++];
        switch (escaped) {
            case 'u': {
                char result = '\u0000';
                char c = '\u0000';
                for (int i = 0; i < 4; ++i) {
                    if (this.strBeginIndex >= this.strEndIndex) {
                        this.refill();
                    }
                    c = this.strValue[this.strBeginIndex++];
                    result = (char)(result << 4);
                    if (c >= '0' && c <= '9') {
                        result = (char)(result + (c - 48));
                        continue;
                    }
                    if (c >= 'a' && c <= 'f') {
                        result = (char)(result + (c - 97 + 10));
                        continue;
                    }
                    if (c >= 'A' && c <= 'F') {
                        result = (char)(result + (c - 65 + 10));
                        continue;
                    }
                    throw new ParseException("Number format fxception: \\u" + String.valueOf(this.cbuf));
                }
                return result;
            }
            case 't': {
                return '\t';
            }
            case 'b': {
                return '\b';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 'f': {
                return '\f';
            }
        }
        return escaped;
    }

    void refill() throws IOException {
        if (this.strBeginIndex >= this.strEndIndex) {
            int n;
            if (this.nextChar == 0) {
                this.strEnd = this.strBeginIndex;
                if (this.strEnd > this.strStart) {
                    N.copy(this.strValue, this.strStart, this.cbuf, 0, this.strEnd - this.strStart);
                    this.nextChar = this.strEnd - this.strStart;
                } else {
                    this.strStart = 0;
                }
            }
            if ((n = IOUtil.read(this.reader, this.strValue, 0, this.strValue.length)) > 0) {
                this.strBeginIndex = 0;
                this.strEndIndex = n;
            }
        }
    }
}

