/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.parser;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.landawn.abacus.exception.UncheckedIOException;
import com.landawn.abacus.parser.AbstractParser;
import com.landawn.abacus.parser.KryoDeserializationConfig;
import com.landawn.abacus.parser.KryoSerializationConfig;
import com.landawn.abacus.util.ByteArrayOutputStream;
import com.landawn.abacus.util.IOUtil;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Objectory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class KryoParser
extends AbstractParser<KryoSerializationConfig, KryoDeserializationConfig> {
    private static final int BUFFER_SIZE = 8192;
    private static final List<Output> outputPool = new ArrayList<Output>(1000);
    private static final List<Input> inputPool = new ArrayList<Input>(1000);
    private final Map<Class<?>, Integer> kryoClassIdMap = new ConcurrentHashMap();
    private final Map<Class<?>, Serializer<?>> kryoClassSerializerMap = new ConcurrentHashMap();
    private final Map<Kryo, Kryo> xPool = new IdentityHashMap<Kryo, Kryo>();
    private final List<Kryo> kryoPool = new ArrayList<Kryo>(1000);

    KryoParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String serialize(Object obj, KryoSerializationConfig config) {
        ByteArrayOutputStream os = Objectory.createByteArrayOutputStream();
        try {
            this.write(os, obj, config);
            String string = N.base64Encode(os.toByteArray());
            return string;
        }
        finally {
            Objectory.recycle(os);
        }
    }

    @Override
    public void serialize(File file, Object obj, KryoSerializationConfig config) {
        FileOutputStream os = null;
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            os = new FileOutputStream(file);
            this.write(os, obj, config);
            os.flush();
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException(e);
            }
            catch (Throwable throwable) {
                IOUtil.close(os);
                throw throwable;
            }
        }
        IOUtil.close(os);
    }

    @Override
    public void serialize(OutputStream os, Object obj, KryoSerializationConfig config) {
        this.write(os, obj, config);
    }

    @Override
    public void serialize(Writer writer, Object obj, KryoSerializationConfig config) {
        ByteArrayOutputStream os = Objectory.createByteArrayOutputStream();
        try {
            this.write(os, obj, config);
            writer.write(N.base64Encode(os.toByteArray()));
            writer.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            Objectory.recycle(os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write(OutputStream os, Object obj, KryoSerializationConfig config) {
        Output output = KryoParser.createOutput();
        try {
            output.setOutputStream(os);
            this.write(output, obj, config);
        }
        finally {
            KryoParser.recycle(output);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write(Output output, Object obj, KryoSerializationConfig config) {
        this.check(config);
        Kryo kryo = this.createKryo();
        try {
            if (config != null && config.isWriteClass()) {
                kryo.writeClassAndObject(output, obj);
            } else {
                kryo.writeObject(output, obj);
            }
            output.flush();
        }
        finally {
            this.recycle(kryo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T deserialize(Class<T> targetClass, String st, KryoDeserializationConfig config) {
        Input input = KryoParser.createInput();
        try {
            input.setBuffer(N.base64Decode(st));
            T t = this.read(targetClass, input, config);
            return t;
        }
        finally {
            KryoParser.recycle(input);
        }
    }

    @Override
    public <T> T deserialize(Class<T> targetClass, File file, KryoDeserializationConfig config) {
        T t;
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            t = this.read(targetClass, is, config);
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException(e);
            }
            catch (Throwable throwable) {
                IOUtil.close(is);
                throw throwable;
            }
        }
        IOUtil.close(is);
        return t;
    }

    @Override
    public <T> T deserialize(Class<T> targetClass, InputStream is, KryoDeserializationConfig config) {
        return this.read(targetClass, is, config);
    }

    @Override
    public <T> T deserialize(Class<T> targetClass, Reader reader, KryoDeserializationConfig config) {
        return this.deserialize(targetClass, IOUtil.readString(reader), config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T read(Class<T> targetClass, InputStream is, KryoDeserializationConfig config) {
        Input input = KryoParser.createInput();
        try {
            input.setInputStream(is);
            T t = this.read(targetClass, input, config);
            return t;
        }
        finally {
            KryoParser.recycle(input);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T read(Class<T> targetClass, Input input, KryoDeserializationConfig config) {
        this.check(config);
        Kryo kryo = this.createKryo();
        try {
            Object object = targetClass == null ? kryo.readClassAndObject(input) : kryo.readObject(input, targetClass);
            return (T)object;
        }
        finally {
            this.recycle(kryo);
        }
    }

    protected KryoSerializationConfig check(KryoSerializationConfig config) {
        return config;
    }

    protected KryoDeserializationConfig check(KryoDeserializationConfig config) {
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T copy(T obj) {
        Kryo kryo = this.createKryo();
        try {
            Object object = kryo.copyShallow(obj);
            return (T)object;
        }
        finally {
            this.recycle(kryo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T clone(T obj) {
        Kryo kryo = this.createKryo();
        try {
            Object object = kryo.copy(obj);
            return (T)object;
        }
        finally {
            this.recycle(kryo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] encode(Object obj) {
        ByteArrayOutputStream os = Objectory.createByteArrayOutputStream();
        Output output = KryoParser.createOutput();
        Kryo kryo = this.createKryo();
        try {
            output.setOutputStream((OutputStream)os);
            kryo.writeClassAndObject(output, obj);
            output.flush();
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        finally {
            Objectory.recycle(os);
            KryoParser.recycle(output);
            this.recycle(kryo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T decode(byte[] bytes) {
        Input input = KryoParser.createInput();
        Kryo kryo = this.createKryo();
        try {
            input.setBuffer(bytes);
            Object object = kryo.readClassAndObject(input);
            return (T)object;
        }
        finally {
            KryoParser.recycle(input);
            this.recycle(kryo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Class<?> cls, int id) {
        List<Kryo> list = this.kryoPool;
        synchronized (list) {
            this.kryoClassIdMap.put(cls, id);
            this.xPool.clear();
            this.kryoPool.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Class<?> cls, Serializer<?> serializer) {
        List<Kryo> list = this.kryoPool;
        synchronized (list) {
            this.kryoClassSerializerMap.put(cls, serializer);
            this.xPool.clear();
            this.kryoPool.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Kryo createKryo() {
        List<Kryo> list = this.kryoPool;
        synchronized (list) {
            if (this.kryoPool.size() > 0) {
                return this.kryoPool.remove(this.kryoPool.size() - 1);
            }
            Kryo kryo = new Kryo();
            if (N.notNullOrEmpty(this.kryoClassIdMap)) {
                for (Class<?> cls : this.kryoClassIdMap.keySet()) {
                    kryo.register(cls, this.kryoClassIdMap.get(cls).intValue());
                }
            }
            if (N.notNullOrEmpty(this.kryoClassSerializerMap)) {
                for (Class<?> cls : this.kryoClassSerializerMap.keySet()) {
                    kryo.register(cls, this.kryoClassSerializerMap.get(cls));
                }
            }
            this.xPool.put(kryo, kryo);
            return kryo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recycle(Kryo kryo) {
        if (kryo == null) {
            return;
        }
        List<Kryo> list = this.kryoPool;
        synchronized (list) {
            if (this.kryoPool.size() < 1000 && this.xPool.containsKey(kryo)) {
                this.kryoPool.add(kryo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Output createOutput() {
        List<Output> list = outputPool;
        synchronized (list) {
            if (outputPool.size() > 0) {
                return outputPool.remove(outputPool.size() - 1);
            }
            return new Output(8192);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void recycle(Output output) {
        if (output == null || output.getBuffer() != null && output.getBuffer().length > 8192) {
            return;
        }
        List<Output> list = outputPool;
        synchronized (list) {
            if (outputPool.size() < 1000) {
                output.setOutputStream(null);
                outputPool.add(output);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Input createInput() {
        List<Input> list = inputPool;
        synchronized (list) {
            if (inputPool.size() > 0) {
                return inputPool.remove(inputPool.size() - 1);
            }
            return new Input(8192);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void recycle(Input input) {
        if (input == null || input.getBuffer() != null && input.getBuffer().length > 8192) {
            return;
        }
        List<Input> list = inputPool;
        synchronized (list) {
            if (inputPool.size() < 1000) {
                input.setInputStream(null);
                inputPool.add(input);
            }
        }
    }
}

