/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.parser;

import com.landawn.abacus.parser.JSONDeserializationConfig;
import com.landawn.abacus.parser.JSONParser;
import com.landawn.abacus.parser.JSONParserImpl;
import com.landawn.abacus.parser.JSONSerializationConfig;
import com.landawn.abacus.parser.KryoParser;
import com.landawn.abacus.parser.XMLDeserializationConfig;
import com.landawn.abacus.parser.XMLParser;
import com.landawn.abacus.parser.XMLParserImpl;
import com.landawn.abacus.parser.XMLParserType;
import com.landawn.abacus.parser.XMLSerializationConfig;

public final class ParserFactory {
    private static final boolean isXMLAvailable;
    private static final boolean isKryoAvailable;

    private ParserFactory() {
    }

    public static boolean isXMLAvailable() {
        return isXMLAvailable;
    }

    public static boolean isKryoAvailable() {
        return isKryoAvailable;
    }

    public static KryoParser createKryoParser() {
        return new KryoParser();
    }

    public static JSONParser createJSONParser() {
        return new JSONParserImpl();
    }

    public static JSONParser createJSONParser(JSONSerializationConfig jsc, JSONDeserializationConfig jdc) {
        return new JSONParserImpl(jsc, jdc);
    }

    public static XMLParser createXMLParser() {
        return new XMLParserImpl(XMLParserType.StAX);
    }

    public static XMLParser createXMLParser(XMLSerializationConfig xsc, XMLDeserializationConfig xdc) {
        return new XMLParserImpl(XMLParserType.StAX, xsc, xdc);
    }

    static {
        Boolean isAvailable = false;
        try {
            new XMLParserImpl(XMLParserType.StAX);
            isAvailable = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        isXMLAvailable = isAvailable;
        isAvailable = false;
        try {
            Class.forName("com.esotericsoftware.kryo.Kryo");
            ParserFactory.createKryoParser();
            isAvailable = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        isKryoAvailable = isAvailable;
    }
}

