/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.parser;

import com.alibaba.fastjson.annotation.JSONField;
import com.esotericsoftware.reflectasm.FieldAccess;
import com.esotericsoftware.reflectasm.MethodAccess;
import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.landawn.abacus.annotation.AccessFieldByMethod;
import com.landawn.abacus.annotation.Column;
import com.landawn.abacus.annotation.Internal;
import com.landawn.abacus.annotation.JsonXmlConfig;
import com.landawn.abacus.annotation.JsonXmlField;
import com.landawn.abacus.annotation.Transient;
import com.landawn.abacus.annotation.Type;
import com.landawn.abacus.core.DirtyMarkerUtil;
import com.landawn.abacus.logging.Logger;
import com.landawn.abacus.logging.LoggerFactory;
import com.landawn.abacus.parser.ASMUtil;
import com.landawn.abacus.parser.JSONReader;
import com.landawn.abacus.parser.SerializationConfig;
import com.landawn.abacus.type.ObjectType;
import com.landawn.abacus.type.TypeFactory;
import com.landawn.abacus.util.CharacterWriter;
import com.landawn.abacus.util.ClassUtil;
import com.landawn.abacus.util.DateUtil;
import com.landawn.abacus.util.ImmutableList;
import com.landawn.abacus.util.ImmutableMap;
import com.landawn.abacus.util.Multiset;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.NamingPolicy;
import com.landawn.abacus.util.Numbers;
import com.landawn.abacus.util.ObjectPool;
import com.landawn.abacus.util.Splitter;
import com.landawn.abacus.util.StringUtil;
import com.landawn.abacus.util.u;
import java.io.IOException;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.persistence.Table;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.MutableDateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@Internal
public final class ParserUtil {
    static final Logger logger = LoggerFactory.getLogger(ParserUtil.class);
    private static final PropInfo PROP_INFO_MASK = new PropInfo("PROP_INFO_MASK");
    private static final char PROP_NAME_SEPARATOR = '.';
    private static final String GET = "get".intern();
    private static final String SET = "set".intern();
    private static final String IS = "is".intern();
    private static final String HAS = "has".intern();
    private static final int POOL_SIZE = 1024;
    private static final int defaultNameIndex = NamingPolicy.LOWER_CAMEL_CASE.ordinal();
    private static final Map<Class<?>, EntityInfo> entityInfoPool = new ObjectPool(1024);

    private ParserUtil() {
    }

    static boolean isJsonXmlSerializable(Field field, JsonXmlConfig jsonXmlConfig) {
        if (field == null) {
            return true;
        }
        if (Modifier.isStatic(field.getModifiers())) {
            return false;
        }
        if (field.isAnnotationPresent(JsonXmlField.class) && field.getAnnotation(JsonXmlField.class).ignore()) {
            return false;
        }
        try {
            if (field.isAnnotationPresent(JSONField.class) && !field.getAnnotation(JSONField.class).serialize()) {
                return false;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (field.isAnnotationPresent(JsonIgnore.class) && field.getAnnotation(JsonIgnore.class).value()) {
                return false;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (jsonXmlConfig != null && N.notNullOrEmpty(jsonXmlConfig.ignoredFields())) {
            String fieldName = field.getName();
            for (String ignoreFieldName : jsonXmlConfig.ignoredFields()) {
                if (!fieldName.equals(ignoreFieldName) && !fieldName.matches(ignoreFieldName)) continue;
                return false;
            }
        }
        return true;
    }

    static String getDateFormat(Field field, JsonXmlConfig jsonXmlConfig) {
        if (field != null) {
            if (field.isAnnotationPresent(JsonXmlField.class) && N.notNullOrEmpty(field.getAnnotation(JsonXmlField.class).dateFormat())) {
                return field.getAnnotation(JsonXmlField.class).dateFormat();
            }
            try {
                if (field.isAnnotationPresent(JSONField.class) && N.notNullOrEmpty(field.getAnnotation(JSONField.class).format())) {
                    return field.getAnnotation(JSONField.class).format();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                if (field.isAnnotationPresent(JsonFormat.class) && N.notNullOrEmpty(field.getAnnotation(JsonFormat.class).pattern())) {
                    return field.getAnnotation(JsonFormat.class).pattern();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (jsonXmlConfig != null && N.notNullOrEmpty(jsonXmlConfig.dateFormat())) {
            return jsonXmlConfig.dateFormat();
        }
        return null;
    }

    static String getTimeZone(Field field, JsonXmlConfig jsonXmlConfig) {
        if (field != null) {
            if (field.isAnnotationPresent(JsonXmlField.class) && N.notNullOrEmpty(field.getAnnotation(JsonXmlField.class).timeZone())) {
                return field.getAnnotation(JsonXmlField.class).timeZone();
            }
            try {
                if (field.isAnnotationPresent(JsonFormat.class) && N.notNullOrEmpty(field.getAnnotation(JsonFormat.class).timezone())) {
                    return field.getAnnotation(JsonFormat.class).timezone();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (jsonXmlConfig != null && N.notNullOrEmpty(jsonXmlConfig.timeZone())) {
            return jsonXmlConfig.timeZone();
        }
        return null;
    }

    static String getNumberFormat(Field field, JsonXmlConfig jsonXmlConfig) {
        if (field != null && field.isAnnotationPresent(JsonXmlField.class) && N.notNullOrEmpty(field.getAnnotation(JsonXmlField.class).numberFormat())) {
            return field.getAnnotation(JsonXmlField.class).numberFormat();
        }
        if (jsonXmlConfig != null && N.notNullOrEmpty(jsonXmlConfig.numberFormat())) {
            return jsonXmlConfig.numberFormat();
        }
        return null;
    }

    static Type.EnumBy getEnumerated(Field field, JsonXmlConfig jsonXmlConfig) {
        if (field != null && field.isAnnotationPresent(JsonXmlField.class) && field.getAnnotation(JsonXmlField.class).enumerated() != null) {
            return field.getAnnotation(JsonXmlField.class).enumerated();
        }
        if (jsonXmlConfig != null && jsonXmlConfig.enumerated() != null) {
            return jsonXmlConfig.enumerated();
        }
        return Type.EnumBy.NAME;
    }

    static boolean isJsonRawValue(Field field) {
        boolean isJsonRawValue = false;
        if (field != null && field.isAnnotationPresent(JsonXmlField.class) && (isJsonRawValue = field.getAnnotation(JsonXmlField.class).isJsonRawValue()) && !CharSequence.class.isAssignableFrom(field.getType())) {
            throw new IllegalArgumentException("'isJsonRawValue' can only be applied to CharSequence type field");
        }
        return isJsonRawValue;
    }

    static JsonNameTag[] getJsonNameTags(String name) {
        JsonNameTag[] result = new JsonNameTag[NamingPolicy.values().length];
        for (NamingPolicy np : NamingPolicy.values()) {
            result[np.ordinal()] = new JsonNameTag(ParserUtil.convertName(name, np));
        }
        return result;
    }

    static XmlNameTag[] getXmlNameTags(String name, String typeName, boolean isEntity) {
        XmlNameTag[] result = new XmlNameTag[NamingPolicy.values().length];
        for (NamingPolicy np : NamingPolicy.values()) {
            result[np.ordinal()] = new XmlNameTag(ParserUtil.convertName(name, np), typeName, isEntity);
        }
        return result;
    }

    static JsonNameTag[] getJsonNameTags(String propName, Field field) {
        String jsonXmlFieldName = null;
        if (field != null) {
            if (field.isAnnotationPresent(JsonXmlField.class) && N.notNullOrEmpty(field.getAnnotation(JsonXmlField.class).name())) {
                jsonXmlFieldName = field.getAnnotation(JsonXmlField.class).name();
            } else {
                try {
                    if (field.isAnnotationPresent(JSONField.class) && N.notNullOrEmpty(field.getAnnotation(JSONField.class).name())) {
                        jsonXmlFieldName = field.getAnnotation(JSONField.class).name();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (N.isNullOrEmpty(jsonXmlFieldName)) {
                    try {
                        if (field.isAnnotationPresent(JsonProperty.class) && N.notNullOrEmpty(field.getAnnotation(JsonProperty.class).value())) {
                            jsonXmlFieldName = field.getAnnotation(JsonProperty.class).value();
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
        JsonNameTag[] result = new JsonNameTag[NamingPolicy.values().length];
        for (NamingPolicy np : NamingPolicy.values()) {
            result[np.ordinal()] = new JsonNameTag(N.isNullOrEmpty(jsonXmlFieldName) ? ParserUtil.convertName(propName, np) : jsonXmlFieldName);
        }
        return result;
    }

    static XmlNameTag[] getXmlNameTags(String propName, Field field, String typeName, boolean isEntity) {
        String jsonXmlFieldName = null;
        if (field != null) {
            if (field.isAnnotationPresent(JsonXmlField.class) && N.notNullOrEmpty(field.getAnnotation(JsonXmlField.class).name())) {
                jsonXmlFieldName = field.getAnnotation(JsonXmlField.class).name();
            } else {
                try {
                    if (field.isAnnotationPresent(JSONField.class) && N.notNullOrEmpty(field.getAnnotation(JSONField.class).name())) {
                        jsonXmlFieldName = field.getAnnotation(JSONField.class).name();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (N.isNullOrEmpty(jsonXmlFieldName)) {
                    try {
                        if (field.isAnnotationPresent(JsonProperty.class) && N.notNullOrEmpty(field.getAnnotation(JsonProperty.class).value())) {
                            jsonXmlFieldName = field.getAnnotation(JsonProperty.class).value();
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
        XmlNameTag[] result = new XmlNameTag[NamingPolicy.values().length];
        for (NamingPolicy np : NamingPolicy.values()) {
            result[np.ordinal()] = new XmlNameTag(N.isNullOrEmpty(jsonXmlFieldName) ? ParserUtil.convertName(propName, np) : jsonXmlFieldName, typeName, isEntity);
        }
        return result;
    }

    static String[] getAlias(Field field) {
        String[] alias = null;
        if (field != null) {
            if (field.isAnnotationPresent(JsonXmlField.class) && N.notNullOrEmpty(field.getAnnotation(JsonXmlField.class).name())) {
                alias = field.getAnnotation(JsonXmlField.class).alias();
            } else {
                try {
                    if (field.isAnnotationPresent(JSONField.class) && N.notNullOrEmpty(field.getAnnotation(JSONField.class).name())) {
                        alias = field.getAnnotation(JSONField.class).alternateNames();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (N.isNullOrEmpty(alias)) {
                    try {
                        if (field.isAnnotationPresent(JsonAlias.class) && N.notNullOrEmpty(field.getAnnotation(JsonAlias.class).value())) {
                            alias = field.getAnnotation(JsonAlias.class).value();
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
        return alias;
    }

    private static String convertName(String name, NamingPolicy namingPolicy) {
        return namingPolicy == null || namingPolicy == NamingPolicy.LOWER_CAMEL_CASE || namingPolicy == NamingPolicy.NO_CHANGE ? name : namingPolicy.convert(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EntityInfo getEntityInfo(Class<?> cls) {
        if (!ClassUtil.isEntity(cls)) {
            throw new IllegalArgumentException("No property getter/setter method or public field found in the specified entity: " + ClassUtil.getCanonicalClassName(cls));
        }
        EntityInfo entityInfo = entityInfoPool.get(cls);
        if (entityInfo == null) {
            Map<Class<?>, EntityInfo> map = entityInfoPool;
            synchronized (map) {
                entityInfo = entityInfoPool.get(cls);
                if (entityInfo == null) {
                    entityInfo = new EntityInfo(cls);
                    entityInfoPool.put(cls, entityInfo);
                }
            }
        }
        return entityInfo;
    }

    static int hashCode(char[] a) {
        int result = 1;
        for (char e : a) {
            result = 31 * result + e;
        }
        return result;
    }

    static int hashCode(char[] a, int fromIndex, int toIndex) {
        return N.hashCode(a, fromIndex, toIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @Internal
    public static void refreshEntityPropInfo(Class<?> cls) {
        Map<Class<?>, EntityInfo> map = entityInfoPool;
        synchronized (map) {
            entityInfoPool.remove(cls);
        }
    }

    static class JodaDateTimeFormatterHolder {
        final DateTimeZone dtz;
        final DateTimeFormatter dtf;

        JodaDateTimeFormatterHolder(String dateFormat, TimeZone timeZone) {
            this.dtz = DateTimeZone.forTimeZone((TimeZone)timeZone);
            this.dtf = DateTimeFormat.forPattern((String)dateFormat).withZone(this.dtz);
        }
    }

    static interface DateTimeReaderWriter<T> {
        public T read(PropInfo var1, String var2);

        public void write(PropInfo var1, T var2, CharacterWriter var3) throws IOException;
    }

    static class XmlNameTag {
        final char[] name;
        final char[] epStart;
        final char[] epStartWithType;
        final char[] epEnd;
        final char[] epNull;
        final char[] epNullWithType;
        final char[] namedStart;
        final char[] namedStartWithType;
        final char[] namedEnd;
        final char[] namedNull;
        final char[] namedNullWithType;

        public XmlNameTag(String name, String typeName, boolean isEntity) {
            this.name = name.toCharArray();
            String typeAttr = typeName.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
            if (isEntity) {
                this.epStart = ("<entity name=\"" + name + "\">").toCharArray();
                this.epStartWithType = ("<entity name=\"" + name + "\" type=\"" + typeAttr + "\">").toCharArray();
                this.epEnd = "</entity>".toCharArray();
                this.epNull = ("<entity name=\"" + name + "\" isNull=\"true\" />").toCharArray();
                this.epNullWithType = ("<entity name=\"" + name + "\" type=\"" + typeAttr + "\" isNull=\"true\" />").toCharArray();
            } else {
                this.epStart = ("<property name=\"" + name + "\">").toCharArray();
                this.epStartWithType = ("<property name=\"" + name + "\" type=\"" + typeAttr + "\">").toCharArray();
                this.epEnd = "</property>".toCharArray();
                this.epNull = ("<property name=\"" + name + "\" isNull=\"true\" />").toCharArray();
                this.epNullWithType = ("<property name=\"" + name + "\" type=\"" + typeAttr + "\" isNull=\"true\" />").toCharArray();
            }
            this.namedStart = ("<" + name + ">").toCharArray();
            this.namedStartWithType = ("<" + name + " type=\"" + typeAttr + "\">").toCharArray();
            this.namedEnd = ("</" + name + ">").toCharArray();
            this.namedNull = ("<" + name + " isNull=\"true\" />").toCharArray();
            this.namedNullWithType = ("<" + name + " type=\"" + typeAttr + "\" isNull=\"true\" />").toCharArray();
        }

        public int hashCode() {
            return this.name == null ? 0 : N.hashCode(this.name);
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof XmlNameTag && N.equals(((XmlNameTag)obj).name, this.name);
        }

        public String toString() {
            return N.toString(this.name);
        }
    }

    static class JsonNameTag {
        final char[] name;
        final char[] nameWithColon;
        final char[] nameNull;
        final char[] quotedName;
        final char[] quotedNameWithColon;
        final char[] quotedNameNull;

        public JsonNameTag(String name) {
            this.name = name.toCharArray();
            this.nameWithColon = (name + ":").toCharArray();
            this.nameNull = (name + ":null").toCharArray();
            this.quotedName = ("\"" + name + "\"").toCharArray();
            this.quotedNameWithColon = ("\"" + name + "\":").toCharArray();
            this.quotedNameNull = ("\"" + name + "\":null").toCharArray();
        }

        public int hashCode() {
            return this.name == null ? 0 : N.hashCode(this.name);
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof JsonNameTag && N.equals(((JsonNameTag)obj).name, this.name);
        }

        public String toString() {
            return N.toString(this.name);
        }
    }

    static class ASMPropInfo
    extends PropInfo {
        final MethodAccess methodAccess;
        final int getMethodAccessIndex;
        final int setMethodAccessIndex;
        final FieldAccess fieldAccess;
        final int fieldAccessIndex;

        public ASMPropInfo(String name, Field field, Method getMethod, JsonXmlConfig jsonXmlConfig, ImmutableMap<Class<? extends Annotation>, Annotation> classAnnotations) {
            super(name, field, getMethod, jsonXmlConfig, classAnnotations);
            this.methodAccess = MethodAccess.get((Class)this.declaringClass);
            this.getMethodAccessIndex = getMethod == null ? -1 : this.methodAccess.getIndex(getMethod.getName(), 0);
            this.setMethodAccessIndex = this.setMethod == null ? -1 : this.methodAccess.getIndex(this.setMethod.getName(), (Class[])this.setMethod.getParameterTypes());
            this.fieldAccess = FieldAccess.get((Class)this.declaringClass);
            this.fieldAccessIndex = field == null || !this.isFieldAccessible || Modifier.isPrivate(field.getModifiers()) || Modifier.isFinal(field.getModifiers()) ? -1 : this.fieldAccess.getIndex(field.getName());
        }

        @Override
        public <T> T getPropValue(Object obj) {
            return (T)(this.fieldAccessIndex > -1 ? this.fieldAccess.get(obj, this.fieldAccessIndex) : this.methodAccess.invoke(obj, this.getMethodAccessIndex, new Object[0]));
        }

        @Override
        public void setPropValue(Object obj, Object propValue) {
            propValue = propValue == null ? this.type.defaultValue() : propValue;
            try {
                if (this.fieldAccessIndex > -1) {
                    this.fieldAccess.set(obj, this.fieldAccessIndex, propValue);
                } else if (this.setMethodAccessIndex > -1) {
                    this.methodAccess.invoke(obj, this.setMethodAccessIndex, new Object[]{propValue});
                } else if (this.getMethod != null) {
                    ClassUtil.setPropValueByGet(obj, this.getMethod, propValue);
                } else {
                    this.field.set(obj, propValue);
                }
            }
            catch (Exception e) {
                if (logger.isWarnEnabled()) {
                    logger.warn(e, "Failed to set value for field: {} in class: {}", (Object)this.field, (Object)this.declaringClass);
                }
                propValue = N.convert(propValue, this.jsonXmlType);
                if (this.fieldAccessIndex > -1) {
                    this.fieldAccess.set(obj, this.fieldAccessIndex, propValue);
                }
                if (this.setMethodAccessIndex > -1) {
                    this.methodAccess.invoke(obj, this.setMethodAccessIndex, new Object[]{propValue});
                }
                try {
                    this.field.set(obj, propValue);
                }
                catch (Exception e2) {
                    N.toRuntimeException(e);
                }
            }
        }
    }

    public static class PropInfo {
        static final char[] NULL_CHAR_ARRAY = "null".toCharArray();
        public final Class<Object> declaringClass;
        public final String name;
        public final Class<Object> clazz;
        public final com.landawn.abacus.type.Type<Object> type;
        public final Field field;
        public final Method getMethod;
        public final Method setMethod;
        public final ImmutableMap<Class<? extends Annotation>, Annotation> annotations;
        public final com.landawn.abacus.type.Type<Object> jsonXmlType;
        public final com.landawn.abacus.type.Type<Object> dbType;
        final JsonNameTag[] jsonNameTags;
        final XmlNameTag[] xmlNameTags;
        final boolean isFieldAccessible;
        final boolean isDirtyMark;
        final String dateFormat;
        final TimeZone timeZone;
        final boolean isJsonRawValue;
        final JodaDateTimeFormatterHolder jodaDTFH;
        final boolean isLongDateFormat;
        final NumberFormat numberFormat;
        final boolean hasFormat;
        public final boolean isTransient;
        public final JsonXmlField.Expose jsonXmlExpose;
        public final boolean isMarkedToColumn;
        public final u.Optional<String> columnName;
        static final Map<Class<?>, DateTimeReaderWriter<?>> propFuncMap = new HashMap();

        PropInfo(String propName) {
            this.declaringClass = null;
            this.name = propName;
            this.field = null;
            this.getMethod = null;
            this.setMethod = null;
            this.annotations = ImmutableMap.empty();
            this.clazz = null;
            this.type = null;
            this.jsonXmlType = null;
            this.dbType = null;
            this.xmlNameTags = null;
            this.jsonNameTags = null;
            this.isDirtyMark = false;
            this.isFieldAccessible = false;
            this.dateFormat = null;
            this.timeZone = null;
            this.isJsonRawValue = false;
            this.jodaDTFH = null;
            this.isLongDateFormat = false;
            this.numberFormat = null;
            this.hasFormat = false;
            this.isTransient = false;
            this.jsonXmlExpose = JsonXmlField.Expose.DEFAULT;
            this.isMarkedToColumn = false;
            this.columnName = u.Optional.empty();
        }

        public PropInfo(String propName, Field field, Method getMethod, JsonXmlConfig jsonXmlConfig, ImmutableMap<Class<? extends Annotation>, Annotation> classAnnotations) {
            this.declaringClass = field != null ? field.getDeclaringClass() : getMethod.getDeclaringClass();
            this.isDirtyMark = DirtyMarkerUtil.isDirtyMarker(this.declaringClass);
            this.field = field;
            this.name = propName;
            this.getMethod = getMethod;
            this.setMethod = ClassUtil.getPropSetMethod(this.declaringClass, propName);
            this.annotations = ImmutableMap.of(this.getAnnotations());
            boolean bl = this.isTransient = this.annotations.containsKey(Transient.class) || field != null && Modifier.isTransient(field.getModifiers());
            this.clazz = field == null ? (this.setMethod == null ? getMethod.getReturnType() : this.setMethod.getParameterTypes()[0]) : field.getType();
            this.type = this.getType(this.getAnnoType(this.field, this.getMethod, this.setMethod, this.clazz, jsonXmlConfig), this.field, this.getMethod, this.setMethod, this.clazz, this.declaringClass);
            this.jsonXmlType = this.getType(this.getJsonXmlAnnoType(this.field, this.getMethod, this.setMethod, this.clazz, jsonXmlConfig), this.field, this.getMethod, this.setMethod, this.clazz, this.declaringClass);
            this.dbType = this.getType(this.getDBAnnoType(this.field, this.getMethod, this.setMethod, this.clazz), this.field, this.getMethod, this.setMethod, this.clazz, this.declaringClass);
            this.jsonNameTags = ParserUtil.getJsonNameTags(propName, field);
            this.xmlNameTags = ParserUtil.getXmlNameTags(propName, field, this.jsonXmlType.name(), false);
            if (field != null && !this.annotations.containsKey(AccessFieldByMethod.class) && !classAnnotations.containsKey(AccessFieldByMethod.class)) {
                ClassUtil.setAccessibleQuietly(field, true);
            }
            this.isFieldAccessible = !this.isDirtyMark && field != null && field.isAccessible();
            String timeZoneStr = StringUtil.trim(ParserUtil.getTimeZone(field, jsonXmlConfig));
            String dateFormatStr = StringUtil.trim(ParserUtil.getDateFormat(field, jsonXmlConfig));
            this.dateFormat = N.isNullOrEmpty(dateFormatStr) ? null : dateFormatStr;
            this.timeZone = N.isNullOrEmpty(timeZoneStr) ? TimeZone.getDefault() : TimeZone.getTimeZone(timeZoneStr);
            this.isJsonRawValue = ParserUtil.isJsonRawValue(field);
            JodaDateTimeFormatterHolder tmpJodaDTFH = null;
            try {
                if (Class.forName("org.joda.time.DateTime") != null) {
                    tmpJodaDTFH = new JodaDateTimeFormatterHolder(this.dateFormat, this.timeZone);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.jodaDTFH = tmpJodaDTFH;
            this.isLongDateFormat = N.notNullOrEmpty(this.dateFormat) && "long".equalsIgnoreCase(this.dateFormat);
            String numberFormatStr = StringUtil.trim(ParserUtil.getNumberFormat(field, jsonXmlConfig));
            this.numberFormat = N.isNullOrEmpty(numberFormatStr) ? null : new DecimalFormat(numberFormatStr);
            this.hasFormat = N.notNullOrEmpty(this.dateFormat) || this.numberFormat != null;
            this.jsonXmlExpose = field != null && field.isAnnotationPresent(JsonXmlField.class) ? field.getAnnotation(JsonXmlField.class).expose() : JsonXmlField.Expose.DEFAULT;
            String tmpColumnName = null;
            boolean tmpIsMarkedToColumn = false;
            if (this.annotations.containsKey(Column.class)) {
                tmpIsMarkedToColumn = true;
                tmpColumnName = ((Column)this.annotations.get(Column.class)).value();
                if (N.isNullOrEmpty(tmpColumnName)) {
                    tmpColumnName = ((Column)this.annotations.get(Column.class)).name();
                }
            } else {
                try {
                    if (this.annotations.containsKey(javax.persistence.Column.class)) {
                        tmpIsMarkedToColumn = true;
                        tmpColumnName = ((javax.persistence.Column)this.annotations.get(javax.persistence.Column.class)).name();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.isMarkedToColumn = tmpIsMarkedToColumn;
            this.columnName = N.isNullOrEmpty(tmpColumnName) ? u.Optional.empty() : u.Optional.ofNullable(tmpColumnName);
        }

        public <T> T getPropValue(Object obj) {
            try {
                return (T)(this.isFieldAccessible ? this.field.get(obj) : this.getMethod.invoke(obj, new Object[0]));
            }
            catch (Exception e) {
                throw N.toRuntimeException(e);
            }
        }

        public void setPropValue(Object obj, Object propValue) {
            propValue = propValue == null ? this.type.defaultValue() : propValue;
            try {
                if (this.isFieldAccessible) {
                    this.field.set(obj, propValue);
                } else if (this.setMethod != null) {
                    this.setMethod.invoke(obj, propValue);
                } else if (this.getMethod != null) {
                    ClassUtil.setPropValueByGet(obj, this.getMethod, propValue);
                } else {
                    this.field.set(obj, propValue);
                }
            }
            catch (Exception e) {
                if (logger.isWarnEnabled()) {
                    logger.warn(e, "Failed to set value for field: {} in class: {}", (Object)this.field, this.declaringClass);
                }
                propValue = N.convert(propValue, this.jsonXmlType);
                try {
                    if (this.isFieldAccessible) {
                        this.field.set(obj, propValue);
                    } else if (this.setMethod != null) {
                        this.setMethod.invoke(obj, propValue);
                    } else {
                        this.field.set(obj, propValue);
                    }
                }
                catch (Exception e2) {
                    throw N.toRuntimeException(e);
                }
            }
        }

        public Object readPropValue(String strValue) {
            if (N.notNullOrEmpty(this.dateFormat)) {
                DateTimeReaderWriter<?> func = propFuncMap.get(this.clazz);
                if (func == null) {
                    throw new UnsupportedOperationException("'DateFormat' annotation for field: " + this.field + " is only supported for types: java.util.Date/Calendar, java.sql.Date/Time/Timestamp, java.time.LocalDateTime/LocalDate/LocalTime/ZonedDateTime, not supported for: " + ClassUtil.getCanonicalClassName(this.clazz));
                }
                return func.read(this, strValue);
            }
            return this.jsonXmlType.valueOf(strValue);
        }

        public void writePropValue(CharacterWriter writer, Object x, SerializationConfig<?> config) throws IOException {
            if (this.hasFormat) {
                if (x == null) {
                    writer.write(NULL_CHAR_ARRAY);
                } else if (this.dateFormat != null) {
                    DateTimeReaderWriter<?> func;
                    boolean isQuote;
                    boolean bl = isQuote = config != null && config.getStringQuotation() != '\u0000';
                    if (isQuote) {
                        writer.write(config.getStringQuotation());
                    }
                    if ((func = propFuncMap.get(this.clazz)) == null) {
                        throw new UnsupportedOperationException("'DateFormat' annotation for field: " + this.field + " is only supported for types: java.util.Date/Calendar, java.sql.Date/Time/Timestamp, java.time.LocalDateTime/LocalDate/LocalTime/ZonedDateTime, not supported for: " + ClassUtil.getCanonicalClassName(this.clazz));
                    }
                    func.write(this, x, writer);
                    if (isQuote) {
                        writer.write(config.getStringQuotation());
                    }
                } else {
                    writer.write(this.numberFormat.format(x));
                }
            } else if (this.isJsonRawValue) {
                if (x == null) {
                    writer.write(NULL_CHAR_ARRAY);
                } else {
                    writer.write(((CharSequence)x).toString());
                }
            } else {
                this.jsonXmlType.writeCharacter(writer, x, config);
            }
        }

        public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
            return this.annotations.containsKey(annotationClass);
        }

        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            return (T)this.annotations.get(annotationClass);
        }

        private Map<Class<? extends Annotation>, Annotation> getAnnotations() {
            HashMap<Class<? extends Annotation>, Annotation> annotations = new HashMap<Class<? extends Annotation>, Annotation>();
            if (this.field != null && N.notNullOrEmpty(this.field.getAnnotations())) {
                for (Annotation anno : this.field.getAnnotations()) {
                    annotations.put(anno.annotationType(), anno);
                }
            }
            if (this.getMethod != null && N.notNullOrEmpty(this.getMethod.getAnnotations())) {
                for (Annotation anno : this.getMethod.getAnnotations()) {
                    annotations.put(anno.annotationType(), anno);
                }
            }
            if (this.setMethod != null && N.notNullOrEmpty(this.setMethod.getAnnotations())) {
                for (Annotation anno : this.setMethod.getAnnotations()) {
                    annotations.put(anno.annotationType(), anno);
                }
            }
            return annotations;
        }

        private String getAnnoType(Field field, Method getMethod, Method setMethod, Class<?> propClass, JsonXmlConfig jsonXmlConfig) {
            String typeName;
            Type typeAnno = this.getAnnotation(Type.class);
            if (typeAnno != null && (typeAnno.scope() == Type.Scope.ALL || typeAnno.scope() == Type.Scope.PARSER) && N.notNullOrEmpty(typeName = this.getTypeName(typeAnno, propClass))) {
                return typeName;
            }
            JsonXmlField jsonXmlFieldAnno = this.getAnnotation(JsonXmlField.class);
            if (jsonXmlFieldAnno != null) {
                if (N.notNullOrEmpty(jsonXmlFieldAnno.type())) {
                    return jsonXmlFieldAnno.type();
                }
                if (propClass.isEnum()) {
                    return ClassUtil.getCanonicalClassName(propClass) + "(" + String.valueOf(ParserUtil.getEnumerated(field, jsonXmlConfig) == Type.EnumBy.ORDINAL) + ")";
                }
            }
            if (jsonXmlConfig != null && propClass.isEnum()) {
                return ClassUtil.getCanonicalClassName(propClass) + "(" + String.valueOf(ParserUtil.getEnumerated(field, jsonXmlConfig) == Type.EnumBy.ORDINAL) + ")";
            }
            return null;
        }

        private String getJsonXmlAnnoType(Field field, Method getMethod, Method setMethod, Class<?> propClass, JsonXmlConfig jsonXmlConfig) {
            String typeName;
            JsonXmlField jsonXmlFieldAnno = this.getAnnotation(JsonXmlField.class);
            if (jsonXmlFieldAnno != null) {
                if (N.notNullOrEmpty(jsonXmlFieldAnno.type())) {
                    return jsonXmlFieldAnno.type();
                }
                if (propClass.isEnum()) {
                    return ClassUtil.getCanonicalClassName(propClass) + "(" + String.valueOf(ParserUtil.getEnumerated(field, jsonXmlConfig) == Type.EnumBy.ORDINAL) + ")";
                }
            }
            if (jsonXmlConfig != null && propClass.isEnum()) {
                return ClassUtil.getCanonicalClassName(propClass) + "(" + String.valueOf(ParserUtil.getEnumerated(field, jsonXmlConfig) == Type.EnumBy.ORDINAL) + ")";
            }
            Type typeAnno = this.getAnnotation(Type.class);
            if (typeAnno != null && (typeAnno.scope() == Type.Scope.ALL || typeAnno.scope() == Type.Scope.PARSER) && N.notNullOrEmpty(typeName = this.getTypeName(typeAnno, propClass))) {
                return typeName;
            }
            return null;
        }

        private String getDBAnnoType(Field field, Method getMethod, Method setMethod, Class<?> propClass) {
            String typeName;
            Type typeAnno = this.getAnnotation(Type.class);
            if (typeAnno != null && (typeAnno.scope() == Type.Scope.ALL || typeAnno.scope() == Type.Scope.DB) && N.notNullOrEmpty(typeName = this.getTypeName(typeAnno, propClass))) {
                return typeName;
            }
            return null;
        }

        private String getTypeName(Type typeAnno, Class<?> propClass) {
            u.Optional<String> typeName = N.firstNonEmpty(typeAnno.value(), typeAnno.name());
            Class<? extends com.landawn.abacus.type.Type> typeClass = typeAnno.clazz();
            if (typeClass != null && !typeClass.equals(com.landawn.abacus.type.Type.class)) {
                com.landawn.abacus.type.Type type = null;
                Constructor<? extends com.landawn.abacus.type.Type> constructor = null;
                if (typeName.isPresent()) {
                    constructor = ClassUtil.getDeclaredConstructor(typeClass, String.class);
                    if (constructor != null) {
                        ClassUtil.setAccessibleQuietly(constructor, true);
                        type = ClassUtil.invokeConstructor(constructor, typeName.get());
                    } else {
                        constructor = ClassUtil.getDeclaredConstructor(typeClass, new Class[0]);
                        if (constructor == null) {
                            throw new IllegalArgumentException("No default constructor found in type class: " + typeClass);
                        }
                        ClassUtil.setAccessibleQuietly(constructor, true);
                        type = ClassUtil.invokeConstructor(constructor, new Object[0]);
                    }
                } else {
                    constructor = ClassUtil.getDeclaredConstructor(typeClass, new Class[0]);
                    if (constructor == null) {
                        throw new IllegalArgumentException("No default constructor found in type class: " + typeClass);
                    }
                    ClassUtil.setAccessibleQuietly(constructor, true);
                    type = ClassUtil.invokeConstructor(constructor, new Object[0]);
                }
                try {
                    TypeFactory.registerType(type);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return type.name();
            }
            if (typeName.isPresent()) {
                return typeName.get();
            }
            if (propClass.isEnum()) {
                return ClassUtil.getCanonicalClassName(propClass) + "(" + String.valueOf(typeAnno.enumerated() == Type.EnumBy.ORDINAL) + ")";
            }
            return null;
        }

        private <T> com.landawn.abacus.type.Type<T> getType(String annoType, Field field, Method getMethod, Method setMethod, Class<?> propClass, Class<?> entityClass) {
            if (N.isNullOrEmpty(annoType)) {
                String parameterizedTypeName = field != null ? ClassUtil.getParameterizedTypeNameByField(field) : ClassUtil.getParameterizedTypeNameByMethod(setMethod == null ? getMethod : setMethod);
                return N.typeOf(parameterizedTypeName);
            }
            com.landawn.abacus.type.Type type = null;
            try {
                type = N.typeOf(annoType);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if ((type == null || type.getClass().equals(ObjectType.class)) && N.notNullOrEmpty(ClassUtil.getPackageName(entityClass))) {
                String pkgName = ClassUtil.getPackageName(entityClass);
                StringBuilder sb = new StringBuilder();
                int start = 0;
                int len = annoType.length();
                for (int i = 0; i < len; ++i) {
                    char ch = annoType.charAt(i);
                    if (ch != '<' && ch != '>' && ch != ' ' && ch != ',') continue;
                    String str = annoType.substring(start, i);
                    if (str.length() > 0 && N.typeOf(str).clazz().equals(Object.class) && !N.typeOf(pkgName + "." + str).clazz().equals(Object.class)) {
                        sb.append(pkgName + "." + str);
                    } else {
                        sb.append(str);
                    }
                    sb.append(ch);
                    start = i + 1;
                }
                if (start < annoType.length()) {
                    String str = annoType.substring(start);
                    if (N.typeOf(str).clazz().equals(Object.class) && !N.typeOf(pkgName + "." + str).clazz().equals(Object.class)) {
                        sb.append(pkgName + "." + str);
                    } else {
                        sb.append(str);
                    }
                }
                type = N.typeOf(sb.toString());
            }
            return type;
        }

        public int hashCode() {
            return (this.name == null ? 0 : this.name.hashCode()) * 31 + (this.field == null ? 0 : this.field.hashCode());
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof PropInfo && ((PropInfo)obj).name.equals(this.name) && N.equals(((PropInfo)obj).field, this.field);
        }

        public String toString() {
            return this.name;
        }

        static {
            propFuncMap.put(java.util.Date.class, new DateTimeReaderWriter<java.util.Date>(){

                @Override
                public java.util.Date read(PropInfo propInfo, String strValue) {
                    if (propInfo.isLongDateFormat) {
                        return new java.util.Date(Numbers.toLong(strValue));
                    }
                    return DateUtil.parseJUDate(strValue, propInfo.dateFormat, propInfo.timeZone);
                }

                @Override
                public void write(PropInfo propInfo, java.util.Date x, CharacterWriter writer) throws IOException {
                    if (propInfo.isLongDateFormat) {
                        writer.write(x.getTime());
                    } else {
                        DateUtil.format((Writer)writer, x, propInfo.dateFormat, propInfo.timeZone);
                    }
                }
            });
            propFuncMap.put(Calendar.class, new DateTimeReaderWriter<Calendar>(){

                @Override
                public Calendar read(PropInfo propInfo, String strValue) {
                    if (propInfo.isLongDateFormat) {
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTimeInMillis(Numbers.toLong(strValue));
                        calendar.setTimeZone(propInfo.timeZone);
                        return calendar;
                    }
                    return DateUtil.parseCalendar(strValue, propInfo.dateFormat, propInfo.timeZone);
                }

                @Override
                public void write(PropInfo propInfo, Calendar x, CharacterWriter writer) throws IOException {
                    if (propInfo.isLongDateFormat) {
                        writer.write(x.getTimeInMillis());
                    } else {
                        DateUtil.format((Writer)writer, x, propInfo.dateFormat, propInfo.timeZone);
                    }
                }
            });
            propFuncMap.put(Timestamp.class, new DateTimeReaderWriter<Timestamp>(){

                @Override
                public Timestamp read(PropInfo propInfo, String strValue) {
                    if (propInfo.isLongDateFormat) {
                        return new Timestamp(Numbers.toLong(strValue));
                    }
                    return DateUtil.parseTimestamp(strValue, propInfo.dateFormat, propInfo.timeZone);
                }

                @Override
                public void write(PropInfo propInfo, Timestamp x, CharacterWriter writer) throws IOException {
                    if (propInfo.isLongDateFormat) {
                        writer.write(x.getTime());
                    } else {
                        DateUtil.format((Writer)writer, x, propInfo.dateFormat, propInfo.timeZone);
                    }
                }
            });
            propFuncMap.put(Date.class, new DateTimeReaderWriter<Date>(){

                @Override
                public Date read(PropInfo propInfo, String strValue) {
                    if (propInfo.isLongDateFormat) {
                        return new Date(Numbers.toLong(strValue));
                    }
                    return DateUtil.parseDate(strValue, propInfo.dateFormat, propInfo.timeZone);
                }

                @Override
                public void write(PropInfo propInfo, Date x, CharacterWriter writer) throws IOException {
                    if (propInfo.isLongDateFormat) {
                        writer.write(x.getTime());
                    } else {
                        DateUtil.format((Writer)writer, x, propInfo.dateFormat, propInfo.timeZone);
                    }
                }
            });
            propFuncMap.put(Time.class, new DateTimeReaderWriter<Time>(){

                @Override
                public Time read(PropInfo propInfo, String strValue) {
                    if (propInfo.isLongDateFormat) {
                        return new Time(Numbers.toLong(strValue));
                    }
                    return DateUtil.parseTime(strValue, propInfo.dateFormat, propInfo.timeZone);
                }

                @Override
                public void write(PropInfo propInfo, Time x, CharacterWriter writer) throws IOException {
                    if (propInfo.isLongDateFormat) {
                        writer.write(x.getTime());
                    } else {
                        DateUtil.format((Writer)writer, x, propInfo.dateFormat, propInfo.timeZone);
                    }
                }
            });
            try {
                if (Class.forName("org.joda.time.DateTime") != null) {
                    propFuncMap.put(DateTime.class, new DateTimeReaderWriter<DateTime>(){

                        @Override
                        public DateTime read(PropInfo propInfo, String strValue) {
                            if (propInfo.isLongDateFormat) {
                                DateTime dt = new DateTime(Numbers.toLong(strValue));
                                return dt.getZone().equals((Object)propInfo.jodaDTFH.dtz) ? dt : dt.withZone(propInfo.jodaDTFH.dtz);
                            }
                            return propInfo.jodaDTFH.dtf.parseDateTime(strValue);
                        }

                        @Override
                        public void write(PropInfo propInfo, DateTime x, CharacterWriter writer) throws IOException {
                            if (propInfo.isLongDateFormat) {
                                writer.write(x.getMillis());
                            } else {
                                propInfo.jodaDTFH.dtf.printTo((Writer)writer, (ReadableInstant)x);
                            }
                        }
                    });
                    propFuncMap.put(MutableDateTime.class, new DateTimeReaderWriter<MutableDateTime>(){

                        @Override
                        public MutableDateTime read(PropInfo propInfo, String strValue) {
                            if (propInfo.isLongDateFormat) {
                                MutableDateTime dt = new MutableDateTime(Numbers.toLong(strValue));
                                if (!propInfo.jodaDTFH.dtz.equals((Object)dt.getZone())) {
                                    dt.setZone(propInfo.jodaDTFH.dtz);
                                }
                                return dt;
                            }
                            return propInfo.jodaDTFH.dtf.parseMutableDateTime(strValue);
                        }

                        @Override
                        public void write(PropInfo propInfo, MutableDateTime x, CharacterWriter writer) throws IOException {
                            if (propInfo.isLongDateFormat) {
                                writer.write(x.getMillis());
                            } else {
                                propInfo.jodaDTFH.dtf.printTo((Writer)writer, (ReadableInstant)x);
                            }
                        }
                    });
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static class EntityInfo
    implements JSONReader.SymbolReader {
        public final Class<Object> cls;
        public final String simpleClassName;
        public final String canonicalClassName;
        final String name;
        public final com.landawn.abacus.type.Type<Object> type;
        public final ImmutableList<PropInfo> propInfoList;
        public final ImmutableMap<Class<? extends Annotation>, Annotation> annotations;
        final NamingPolicy jsonXmlNamingPolicy;
        final String typeName;
        final JsonNameTag[] jsonNameTags;
        final XmlNameTag[] xmlNameTags;
        final PropInfo[] propInfos;
        final PropInfo[] jsonXmlSerializablePropInfos;
        final PropInfo[] nonTransientSeriPropInfos;
        final PropInfo[] transientSeriPropInfos;
        final Set<String> transientSeriPropNameSet = N.newHashSet();
        private final Map<String, PropInfo> propInfoMap;
        private final Map<String, List<PropInfo>> propInfoQueueMap;
        private final PropInfo[] propInfoArray;
        private final Map<Integer, PropInfo> hashPropInfoMap;
        public final u.Optional<String> tableName;

        public EntityInfo(Class<?> cls) {
            this.simpleClassName = ClassUtil.getSimpleClassName(cls);
            this.canonicalClassName = ClassUtil.getCanonicalClassName(cls);
            this.name = ClassUtil.formalizePropName(this.simpleClassName);
            this.cls = cls;
            this.type = N.typeOf(cls);
            this.typeName = this.type.name();
            this.annotations = ImmutableMap.of(this.getAnnotations(cls));
            JsonXmlConfig jsonXmlConfig = (JsonXmlConfig)this.annotations.get(JsonXmlConfig.class);
            this.jsonXmlNamingPolicy = jsonXmlConfig == null || jsonXmlConfig.namingPolicy() == null ? NamingPolicy.LOWER_CAMEL_CASE : jsonXmlConfig.namingPolicy();
            this.jsonNameTags = ParserUtil.getJsonNameTags(this.name);
            this.xmlNameTags = ParserUtil.getXmlNameTags(this.name, this.typeName, true);
            ImmutableList<String> propNameList = ClassUtil.getPropNameList(cls);
            ArrayList<ASMPropInfo> seriPropInfoList = new ArrayList<ASMPropInfo>();
            ArrayList<ASMPropInfo> nonTransientSeriPropInfoList = new ArrayList<ASMPropInfo>();
            ArrayList<ASMPropInfo> transientSeriPropInfoList = new ArrayList<ASMPropInfo>();
            this.propInfos = new PropInfo[propNameList.size()];
            this.propInfoMap = new ObjectPool<String, PropInfo>((propNameList.size() + 1) * 2);
            this.propInfoQueueMap = new ObjectPool<String, List<PropInfo>>((propNameList.size() + 1) * 2);
            this.hashPropInfoMap = new ObjectPool<Integer, PropInfo>((propNameList.size() + 1) * 2);
            PropInfo propInfo = null;
            int i = 0;
            Multiset<Integer> multiSet = N.newMultiset(propNameList.size() + 16);
            int maxLength = 0;
            Field field = null;
            Method getMethod = null;
            for (String propName : propNameList) {
                Object[] alias;
                field = ClassUtil.getPropField(cls, propName);
                getMethod = ClassUtil.getPropGetMethod(cls, propName);
                propInfo = ASMUtil.isASMAvailable() ? new ASMPropInfo(propName, field, getMethod, jsonXmlConfig, this.annotations) : new PropInfo(propName, field, getMethod, jsonXmlConfig, this.annotations);
                this.propInfos[i++] = propInfo;
                this.propInfoMap.put(propName, propInfo);
                String jsonTagName = null;
                for (JsonNameTag nameTag : propInfo.jsonNameTags) {
                    jsonTagName = new String(nameTag.name);
                    if (this.propInfoMap.containsKey(jsonTagName)) continue;
                    this.propInfoMap.put(jsonTagName, propInfo);
                }
                if (propInfo.columnName.isPresent() && !this.propInfoMap.containsKey(propInfo.columnName.get())) {
                    this.propInfoMap.put(propInfo.columnName.get(), propInfo);
                }
                if (N.notNullOrEmpty(alias = ParserUtil.getAlias(propInfo.field))) {
                    for (Object str : alias) {
                        if (this.propInfoMap.containsKey(str)) {
                            throw new IllegalArgumentException("Can't set alias: " + (String)str + " for property/field: " + propInfo.field + " because " + (String)str + " is a property/field name in class: " + cls);
                        }
                        this.propInfoMap.put((String)str, propInfo);
                    }
                }
                if (!ParserUtil.isJsonXmlSerializable(propInfo.field, jsonXmlConfig)) {
                    if (propInfo.jsonXmlExpose != JsonXmlField.Expose.DEFAULT) {
                        throw new IllegalArgumentException("JsonXmlField.Expose can't be: " + (Object)((Object)propInfo.jsonXmlExpose) + " for non-serializable field: " + propInfo.field);
                    }
                } else {
                    seriPropInfoList.add((ASMPropInfo)propInfo);
                    if (propInfo.isTransient) {
                        if (propInfo.jsonXmlExpose != JsonXmlField.Expose.DEFAULT) {
                            throw new IllegalArgumentException("JsonXmlField.Expose can't be: " + (Object)((Object)propInfo.jsonXmlExpose) + " for transient field: " + propInfo.field);
                        }
                        this.transientSeriPropNameSet.add(propName);
                        transientSeriPropInfoList.add((ASMPropInfo)propInfo);
                    } else {
                        nonTransientSeriPropInfoList.add((ASMPropInfo)propInfo);
                    }
                }
                multiSet.add(propInfo.jsonNameTags[defaultNameIndex].name.length);
                maxLength = Math.max(propInfo.jsonNameTags[defaultNameIndex].name.length, maxLength);
            }
            this.jsonXmlSerializablePropInfos = seriPropInfoList.toArray(new PropInfo[seriPropInfoList.size()]);
            this.nonTransientSeriPropInfos = nonTransientSeriPropInfoList.toArray(new PropInfo[nonTransientSeriPropInfoList.size()]);
            this.transientSeriPropInfos = transientSeriPropInfoList.toArray(new PropInfo[transientSeriPropInfoList.size()]);
            this.propInfoArray = new PropInfo[maxLength + 1];
            for (PropInfo e : this.propInfos) {
                this.hashPropInfoMap.put(ParserUtil.hashCode(e.jsonNameTags[defaultNameIndex].name), e);
                if (multiSet.get(e.jsonNameTags[defaultNameIndex].name.length) != 1) continue;
                this.propInfoArray[e.jsonNameTags[defaultNameIndex].name.length] = e;
            }
            this.propInfoList = ImmutableList.of(this.propInfos);
            String tmpTableName = null;
            if (this.annotations.containsKey(com.landawn.abacus.annotation.Table.class)) {
                tmpTableName = ((com.landawn.abacus.annotation.Table)this.annotations.get(com.landawn.abacus.annotation.Table.class)).value();
                if (N.isNullOrEmpty(tmpTableName)) {
                    tmpTableName = ((com.landawn.abacus.annotation.Table)this.annotations.get(com.landawn.abacus.annotation.Table.class)).name();
                }
            } else {
                try {
                    if (this.annotations.containsKey(Table.class)) {
                        tmpTableName = ((Table)this.annotations.get(Table.class)).name();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.tableName = N.isNullOrEmpty(tmpTableName) ? u.Optional.empty() : u.Optional.ofNullable(tmpTableName);
        }

        public PropInfo getPropInfo(String propName) {
            PropInfo propInfo = this.propInfoMap.get(propName);
            if (propInfo == null) {
                Method method = ClassUtil.getPropGetMethod(this.cls, propName);
                if (method != null) {
                    propInfo = this.propInfoMap.get(ClassUtil.getPropNameByMethod(method));
                }
                if (propInfo == null) {
                    for (String key : this.propInfoMap.keySet()) {
                        if (!this.isPropName(this.cls, propName, key)) continue;
                        propInfo = this.propInfoMap.get(key);
                        break;
                    }
                    if (propInfo == null && !propName.equalsIgnoreCase(ClassUtil.formalizePropName(propName))) {
                        propInfo = this.getPropInfo(ClassUtil.formalizePropName(propName));
                    }
                }
                if (propInfo == null) {
                    propInfo = PROP_INFO_MASK;
                } else if (propInfo != PROP_INFO_MASK) {
                    this.hashPropInfoMap.put(ParserUtil.hashCode(propInfo.jsonNameTags[defaultNameIndex].name), propInfo);
                }
                this.propInfoMap.put(propName, propInfo);
            }
            return propInfo == PROP_INFO_MASK ? null : propInfo;
        }

        public <T> T getPropValue(Object obj, String propName) {
            PropInfo propInfo = this.getPropInfo(propName);
            if (propInfo == null) {
                List<PropInfo> propInfoQueue = this.getPropInfoQueue(propName);
                if (propInfoQueue.size() == 0) {
                    throw new RuntimeException("No property method found with property name: " + propName + " in class: " + this.cls.getCanonicalName());
                }
                Object propEntity = obj;
                int len = propInfoQueue.size();
                for (int i = 0; i < len; ++i) {
                    propEntity = propInfoQueue.get(i).getPropValue(propEntity);
                    if (propEntity != null) continue;
                    return (T)propInfoQueue.get((int)(len - 1)).type.defaultValue();
                }
                return (T)propEntity;
            }
            return propInfo.getPropValue(obj);
        }

        public void setPropValue(Object obj, String propName, Object propValue) {
            this.setPropValue(obj, propName, propValue, false);
        }

        public boolean setPropValue(Object obj, String propName, Object propValue, boolean ignoreUnmatchedProperty) {
            PropInfo propInfo = this.getPropInfo(propName);
            if (propInfo == null) {
                List<PropInfo> propInfoQueue = this.getPropInfoQueue(propName);
                if (propInfoQueue.size() == 0) {
                    if (!ignoreUnmatchedProperty) {
                        throw new RuntimeException("No property method found with property name: " + propName + " in class: " + this.cls.getCanonicalName());
                    }
                    return false;
                }
                Object propEntity = obj;
                Object subPropValue = null;
                int len = propInfoQueue.size();
                for (int i = 0; i < len; ++i) {
                    propInfo = propInfoQueue.get(i);
                    if (i == len - 1) {
                        propInfo.setPropValue(propEntity, propValue);
                        continue;
                    }
                    subPropValue = propInfo.getPropValue(propEntity);
                    if (subPropValue == null) {
                        if (propInfo.type.isCollection()) {
                            subPropValue = N.newInstance(propInfo.type.getElementType().clazz());
                            Collection c = (Collection)N.newInstance(propInfo.type.clazz());
                            c.add(subPropValue);
                            propInfo.setPropValue(propEntity, c);
                        } else {
                            subPropValue = N.newInstance(propInfo.clazz);
                            propInfo.setPropValue(propEntity, subPropValue);
                        }
                    } else if (propInfo.type.isCollection()) {
                        subPropValue = propInfo.type.isList() ? ((List)subPropValue).get(0) : N.firstOrNullIfEmpty((Collection)subPropValue);
                    }
                    propEntity = subPropValue;
                }
            } else {
                propInfo.setPropValue(obj, propValue);
            }
            return true;
        }

        private boolean isPropName(Class<?> cls, String inputPropName, String propNameByMethod) {
            if (inputPropName.length() > 128) {
                throw new RuntimeException("The property name execeed 128: " + inputPropName);
            }
            return (inputPropName = inputPropName.trim()).equalsIgnoreCase(propNameByMethod) || inputPropName.replace("_", N.EMPTY_STRING).equalsIgnoreCase(propNameByMethod) || inputPropName.equalsIgnoreCase(ClassUtil.getSimpleClassName(cls) + '.' + propNameByMethod) || inputPropName.startsWith(GET) && inputPropName.substring(3).equalsIgnoreCase(propNameByMethod) || inputPropName.startsWith(SET) && inputPropName.substring(3).equalsIgnoreCase(propNameByMethod) || inputPropName.startsWith(IS) && inputPropName.substring(2).equalsIgnoreCase(propNameByMethod) || inputPropName.startsWith(HAS) && inputPropName.substring(2).equalsIgnoreCase(propNameByMethod);
        }

        private List<PropInfo> getPropInfoQueue(String propName) {
            List<PropInfo> propInfoQueue = this.propInfoQueueMap.get(propName);
            if (propInfoQueue == null) {
                propInfoQueue = new ArrayList<PropInfo>();
                String[] strs = Splitter.with('.').splitToArray(propName);
                if (strs.length > 1) {
                    Class<Object> propClass = this.cls;
                    PropInfo propInfo = null;
                    int len = strs.length;
                    for (int i = 0; i < len; ++i) {
                        propInfo = ParserUtil.getEntityInfo(propClass).getPropInfo(strs[i]);
                        if (propInfo == null) {
                            propInfoQueue.clear();
                            break;
                        }
                        propInfoQueue.add(propInfo);
                        propClass = propInfo.type.isCollection() ? propInfo.type.getElementType().clazz() : propInfo.clazz;
                    }
                }
                this.propInfoQueueMap.put(propName, propInfoQueue);
            }
            return propInfoQueue;
        }

        @Override
        public PropInfo readPropInfo(char[] cbuf, int fromIndex, int toIndex) {
            char[] tmp;
            int len = toIndex - fromIndex;
            if (len == 0) {
                return null;
            }
            PropInfo propInfo = null;
            if (len < this.propInfoArray.length) {
                propInfo = this.propInfoArray[len];
            }
            if (propInfo == null) {
                propInfo = this.hashPropInfoMap.get(ParserUtil.hashCode(cbuf, fromIndex, toIndex));
            }
            if (propInfo != null && (tmp = propInfo.jsonNameTags[defaultNameIndex].name).length == len) {
                for (int i = 0; i < len; ++i) {
                    if (cbuf[i + fromIndex] == tmp[i]) continue;
                    return null;
                }
            }
            return propInfo;
        }

        public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
            return this.annotations.containsKey(annotationClass);
        }

        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            return (T)this.annotations.get(annotationClass);
        }

        private Map<Class<? extends Annotation>, Annotation> getAnnotations(Class<?> cls) {
            HashMap<Class<? extends Annotation>, Annotation> annotations = new HashMap<Class<? extends Annotation>, Annotation>();
            Set<Class<?>> classes = ClassUtil.getAllSuperTypes(cls);
            N.reverse(classes);
            classes.add(cls);
            for (Class<?> clazz : classes) {
                if (!N.notNullOrEmpty(clazz.getAnnotations())) continue;
                for (Annotation anno : clazz.getAnnotations()) {
                    annotations.put(anno.annotationType(), anno);
                }
            }
            return annotations;
        }

        public int hashCode() {
            return this.cls == null ? 0 : this.cls.hashCode();
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof EntityInfo && N.equals(((EntityInfo)obj).cls, this.cls);
        }

        public String toString() {
            return ClassUtil.getCanonicalClassName(this.cls);
        }
    }
}

