/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.parser;

import com.landawn.abacus.DirtyMarker;
import com.landawn.abacus.annotation.JsonXmlField;
import com.landawn.abacus.core.DirtyMarkerUtil;
import com.landawn.abacus.core.MapEntity;
import com.landawn.abacus.exception.ParseException;
import com.landawn.abacus.exception.UncheckedIOException;
import com.landawn.abacus.parser.AbstractXMLParser;
import com.landawn.abacus.parser.Exclusion;
import com.landawn.abacus.parser.JSONDeserializationConfig;
import com.landawn.abacus.parser.ParserUtil;
import com.landawn.abacus.parser.XMLConstants;
import com.landawn.abacus.parser.XMLDeserializationConfig;
import com.landawn.abacus.parser.XMLParserType;
import com.landawn.abacus.parser.XMLSerializationConfig;
import com.landawn.abacus.type.Type;
import com.landawn.abacus.util.BufferedReader;
import com.landawn.abacus.util.BufferedXMLWriter;
import com.landawn.abacus.util.ClassUtil;
import com.landawn.abacus.util.IOUtil;
import com.landawn.abacus.util.IdentityHashSet;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.NamingPolicy;
import com.landawn.abacus.util.Objectory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

final class XMLParserImpl
extends AbstractXMLParser {
    private final XMLParserType parserType;

    XMLParserImpl(XMLParserType parserType) {
        this.parserType = parserType;
    }

    XMLParserImpl(XMLParserType parserType, XMLSerializationConfig xsc, XMLDeserializationConfig xdc) {
        super(xsc, xdc);
        this.parserType = parserType;
    }

    @Override
    public String serialize(Object obj, XMLSerializationConfig config) {
        if (obj == null) {
            return N.EMPTY_STRING;
        }
        BufferedXMLWriter bw = Objectory.createBufferedXMLWriter();
        IdentityHashSet<Object> serializedObjects = config != null && config.supportCircularReference() ? new IdentityHashSet<Object>() : null;
        try {
            this.write(bw, obj, config, false, null, serializedObjects);
            String string = bw.toString();
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            Objectory.recycle(bw);
        }
    }

    @Override
    public void serialize(File file, Object obj, XMLSerializationConfig config) {
        FileOutputStream os = null;
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            os = new FileOutputStream(file);
            this.serialize((OutputStream)os, obj, config);
            os.flush();
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException(e);
            }
            catch (Throwable throwable) {
                IOUtil.close(os);
                throw throwable;
            }
        }
        IOUtil.close(os);
    }

    @Override
    public void serialize(OutputStream os, Object obj, XMLSerializationConfig config) {
        BufferedXMLWriter bw = Objectory.createBufferedXMLWriter(os);
        IdentityHashSet<Object> serializedObjects = config != null && config.supportCircularReference() ? new IdentityHashSet<Object>() : null;
        try {
            this.write(bw, obj, config, true, null, serializedObjects);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            Objectory.recycle(bw);
        }
    }

    @Override
    public void serialize(Writer writer, Object obj, XMLSerializationConfig config) {
        boolean isBufferedWriter = writer instanceof BufferedXMLWriter;
        BufferedXMLWriter bw = isBufferedWriter ? (BufferedXMLWriter)writer : Objectory.createBufferedXMLWriter(writer);
        IdentityHashSet<Object> serializedObjects = config != null && config.supportCircularReference() ? new IdentityHashSet<Object>() : null;
        try {
            this.write(bw, obj, config, true, null, serializedObjects);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            if (!isBufferedWriter) {
                Objectory.recycle(bw);
            }
        }
    }

    protected void write(BufferedXMLWriter bw, Object obj, XMLSerializationConfig config, boolean flush, String indentation, IdentityHashSet<Object> serializedObjects) throws IOException {
        XMLSerializationConfig configToUse = this.check(config);
        if (obj == null) {
            IOUtil.write((Writer)bw, (CharSequence)N.EMPTY_STRING);
            return;
        }
        Class<?> cls = obj.getClass();
        Type<Object> type = N.typeOf(cls);
        switch (type.getSerializationType()) {
            case SERIALIZABLE: {
                if (type.isObjectArray()) {
                    this.writeArray(bw, type, obj, configToUse, indentation, serializedObjects);
                    break;
                }
                if (type.isCollection()) {
                    this.writeCollection(bw, type, (Collection)obj, configToUse, indentation, serializedObjects);
                    break;
                }
                type.writeCharacter(bw, obj, configToUse);
                break;
            }
            case ENTITY: {
                this.writeEntity(bw, type, obj, configToUse, indentation, serializedObjects);
                break;
            }
            case MAP: {
                this.writeMap(bw, type, (Map)obj, configToUse, indentation, serializedObjects);
                break;
            }
            case MAP_ENTITY: {
                this.writeMapEntity(bw, type, (MapEntity)obj, configToUse, indentation, serializedObjects);
                break;
            }
            case ARRAY: {
                this.writeArray(bw, type, obj, configToUse, indentation, serializedObjects);
                break;
            }
            case COLLECTION: {
                this.writeCollection(bw, type, (Collection)obj, configToUse, indentation, serializedObjects);
                break;
            }
            default: {
                throw new ParseException("Unsupported class: " + ClassUtil.getCanonicalClassName(cls) + ". Only Array/List/Map and Entity class with getter/setter methods are supported");
            }
        }
        if (flush) {
            bw.flush();
        }
    }

    protected void writeEntity(BufferedXMLWriter bw, Type<Object> type, Object obj, XMLSerializationConfig config, String indentation, IdentityHashSet<Object> serializedObjects) throws IOException {
        if (this.hasCircularReference(bw, obj, serializedObjects)) {
            return;
        }
        Class<Object> cls = type.clazz();
        ParserUtil.EntityInfo entityInfo = ParserUtil.getEntityInfo(cls);
        if (N.isNullOrEmpty(entityInfo.jsonXmlSerializablePropInfos)) {
            throw new ParseException("No serializable property is found in class: " + ClassUtil.getCanonicalClassName(cls));
        }
        boolean tagByPropertyName = config.isTagByPropertyName();
        boolean ignoreTypeInfo = config.isIgnoreTypeInfo();
        boolean isPrettyFormat = config.isPrettyFormat();
        NamingPolicy jsonXmlNamingPolicy = config.getPropNamingPolicy() == null ? entityInfo.jsonXmlNamingPolicy : config.getPropNamingPolicy();
        int nameTagIdx = jsonXmlNamingPolicy.ordinal();
        if (isPrettyFormat && indentation != null) {
            bw.write(IOUtil.LINE_SEPARATOR);
            bw.write(indentation);
        }
        if (tagByPropertyName) {
            if (ignoreTypeInfo) {
                bw.write(entityInfo.xmlNameTags[nameTagIdx].namedStart);
            } else {
                bw.write(entityInfo.xmlNameTags[nameTagIdx].namedStartWithType);
            }
        } else if (ignoreTypeInfo) {
            bw.write(entityInfo.xmlNameTags[nameTagIdx].epStart);
        } else {
            bw.write(entityInfo.xmlNameTags[nameTagIdx].epStartWithType);
        }
        String propIndentation = isPrettyFormat ? (indentation == null ? N.EMPTY_STRING : indentation) + config.getIndentation() : null;
        this.writeProperties(bw, type, obj, config, propIndentation, serializedObjects);
        if (isPrettyFormat) {
            bw.write(IOUtil.LINE_SEPARATOR);
            if (indentation != null) {
                bw.write(indentation);
            }
        }
        if (tagByPropertyName) {
            bw.write(entityInfo.xmlNameTags[nameTagIdx].namedEnd);
        } else {
            bw.write(entityInfo.xmlNameTags[nameTagIdx].epEnd);
        }
    }

    protected void writeProperties(BufferedXMLWriter bw, Type<Object> type, Object obj, XMLSerializationConfig config, String propIndentation, IdentityHashSet<Object> serializedObjects) throws IOException {
        if (this.hasCircularReference(bw, obj, serializedObjects)) {
            return;
        }
        Class<Object> cls = type.clazz();
        ParserUtil.EntityInfo entityInfo = ParserUtil.getEntityInfo(cls);
        Collection<String> ignoredClassPropNames = config.getIgnoredPropNames(cls);
        boolean ignoreNullProperty = config.getExclusion() == Exclusion.NULL || config.getExclusion() == Exclusion.DEFAULT;
        boolean ignoreDefaultProperty = config.getExclusion() == Exclusion.DEFAULT;
        boolean tagByPropertyName = config.isTagByPropertyName();
        boolean ignoreTypeInfo = config.isIgnoreTypeInfo();
        boolean isPrettyFormat = config.isPrettyFormat();
        NamingPolicy jsonXmlNamingPolicy = config.getPropNamingPolicy() == null ? entityInfo.jsonXmlNamingPolicy : config.getPropNamingPolicy();
        int nameTagIdx = jsonXmlNamingPolicy.ordinal();
        Set signedPropNameSet = null;
        if (ignoreNullProperty && obj instanceof DirtyMarker) {
            Set<String> signedPropNames = DirtyMarkerUtil.signedPropNames((DirtyMarker)obj);
            if (N.isNullOrEmpty(signedPropNames)) {
                return;
            }
            signedPropNameSet = Objectory.createSet();
            for (String propName : signedPropNames) {
                signedPropNameSet.add(entityInfo.getPropInfo((String)propName).name);
            }
        }
        String nextIndentation = isPrettyFormat ? (propIndentation == null ? N.EMPTY_STRING : propIndentation) + config.getIndentation() : null;
        ParserUtil.PropInfo[] propInfoList = config.isSkipTransientField() ? entityInfo.nonTransientSeriPropInfos : entityInfo.jsonXmlSerializablePropInfos;
        ParserUtil.PropInfo propInfo2 = null;
        String propName = null;
        Object propValue = null;
        for (ParserUtil.PropInfo propInfo2 : propInfoList) {
            propName = propInfo2.name;
            if (propInfo2.jsonXmlExpose == JsonXmlField.Expose.DESERIALIZE_ONLY || signedPropNameSet != null && !signedPropNameSet.contains(propName) || ignoredClassPropNames != null && ignoredClassPropNames.contains(propName)) continue;
            propValue = propInfo2.getPropValue(obj);
            if (ignoreNullProperty && propValue == null || ignoreDefaultProperty && propValue != null && propInfo2.jsonXmlType != null && propInfo2.jsonXmlType.isPrimitiveType() && propValue.equals(propInfo2.jsonXmlType.defaultValue())) continue;
            if (isPrettyFormat) {
                bw.write(IOUtil.LINE_SEPARATOR);
                bw.write(propIndentation);
            }
            if (propValue == null) {
                if (tagByPropertyName) {
                    if (ignoreTypeInfo) {
                        bw.write(propInfo2.xmlNameTags[nameTagIdx].namedNull);
                        continue;
                    }
                    bw.write(propInfo2.xmlNameTags[nameTagIdx].namedNullWithType);
                    continue;
                }
                if (ignoreTypeInfo) {
                    bw.write(propInfo2.xmlNameTags[nameTagIdx].epNull);
                    continue;
                }
                bw.write(propInfo2.xmlNameTags[nameTagIdx].epNullWithType);
                continue;
            }
            if (tagByPropertyName) {
                if (ignoreTypeInfo) {
                    bw.write(propInfo2.xmlNameTags[nameTagIdx].namedStart);
                } else {
                    bw.write(propInfo2.xmlNameTags[nameTagIdx].namedStartWithType);
                }
            } else if (ignoreTypeInfo) {
                bw.write(propInfo2.xmlNameTags[nameTagIdx].epStart);
            } else {
                bw.write(propInfo2.xmlNameTags[nameTagIdx].epStartWithType);
            }
            if (propInfo2.hasFormat) {
                propInfo2.writePropValue(bw, propValue, config);
            } else {
                this.writeValue(bw, propInfo2.jsonXmlType, propInfo2, propValue, config, isPrettyFormat, propIndentation, nextIndentation, serializedObjects);
            }
            if (tagByPropertyName) {
                bw.write(propInfo2.xmlNameTags[nameTagIdx].namedEnd);
                continue;
            }
            bw.write(propInfo2.xmlNameTags[nameTagIdx].epEnd);
        }
        Objectory.recycle(signedPropNameSet);
    }

    protected void writeMap(BufferedXMLWriter bw, Type<Object> type, Map<?, ?> m, XMLSerializationConfig config, String indentation, IdentityHashSet<Object> serializedObjects) throws IOException {
        if (this.hasCircularReference(bw, m, serializedObjects)) {
            return;
        }
        Class<Object> cls = type.clazz();
        Collection<String> ignoredClassPropNames = config.getIgnoredPropNames(Map.class);
        boolean ignoreTypeInfo = config.isIgnoreTypeInfo();
        boolean isPrettyFormat = config.isPrettyFormat();
        if (isPrettyFormat && indentation != null) {
            bw.write(IOUtil.LINE_SEPARATOR);
            bw.write(indentation);
        }
        if (ignoreTypeInfo) {
            bw.write("<map>");
        } else {
            bw.write(XMLConstants.START_MAP_ELE_WITH_TYPE);
            bw.write(N.typeOf(cls).xmlName());
            bw.write(XMLConstants.CLOSE_ATTR_AND_ELE);
        }
        String propIndentation = isPrettyFormat ? (indentation == null ? N.EMPTY_STRING : indentation) + config.getIndentation() : null;
        String nextIndentation = propIndentation + config.getIndentation();
        String strKey = null;
        Object value = null;
        Type<Object> valueType = null;
        for (Object key : m.keySet()) {
            if (ignoredClassPropNames != null && ignoredClassPropNames.contains(key)) continue;
            strKey = key == null ? NULL_STRING : key.toString();
            value = m.get(key);
            if (isPrettyFormat) {
                bw.write(IOUtil.LINE_SEPARATOR);
                bw.write(propIndentation);
            }
            if (value == null) {
                bw.write('<');
                bw.write(strKey);
                bw.write(" isNull=\"true\"");
                bw.write(XMLConstants.END_ELEMENT);
                continue;
            }
            valueType = N.typeOf(value.getClass());
            bw.write('<');
            bw.write(strKey);
            if (ignoreTypeInfo) {
                bw.write('>');
            } else {
                bw.write(" type=\"");
                bw.write(valueType.xmlName());
                bw.write(XMLConstants.CLOSE_ATTR_AND_ELE);
            }
            this.writeValue(bw, valueType, null, value, config, isPrettyFormat, propIndentation, nextIndentation, serializedObjects);
            bw.write('<');
            bw.write('/');
            bw.write(strKey);
            bw.write('>');
        }
        if (isPrettyFormat) {
            bw.write(IOUtil.LINE_SEPARATOR);
            if (indentation != null) {
                bw.write(indentation);
            }
        }
        bw.write("</map>");
    }

    protected void writeMapEntity(BufferedXMLWriter bw, Type<Object> type, MapEntity mapEntity, XMLSerializationConfig config, String indentation, IdentityHashSet<Object> serializedObjects) throws IOException {
        if (this.hasCircularReference(bw, mapEntity, serializedObjects)) {
            return;
        }
        Class<Object> cls = type.clazz();
        NamingPolicy jsonXmlNamingPolicy = config.getPropNamingPolicy();
        Collection<String> ignoredClassPropNames = config.getIgnoredPropNames(Map.class);
        boolean ignoreTypeInfo = config.isIgnoreTypeInfo();
        boolean isPrettyFormat = config.isPrettyFormat();
        if (isPrettyFormat && indentation != null) {
            bw.write(IOUtil.LINE_SEPARATOR);
            bw.write(indentation);
        }
        bw.write('<');
        bw.write(mapEntity.entityName());
        if (ignoreTypeInfo) {
            bw.write('>');
        } else {
            bw.write(" type=\"");
            bw.write(N.typeOf(cls).xmlName());
            bw.write(XMLConstants.CLOSE_ATTR_AND_ELE);
        }
        String propIndentation = isPrettyFormat ? (indentation == null ? N.EMPTY_STRING : indentation) + config.getIndentation() : null;
        String nextIndentation = propIndentation + config.getIndentation();
        Object value = null;
        Type<Object> valueType = null;
        for (String key : mapEntity.keySet()) {
            if (ignoredClassPropNames != null && ignoredClassPropNames.contains(key)) continue;
            value = mapEntity.get(key);
            if (isPrettyFormat) {
                bw.write(IOUtil.LINE_SEPARATOR);
                bw.write(propIndentation);
            }
            String string = key = jsonXmlNamingPolicy == null ? key : jsonXmlNamingPolicy.convert(key);
            if (value == null) {
                bw.write('<');
                bw.write(key);
                bw.write(" isNull=\"true\"");
                bw.write(XMLConstants.END_ELEMENT);
                continue;
            }
            valueType = N.typeOf(value.getClass());
            bw.write('<');
            bw.write(key);
            if (ignoreTypeInfo) {
                bw.write('>');
            } else {
                bw.write(" type=\"");
                bw.write(valueType.xmlName());
                bw.write(XMLConstants.CLOSE_ATTR_AND_ELE);
            }
            this.writeValue(bw, valueType, null, value, config, isPrettyFormat, propIndentation, nextIndentation, serializedObjects);
            bw.write('<');
            bw.write('/');
            bw.write(key);
            bw.write('>');
        }
        if (isPrettyFormat) {
            bw.write(IOUtil.LINE_SEPARATOR);
            if (indentation != null) {
                bw.write(indentation);
            }
        }
        bw.write('<');
        bw.write('/');
        bw.write(mapEntity.entityName());
        bw.write('>');
    }

    protected void writeArray(BufferedXMLWriter bw, Type<Object> type, Object obj, XMLSerializationConfig config, String indentation, IdentityHashSet<Object> serializedObjects) throws IOException {
        if (this.hasCircularReference(bw, obj, serializedObjects)) {
            return;
        }
        Class<Object> cls = type.clazz();
        boolean ignoreTypeInfo = config.isIgnoreTypeInfo();
        boolean isPrettyFormat = config.isPrettyFormat();
        if (isPrettyFormat && indentation != null) {
            bw.write(IOUtil.LINE_SEPARATOR);
            bw.write(indentation);
        }
        if (ignoreTypeInfo) {
            bw.write("<array>");
        } else {
            bw.write(XMLConstants.START_ARRAY_ELE_WITH_TYPE);
            bw.write(N.typeOf(cls).xmlName());
            bw.write(XMLConstants.CLOSE_ATTR_AND_ELE);
        }
        String nextIndentation = isPrettyFormat ? (indentation == null ? N.EMPTY_STRING : indentation) + config.getIndentation() : null;
        Object[] a = (Object[])obj;
        boolean isSerializableByJSON = this.isSerializableByJSON(a);
        if (isSerializableByJSON) {
            strType.writeCharacter(bw, jsonParser.serialize(a, this.getJSC(config)), config);
        } else {
            for (Object e : a) {
                if (e == null) {
                    bw.write("<null isNull=\"true\" />");
                    continue;
                }
                this.write(bw, e, config, false, nextIndentation, serializedObjects);
            }
        }
        if (isPrettyFormat && !isSerializableByJSON) {
            bw.write(IOUtil.LINE_SEPARATOR);
            if (indentation != null) {
                bw.write(indentation);
            }
        }
        bw.write("</array>");
    }

    protected void writeCollection(BufferedXMLWriter bw, Type<Object> type, Collection<?> c, XMLSerializationConfig config, String indentation, IdentityHashSet<Object> serializedObjects) throws IOException {
        if (this.hasCircularReference(bw, c, serializedObjects)) {
            return;
        }
        Class<Object> cls = type.clazz();
        boolean ignoreTypeInfo = config.isIgnoreTypeInfo();
        boolean isPrettyFormat = config.isPrettyFormat();
        if (isPrettyFormat && indentation != null) {
            bw.write(IOUtil.LINE_SEPARATOR);
            bw.write(indentation);
        }
        if (type.isList()) {
            if (ignoreTypeInfo) {
                bw.write("<list>");
            } else {
                bw.write(XMLConstants.START_LIST_ELE_WITH_TYPE);
                bw.write(N.typeOf(cls).xmlName());
                bw.write(XMLConstants.CLOSE_ATTR_AND_ELE);
            }
        } else if (type.isSet()) {
            if (ignoreTypeInfo) {
                bw.write("<set>");
            } else {
                bw.write(XMLConstants.START_SET_ELE_WITH_TYPE);
                bw.write(type.xmlName());
                bw.write(XMLConstants.CLOSE_ATTR_AND_ELE);
            }
        } else if (ignoreTypeInfo) {
            bw.write("<collection>");
        } else {
            bw.write(XMLConstants.START_COLLECTION_ELE_WITH_TYPE);
            bw.write(type.xmlName());
            bw.write(XMLConstants.CLOSE_ATTR_AND_ELE);
        }
        String nextIndentation = isPrettyFormat ? (indentation == null ? N.EMPTY_STRING : indentation) + config.getIndentation() : null;
        boolean isSerializableByJSON = this.isSerializableByJSON(c);
        if (isSerializableByJSON) {
            strType.writeCharacter(bw, jsonParser.serialize(c, this.getJSC(config)), config);
        } else {
            for (Object e : c) {
                if (e == null) {
                    bw.write("<null isNull=\"true\" />");
                    continue;
                }
                this.write(bw, e, config, false, nextIndentation, serializedObjects);
            }
        }
        if (isPrettyFormat && !isSerializableByJSON) {
            bw.write(IOUtil.LINE_SEPARATOR);
            if (indentation != null) {
                bw.write(indentation);
            }
        }
        if (type.isList()) {
            bw.write("</list>");
        } else if (type.isSet()) {
            bw.write("</set>");
        } else {
            bw.write("</collection>");
        }
    }

    protected void writeValue(BufferedXMLWriter bw, Type<Object> valueType, ParserUtil.PropInfo propInfo, Object value, XMLSerializationConfig config, boolean isPrettyFormat, String propIndentation, String nextIndentation, IdentityHashSet<Object> serializedObjects) throws IOException {
        if (valueType.isSerializable()) {
            if (valueType.isObjectArray() || valueType.isCollection()) {
                strType.writeCharacter(bw, jsonParser.serialize(value, this.getJSC(config)), config);
            } else if (propInfo != null && propInfo.hasFormat) {
                propInfo.writePropValue(bw, value, config);
            } else {
                valueType.writeCharacter(bw, value, config);
            }
        } else if (valueType.isObjectArray()) {
            Object[] a = (Object[])value;
            boolean isSerializableByJSON = this.isSerializableByJSON(a);
            if (isSerializableByJSON) {
                strType.writeCharacter(bw, jsonParser.serialize(a, this.getJSC(config)), config);
            } else {
                for (Object e : a) {
                    if (e == null) {
                        if (isPrettyFormat) {
                            bw.write(IOUtil.LINE_SEPARATOR);
                            bw.write(nextIndentation);
                        }
                        bw.write("<null isNull=\"true\" />");
                        continue;
                    }
                    this.write(bw, e, config, false, nextIndentation, serializedObjects);
                }
                if (isPrettyFormat) {
                    bw.write(IOUtil.LINE_SEPARATOR);
                    bw.write(propIndentation);
                }
            }
        } else if (valueType.isCollection()) {
            Collection c = (Collection)value;
            boolean isSerializableByJSON = this.isSerializableByJSON(c);
            if (isSerializableByJSON) {
                strType.writeCharacter(bw, jsonParser.serialize(c, this.getJSC(config)), config);
            } else {
                for (Object e : c) {
                    if (e == null) {
                        if (isPrettyFormat) {
                            bw.write(IOUtil.LINE_SEPARATOR);
                            bw.write(nextIndentation);
                        }
                        bw.write("<null isNull=\"true\" />");
                        continue;
                    }
                    this.write(bw, e, config, false, nextIndentation, serializedObjects);
                }
                if (isPrettyFormat) {
                    bw.write(IOUtil.LINE_SEPARATOR);
                    bw.write(propIndentation);
                }
            }
        } else {
            this.write(bw, value, config, false, nextIndentation, serializedObjects);
            if (isPrettyFormat) {
                bw.write(IOUtil.LINE_SEPARATOR);
                bw.write(propIndentation);
            }
        }
    }

    private boolean hasCircularReference(BufferedXMLWriter bw, Object obj, IdentityHashSet<Object> serializedObjects) throws IOException {
        if (obj != null && serializedObjects != null) {
            if (serializedObjects.contains(obj)) {
                bw.write("null");
                return true;
            }
            serializedObjects.add(obj);
        }
        return false;
    }

    protected boolean isSerializableByJSON(Object[] a) {
        if (N.typeOf(a.getClass().getComponentType()).isSerializable()) {
            return true;
        }
        for (Object e : a) {
            if (e == null || !N.typeOf(e.getClass()).isSerializable()) continue;
            return true;
        }
        return false;
    }

    protected boolean isSerializableByJSON(Collection<?> c) {
        for (Object e : c) {
            if (e == null || !N.typeOf(e.getClass()).isSerializable()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T deserialize(Class<T> targetClass, String st, XMLDeserializationConfig config) {
        if (N.isNullOrEmpty(st)) {
            return N.defaultValueOf(targetClass);
        }
        BufferedReader br = Objectory.createBufferedReader(st);
        try {
            T t = this.read(null, targetClass, br, config);
            return t;
        }
        finally {
            Objectory.recycle(br);
        }
    }

    @Override
    public <T> T deserialize(Class<T> targetClass, File file, XMLDeserializationConfig config) {
        T t;
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            t = this.deserialize(targetClass, (InputStream)is, config);
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException(e);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtil.closeQuietly(is);
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T deserialize(Class<T> targetClass, InputStream is, XMLDeserializationConfig config) {
        BufferedReader br = Objectory.createBufferedReader(is);
        try {
            T t = this.read(null, targetClass, br, config);
            return t;
        }
        finally {
            Objectory.recycle(br);
        }
    }

    @Override
    public <T> T deserialize(Class<T> targetClass, Reader reader, XMLDeserializationConfig config) {
        return this.read(null, targetClass, reader, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T deserialize(Map<String, Class<?>> nodeClasses, InputStream is, XMLDeserializationConfig config) {
        BufferedReader br = Objectory.createBufferedReader(is);
        try {
            T t = this.read(nodeClasses, null, br, config);
            return t;
        }
        finally {
            Objectory.recycle(br);
        }
    }

    @Override
    public <T> T deserialize(Map<String, Class<?>> nodeClasses, Reader reader, XMLDeserializationConfig config) {
        return this.read(nodeClasses, null, reader, config);
    }

    protected <T> T read(Map<String, Class<?>> nodeClasses, Class<T> targetClass, Reader br, XMLDeserializationConfig config) {
        XMLDeserializationConfig configToUse = this.check(config);
        switch (this.parserType) {
            case StAX: {
                try {
                    XMLStreamReader xmlReader = this.createXMLStreamReader(br);
                    int event = xmlReader.next();
                    while (event != 1 && xmlReader.hasNext()) {
                        event = xmlReader.next();
                    }
                    if (targetClass == null && N.notNullOrEmpty(nodeClasses)) {
                        String nodeName = null;
                        if (xmlReader.getAttributeCount() > 0) {
                            nodeName = xmlReader.getAttributeValue(null, "name");
                        }
                        if (N.isNullOrEmpty(nodeName)) {
                            nodeName = xmlReader.getLocalName();
                        }
                        targetClass = nodeClasses.get(nodeName);
                    }
                    if (targetClass == null) {
                        throw new ParseException("No target class is specified");
                    }
                    return this.readByStreamParser(targetClass, xmlReader, configToUse);
                }
                catch (XMLStreamException e) {
                    throw new ParseException(e);
                }
            }
        }
        throw new ParseException("Unsupported parser: " + (Object)((Object)this.parserType));
    }

    protected <T> T readByStreamParser(Class<T> targetClass, XMLStreamReader xmlReader, XMLDeserializationConfig config) throws XMLStreamException {
        return this.readByStreamParser(targetClass, xmlReader, config, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected <T> T readByStreamParser(Class<?> targetClass, XMLStreamReader xmlReader, XMLDeserializationConfig config, Type<?> propType, ParserUtil.PropInfo propInfo) throws XMLStreamException {
        if (targetClass.equals(Object.class)) {
            targetClass = MapEntity.class;
        }
        if ((hasPropTypes = N.notNullOrEmpty((configToUse = this.check(config)).getPropTypes())) && xmlReader.getEventType() == 1 && configToUse.hasPropType(xmlReader.getLocalName())) {
            targetClass = configToUse.getPropType(xmlReader.getLocalName()).clazz();
        }
        serializationType = this.getDeserializationType(targetClass);
        propName = null;
        propValue = null;
        text = null;
        sb = null;
        switch (1.$SwitchMap$com$landawn$abacus$type$Type$SerializationType[serializationType.ordinal()]) {
            case 2: {
                ignoreUnmatchedProperty = configToUse.isIgnoreUnmatchedProperty();
                ignoredClassPropNames = configToUse.getIgnoredPropNames(targetClass);
                entityInfo = ParserUtil.getEntityInfo(targetClass);
                entity = N.newInstance(targetClass);
                attrCount = 0;
                event = xmlReader.next();
                while (xmlReader.hasNext()) {
                    switch (event) {
                        case 1: {
                            if (propName != null) ** GOTO lbl46
                            propName = xmlReader.getLocalName();
                            propInfo = entityInfo.getPropInfo(propName);
                            if (propName != null && ignoredClassPropNames != null && ignoredClassPropNames.contains(propName)) break;
                            if (propInfo == null) {
                                if (ignoreUnmatchedProperty) break;
                                throw new ParseException("Unknown property element: " + propName + " for class: " + targetClass.getCanonicalName());
                            }
                            v0 /* !! */  = propType = hasPropTypes != false ? configToUse.getPropType(propName) : null;
                            if (propType != null) break;
                            if (propInfo.jsonXmlType.isSerializable()) {
                                propType = propInfo.jsonXmlType;
                                break;
                            }
                            attrCount = xmlReader.getAttributeCount();
                            if (attrCount != 1) ** GOTO lbl38
                            if (!"type".equals(xmlReader.getAttributeLocalName(0))) ** GOTO lbl43
                            propType = N.typeOf(xmlReader.getAttributeValue(0));
                            ** GOTO lbl43
lbl38:
                            // 1 sources

                            if (attrCount > 1) {
                                for (i = 0; i < attrCount; ++i) {
                                    if (!"type".equals(xmlReader.getAttributeLocalName(i))) continue;
                                    propType = N.typeOf(xmlReader.getAttributeValue(i));
                                    break;
                                }
                            }
lbl43:
                            // 6 sources

                            if (propType != null) break;
                            propType = propInfo.jsonXmlType;
                            break;
lbl46:
                            // 1 sources

                            if (propInfo == null || propName != null && ignoredClassPropNames != null && ignoredClassPropNames.contains(propName)) {
                                startCount = 1;
                                e = xmlReader.next();
                                while ((startCount += e == 1 ? 1 : (e == 2 ? -1 : 0)) >= 0 && xmlReader.hasNext()) {
                                    e = xmlReader.next();
                                }
                            } else if (Map.class.isAssignableFrom(propType.clazz()) || ClassUtil.isEntity(propType.clazz()) || MapEntity.class.equals(propType.clazz()) || Object.class.equals(propType.clazz())) {
                                propValue = this.readByStreamParser(Object.class.equals(propType.clazz()) != false ? Map.class : propType.clazz(), xmlReader, configToUse, propType, propInfo);
                                startCount = 0;
                                e = xmlReader.next();
                                while ((startCount += e == 1 ? 1 : (e == 2 ? -1 : 0)) >= 0 && xmlReader.hasNext()) {
                                    e = xmlReader.next();
                                }
                            } else {
                                c = Collection.class.isAssignableFrom(propType.clazz()) != false ? (Collection)N.newInstance(propType.clazz()) : new ArrayList<E>();
                                propEleType = this.getPropEleType(propType);
                                do {
                                    if (xmlReader.getAttributeCount() > 0 && XMLParserImpl.TRUE.equals(xmlReader.getAttributeValue(null, "isNull"))) {
                                        c.add(null);
                                        xmlReader.next();
                                        continue;
                                    }
                                    c.add(this.readByStreamParser(propEleType.clazz(), xmlReader, configToUse, propType, null));
                                } while (xmlReader.hasNext() && xmlReader.next() == 1);
                                v1 = propValue = propType.clazz().isArray() != false ? XMLParserImpl.collection2Array(propType.clazz(), c) : c;
                            }
                            if (xmlReader.getEventType() == 2 && xmlReader.getLocalName().equals(propName)) {
                                if (!(propInfo == null || propInfo.jsonXmlExpose == JsonXmlField.Expose.SERIALIZE_ONLY || propName != null && ignoredClassPropNames != null && ignoredClassPropNames.contains(propName))) {
                                    propInfo.setPropValue(entity, propValue);
                                }
                                propName = null;
                                propValue = null;
                                propInfo = null;
                                break;
                            }
                            throw new ParseException("Unknown parser error at element: " + xmlReader.getLocalName());
                        }
                        case 4: {
                            if (propInfo == null) break;
                            text = xmlReader.getText();
                            if (text != null && text.length() > 256) {
                                while ((event = xmlReader.next()) == 4) {
                                    if (sb == null) {
                                        sb = new StringBuilder(text.length() * 2);
                                        sb.append(text);
                                    } else if (sb.length() == 0) {
                                        sb.append(text);
                                    }
                                    sb.append(xmlReader.getText());
                                }
                                if (sb != null && sb.length() > text.length()) {
                                    text = sb.toString();
                                    sb.setLength(0);
                                }
                            }
                            v2 = propValue = propInfo.hasFormat != false ? propInfo.readPropValue(text) : propType.valueOf(text);
                            if (event != 2) break;
                            if (!(propInfo == null || propInfo.jsonXmlExpose == JsonXmlField.Expose.SERIALIZE_ONLY || propName != null && ignoredClassPropNames != null && ignoredClassPropNames.contains(propName))) {
                                propInfo.setPropValue(entity, propValue == null ? propType.defaultValue() : propValue);
                            }
                            propName = null;
                            propValue = null;
                            propInfo = null;
                            break;
                        }
                        case 2: {
                            if (propName == null) {
                                return (T)entity;
                            }
                            if (!(propInfo == null || propInfo.jsonXmlExpose == JsonXmlField.Expose.SERIALIZE_ONLY || propName != null && ignoredClassPropNames != null && ignoredClassPropNames.contains(propName))) {
                                propInfo.setPropValue(entity, propValue == null ? propType.defaultValue() : propValue);
                            }
                            propName = null;
                            propValue = null;
                            propInfo = null;
                            break;
                        }
                    }
                    event = xmlReader.next();
                }
                throw new ParseException("Unknown parser error");
            }
            case 3: {
                ignoredClassPropNames = configToUse.getIgnoredPropNames(Map.class);
                keyType = XMLParserImpl.defaultKeyType;
                if (propInfo != null && propInfo.jsonXmlType.getParameterTypes().length == 2 && !Object.class.equals(propInfo.jsonXmlType.getParameterTypes()[0].clazz())) {
                    keyType = propInfo.jsonXmlType.getParameterTypes()[0];
                } else if (propType != null && propType.getParameterTypes().length == 2 && Map.class.isAssignableFrom(propType.clazz()) && !Object.class.equals(propType.getParameterTypes()[0].clazz())) {
                    keyType = propType.getParameterTypes()[0];
                } else if (configToUse.getMapKeyType() != null && !Object.class.equals(configToUse.getMapKeyType().clazz())) {
                    keyType = configToUse.getMapKeyType();
                }
                isStringKey = keyType.clazz() == String.class;
                valueType /* !! */  = XMLParserImpl.defaultValueType;
                if (propInfo != null && propInfo.jsonXmlType.getParameterTypes().length == 2 && !Object.class.equals(propInfo.jsonXmlType.getParameterTypes()[1].clazz())) {
                    valueType /* !! */  = propInfo.jsonXmlType.getParameterTypes()[1];
                } else if (propType != null && propType.getParameterTypes().length == 2 && Map.class.isAssignableFrom(propType.clazz()) && !Object.class.equals(propType.getParameterTypes()[1].clazz())) {
                    valueType /* !! */  = propType.getParameterTypes()[1];
                } else if (configToUse.getMapValueType() != null && !Object.class.equals(configToUse.getMapValueType().clazz())) {
                    valueType /* !! */  = configToUse.getMapValueType();
                }
                map = (Map)N.newInstance(targetClass);
                attrCount = 0;
                event = xmlReader.next();
                while (xmlReader.hasNext()) {
                    switch (event) {
                        case 1: {
                            if (propName != null) ** GOTO lbl165
                            propName = xmlReader.getLocalName();
                            v3 /* !! */  = propType = hasPropTypes != false ? configToUse.getPropType(propName) : null;
                            if (propType != null) break;
                            attrCount = xmlReader.getAttributeCount();
                            if (attrCount != 1) ** GOTO lbl157
                            if (!"type".equals(xmlReader.getAttributeLocalName(0))) ** GOTO lbl162
                            propType = N.typeOf(xmlReader.getAttributeValue(0));
                            ** GOTO lbl162
lbl157:
                            // 1 sources

                            if (attrCount > 1) {
                                for (i = 0; i < attrCount; ++i) {
                                    if (!"type".equals(xmlReader.getAttributeLocalName(i))) continue;
                                    propType = N.typeOf(xmlReader.getAttributeValue(i));
                                    break;
                                }
                            }
lbl162:
                            // 6 sources

                            if (propType != null) break;
                            propType = valueType /* !! */ ;
                            break;
lbl165:
                            // 1 sources

                            if (propName != null && ignoredClassPropNames != null && ignoredClassPropNames.contains(propName)) {
                                startCount = 1;
                                e = xmlReader.next();
                                while ((startCount += e == 1 ? 1 : (e == 2 ? -1 : 0)) >= 0 && xmlReader.hasNext()) {
                                    e = xmlReader.next();
                                }
                            } else if (Map.class.isAssignableFrom(propType.clazz()) || ClassUtil.isEntity(propType.clazz()) || MapEntity.class.equals(propType.clazz()) || Object.class.equals(propType.clazz())) {
                                propValue = this.readByStreamParser(Object.class.equals(propType.clazz()) != false ? Map.class : propType.clazz(), xmlReader, configToUse, propType, null);
                                startCount = 0;
                                e = xmlReader.next();
                                while ((startCount += e == 1 ? 1 : (e == 2 ? -1 : 0)) >= 0 && xmlReader.hasNext()) {
                                    e = xmlReader.next();
                                }
                            } else {
                                c = Collection.class.isAssignableFrom(propType.clazz()) != false ? (Collection)N.newInstance(propType.clazz()) : new ArrayList<E>();
                                propEleType = this.getPropEleType(propType);
                                do {
                                    if (xmlReader.getAttributeCount() > 0 && XMLParserImpl.TRUE.equals(xmlReader.getAttributeValue(null, "isNull"))) {
                                        c.add(null);
                                        xmlReader.next();
                                        continue;
                                    }
                                    c.add(this.readByStreamParser(propEleType.clazz(), xmlReader, configToUse, propType, null));
                                } while (xmlReader.hasNext() && xmlReader.next() == 1);
                                v4 = propValue = propType.clazz().isArray() != false ? XMLParserImpl.collection2Array(propType.clazz(), c) : c;
                            }
                            if (xmlReader.getEventType() == 2 && xmlReader.getLocalName().equals(propName)) {
                                if (propName == null || ignoredClassPropNames == null || !ignoredClassPropNames.contains(propName)) {
                                    map.put(isStringKey != false ? propName : keyType.valueOf(propName), propValue);
                                }
                                propName = null;
                                propValue = null;
                                break;
                            }
                            throw new ParseException("Unknown parser error at element: " + xmlReader.getLocalName());
                        }
                        case 4: {
                            text = xmlReader.getText();
                            if (text != null && text.length() > 256) {
                                while ((event = xmlReader.next()) == 4) {
                                    if (sb == null) {
                                        sb = new StringBuilder(text.length() * 2);
                                        sb.append(text);
                                    } else if (sb.length() == 0) {
                                        sb.append(text);
                                    }
                                    sb.append(xmlReader.getText());
                                }
                                if (sb != null && sb.length() > text.length()) {
                                    text = sb.toString();
                                    sb.setLength(0);
                                }
                            }
                            propValue = propType.valueOf(text);
                            if (event != 2) break;
                            if (propName == null || ignoredClassPropNames == null || !ignoredClassPropNames.contains(propName)) {
                                map.put(isStringKey != false ? propName : keyType.valueOf(propName), propValue == null ? propType.defaultValue() : propValue);
                            }
                            propName = null;
                            propValue = null;
                            break;
                        }
                        case 2: {
                            if (propName == null) {
                                return (T)map;
                            }
                            if (propName == null || ignoredClassPropNames == null || !ignoredClassPropNames.contains(propName)) {
                                map.put(isStringKey != false ? propName : keyType.valueOf(propName), propValue == null ? propType.defaultValue() : propValue);
                            }
                            propName = null;
                            propValue = null;
                            break;
                        }
                    }
                    event = xmlReader.next();
                }
                throw new ParseException("Unknown parser error");
            }
            case 4: {
                ignoredClassPropNames = configToUse.getIgnoredPropNames(Map.class);
                valueType /* !! */  = XMLParserImpl.defaultValueType;
                if (propInfo != null && propInfo.jsonXmlType.getParameterTypes().length == 2 && !Object.class.equals(propInfo.jsonXmlType.getParameterTypes()[1].clazz())) {
                    valueType /* !! */  = propInfo.jsonXmlType.getParameterTypes()[1];
                } else if (propType != null && propType.getParameterTypes().length == 2 && Map.class.isAssignableFrom(propType.clazz()) && !Object.class.equals(propType.getParameterTypes()[1].clazz())) {
                    valueType /* !! */  = propType.getParameterTypes()[1];
                } else if (configToUse.getMapValueType() != null && !Object.class.equals(configToUse.getMapValueType().clazz())) {
                    valueType /* !! */  = configToUse.getMapValueType();
                }
                mapEntity = N.newEntity(MapEntity.class, xmlReader.getLocalName());
                attrCount = 0;
                event = xmlReader.next();
                while (xmlReader.hasNext()) {
                    switch (event) {
                        case 1: {
                            if (propName != null) ** GOTO lbl273
                            propName = xmlReader.getLocalName();
                            v5 /* !! */  = propType = hasPropTypes != false ? configToUse.getPropType(propName) : null;
                            if (propType != null) break;
                            attrCount = xmlReader.getAttributeCount();
                            if (attrCount != 1) ** GOTO lbl265
                            if (!"type".equals(xmlReader.getAttributeLocalName(0))) ** GOTO lbl270
                            propType = N.typeOf(xmlReader.getAttributeValue(0));
                            ** GOTO lbl270
lbl265:
                            // 1 sources

                            if (attrCount > 1) {
                                for (i = 0; i < attrCount; ++i) {
                                    if (!"type".equals(xmlReader.getAttributeLocalName(i))) continue;
                                    propType = N.typeOf(xmlReader.getAttributeValue(i));
                                    break;
                                }
                            }
lbl270:
                            // 6 sources

                            if (propType != null) break;
                            propType = valueType /* !! */ ;
                            break;
lbl273:
                            // 1 sources

                            if (propName != null && ignoredClassPropNames != null && ignoredClassPropNames.contains(propName)) {
                                startCount = 1;
                                e = xmlReader.next();
                                while ((startCount += e == 1 ? 1 : (e == 2 ? -1 : 0)) >= 0 && xmlReader.hasNext()) {
                                    e = xmlReader.next();
                                }
                            } else if (Map.class.isAssignableFrom(propType.clazz()) || ClassUtil.isEntity(propType.clazz()) || MapEntity.class.equals(propType.clazz()) || Object.class.equals(propType.clazz())) {
                                propValue = this.readByStreamParser(Object.class.equals(propType.clazz()) != false ? MapEntity.class : propType.clazz(), xmlReader, configToUse, propType, null);
                                startCount = 0;
                                e = xmlReader.next();
                                while ((startCount += e == 1 ? 1 : (e == 2 ? -1 : 0)) >= 0 && xmlReader.hasNext()) {
                                    e = xmlReader.next();
                                }
                            } else {
                                c = Collection.class.isAssignableFrom(propType.clazz()) != false ? (Collection)N.newInstance(propType.clazz()) : new ArrayList<E>();
                                propEleType = this.getPropEleType(propType);
                                do {
                                    if (xmlReader.getAttributeCount() > 0 && XMLParserImpl.TRUE.equals(xmlReader.getAttributeValue(null, "isNull"))) {
                                        c.add(null);
                                        xmlReader.next();
                                        continue;
                                    }
                                    c.add(this.readByStreamParser(propEleType.clazz(), xmlReader, this.defaultXMLDeserializationConfig, propType, null));
                                } while (xmlReader.hasNext() && xmlReader.next() == 1);
                                v6 = propValue = propType.clazz().isArray() != false ? XMLParserImpl.collection2Array(propType.clazz(), c) : c;
                            }
                            if (xmlReader.getEventType() == 2 && xmlReader.getLocalName().equals(propName)) {
                                if (propName == null || ignoredClassPropNames == null || !ignoredClassPropNames.contains(propName)) {
                                    mapEntity.set(propName, propValue);
                                }
                                propName = null;
                                propValue = null;
                                break;
                            }
                            throw new ParseException("Unknown parser error at element: " + xmlReader.getLocalName());
                        }
                        case 4: {
                            text = xmlReader.getText();
                            if (text != null && text.length() > 256) {
                                while ((event = xmlReader.next()) == 4) {
                                    if (sb == null) {
                                        sb = new StringBuilder(text.length() * 2);
                                        sb.append(text);
                                    } else if (sb.length() == 0) {
                                        sb.append(text);
                                    }
                                    sb.append(xmlReader.getText());
                                }
                                if (sb != null && sb.length() > text.length()) {
                                    text = sb.toString();
                                    sb.setLength(0);
                                }
                            }
                            propValue = propType.valueOf(text);
                            if (event != 2) break;
                            if (propName == null || ignoredClassPropNames == null || !ignoredClassPropNames.contains(propName)) {
                                mapEntity.set(propName, propValue == null ? propType.defaultValue() : propValue);
                            }
                            propName = null;
                            propValue = null;
                            break;
                        }
                        case 2: {
                            if (propName == null) {
                                return (T)mapEntity;
                            }
                            if (propName == null || ignoredClassPropNames == null || !ignoredClassPropNames.contains(propName)) {
                                mapEntity.set(propName, propValue == null ? propType.defaultValue() : propValue);
                            }
                            propName = null;
                            propValue = null;
                            break;
                        }
                    }
                    event = xmlReader.next();
                }
                throw new ParseException("Unknown parser error");
            }
            case 5: {
                eleType = null;
                eleType = propInfo != null && propInfo.clazz.isArray() != false && Object.class.equals(propInfo.clazz.getComponentType()) == false ? N.typeOf(propInfo.clazz.getComponentType()) : (configToUse.getElementType() != null && Object.class.equals(configToUse.getElementType().clazz()) == false ? configToUse.getElementType() : N.typeOf(targetClass.isArray() != false ? targetClass.getComponentType() : String.class));
                list = Objectory.createList();
                try {
                    event = xmlReader.next();
                    while (xmlReader.hasNext()) {
                        switch (event) {
                            case 1: {
                                if (xmlReader.getAttributeCount() > 0 && XMLParserImpl.TRUE.equals(xmlReader.getAttributeValue(null, "isNull"))) {
                                    list.add(null);
                                    break;
                                }
                                if (String.class == eleType.clazz() || Object.class == eleType.clazz()) {
                                    list.add(this.readByStreamParser(Map.class, xmlReader, configToUse, eleType, null));
                                    break;
                                }
                                list.add(this.readByStreamParser(eleType.clazz(), xmlReader, configToUse, eleType, null));
                                break;
                            }
                            case 4: {
                                text = xmlReader.getText();
                                if (text != null && text.length() > 256) {
                                    while ((event = xmlReader.next()) == 4) {
                                        if (sb == null) {
                                            sb = new StringBuilder(text.length() * 2);
                                            sb.append(text);
                                        } else if (sb.length() == 0) {
                                            sb.append(text);
                                        }
                                        sb.append(xmlReader.getText());
                                    }
                                    if (sb != null && sb.length() > text.length()) {
                                        text = sb.toString();
                                        sb.setLength(0);
                                    }
                                }
                                propValue = eleType.clazz() == String.class || eleType.clazz() == Object.class ? N.typeOf(targetClass).valueOf(text) : XMLParserImpl.jsonParser.deserialize(targetClass, text, JSONDeserializationConfig.JDC.create().setElementType(eleType.clazz()));
                                if (event == 2) {
                                    if (propValue != null) {
                                        var16_31 = propValue;
                                        return (T)var16_31;
                                    }
                                    var16_32 = XMLParserImpl.collection2Array(targetClass, list);
                                    return var16_32;
                                }
                            }
                            case 2: {
                                if (propValue != null) {
                                    var16_33 = propValue;
                                    return (T)var16_33;
                                }
                                var16_34 = XMLParserImpl.collection2Array(targetClass, list);
                                return var16_34;
                            }
                        }
                        event = xmlReader.next();
                    }
                }
                finally {
                    Objectory.recycle(list);
                }
                throw new ParseException("Unknown parser error");
            }
            case 6: {
                eleType = XMLParserImpl.defaultValueType;
                if (propInfo != null && propInfo.clazz.isArray() && !Object.class.equals(propInfo.clazz.getComponentType())) {
                    eleType = N.typeOf(propInfo.clazz.getComponentType());
                } else if (propType != null && propType.getParameterTypes().length == 1 && Collection.class.isAssignableFrom(propType.clazz()) && !Object.class.equals(propType.getParameterTypes()[0].clazz())) {
                    eleType = propType.getParameterTypes()[0];
                } else if (configToUse.getElementType() != null && !Object.class.equals(configToUse.getElementType().clazz())) {
                    eleType = configToUse.getElementType();
                }
                result = (Collection)N.newInstance(targetClass);
                event = xmlReader.next();
                while (xmlReader.hasNext()) {
                    switch (event) {
                        case 1: {
                            if (xmlReader.getAttributeCount() > 0 && XMLParserImpl.TRUE.equals(xmlReader.getAttributeValue(null, "isNull"))) {
                                result.add(null);
                                break;
                            }
                            if (String.class == eleType.clazz() || Object.class == eleType.clazz()) {
                                result.add(this.readByStreamParser(Map.class, xmlReader, configToUse, eleType, null));
                                break;
                            }
                            result.add(this.readByStreamParser(eleType.clazz(), xmlReader, configToUse, eleType, null));
                            break;
                        }
                        case 4: {
                            text = xmlReader.getText();
                            if (text != null && text.length() > 256) {
                                while ((event = xmlReader.next()) == 4) {
                                    if (sb == null) {
                                        sb = new StringBuilder(text.length() * 2);
                                        sb.append(text);
                                    } else if (sb.length() == 0) {
                                        sb.append(text);
                                    }
                                    sb.append(xmlReader.getText());
                                }
                                if (sb != null && sb.length() > text.length()) {
                                    text = sb.toString();
                                    sb.setLength(0);
                                }
                            }
                            propValue = eleType.clazz() == String.class || eleType.clazz() == Object.class ? (Object)N.typeOf(targetClass).valueOf(text) : XMLParserImpl.jsonParser.deserialize(targetClass, text, JSONDeserializationConfig.JDC.create().setElementType(eleType.clazz()));
                            if (event == 2) {
                                if (propValue != null) {
                                    return (T)propValue;
                                }
                                return (T)result;
                            }
                        }
                        case 2: {
                            if (propValue != null) {
                                return (T)propValue;
                            }
                            return (T)result;
                        }
                    }
                    event = xmlReader.next();
                }
                throw new ParseException("Unknown parser error");
            }
        }
        throw new ParseException("Unsupported class type: " + ClassUtil.getCanonicalClassName(targetClass) + ". Only array, collection, map and entity types are supported");
    }

    protected Type.SerializationType getDeserializationType(Class<?> targetClass) {
        Type type = N.typeOf(targetClass);
        Type.SerializationType serializationType = type.getSerializationType();
        if (type.isSerializable()) {
            if (type.isObjectArray()) {
                serializationType = Type.SerializationType.ARRAY;
            } else if (type.isCollection()) {
                serializationType = Type.SerializationType.COLLECTION;
            }
        }
        return serializationType;
    }

    private Type<?> getPropEleType(Type<?> propType) {
        Type<Object> propEleType = null;
        propEleType = propType.clazz().isArray() && (ClassUtil.isEntity(propType.getElementType().clazz()) || Map.class.isAssignableFrom(propType.getElementType().clazz())) ? propType.getElementType() : (propType.getParameterTypes().length == 1 && (ClassUtil.isEntity(propType.getParameterTypes()[0].clazz()) || Map.class.isAssignableFrom(propType.getParameterTypes()[0].clazz())) ? propType.getParameterTypes()[0] : N.typeOf(Map.class));
        return propEleType;
    }
}

