/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.pool;

import com.landawn.abacus.logging.Logger;
import com.landawn.abacus.logging.LoggerFactory;
import com.landawn.abacus.pool.EvictionPolicy;
import com.landawn.abacus.pool.Pool;
import com.landawn.abacus.util.ClassUtil;
import com.landawn.abacus.util.MoreExecutors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public abstract class AbstractPool
implements Pool {
    private static final long serialVersionUID = -7780250223658416202L;
    static final Logger logger = LoggerFactory.getLogger(AbstractPool.class);
    static final long DEFAULT_EVICT_DELAY = 3000L;
    static final float DEFAULT_BALANCE_FACTOR = 0.2f;
    static final ScheduledExecutorService scheduledExecutor;
    final AtomicLong putCount = new AtomicLong();
    final AtomicLong hitCount = new AtomicLong();
    final AtomicLong missCount = new AtomicLong();
    final AtomicLong evictionCount = new AtomicLong();
    final ReentrantLock lock = new ReentrantLock();
    final Condition notEmpty = this.lock.newCondition();
    final Condition notFull = this.lock.newCondition();
    final int capacity;
    final EvictionPolicy evictionPolicy;
    final boolean autoBalance;
    final float balanceFactor;
    boolean isClosed = false;

    protected AbstractPool(int capacity, long evictDelay, EvictionPolicy evictionPolicy, boolean autoBalance, float balanceFactor) {
        if (capacity < 0 || evictDelay < 0L || balanceFactor < 0.0f) {
            throw new IllegalArgumentException("Capacity(" + capacity + "), evict delay(" + evictDelay + "), balanc factor(" + balanceFactor + ") can not be negative");
        }
        this.capacity = capacity;
        this.evictionPolicy = evictionPolicy == null ? EvictionPolicy.LAST_ACCESS_TIME : evictionPolicy;
        this.autoBalance = autoBalance;
        this.balanceFactor = balanceFactor == 0.0f ? 0.2f : balanceFactor;
        final Class<?> cls = this.getClass();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                logger.warn("Starting to shutdown pool: " + ClassUtil.getCanonicalClassName(cls));
                try {
                    AbstractPool.this.close();
                }
                finally {
                    logger.warn("Completed to shutdown pool: " + ClassUtil.getCanonicalClassName(cls));
                }
            }
        });
    }

    @Override
    public void lock() {
        this.lock.lock();
    }

    @Override
    public void unlock() {
        this.lock.unlock();
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public long putCount() {
        return this.putCount.get();
    }

    @Override
    public long hitCount() {
        return this.hitCount.get();
    }

    @Override
    public long missCount() {
        return this.missCount.get();
    }

    @Override
    public long evictionCount() {
        return this.evictionCount.get();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    protected void assertNotClosed() {
        if (this.isClosed) {
            throw new RuntimeException(ClassUtil.getCanonicalClassName(this.getClass()) + " has been closed");
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.isClosed) {
            this.close();
        }
    }

    static {
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(64);
        executor.setKeepAliveTime(180L, TimeUnit.SECONDS);
        executor.allowCoreThreadTimeOut(true);
        executor.setRemoveOnCancelPolicy(true);
        scheduledExecutor = MoreExecutors.getExitingScheduledExecutorService(executor);
    }
}

