/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.pool;

import com.landawn.abacus.pool.AbstractPool;
import com.landawn.abacus.pool.ActivityPrint;
import com.landawn.abacus.pool.EvictionPolicy;
import com.landawn.abacus.pool.ObjectPool;
import com.landawn.abacus.pool.Poolable;
import com.landawn.abacus.util.ClassUtil;
import com.landawn.abacus.util.ExceptionUtil;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Objectory;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.List;
import java.util.PriorityQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class GenericObjectPool<E extends Poolable>
extends AbstractPool
implements ObjectPool<E> {
    private static final long serialVersionUID = -5055744987721643286L;
    private final long maxMemorySize;
    private final ObjectPool.MemoryMeasure<E> memoryMeasure;
    private volatile long usedMemorySize = 0L;
    final Deque<E> pool;
    final Comparator<E> cmp;
    ScheduledFuture<?> scheduleFuture;

    protected GenericObjectPool(int capacity, long evictDelay, EvictionPolicy evictionPolicy) {
        this(capacity, evictDelay, evictionPolicy, 0L, null);
    }

    protected GenericObjectPool(int capacity, long evictDelay, EvictionPolicy evictionPolicy, long maxMemorySize, ObjectPool.MemoryMeasure<E> memoryMeasure) {
        this(capacity, evictDelay, evictionPolicy, true, 0.2f, maxMemorySize, memoryMeasure);
    }

    protected GenericObjectPool(int capacity, long evictDelay, EvictionPolicy evictionPolicy, boolean autoBalance, float balanceFactor) {
        this(capacity, evictDelay, evictionPolicy, autoBalance, balanceFactor, 0L, null);
    }

    protected GenericObjectPool(int capacity, long evictDelay, EvictionPolicy evictionPolicy, boolean autoBalance, float balanceFactor, long maxMemorySize, ObjectPool.MemoryMeasure<E> memoryMeasure) {
        super(capacity, evictDelay, evictionPolicy, autoBalance, balanceFactor);
        this.maxMemorySize = maxMemorySize;
        this.memoryMeasure = memoryMeasure;
        this.pool = new ArrayDeque(capacity > 1000 ? 1000 : capacity);
        switch (this.evictionPolicy) {
            case LAST_ACCESS_TIME: {
                this.cmp = new Comparator<E>(){

                    @Override
                    public int compare(E o1, E o2) {
                        return Long.compare(o1.activityPrint().getLastAccessTime(), o2.activityPrint().getLastAccessTime());
                    }
                };
                break;
            }
            case ACCESS_COUNT: {
                this.cmp = new Comparator<E>(){

                    @Override
                    public int compare(E o1, E o2) {
                        return Long.compare(o1.activityPrint().getAccessCount(), o2.activityPrint().getAccessCount());
                    }
                };
                break;
            }
            case EXPIRATION_TIME: {
                this.cmp = new Comparator<E>(){

                    @Override
                    public int compare(E o1, E o2) {
                        return Long.compare(o1.activityPrint().getExpirationTime(), o2.activityPrint().getExpirationTime());
                    }
                };
                break;
            }
            default: {
                throw new RuntimeException("Unsupproted eviction policy: " + evictionPolicy.name());
            }
        }
        if (evictDelay > 0L) {
            Runnable evictTask = new Runnable(){

                @Override
                public void run() {
                    block2: {
                        try {
                            GenericObjectPool.this.evict();
                        }
                        catch (Exception e) {
                            if (!AbstractPool.logger.isWarnEnabled()) break block2;
                            AbstractPool.logger.warn(ExceptionUtil.getMessage(e));
                        }
                    }
                }
            };
            this.scheduleFuture = scheduledExecutor.scheduleWithFixedDelay(evictTask, evictDelay, evictDelay, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public boolean add(E e) {
        this.assertNotClosed();
        if (e == null) {
            throw new NullPointerException();
        }
        if (e.activityPrint().isExpired()) {
            return false;
        }
        this.putCount.incrementAndGet();
        this.lock.lock();
        try {
            if (this.pool.size() >= this.capacity) {
                if (this.autoBalance) {
                    this.vacate();
                } else {
                    boolean bl = false;
                    return bl;
                }
            }
            if (this.memoryMeasure != null && this.memoryMeasure.sizeOf(e) > this.maxMemorySize - this.usedMemorySize) {
                boolean bl = false;
                return bl;
            }
            this.pool.push(e);
            if (this.memoryMeasure != null) {
                this.usedMemorySize += this.memoryMeasure.sizeOf(e);
            }
            this.notEmpty.signal();
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E e, boolean autoDestroyOnFailedToAdd) {
        boolean sucess = false;
        try {
            sucess = this.add(e);
        }
        finally {
            if (autoDestroyOnFailedToAdd && !sucess && e != null) {
                e.destroy();
            }
        }
        return sucess;
    }

    @Override
    public boolean add(E e, long timeout, TimeUnit unit) throws InterruptedException {
        this.assertNotClosed();
        if (e == null) {
            throw new NullPointerException();
        }
        if (e.activityPrint().isExpired()) {
            return false;
        }
        this.putCount.incrementAndGet();
        long nanos = unit.toNanos(timeout);
        this.lock.lock();
        try {
            if (this.pool.size() >= this.capacity && this.autoBalance) {
                this.vacate();
            }
            while (true) {
                if (this.pool.size() < this.capacity) {
                    if (this.memoryMeasure != null && this.memoryMeasure.sizeOf(e) > this.maxMemorySize - this.usedMemorySize) {
                        boolean bl = false;
                        return bl;
                    }
                    this.pool.push(e);
                    if (this.memoryMeasure != null) {
                        this.usedMemorySize += this.memoryMeasure.sizeOf(e);
                    }
                    this.notEmpty.signal();
                    boolean bl = true;
                    return bl;
                }
                if (nanos <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                nanos = this.notFull.awaitNanos(nanos);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E e, long timeout, TimeUnit unit, boolean autoDestroyOnFailedToAdd) throws InterruptedException {
        boolean sucess = false;
        try {
            sucess = this.add(e, timeout, unit);
        }
        finally {
            if (autoDestroyOnFailedToAdd && !sucess && e != null) {
                e.destroy();
            }
        }
        return sucess;
    }

    @Override
    public E take() {
        this.assertNotClosed();
        Poolable e = null;
        this.lock.lock();
        try {
            Poolable poolable = e = this.pool.size() > 0 ? (Poolable)this.pool.pop() : null;
            if (e != null) {
                ActivityPrint activityPrint = e.activityPrint();
                activityPrint.updateLastAccessTime();
                activityPrint.updateAccessCount();
                if (this.memoryMeasure != null) {
                    this.usedMemorySize -= this.memoryMeasure.sizeOf(e);
                }
                this.hitCount.incrementAndGet();
                this.notFull.signal();
            } else {
                this.missCount.incrementAndGet();
            }
        }
        finally {
            this.lock.unlock();
        }
        return (E)e;
    }

    @Override
    public E take(long timeout, TimeUnit unit) throws InterruptedException {
        this.assertNotClosed();
        Poolable e = null;
        long nanos = unit.toNanos(timeout);
        this.lock.lock();
        try {
            while (true) {
                Poolable poolable = e = this.pool.size() > 0 ? (Poolable)this.pool.pop() : null;
                if (e != null) {
                    ActivityPrint activityPrint = e.activityPrint();
                    activityPrint.updateLastAccessTime();
                    activityPrint.updateAccessCount();
                    if (this.memoryMeasure != null) {
                        this.usedMemorySize -= this.memoryMeasure.sizeOf(e);
                    }
                    this.hitCount.incrementAndGet();
                    this.notFull.signal();
                    Poolable poolable2 = e;
                    return (E)poolable2;
                }
                if (nanos <= 0L) {
                    this.missCount.incrementAndGet();
                    E e2 = null;
                    return e2;
                }
                nanos = this.notEmpty.awaitNanos(nanos);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean contains(E e) {
        this.assertNotClosed();
        this.lock.lock();
        try {
            boolean bl = this.pool.contains(e);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void vacate() {
        this.assertNotClosed();
        this.lock.lock();
        try {
            this.vacate((int)((float)this.pool.size() * this.balanceFactor));
            this.notFull.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void clear() {
        this.assertNotClosed();
        this.removeAll();
    }

    @Override
    public void close() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        try {
            if (this.scheduleFuture != null) {
                this.scheduleFuture.cancel(true);
            }
        }
        finally {
            this.removeAll();
        }
    }

    @Override
    public int size() {
        return this.pool.size();
    }

    public int hashCode() {
        return this.pool.hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof GenericObjectPool && N.equals(((GenericObjectPool)obj).pool, this.pool);
    }

    public String toString() {
        return this.pool.toString();
    }

    protected void vacate(int vacationNumber) {
        int size = this.pool.size();
        if (vacationNumber >= size) {
            this.destroyAll(new ArrayList<E>(this.pool));
            this.pool.clear();
        } else {
            PriorityQueue<Poolable> heap = new PriorityQueue<Poolable>(vacationNumber, this.cmp);
            for (Poolable e : this.pool) {
                if (heap.size() < vacationNumber) {
                    heap.offer(e);
                    continue;
                }
                if (this.cmp.compare(e, heap.peek()) >= 0) continue;
                heap.poll();
                heap.offer(e);
            }
            for (Poolable e : heap) {
                this.pool.remove(e);
            }
            this.destroyAll(heap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void evict() {
        this.lock.lock();
        List removingObjects = null;
        try {
            for (Poolable e : this.pool) {
                if (!e.activityPrint().isExpired()) continue;
                if (removingObjects == null) {
                    removingObjects = Objectory.createList();
                }
                removingObjects.add(e);
            }
            if (N.notNullOrEmpty(removingObjects)) {
                this.pool.removeAll(removingObjects);
                this.destroyAll(removingObjects);
                this.notFull.signalAll();
            }
        }
        finally {
            this.lock.unlock();
            Objectory.recycle(removingObjects);
        }
    }

    protected void destroy(E value) {
        block5: {
            this.evictionCount.incrementAndGet();
            if (value != null) {
                if (logger.isInfoEnabled()) {
                    logger.info("Destroying cached object " + ClassUtil.getSimpleClassName(value.getClass()) + " with activity print: " + value.activityPrint());
                }
                if (this.memoryMeasure != null) {
                    this.usedMemorySize -= this.memoryMeasure.sizeOf(value);
                }
                try {
                    value.destroy();
                }
                catch (Exception e) {
                    if (!logger.isWarnEnabled()) break block5;
                    logger.warn(ExceptionUtil.getMessage(e));
                }
            }
        }
    }

    protected void destroyAll(Collection<E> c) {
        if (N.notNullOrEmpty(c)) {
            for (Poolable e : c) {
                this.destroy(e);
            }
        }
    }

    private void removeAll() {
        this.lock.lock();
        try {
            this.destroyAll(new ArrayList<E>(this.pool));
            this.pool.clear();
            this.notFull.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void writeObject(ObjectOutputStream os) throws IOException {
        this.lock.lock();
        try {
            os.defaultWriteObject();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        this.lock.lock();
        try {
            is.defaultReadObject();
        }
        finally {
            this.lock.unlock();
        }
    }
}

