/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.type;

import com.landawn.abacus.parser.SerializationConfig;
import com.landawn.abacus.type.NumberType;
import com.landawn.abacus.util.CharacterWriter;
import com.landawn.abacus.util.IOUtil;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Numbers;
import java.io.IOException;
import java.io.Writer;

public abstract class AbstractByteType
extends NumberType<Number> {
    protected AbstractByteType(String typeName) {
        super(typeName);
    }

    @Override
    public String stringOf(Number x) {
        if (x == null) {
            return null;
        }
        return N.stringOf(x.byteValue());
    }

    @Override
    public Byte valueOf(String str) {
        if (N.isNullOrEmpty(str)) {
            return (Byte)this.defaultValue();
        }
        try {
            return Numbers.toByte(str);
        }
        catch (NumberFormatException e) {
            char ch;
            if (str.length() > 1 && ((ch = str.charAt(str.length() - 1)) == 'l' || ch == 'L' || ch == 'f' || ch == 'F' || ch == 'd' || ch == 'D')) {
                return Numbers.toByte(str.substring(0, str.length() - 1));
            }
            throw e;
        }
    }

    @Override
    public Byte valueOf(char[] cbuf, int offset, int len) {
        if (cbuf == null || len == 0) {
            return (Byte)this.defaultValue();
        }
        int i = AbstractByteType.parseInt(cbuf, offset, len);
        if (i < -128 || i > 127) {
            throw new NumberFormatException("Value out of range. Value:\"" + i + "\" Radix:" + 10);
        }
        return (byte)i;
    }

    @Override
    public void write(Writer writer, Number x) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            IOUtil.write(writer, x.byteValue());
        }
    }

    @Override
    public void writeCharacter(CharacterWriter writer, Number x, SerializationConfig<?> config) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            writer.write(x.byteValue());
        }
    }
}

