/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.type;

import com.landawn.abacus.exception.UncheckedSQLException;
import com.landawn.abacus.parser.SerializationConfig;
import com.landawn.abacus.type.AbstractCharSequenceType;
import com.landawn.abacus.util.CharacterWriter;
import com.landawn.abacus.util.N;
import java.io.IOException;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

public abstract class AbstractStringType
extends AbstractCharSequenceType<String> {
    protected AbstractStringType(String typeName) {
        super(typeName);
    }

    @Override
    public Class<String> clazz() {
        return String.class;
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

    @Override
    public String stringOf(String str) {
        return str;
    }

    @Override
    public String valueOf(String str) {
        return str;
    }

    @Override
    public String valueOf(char[] cbuf, int offset, int len) {
        return cbuf == null ? null : (cbuf.length == 0 || len == 0 ? N.EMPTY_STRING : String.valueOf(cbuf, offset, len));
    }

    @Override
    public String valueOf(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Clob) {
            Clob clob = (Clob)obj;
            try {
                String string = clob.getSubString(1L, (int)clob.length());
                return string;
            }
            catch (SQLException e) {
                throw new UncheckedSQLException(e);
            }
            finally {
                try {
                    clob.free();
                }
                catch (SQLException e) {
                    throw new UncheckedSQLException(e);
                }
            }
        }
        return this.valueOf(N.typeOf(obj.getClass()).stringOf(obj));
    }

    @Override
    public void write(Writer writer, String x) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            writer.write(x);
        }
    }

    @Override
    public void writeCharacter(CharacterWriter writer, String x, SerializationConfig<?> config) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            char ch;
            char c = ch = config == null ? (char)'\u0000' : config.getStringQuotation();
            if (ch == '\u0000') {
                writer.writeCharacter(x);
            } else {
                writer.write(ch);
                writer.writeCharacter(x);
                writer.write(ch);
            }
        }
    }
}

