/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.type;

import com.landawn.abacus.parser.SerializationConfig;
import com.landawn.abacus.type.AbstractAtomicType;
import com.landawn.abacus.util.CharacterWriter;
import com.landawn.abacus.util.IOUtil;
import com.landawn.abacus.util.N;
import java.io.IOException;
import java.io.Writer;
import java.util.concurrent.atomic.AtomicInteger;

public class AtomicIntegerType
extends AbstractAtomicType<AtomicInteger> {
    public static final String ATOMIC_INTEGER = AtomicInteger.class.getSimpleName();

    AtomicIntegerType() {
        super(ATOMIC_INTEGER);
    }

    @Override
    public Class<AtomicInteger> clazz() {
        return AtomicInteger.class;
    }

    @Override
    public String stringOf(AtomicInteger x) {
        return x == null ? null : String.valueOf(x.get());
    }

    @Override
    public AtomicInteger valueOf(String str) {
        return N.isNullOrEmpty(str) ? null : new AtomicInteger(Integer.parseInt(str));
    }

    @Override
    public void write(Writer writer, AtomicInteger x) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            IOUtil.write(writer, x.get());
        }
    }

    @Override
    public void writeCharacter(CharacterWriter writer, AtomicInteger x, SerializationConfig<?> config) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            writer.writeInt(x.get());
        }
    }
}

