/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.type;

import com.landawn.abacus.parser.SerializationConfig;
import com.landawn.abacus.type.NumberType;
import com.landawn.abacus.util.CharacterWriter;
import com.landawn.abacus.util.N;
import java.io.IOException;
import java.math.BigDecimal;

public final class BigDecimalType
extends NumberType<BigDecimal> {
    public static final String BIG_DECIMAL = BigDecimal.class.getSimpleName();

    BigDecimalType() {
        super(BIG_DECIMAL);
    }

    @Override
    public Class<BigDecimal> clazz() {
        return BigDecimal.class;
    }

    @Override
    public String stringOf(BigDecimal x) {
        return x == null ? null : x.toString();
    }

    @Override
    public BigDecimal valueOf(String str) {
        return N.isNullOrEmpty(str) ? null : new BigDecimal(str);
    }

    @Override
    public void writeCharacter(CharacterWriter writer, BigDecimal x, SerializationConfig<?> config) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else if (config != null && config.writeBigDecimalAsPlain()) {
            writer.writeCharacter(x.toPlainString());
        } else {
            writer.writeCharacter(this.stringOf(x));
        }
    }
}

