/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.type;

import com.landawn.abacus.parser.SerializationConfig;
import com.landawn.abacus.type.ObjectArrayType;
import com.landawn.abacus.util.CharacterWriter;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Objectory;
import java.io.IOException;
import java.io.Writer;

public final class BooleanArrayType
extends ObjectArrayType<Boolean> {
    BooleanArrayType() {
        super(Boolean[].class);
    }

    @Override
    public String stringOf(Boolean[] x) {
        if (x == null) {
            return null;
        }
        StringBuilder sb = Objectory.createStringBuilder();
        sb.append('[');
        int len = x.length;
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append(ELEMENT_SEPARATOR);
            }
            if (x[i] == null) {
                sb.append(NULL_CHAR_ARRAY);
                continue;
            }
            sb.append(x[i]);
        }
        sb.append(']');
        String str = sb.toString();
        Objectory.recycle(sb);
        return str;
    }

    @Override
    public Boolean[] valueOf(String str) {
        if (str == null) {
            return null;
        }
        if (str.length() == 0 || "[]".equals(str)) {
            return N.EMPTY_BOOLEAN_OBJ_ARRAY;
        }
        String[] strs = BooleanArrayType.split(str);
        int len = strs.length;
        Boolean[] a = new Boolean[len];
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                a[i] = strs[i].length() == 4 && strs[i].equals(NULL_STRING) ? null : (Boolean)this.elementType.valueOf(strs[i]);
            }
        }
        return a;
    }

    @Override
    public void write(Writer writer, Boolean[] x) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            writer.write(91);
            int len = x.length;
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    writer.write(ELEMENT_SEPARATOR);
                }
                if (x[i] == null) {
                    writer.write(NULL_CHAR_ARRAY);
                    continue;
                }
                writer.write(x[i] == true ? TRUE_CHAR_ARRAY : FALSE_CHAR_ARRAY);
            }
            writer.write(93);
        }
    }

    @Override
    public void writeCharacter(CharacterWriter writer, Boolean[] x, SerializationConfig<?> config) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            writer.write('[');
            int len = x.length;
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    writer.write(ELEMENT_SEPARATOR);
                }
                if (x[i] == null) {
                    writer.write(NULL_CHAR_ARRAY);
                    continue;
                }
                writer.write(x[i] == true ? TRUE_CHAR_ARRAY : FALSE_CHAR_ARRAY);
            }
            writer.write(']');
        }
    }
}

