/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.type;

import com.landawn.abacus.parser.SerializationConfig;
import com.landawn.abacus.type.AbstractType;
import com.landawn.abacus.util.CharacterWriter;
import java.io.IOException;
import java.io.Writer;

public class BooleanCharType
extends AbstractType<Boolean> {
    private static final String typeName = "BooleanChar";

    protected BooleanCharType() {
        super(typeName);
    }

    @Override
    public Class<Boolean> clazz() {
        return Boolean.class;
    }

    @Override
    public boolean isBoolean() {
        return false;
    }

    @Override
    public String stringOf(Boolean b) {
        return b == null || b == false ? "N" : "Y";
    }

    @Override
    public Boolean valueOf(String st) {
        return "Y".equalsIgnoreCase(st) ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public Boolean defaultValue() {
        return Boolean.FALSE;
    }

    @Override
    public Boolean valueOf(char[] cbuf, int offset, int len) {
        return cbuf == null || len == 0 ? this.defaultValue() : (len == 1 && (cbuf[offset] == 'Y' || cbuf[offset] == 'y') ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void write(Writer writer, Boolean x) throws IOException {
        writer.write(this.stringOf(x));
    }

    @Override
    public void writeCharacter(CharacterWriter writer, Boolean x, SerializationConfig<?> config) throws IOException {
        char ch;
        char c = ch = config == null ? (char)'\u0000' : config.getCharQuotation();
        if (ch == '\u0000') {
            writer.write(this.stringOf(x));
        } else {
            writer.write(ch);
            writer.write(this.stringOf(x));
            writer.write(ch);
        }
    }
}

