/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.type;

import com.landawn.abacus.type.AbstractType;
import com.landawn.abacus.util.ClassUtil;
import com.landawn.abacus.util.N;
import java.nio.ByteBuffer;

public class ByteBufferType
extends AbstractType<ByteBuffer> {
    public static final String BYTE_BUFFER = "ByteBuffer";

    ByteBufferType() {
        super(BYTE_BUFFER);
    }

    ByteBufferType(Class<? extends ByteBuffer> cls) {
        super(ClassUtil.getSimpleClassName(cls));
    }

    @Override
    public Class<ByteBuffer> clazz() {
        return ByteBuffer.class;
    }

    @Override
    public boolean isByteBuffer() {
        return true;
    }

    @Override
    public String stringOf(ByteBuffer x) {
        return x == null ? null : N.base64Encode(ByteBufferType.byteArrayOf(x));
    }

    @Override
    public ByteBuffer valueOf(String str) {
        if (str == null) {
            return null;
        }
        if (str.length() == 0) {
            return ByteBufferType.valueOf(N.EMPTY_BYTE_ARRAY);
        }
        return ByteBufferType.valueOf(N.base64Decode(str));
    }

    public static byte[] byteArrayOf(ByteBuffer x) {
        byte[] bytes = new byte[x.position()];
        x.position(0);
        x.get(bytes);
        x.position(bytes.length);
        return bytes;
    }

    public static ByteBuffer valueOf(byte[] bytes) {
        return ByteBuffer.wrap(bytes, bytes.length, 0);
    }
}

