/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.type;

import com.landawn.abacus.exception.UncheckedIOException;
import com.landawn.abacus.parser.JSONDeserializationConfig;
import com.landawn.abacus.parser.SerializationConfig;
import com.landawn.abacus.type.AbstractType;
import com.landawn.abacus.type.Type;
import com.landawn.abacus.type.TypeFactory;
import com.landawn.abacus.type.Utils;
import com.landawn.abacus.util.BufferedJSONWriter;
import com.landawn.abacus.util.CharacterWriter;
import com.landawn.abacus.util.ClassUtil;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Objectory;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.Set;

public class CollectionType<E, T extends Collection<E>>
extends AbstractType<T> {
    private final String declaringName;
    private final Class<T> typeClass;
    private final Type<E>[] parameterTypes;
    private final Type<E> elementType;
    private final boolean isList;
    private final boolean isSet;
    private final JSONDeserializationConfig jdc;

    CollectionType(Class<T> typeClass, String parameterTypeName) {
        super(CollectionType.getTypeName(typeClass, parameterTypeName, false));
        String tmp = null;
        if (typeClass.isInterface()) {
            tmp = CollectionType.getTypeName(typeClass, parameterTypeName, true);
        } else if (List.class.isAssignableFrom(typeClass)) {
            tmp = CollectionType.getTypeName(List.class, parameterTypeName, true);
        } else if (Set.class.isAssignableFrom(typeClass)) {
            tmp = CollectionType.getTypeName(Set.class, parameterTypeName, true);
        } else if (Queue.class.isAssignableFrom(typeClass)) {
            tmp = CollectionType.getTypeName(Queue.class, parameterTypeName, true);
        } else {
            Class<?>[] interfaceClasses;
            tmp = CollectionType.getTypeName(Collection.class, parameterTypeName, true);
            for (Class<?> interfaceClass : interfaceClasses = typeClass.getInterfaces()) {
                if (!Collection.class.isAssignableFrom(interfaceClass) || interfaceClass.equals(Collection.class)) continue;
                tmp = CollectionType.getTypeName(interfaceClass, parameterTypeName, true);
                break;
            }
        }
        this.declaringName = tmp;
        this.typeClass = typeClass;
        this.parameterTypes = new Type[]{TypeFactory.getType(parameterTypeName)};
        this.elementType = this.parameterTypes[0];
        this.jdc = (JSONDeserializationConfig)JSONDeserializationConfig.JDC.create().setElementType(this.elementType);
        this.isList = List.class.isAssignableFrom(this.typeClass);
        this.isSet = Set.class.isAssignableFrom(this.typeClass);
    }

    @Override
    public String declaringName() {
        return this.declaringName;
    }

    @Override
    public Class<T> clazz() {
        return this.typeClass;
    }

    @Override
    public Type<E> getElementType() {
        return this.elementType;
    }

    @Override
    public Type<E>[] getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public boolean isList() {
        return this.isList;
    }

    @Override
    public boolean isSet() {
        return this.isSet;
    }

    @Override
    public boolean isCollection() {
        return true;
    }

    @Override
    public boolean isGenericType() {
        return true;
    }

    @Override
    public boolean isSerializable() {
        return this.elementType.isSerializable();
    }

    @Override
    public Type.SerializationType getSerializationType() {
        return this.isSerializable() ? Type.SerializationType.SERIALIZABLE : Type.SerializationType.COLLECTION;
    }

    @Override
    public String stringOf(T x) {
        if (x == null) {
            return null;
        }
        if (x.size() == 0) {
            return "[]";
        }
        if (this.isSerializable()) {
            BufferedJSONWriter bw = Objectory.createBufferedJSONWriter();
            try {
                bw.write('[');
                int i = 0;
                for (Object e : x) {
                    if (i++ > 0) {
                        bw.write(ELEMENT_SEPARATOR_CHAR_ARRAY);
                    }
                    if (e == null) {
                        bw.write(NULL_CHAR_ARRAY);
                        continue;
                    }
                    this.elementType.writeCharacter(bw, e, Utils.jsc);
                }
                bw.write(']');
                String string = bw.toString();
                return string;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            finally {
                Objectory.recycle(bw);
            }
        }
        return Utils.jsonParser.serialize(x, Utils.jsc);
    }

    @Override
    public T valueOf(String str) {
        if (str == null) {
            return null;
        }
        if (str.length() == 0 || "[]".equals(str)) {
            return (T)((Collection)N.newInstance(this.typeClass));
        }
        return (T)((Collection)Utils.jsonParser.deserialize(this.typeClass, str, this.jdc));
    }

    @Override
    public void write(Writer writer, T x) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            boolean isBufferedWriter = writer instanceof com.landawn.abacus.util.BufferedWriter || writer instanceof BufferedWriter;
            Writer bw = isBufferedWriter ? writer : Objectory.createBufferedWriter(writer);
            try {
                bw.write(91);
                int i = 0;
                for (Object e : x) {
                    if (i++ > 0) {
                        bw.write(ELEMENT_SEPARATOR_CHAR_ARRAY);
                    }
                    if (e == null) {
                        bw.write(NULL_CHAR_ARRAY);
                        continue;
                    }
                    this.elementType.write(bw, e);
                }
                bw.write(93);
                if (!isBufferedWriter) {
                    bw.flush();
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            finally {
                if (!isBufferedWriter) {
                    Objectory.recycle((com.landawn.abacus.util.BufferedWriter)bw);
                }
            }
        }
    }

    @Override
    public void writeCharacter(CharacterWriter writer, T x, SerializationConfig<?> config) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            try {
                writer.write('[');
                int i = 0;
                for (Object e : x) {
                    if (i++ > 0) {
                        writer.write(ELEMENT_SEPARATOR_CHAR_ARRAY);
                    }
                    if (e == null) {
                        writer.write(NULL_CHAR_ARRAY);
                        continue;
                    }
                    this.elementType.writeCharacter(writer, e, config);
                }
                writer.write(']');
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    protected static String getTypeName(Class<?> typeClass, String parameterTypeName, boolean isDeclaringName) {
        if (isDeclaringName) {
            return ClassUtil.getSimpleClassName(typeClass) + "<" + TypeFactory.getType(parameterTypeName).declaringName() + ">";
        }
        return ClassUtil.getCanonicalClassName(typeClass) + "<" + TypeFactory.getType(parameterTypeName).name() + ">";
    }
}

