/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.type;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.landawn.abacus.annotation.JsonXmlField;
import com.landawn.abacus.annotation.Type;
import com.landawn.abacus.parser.SerializationConfig;
import com.landawn.abacus.type.SingleValueType;
import com.landawn.abacus.util.BiMap;
import com.landawn.abacus.util.CharacterWriter;
import com.landawn.abacus.util.ClassUtil;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Numbers;
import com.landawn.abacus.util.StringUtil;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

public final class EnumType<T extends Enum<T>>
extends SingleValueType<T> {
    public static final String ENUM = Enum.class.getSimpleName();
    private static final String NULL = "null";
    private final BiMap<Number, T> numberEnum = new BiMap();
    private final Map<T, String> enumJsonXmlNameMap = new EnumMap<T, String>(this.typeClass);
    private final Map<String, T> jsonXmlNameEnumMap = new HashMap<String, T>();
    private final Type.EnumBy enumBy;
    private boolean hasNull = false;

    EnumType(String enumClassName) {
        this(enumClassName, false);
    }

    EnumType(String clsName, boolean ordinal) {
        super(ordinal ? clsName + "(true)" : clsName, EnumType.getEnumClass(ClassUtil.forClass(clsName)));
        for (Enum enumConstant : (Enum[])this.typeClass.getEnumConstants()) {
            this.numberEnum.put(enumConstant.ordinal(), enumConstant);
            String jsonXmlName = this.getJsonXmlName(enumConstant);
            this.enumJsonXmlNameMap.put(enumConstant, this.getJsonXmlName(enumConstant));
            this.jsonXmlNameEnumMap.put(jsonXmlName, enumConstant);
        }
        try {
            this.hasNull = Enum.valueOf(this.typeClass, NULL) != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.enumBy = ordinal ? Type.EnumBy.ORDINAL : Type.EnumBy.NAME;
    }

    public Type.EnumBy enumerated() {
        return this.enumBy;
    }

    @Override
    public boolean isSerializable() {
        return true;
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

    @Override
    public String stringOf(T x) {
        return this.jsonValueType == null ? (x == null ? null : ((Enum)x).name()) : super.stringOf(x);
    }

    @Override
    public T valueOf(String str) {
        if (this.jsonValueType == null) {
            if (N.isNullOrEmpty(str) || !this.hasNull && NULL.equals(str)) {
                return null;
            }
            if (StringUtil.isAsciiDigtalInteger(str)) {
                return this.valueOf(Numbers.toInt(str));
            }
            Enum val = (Enum)this.jsonXmlNameEnumMap.get(str);
            if (val != null) {
                return (T)val;
            }
            return Enum.valueOf(this.typeClass, str);
        }
        return (T)((Enum)super.valueOf(str));
    }

    public T valueOf(int value) {
        Enum result = (Enum)this.numberEnum.get(value);
        if (result == null && value != 0) {
            throw new IllegalArgumentException("No " + this.typeClass.getName() + " for int value: " + value);
        }
        return (T)result;
    }

    @Override
    public void writeCharacter(CharacterWriter writer, T x, SerializationConfig<?> config) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else if (this.jsonValueType == null) {
            if (this.enumBy == Type.EnumBy.ORDINAL) {
                writer.writeInt(((Enum)x).ordinal());
            } else {
                char ch;
                char c = ch = config == null ? (char)'\u0000' : config.getStringQuotation();
                if (ch == '\u0000') {
                    writer.writeCharacter(this.enumJsonXmlNameMap.get(x));
                } else {
                    writer.write(ch);
                    writer.writeCharacter(this.enumJsonXmlNameMap.get(x));
                    writer.write(ch);
                }
            }
        } else {
            super.writeCharacter(writer, x, config);
        }
    }

    private String getJsonXmlName(T enumConstant) {
        try {
            Field field = enumConstant.getClass().getField(((Enum)enumConstant).name());
            if (field.isAnnotationPresent(JsonXmlField.class) && N.notNullOrEmpty(field.getAnnotation(JsonXmlField.class).name())) {
                return field.getAnnotation(JsonXmlField.class).name();
            }
            try {
                if (field.isAnnotationPresent(JSONField.class) && N.notNullOrEmpty(field.getAnnotation(JSONField.class).name())) {
                    return field.getAnnotation(JSONField.class).name();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                if (field.isAnnotationPresent(JsonProperty.class) && N.notNullOrEmpty(field.getAnnotation(JsonProperty.class).value())) {
                    return field.getAnnotation(JsonProperty.class).value();
                }
            }
            catch (Throwable throwable) {}
        }
        catch (NoSuchFieldException | SecurityException exception) {
            // empty catch block
        }
        return ((Enum)enumConstant).name();
    }

    private static Class<?> getEnumClass(Class<?> cls) {
        return cls.isEnum() ? cls : cls.getEnclosingClass();
    }
}

