/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.type;

import com.landawn.abacus.parser.SerializationConfig;
import com.landawn.abacus.type.AbstractType;
import com.landawn.abacus.type.Type;
import com.landawn.abacus.type.TypeFactory;
import com.landawn.abacus.util.CharacterWriter;
import com.landawn.abacus.util.ClassUtil;
import com.landawn.abacus.util.ImmutableList;
import java.io.IOException;
import java.io.Writer;
import java.util.List;

public class ImmutableListType<E>
extends AbstractType<ImmutableList<E>> {
    private final String declaringName;
    private final Class<ImmutableList<E>> typeClass = ImmutableList.class;
    private final Type<E>[] parameterTypes;
    private final Type<E> elementType;
    private final Type<List<E>> listType;

    ImmutableListType(String parameterTypeName) {
        super(ImmutableListType.getTypeName(ImmutableList.class, parameterTypeName, false));
        this.declaringName = ImmutableListType.getTypeName(ImmutableList.class, parameterTypeName, true);
        this.parameterTypes = new Type[]{TypeFactory.getType(parameterTypeName)};
        this.elementType = this.parameterTypes[0];
        this.listType = TypeFactory.getType("List<" + parameterTypeName + ">");
    }

    @Override
    public String declaringName() {
        return this.declaringName;
    }

    @Override
    public Class<ImmutableList<E>> clazz() {
        return this.typeClass;
    }

    @Override
    public Type<E> getElementType() {
        return this.elementType;
    }

    @Override
    public Type<E>[] getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public boolean isList() {
        return true;
    }

    @Override
    public boolean isSet() {
        return false;
    }

    @Override
    public boolean isCollection() {
        return true;
    }

    @Override
    public boolean isGenericType() {
        return true;
    }

    @Override
    public boolean isSerializable() {
        return this.listType.isSerializable();
    }

    @Override
    public Type.SerializationType getSerializationType() {
        return this.isSerializable() ? Type.SerializationType.SERIALIZABLE : Type.SerializationType.COLLECTION;
    }

    @Override
    public String stringOf(ImmutableList<E> x) {
        return this.listType.stringOf(x);
    }

    @Override
    public ImmutableList<E> valueOf(String str) {
        return ImmutableList.of(this.listType.valueOf(str));
    }

    @Override
    public void write(Writer writer, ImmutableList<E> x) throws IOException {
        this.listType.write(writer, x);
    }

    @Override
    public void writeCharacter(CharacterWriter writer, ImmutableList<E> x, SerializationConfig<?> config) throws IOException {
        this.listType.writeCharacter(writer, x, config);
    }

    protected static String getTypeName(Class<?> typeClass, String parameterTypeName, boolean isDeclaringName) {
        if (isDeclaringName) {
            return ClassUtil.getSimpleClassName(typeClass) + "<" + TypeFactory.getType(parameterTypeName).declaringName() + ">";
        }
        return ClassUtil.getCanonicalClassName(typeClass) + "<" + TypeFactory.getType(parameterTypeName).name() + ">";
    }
}

