/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.type;

import com.landawn.abacus.exception.UncheckedIOException;
import com.landawn.abacus.parser.JSONDeserializationConfig;
import com.landawn.abacus.parser.SerializationConfig;
import com.landawn.abacus.type.AbstractType;
import com.landawn.abacus.type.Type;
import com.landawn.abacus.type.TypeFactory;
import com.landawn.abacus.type.Utils;
import com.landawn.abacus.util.CharacterWriter;
import com.landawn.abacus.util.Clazz;
import com.landawn.abacus.util.ImmutableEntry;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Objectory;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.AbstractMap;

public class ImmutableMapEntryType<K, V>
extends AbstractType<AbstractMap.SimpleImmutableEntry<K, V>> {
    private final String declaringName;
    private final Class<AbstractMap.SimpleImmutableEntry<K, V>> typeClass = AbstractMap.SimpleImmutableEntry.class;
    private final Type<K> keyType;
    private final Type<V> valueType;
    private final Type<?>[] parameterTypes;
    private final JSONDeserializationConfig jdc;

    ImmutableMapEntryType(String keyTypeName, String valueTypeName) {
        super(ImmutableMapEntryType.getTypeName(keyTypeName, valueTypeName, false));
        this.declaringName = ImmutableMapEntryType.getTypeName(keyTypeName, valueTypeName, true);
        this.keyType = TypeFactory.getType(keyTypeName);
        this.valueType = TypeFactory.getType(valueTypeName);
        this.parameterTypes = new Type[]{this.keyType, this.valueType};
        this.jdc = (JSONDeserializationConfig)((JSONDeserializationConfig)JSONDeserializationConfig.JDC.create().setMapKeyType(this.keyType)).setMapValueType(this.valueType);
    }

    @Override
    public String declaringName() {
        return this.declaringName;
    }

    @Override
    public Class<AbstractMap.SimpleImmutableEntry<K, V>> clazz() {
        return this.typeClass;
    }

    @Override
    public Type<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public boolean isGenericType() {
        return true;
    }

    @Override
    public String stringOf(AbstractMap.SimpleImmutableEntry<K, V> x) {
        return x == null ? null : Utils.jsonParser.serialize(N.asMap(x.getKey(), x.getValue()));
    }

    @Override
    public AbstractMap.SimpleImmutableEntry<K, V> valueOf(String str) {
        if (N.isNullOrEmpty(str) || "{}".equals(str)) {
            return null;
        }
        return ImmutableEntry.from(Utils.jsonParser.deserialize(Clazz.ofMap(), str, this.jdc).entrySet().iterator().next());
    }

    @Override
    public void write(Writer writer, AbstractMap.SimpleImmutableEntry<K, V> x) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            boolean isBufferedWriter = writer instanceof com.landawn.abacus.util.BufferedWriter || writer instanceof BufferedWriter;
            Writer bw = isBufferedWriter ? writer : Objectory.createBufferedWriter(writer);
            try {
                bw.write(123);
                this.keyType.write(bw, x.getKey());
                writer.write(58);
                this.valueType.write(bw, x.getValue());
                bw.write(125);
                if (!isBufferedWriter) {
                    bw.flush();
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            finally {
                if (!isBufferedWriter) {
                    Objectory.recycle((com.landawn.abacus.util.BufferedWriter)bw);
                }
            }
        }
    }

    @Override
    public void writeCharacter(CharacterWriter writer, AbstractMap.SimpleImmutableEntry<K, V> x, SerializationConfig<?> config) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            try {
                writer.write('{');
                this.keyType.writeCharacter(writer, x.getKey(), config);
                writer.write(':');
                this.valueType.writeCharacter(writer, x.getValue(), config);
                writer.write('}');
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    protected static String getTypeName(String keyTypeName, String valueTypeName, boolean isDeclaringName) {
        if (isDeclaringName) {
            return "Map.ImmutableEntry<" + TypeFactory.getType(keyTypeName).declaringName() + ", " + TypeFactory.getType(valueTypeName).declaringName() + ">";
        }
        return "Map.ImmutableEntry<" + TypeFactory.getType(keyTypeName).name() + ", " + TypeFactory.getType(valueTypeName).name() + ">";
    }
}

