/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.type;

import com.landawn.abacus.exception.UncheckedSQLException;
import com.landawn.abacus.parser.SerializationConfig;
import com.landawn.abacus.type.AbstractType;
import com.landawn.abacus.util.CharacterWriter;
import com.landawn.abacus.util.ClassUtil;
import com.landawn.abacus.util.IOUtil;
import com.landawn.abacus.util.N;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.sql.Blob;
import java.sql.SQLException;

public class InputStreamType
extends AbstractType<InputStream> {
    public static final String INPUT_STREAM = InputStream.class.getSimpleName();
    private final Class<InputStream> typeClass;
    private final Constructor<?> bytesConstructor;
    private final Constructor<?> streamConstructor;

    InputStreamType() {
        this(INPUT_STREAM);
    }

    InputStreamType(String typeName) {
        super(typeName);
        this.typeClass = InputStream.class;
        this.bytesConstructor = null;
        this.streamConstructor = null;
    }

    InputStreamType(Class<InputStream> cls) {
        super(ClassUtil.getSimpleClassName(cls));
        this.typeClass = cls;
        if (Modifier.isAbstract(cls.getModifiers())) {
            this.bytesConstructor = null;
            this.streamConstructor = null;
        } else {
            this.bytesConstructor = ClassUtil.getDeclaredConstructor(cls, byte[].class);
            this.streamConstructor = ClassUtil.getDeclaredConstructor(cls, InputStream.class);
        }
    }

    @Override
    public Class<InputStream> clazz() {
        return this.typeClass;
    }

    @Override
    public boolean isInputStream() {
        return true;
    }

    @Override
    public String stringOf(InputStream x) {
        return x == null ? null : N.base64Encode(IOUtil.readAllBytes(x));
    }

    @Override
    public InputStream valueOf(String str) {
        if (str == null) {
            return null;
        }
        if (this.bytesConstructor != null) {
            return (InputStream)ClassUtil.invokeConstructor(this.bytesConstructor, new Object[]{N.base64Decode(str)});
        }
        if (this.streamConstructor != null) {
            return (InputStream)ClassUtil.invokeConstructor(this.streamConstructor, new ByteArrayInputStream(N.base64Decode(str)));
        }
        return new ByteArrayInputStream(N.base64Decode(str));
    }

    @Override
    public InputStream valueOf(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Blob) {
            Blob blob = (Blob)obj;
            try {
                return blob.getBinaryStream();
            }
            catch (SQLException e) {
                throw new UncheckedSQLException(e);
            }
        }
        return this.valueOf(N.typeOf(obj.getClass()).stringOf(obj));
    }

    @Override
    public void write(Writer writer, InputStream t) throws IOException {
        if (t == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            writer.write(N.base64Encode(IOUtil.readAllBytes(t)));
        }
    }

    @Override
    public void writeCharacter(CharacterWriter writer, InputStream t, SerializationConfig<?> config) throws IOException {
        if (t == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else if (config == null || config.getStringQuotation() == '\u0000') {
            writer.write(N.base64Encode(IOUtil.readAllBytes(t)));
        } else {
            writer.write(config.getStringQuotation());
            writer.write(N.base64Encode(IOUtil.readAllBytes(t)));
            writer.write(config.getStringQuotation());
        }
    }
}

