/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.type;

import com.landawn.abacus.parser.SerializationConfig;
import com.landawn.abacus.type.ObjectArrayType;
import com.landawn.abacus.util.CharacterWriter;
import com.landawn.abacus.util.IOUtil;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Objectory;
import java.io.IOException;
import java.io.Writer;

public final class LongArrayType
extends ObjectArrayType<Long> {
    LongArrayType() {
        super(Long[].class);
    }

    @Override
    public String stringOf(Long[] x) {
        if (x == null) {
            return null;
        }
        if (x.length == 0) {
            return "[]";
        }
        StringBuilder sb = Objectory.createStringBuilder();
        sb.append('[');
        int len = x.length;
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append(ELEMENT_SEPARATOR);
            }
            if (x[i] == null) {
                sb.append(NULL_CHAR_ARRAY);
                continue;
            }
            sb.append(x[i]);
        }
        sb.append(']');
        String str = sb.toString();
        Objectory.recycle(sb);
        return str;
    }

    @Override
    public Long[] valueOf(String str) {
        if (str == null) {
            return null;
        }
        if (str.length() == 0 || "[]".equals(str)) {
            return N.EMPTY_LONG_OBJ_ARRAY;
        }
        String[] strs = LongArrayType.split(str);
        int len = strs.length;
        Long[] a = new Long[len];
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                a[i] = strs[i].length() == 4 && strs[i].equals(NULL_STRING) ? null : (Long)this.elementType.valueOf(strs[i]);
            }
        }
        return a;
    }

    @Override
    public void write(Writer writer, Long[] x) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            writer.write(91);
            int len = x.length;
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    writer.write(ELEMENT_SEPARATOR);
                }
                if (x[i] == null) {
                    writer.write(NULL_CHAR_ARRAY);
                    continue;
                }
                IOUtil.write(writer, x[i]);
            }
            writer.write(93);
        }
    }

    @Override
    public void writeCharacter(CharacterWriter writer, Long[] x, SerializationConfig<?> config) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            writer.write('[');
            int len = x.length;
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    writer.write(ELEMENT_SEPARATOR);
                }
                if (x[i] == null) {
                    writer.write(NULL_CHAR_ARRAY);
                    continue;
                }
                writer.write(x[i]);
            }
            writer.write(']');
        }
    }
}

