/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.type;

import com.landawn.abacus.parser.JSONDeserializationConfig;
import com.landawn.abacus.type.AbstractType;
import com.landawn.abacus.type.CollectionType;
import com.landawn.abacus.type.Type;
import com.landawn.abacus.type.TypeFactory;
import com.landawn.abacus.type.Utils;
import com.landawn.abacus.util.ClassUtil;
import com.landawn.abacus.util.ListMultimap;
import com.landawn.abacus.util.Multimap;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.SetMultimap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MultimapType<K, E, V extends Collection<E>>
extends AbstractType<Multimap<K, E, V>> {
    private static final Class<?> typeClass = Multimap.class;
    private final String declaringName;
    private final Type<?>[] parameterTypes;
    private final JSONDeserializationConfig jdc;

    MultimapType(String keyTypeName, String valueTypeName) {
        super(MultimapType.getTypeName(typeClass, keyTypeName, valueTypeName, false));
        this.parameterTypes = new Type[]{TypeFactory.getType(keyTypeName), TypeFactory.getType(valueTypeName)};
        this.declaringName = MultimapType.getTypeName(typeClass, keyTypeName, valueTypeName, true);
        CollectionType collType = null;
        if (!(this.parameterTypes[1] instanceof CollectionType)) {
            throw new IllegalArgumentException("The value type of Multimap must be a collection type: " + valueTypeName);
        }
        collType = (CollectionType)this.parameterTypes[1];
        this.jdc = (JSONDeserializationConfig)((JSONDeserializationConfig)((JSONDeserializationConfig)JSONDeserializationConfig.JDC.create().setMapKeyType(this.parameterTypes[0])).setMapValueType(this.parameterTypes[1])).setElementType(collType.getElementType());
    }

    @Override
    public String declaringName() {
        return this.declaringName;
    }

    @Override
    public Class<Multimap<K, E, V>> clazz() {
        return typeClass;
    }

    @Override
    public Type<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public boolean isGenericType() {
        return true;
    }

    @Override
    public boolean isSerializable() {
        return true;
    }

    @Override
    public String stringOf(Multimap<K, E, V> x) {
        return x == null ? null : Utils.jsonParser.serialize(x.toMap(), Utils.jsc);
    }

    @Override
    public Multimap<K, E, V> valueOf(String st) {
        if (N.isNullOrEmpty(st)) {
            return null;
        }
        Map map = Utils.jsonParser.deserialize(Map.class, st, this.jdc);
        if (List.class.isAssignableFrom(this.parameterTypes[1].clazz())) {
            ListMultimap multiMap = N.newLinkedListMultimap(map.size());
            for (Map.Entry entry : map.entrySet()) {
                multiMap.putAll(entry.getKey(), (Collection)entry.getValue());
            }
            return multiMap;
        }
        if (Set.class.isAssignableFrom(this.parameterTypes[1].clazz())) {
            SetMultimap multiMap = N.newLinkedSetMultimap(map.size());
            for (Map.Entry entry : map.entrySet()) {
                multiMap.putAll(entry.getKey(), (Collection)entry.getValue());
            }
            return multiMap;
        }
        ListMultimap multiMap = N.newLinkedListMultimap(map.size());
        for (Map.Entry entry : map.entrySet()) {
            multiMap.putAll(entry.getKey(), (Collection)entry.getValue());
        }
        return multiMap;
    }

    protected static String getTypeName(Class<?> typeClass, String keyTypeName, String valueTypeName, boolean isDeclaringName) {
        if (isDeclaringName) {
            return ClassUtil.getSimpleClassName(typeClass) + "<" + TypeFactory.getType(keyTypeName).declaringName() + ", " + TypeFactory.getType(valueTypeName).declaringName() + ">";
        }
        return ClassUtil.getCanonicalClassName(typeClass) + "<" + TypeFactory.getType(keyTypeName).name() + ", " + TypeFactory.getType(valueTypeName).name() + ">";
    }
}

