/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.type;

import com.landawn.abacus.parser.JSONDeserializationConfig;
import com.landawn.abacus.type.AbstractType;
import com.landawn.abacus.type.Type;
import com.landawn.abacus.type.TypeFactory;
import com.landawn.abacus.type.Utils;
import com.landawn.abacus.util.ClassUtil;
import com.landawn.abacus.util.Multiset;
import com.landawn.abacus.util.N;
import java.util.Map;

public class MultisetType<E>
extends AbstractType<Multiset<E>> {
    private final String declaringName;
    private static final Class<?> typeClass = Multiset.class;
    private final Type<E>[] parameterTypes;
    private final Type<E> elementType;
    private final JSONDeserializationConfig jdc;

    MultisetType(String parameterTypeName) {
        super(MultisetType.getTypeName(typeClass, parameterTypeName, false));
        this.declaringName = MultisetType.getTypeName(typeClass, parameterTypeName, true);
        this.parameterTypes = new Type[]{TypeFactory.getType(parameterTypeName)};
        this.elementType = this.parameterTypes[0];
        this.jdc = (JSONDeserializationConfig)((JSONDeserializationConfig)JSONDeserializationConfig.JDC.create().setMapKeyType(this.elementType)).setMapValueType(Integer.class);
    }

    @Override
    public String declaringName() {
        return this.declaringName;
    }

    @Override
    public Class<Multiset<E>> clazz() {
        return typeClass;
    }

    @Override
    public Type<E> getElementType() {
        return this.elementType;
    }

    @Override
    public Type<E>[] getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public boolean isGenericType() {
        return true;
    }

    @Override
    public boolean isSerializable() {
        return true;
    }

    @Override
    public String stringOf(Multiset<E> x) {
        return x == null ? null : Utils.jsonParser.serialize(x.toMap(), Utils.jsc);
    }

    @Override
    public Multiset<E> valueOf(String str) {
        if (N.isNullOrEmpty(str)) {
            return null;
        }
        Map map = Utils.jsonParser.deserialize(Map.class, str, this.jdc);
        Multiset multiSet = N.newMultiset(map.size());
        for (Map.Entry entry : map.entrySet()) {
            multiSet.add(entry.getKey(), (Integer)entry.getValue());
        }
        return multiSet;
    }

    protected static String getTypeName(Class<?> typeClass, String parameterTypeName, boolean isDeclaringName) {
        if (isDeclaringName) {
            return ClassUtil.getSimpleClassName(typeClass) + "<" + TypeFactory.getType(parameterTypeName).declaringName() + ">";
        }
        return ClassUtil.getCanonicalClassName(typeClass) + "<" + TypeFactory.getType(parameterTypeName).name() + ">";
    }
}

