/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.type;

import com.landawn.abacus.parser.SerializationConfig;
import com.landawn.abacus.type.MutableType;
import com.landawn.abacus.util.CharacterWriter;
import com.landawn.abacus.util.IOUtil;
import com.landawn.abacus.util.MutableDouble;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Numbers;
import java.io.IOException;
import java.io.Writer;

public class MutableDoubleType
extends MutableType<MutableDouble> {
    public static final String MUTABLE_DOUBLE = MutableDouble.class.getSimpleName();

    protected MutableDoubleType() {
        super(MUTABLE_DOUBLE);
    }

    @Override
    public Class<MutableDouble> clazz() {
        return MutableDouble.class;
    }

    @Override
    public String stringOf(MutableDouble x) {
        return x == null ? null : N.stringOf(x.doubleValue());
    }

    @Override
    public MutableDouble valueOf(String str) {
        return N.isNullOrEmpty(str) ? null : MutableDouble.of(Numbers.toDouble(str));
    }

    @Override
    public void write(Writer writer, MutableDouble x) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            IOUtil.write(writer, x.doubleValue());
        }
    }

    @Override
    public void writeCharacter(CharacterWriter writer, MutableDouble x, SerializationConfig<?> config) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            writer.write(x.doubleValue());
        }
    }
}

