/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.type;

import com.landawn.abacus.parser.SerializationConfig;
import com.landawn.abacus.type.AbstractOptionalType;
import com.landawn.abacus.type.Type;
import com.landawn.abacus.type.TypeFactory;
import com.landawn.abacus.util.CharacterWriter;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.u;
import java.io.IOException;
import java.io.Writer;

public class NullableType<T>
extends AbstractOptionalType<u.Nullable<T>> {
    public static final String NULLABLE = u.Nullable.class.getSimpleName();
    private final String declaringName;
    private final Type<T>[] parameterTypes;
    private final Type<T> elementType;

    protected NullableType(String parameterTypeName) {
        super(NULLABLE + "<" + TypeFactory.getType(parameterTypeName).name() + ">");
        this.declaringName = NULLABLE + "<" + TypeFactory.getType(parameterTypeName).declaringName() + ">";
        this.parameterTypes = new Type[]{TypeFactory.getType(parameterTypeName)};
        this.elementType = this.parameterTypes[0];
    }

    @Override
    public String declaringName() {
        return this.declaringName;
    }

    @Override
    public Class<u.Nullable<T>> clazz() {
        return u.Nullable.class;
    }

    @Override
    public Type<T> getElementType() {
        return this.elementType;
    }

    @Override
    public Type<T>[] getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public boolean isGenericType() {
        return true;
    }

    @Override
    public boolean isOptionalOrNullable() {
        return true;
    }

    @Override
    public String stringOf(u.Nullable<T> x) {
        return x == null || !x.isPresent() || x.get() == null ? null : N.stringOf(x.get());
    }

    @Override
    public u.Nullable<T> valueOf(String str) {
        return str == null ? u.Nullable.empty() : u.Nullable.of(this.elementType.valueOf(str));
    }

    @Override
    public void write(Writer writer, u.Nullable<T> x) throws IOException {
        if (x == null || !x.isPresent() || x.get() == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            N.typeOf(x.get().getClass()).write(writer, x.get());
        }
    }

    @Override
    public void writeCharacter(CharacterWriter writer, u.Nullable<T> x, SerializationConfig<?> config) throws IOException {
        if (x == null || !x.isPresent() || x.get() == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            N.typeOf(x.get().getClass()).writeCharacter(writer, x.get(), config);
        }
    }
}

