/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.type;

import com.landawn.abacus.parser.SerializationConfig;
import com.landawn.abacus.type.AbstractOptionalType;
import com.landawn.abacus.util.CharacterWriter;
import com.landawn.abacus.util.IOUtil;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Numbers;
import com.landawn.abacus.util.u;
import java.io.IOException;
import java.io.Writer;

public class OptionalIntType
extends AbstractOptionalType<u.OptionalInt> {
    public static final String OPTIONAL_INT = u.OptionalInt.class.getSimpleName();

    protected OptionalIntType() {
        super(OPTIONAL_INT);
    }

    @Override
    public Class<u.OptionalInt> clazz() {
        return u.OptionalInt.class;
    }

    @Override
    public boolean isComparable() {
        return true;
    }

    @Override
    public boolean isOptionalOrNullable() {
        return true;
    }

    @Override
    public String stringOf(u.OptionalInt x) {
        return x == null || !x.isPresent() ? null : String.valueOf(x.get());
    }

    @Override
    public u.OptionalInt valueOf(String str) {
        return N.isNullOrEmpty(str) ? u.OptionalInt.empty() : u.OptionalInt.of(Numbers.toInt(str));
    }

    @Override
    public void write(Writer writer, u.OptionalInt x) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            IOUtil.write(writer, x.get());
        }
    }

    @Override
    public void writeCharacter(CharacterWriter writer, u.OptionalInt x, SerializationConfig<?> config) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            writer.writeInt(x.get());
        }
    }
}

