/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.type;

import com.landawn.abacus.exception.UncheckedIOException;
import com.landawn.abacus.parser.SerializationConfig;
import com.landawn.abacus.type.AbstractType;
import com.landawn.abacus.type.Type;
import com.landawn.abacus.type.TypeFactory;
import com.landawn.abacus.type.Utils;
import com.landawn.abacus.util.BufferedJSONWriter;
import com.landawn.abacus.util.CharacterWriter;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Objectory;
import com.landawn.abacus.util.Range;
import com.landawn.abacus.util.StringUtil;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Array;

public class RangeType<T extends Comparable<? super T>>
extends AbstractType<Range<T>> {
    static final Type<String> strType = TypeFactory.getType(String.class);
    public static final String RANGE = Range.class.getSimpleName();
    private final String declaringName;
    private final Class<Range<T>> typeClass;
    private final Type<T>[] parameterTypes;
    private final Type<T> elementType;

    RangeType(String parameterTypeName) {
        super(RANGE + "<" + TypeFactory.getType(parameterTypeName).name() + ">");
        this.declaringName = RANGE + "<" + TypeFactory.getType(parameterTypeName).declaringName() + ">";
        this.typeClass = Range.class;
        this.parameterTypes = new Type[]{TypeFactory.getType(parameterTypeName)};
        this.elementType = this.parameterTypes[0];
    }

    @Override
    public String declaringName() {
        return this.declaringName;
    }

    @Override
    public Class<Range<T>> clazz() {
        return this.typeClass;
    }

    @Override
    public Type<T>[] getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public Type<T> getElementType() {
        return this.elementType;
    }

    @Override
    public boolean isGenericType() {
        return true;
    }

    @Override
    public String stringOf(Range<T> x) {
        if (x == null) {
            return null;
        }
        Range.BoundType boundType = x.boundType();
        String prefix = boundType == Range.BoundType.OPEN_OPEN || boundType == Range.BoundType.OPEN_CLOSED ? "(" : "[";
        String postfix = boundType == Range.BoundType.OPEN_OPEN || boundType == Range.BoundType.CLOSED_OPEN ? ")" : "]";
        Type<T> type = this.elementType;
        if (x.lowerEndpoint() != null) {
            type = TypeFactory.getType(x.lowerEndpoint().getClass());
        } else if (x.upperEndpoint() != null) {
            type = TypeFactory.getType(x.upperEndpoint().getClass());
        }
        return prefix + type.stringOf(x.lowerEndpoint()) + ELEMENT_SEPARATOR + type.stringOf(x.upperEndpoint()) + postfix;
    }

    @Override
    public Range<T> valueOf(String str) {
        if (N.isNullOrEmpty(str = StringUtil.trim(str))) {
            return null;
        }
        String prefix = str.substring(0, 1);
        String postfix = str.substring(str.length() - 1, str.length());
        Comparable[] tmp = (Comparable[])Utils.jsonParser.deserialize(Array.newInstance(this.elementType.clazz(), 0).getClass(), str, 1, str.length() - 1, Utils.jdc);
        if ("(".equals(prefix)) {
            return ")".equals(postfix) ? Range.open(tmp[0], tmp[1]) : Range.openClosed(tmp[0], tmp[1]);
        }
        return ")".equals(postfix) ? Range.closedOpen(tmp[0], tmp[1]) : Range.closed(tmp[0], tmp[1]);
    }

    @Override
    public void write(Writer writer, Range<T> x) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            Range.BoundType boundType = x.boundType();
            String prefix = boundType == Range.BoundType.OPEN_OPEN || boundType == Range.BoundType.OPEN_CLOSED ? "(" : "[";
            String postfix = boundType == Range.BoundType.OPEN_OPEN || boundType == Range.BoundType.CLOSED_OPEN ? ")" : "]";
            Type<T> type = this.elementType;
            if (x.lowerEndpoint() != null) {
                type = TypeFactory.getType(x.lowerEndpoint().getClass());
            } else if (x.upperEndpoint() != null) {
                type = TypeFactory.getType(x.upperEndpoint().getClass());
            }
            boolean isBufferedWriter = writer instanceof com.landawn.abacus.util.BufferedWriter || writer instanceof BufferedWriter;
            Writer bw = isBufferedWriter ? writer : Objectory.createBufferedWriter(writer);
            try {
                bw.write(prefix);
                type.write(bw, x.lowerEndpoint());
                bw.write(ELEMENT_SEPARATOR_CHAR_ARRAY);
                type.write(bw, x.upperEndpoint());
                bw.write(postfix);
                if (!isBufferedWriter) {
                    bw.flush();
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            finally {
                if (!isBufferedWriter) {
                    Objectory.recycle((com.landawn.abacus.util.BufferedWriter)bw);
                }
            }
        }
    }

    @Override
    public void writeCharacter(CharacterWriter writer, Range<T> x, SerializationConfig<?> config) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            Range.BoundType boundType = x.boundType();
            String prefix = boundType == Range.BoundType.OPEN_OPEN || boundType == Range.BoundType.OPEN_CLOSED ? "(" : "[";
            String postfix = boundType == Range.BoundType.OPEN_OPEN || boundType == Range.BoundType.CLOSED_OPEN ? ")" : "]";
            Type<T> type = this.elementType;
            if (x.lowerEndpoint() != null) {
                type = TypeFactory.getType(x.lowerEndpoint().getClass());
            } else if (x.upperEndpoint() != null) {
                type = TypeFactory.getType(x.upperEndpoint().getClass());
            }
            CharacterWriter tmpWriter = writer instanceof BufferedJSONWriter ? Objectory.createBufferedJSONWriter() : Objectory.createBufferedXMLWriter();
            try {
                tmpWriter.write(prefix);
                type.writeCharacter(tmpWriter, x.lowerEndpoint(), config);
                tmpWriter.write(ELEMENT_SEPARATOR_CHAR_ARRAY);
                type.writeCharacter(tmpWriter, x.upperEndpoint(), config);
                tmpWriter.write(postfix);
                strType.writeCharacter(writer, tmpWriter.toString(), config);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            finally {
                Objectory.recycle(tmpWriter);
            }
        }
    }
}

