/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.type;

import com.landawn.abacus.exception.UncheckedIOException;
import com.landawn.abacus.exception.UncheckedSQLException;
import com.landawn.abacus.parser.SerializationConfig;
import com.landawn.abacus.type.AbstractType;
import com.landawn.abacus.util.CharacterWriter;
import com.landawn.abacus.util.ClassUtil;
import com.landawn.abacus.util.IOUtil;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Objectory;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.sql.Clob;
import java.sql.SQLException;

public class ReaderType
extends AbstractType<Reader> {
    public static final String READER = Reader.class.getSimpleName();
    private final Class<Reader> typeClass;
    private final Constructor<?> stringConstructor;
    private final Constructor<?> readerConstructor;

    ReaderType() {
        this(READER);
    }

    ReaderType(String typeName) {
        super(typeName);
        this.typeClass = Reader.class;
        this.stringConstructor = null;
        this.readerConstructor = null;
    }

    ReaderType(Class<Reader> cls) {
        super(ClassUtil.getSimpleClassName(cls));
        this.typeClass = cls;
        if (Modifier.isAbstract(cls.getModifiers())) {
            this.stringConstructor = null;
            this.readerConstructor = null;
        } else {
            this.stringConstructor = ClassUtil.getDeclaredConstructor(cls, String.class);
            this.readerConstructor = ClassUtil.getDeclaredConstructor(cls, Reader.class);
        }
    }

    @Override
    public Class<Reader> clazz() {
        return this.typeClass;
    }

    @Override
    public boolean isReader() {
        return true;
    }

    @Override
    public String stringOf(Reader x) {
        return x == null ? null : IOUtil.readString(x);
    }

    @Override
    public Reader valueOf(String str) {
        if (str == null) {
            return null;
        }
        if (this.stringConstructor != null) {
            return (Reader)ClassUtil.invokeConstructor(this.stringConstructor, str);
        }
        if (this.readerConstructor != null) {
            return (Reader)ClassUtil.invokeConstructor(this.readerConstructor, new StringReader(str));
        }
        return new StringReader(str);
    }

    @Override
    public Reader valueOf(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Clob) {
            Clob clob = (Clob)obj;
            try {
                return clob.getCharacterStream();
            }
            catch (SQLException e) {
                throw new UncheckedSQLException(e);
            }
        }
        return this.valueOf(N.typeOf(obj.getClass()).stringOf(obj));
    }

    @Override
    public void write(Writer writer, Reader x) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            IOUtil.write(writer, x);
        }
    }

    @Override
    public void writeCharacter(CharacterWriter writer, Reader x, SerializationConfig<?> config) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            if (config != null && config.getStringQuotation() != '\u0000') {
                writer.write(config.getStringQuotation());
            }
            char[] buf = Objectory.createCharArrayBuffer();
            try {
                int count = 0;
                while (-1 != (count = IOUtil.read(x, buf, 0, buf.length))) {
                    writer.writeCharacter(buf, 0, count);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            finally {
                Objectory.recycle(buf);
            }
            if (config != null && config.getStringQuotation() != '\u0000') {
                writer.write(config.getStringQuotation());
            }
        }
    }
}

